/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit.crypto;

import com.ibm.jit.crypto.JITAESCryptInHardware;
import com.ibm.oti.vm.VM;
import java.util.Arrays;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITFullHardwareCrypt {
    private final String _modeName;
    private final String _algorithmName;
    private final int _keyLengthBits;
    private final byte _mode;
    private byte[] _IV_And_key;
    private boolean _modeIsEncrypt;
    private byte _cfbSize;
    private final int _ivLength;
    private final int _keyOffset;
    private final int _keyLengthBytes;
    private final int _blockSize;
    private static JITFullHardwareCrypt[] knownParms = new JITFullHardwareCrypt[]{new JITFullHardwareCrypt("DES", "ECB", 64, 8, 1, 0), new JITFullHardwareCrypt("DESede", "ECB", 128, 8, 2, 0), new JITFullHardwareCrypt("DESede", "ECB", 192, 8, 3, 0), new JITFullHardwareCrypt("AES", "ECB", 128, 16, 18, 0), new JITFullHardwareCrypt("AES", "ECB", 192, 16, 19, 0), new JITFullHardwareCrypt("AES", "ECB", 256, 16, 20, 0), new JITFullHardwareCrypt("DES", "CBC", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "CBC", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "CBC", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "CBC", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "CBC", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "CBC", 256, 16, 20, 16), new JITFullHardwareCrypt("DES", "CFB", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "CFB", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "CFB", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "CFB", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "CFB", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "CFB", 256, 16, 20, 16), new JITFullHardwareCrypt("DES", "CTR", 64, 8, 1, 0), new JITFullHardwareCrypt("DESede", "CTR", 128, 8, 2, 0), new JITFullHardwareCrypt("DESede", "CTR", 192, 8, 3, 0), new JITFullHardwareCrypt("AES", "CTR", 128, 16, 18, 0), new JITFullHardwareCrypt("AES", "CTR", 192, 16, 19, 0), new JITFullHardwareCrypt("AES", "CTR", 256, 16, 20, 0), new JITFullHardwareCrypt("DES", "OFB", 64, 8, 1, 8), new JITFullHardwareCrypt("DESede", "OFB", 128, 8, 2, 8), new JITFullHardwareCrypt("DESede", "OFB", 192, 8, 3, 8), new JITFullHardwareCrypt("AES", "OFB", 128, 16, 18, 16), new JITFullHardwareCrypt("AES", "OFB", 192, 16, 19, 16), new JITFullHardwareCrypt("AES", "OFB", 256, 16, 20, 16)};
    private static hw hardware;
    private static byte[] supportedECB;
    private static byte[] supportedCBC;
    private static byte[] supportedOFB;
    private static byte[] supportedCFB;
    private static byte[] supportedCTR;

    public void cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset) {
        assert (hardware == hw.zseries);
        this.z_cipher(in, inputLength, inputOffset, out, outputOffset, null, 0);
    }

    public void cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset) {
        assert (hardware == hw.zseries);
        this.z_cipher(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset);
    }

    public void cipherFinal(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] aad, int aadLength, int aadOffset, long TAADL, long TPCL) {
        assert (false);
    }

    public void init(boolean isEncrypt, byte[] key) {
        this._modeIsEncrypt = isEncrypt;
        if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
            this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
        }
        System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
    }

    public void init(boolean isEncrypt, byte[] key, byte[] IV) {
        assert (hardware == hw.zseries);
        assert (IV.length == this._ivLength);
        assert (key.length == this._keyLengthBytes);
        this._modeIsEncrypt = isEncrypt;
        if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
            this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
        }
        System.arraycopy((Object)IV, 0, (Object)this._IV_And_key, 0, this._ivLength);
        System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
    }

    public void init(boolean isEncrypt, byte[] key, byte[] IV, int size) {
        assert (hardware == hw.zseries);
        assert (IV.length == this._ivLength);
        assert (key.length == this._keyLengthBytes);
        this._modeIsEncrypt = isEncrypt;
        if (this._IV_And_key == null || this._keyLengthBytes + this._ivLength > this._IV_And_key.length) {
            this._IV_And_key = new byte[this._keyLengthBytes + this._ivLength];
        }
        if (IV == null) {
            Arrays.fill(this._IV_And_key, 0, this._ivLength, (byte)0);
        } else {
            System.arraycopy((Object)IV, 0, (Object)this._IV_And_key, 0, this._ivLength);
        }
        System.arraycopy((Object)key, 0, (Object)this._IV_And_key, this._ivLength, this._keyLengthBytes);
        this._cfbSize = (byte)size;
    }

    public static boolean isSupportedByHardware(String algorithm, String mode) {
        if (hardware != hw.zseries || JITAESCryptInHardware.disableHardwareAcceleration) {
            return false;
        }
        int unitCount = -1;
        if (mode.length() > 3 && mode.startsWith("CFB")) {
            unitCount = Integer.parseInt(mode.substring(3));
            if (unitCount % 8 != 0) {
                return false;
            }
            mode = "CFB";
        }
        JITFullHardwareCrypt element = null;
        for (int i = knownParms.length - 1; i >= 0; --i) {
            element = knownParms[i];
            if (element._algorithmName.equals(algorithm) && element._modeName.equals(mode)) break;
            element = null;
        }
        if (element == null) {
            return false;
        }
        byte[] result = null;
        switch (mode) {
            case "GCM": 
            case "ECB": {
                result = supportedECB;
                break;
            }
            case "CBC": {
                result = supportedCBC;
                break;
            }
            case "OFB": {
                result = supportedOFB;
                break;
            }
            case "CFB": {
                if (unitCount > 0 && unitCount / 8 > element._blockSize) {
                    return false;
                }
                result = supportedCFB;
                break;
            }
            case "CTR": {
                result = supportedCTR;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return (result[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) != 0;
    }

    public int getBlockSize() {
        return this._blockSize;
    }

    public byte[] getIV() {
        if (this._ivLength == 0) {
            return null;
        }
        byte[] result = new byte[this._ivLength];
        System.arraycopy((Object)this._IV_And_key, 0, (Object)result, 0, this._ivLength);
        return result;
    }

    public byte[] getTag() {
        assert (false);
        return null;
    }

    public int getIVSize() {
        return this._ivLength;
    }

    public int getKeySize() {
        return this._keyLengthBits;
    }

    @CallerSensitive
    public static JITFullHardwareCrypt getCrypto(String algorithm, String mode, int keyLength) {
        ClassLoader callerClassLoader = Reflection.getCallerClass().getClassLoader();
        if (callerClassLoader != null && callerClassLoader != VM.getVMLangAccess().getExtClassLoader()) {
            throw new SecurityException(JITFullHardwareCrypt.class.getName());
        }
        for (int i = 0; i < knownParms.length; ++i) {
            JITFullHardwareCrypt element = knownParms[i];
            if (element._keyLengthBits != keyLength || !element._algorithmName.equals(algorithm) || !element._modeName.equals(mode)) continue;
            return JITFullHardwareCrypt.copy(element);
        }
        return null;
    }

    private JITFullHardwareCrypt() {
        assert (false);
        this._modeName = "";
        this._algorithmName = "";
        this._mode = 0;
        this._keyLengthBytes = 0;
        this._ivLength = 0;
        this._keyOffset = 0;
        this._blockSize = 0;
        this._keyLengthBits = 0;
        this._IV_And_key = null;
    }

    private JITFullHardwareCrypt(String algorithm, String modeName, int keyLength, int blockSize, byte mode, int keyOffset) {
        this._algorithmName = algorithm;
        this._modeName = modeName;
        this._keyLengthBits = keyLength;
        this._blockSize = blockSize;
        this._mode = mode;
        this._keyOffset = keyOffset;
        this._ivLength = keyOffset;
        this._keyLengthBytes = keyLength / 8;
    }

    private static JITFullHardwareCrypt copy(JITFullHardwareCrypt in) {
        if (hardware == hw.zseries) {
            return new JITFullHardwareCrypt(in._algorithmName, in._modeName, in._keyLengthBits, in._blockSize, in._mode, in._keyOffset);
        }
        return null;
    }

    private void z_cipher(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset) {
        int modeCode = this._mode;
        if (!this._modeIsEncrypt) {
            modeCode = 128 + this._mode;
        }
        switch (this._modeName) {
            case "GCM": {
                assert (false);
            }
            case "ECB": {
                JITFullHardwareCrypt.z_km(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CBC": {
                JITFullHardwareCrypt.z_kmc(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "OFB": {
                JITFullHardwareCrypt.z_kmo(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CFB": {
                modeCode = (int)((long)modeCode | (long)this._cfbSize << 24);
                JITFullHardwareCrypt.z_kmf(in, inputLength, inputOffset, out, outputOffset, this._IV_And_key, modeCode);
                break;
            }
            case "CTR": {
                JITFullHardwareCrypt.z_kmctr(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset, this._IV_And_key, modeCode);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static void z_km(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_km_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmc(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmc_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmo(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmo_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmf(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmf_native(in, inputLength, inputOffset, out, outputOffset, key_IV, mode);
    }

    private static void z_kmctr(byte[] in, int inputLength, int inputOffset, byte[] out, int outputOffset, byte[] ctr, int ctrOffset, byte[] key_IV, int mode) {
        JITFullHardwareCrypt.z_kmctr_native(in, inputLength, inputOffset, out, outputOffset, ctr, ctrOffset, key_IV, mode);
    }

    private static native void z_km_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmc_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmo_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmf_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6);

    private static native void z_kmctr_native(byte[] var0, int var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    private static native void z_km_supported(byte[] var0);

    private static native void z_kmc_supported(byte[] var0);

    private static native void z_kmo_supported(byte[] var0);

    private static native void z_kmf_supported(byte[] var0);

    private static native void z_kmctr_supported(byte[] var0);

    static {
        if (JITAESCryptInHardware.osArch.equals("s390x") || JITAESCryptInHardware.osArch.equals("s390")) {
            hardware = hw.zseries;
            supportedECB = new byte[16];
            supportedCBC = new byte[16];
            supportedOFB = new byte[16];
            supportedCFB = new byte[16];
            supportedCTR = new byte[16];
            JITFullHardwareCrypt.z_km_supported(supportedECB);
            JITFullHardwareCrypt.z_kmc_supported(supportedCBC);
            JITFullHardwareCrypt.z_kmo_supported(supportedOFB);
            JITFullHardwareCrypt.z_kmf_supported(supportedCFB);
            JITFullHardwareCrypt.z_kmctr_supported(supportedCTR);
        } else {
            hardware = JITAESCryptInHardware.osArch.equals("x86") || JITAESCryptInHardware.osArch.equals("amd64") ? hw.xseries : hw.pseries;
        }
    }

    private static enum hw {
        zseries,
        pseries,
        xseries;

    }
}

