/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jit.crypto;

import com.ibm.jit.crypto.JITAESCryptInHardware;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.vm.VM;
import java.security.AccessController;
import java.util.Arrays;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class JITFullHardwareDigest {
    private final String _algorithmName;
    private final byte _mode;
    private byte[] _IV_And_Length;
    private final int _ivLength;
    private final int _lengthOffset;
    private final int _messageLengthFieldLength;
    private final boolean _isSHA256;
    private static hw hardware;
    private static byte[] supportedKIMD;
    private static byte[] supportedKLMD;
    private static byte[] supportedKMAC;
    private static JITFullHardwareDigest[] knownParms;
    private static final int SHA_256_BUFFER_SIZE_BYTES = 256;
    private static final int SHA_512_BUFFER_SIZE_BYTES = 640;
    private static final int SHA_256_H_VALUES_SIZE_BYTES = 32;
    private static final int SHA_512_H_VALUES_SIZE_BYTES = 64;
    private static final int CryptoHardwareFeatures_LE = 1;
    private static final int CryptoHardwareFeatures_SHA256 = 2;
    private static final int CryptoHardwareFeatures_SHA512 = 4;
    private static int cryptoHardwareFeatures;
    private static boolean disableHardwareAcceleration;

    public void digestFinal(byte[] in, int inputLength, int inputOffset, long totalMessageLength) {
        if (hardware == hw.zseries) {
            this.z_digestFinal(in, inputLength, inputOffset, totalMessageLength);
        } else if (hardware == hw.pseries) {
            this.p_digestFinal(in, inputLength, inputOffset, totalMessageLength);
        }
    }

    private static void flipMessageBlockBytesLE(byte[] in, byte[] out, int inOffset, int outOffset, int length, boolean isDoubleWord) {
        if (!isDoubleWord) {
            for (int j = 0; j < length; j += 4) {
                byte byte3;
                byte byte0 = in[inOffset + j];
                byte byte1 = in[inOffset + j + 1];
                byte byte2 = in[inOffset + j + 2];
                out[outOffset + j] = byte3 = in[inOffset + j + 3];
                out[outOffset + j + 1] = byte2;
                out[outOffset + j + 2] = byte1;
                out[outOffset + j + 3] = byte0;
            }
        } else {
            for (int j = 0; j < length; j += 8) {
                byte byte7;
                byte byte0 = in[inOffset + j];
                byte byte1 = in[inOffset + j + 1];
                byte byte2 = in[inOffset + j + 2];
                byte byte3 = in[inOffset + j + 3];
                byte byte4 = in[inOffset + j + 4];
                byte byte5 = in[inOffset + j + 5];
                byte byte6 = in[inOffset + j + 6];
                out[outOffset + j] = byte7 = in[inOffset + j + 7];
                out[outOffset + j + 1] = byte6;
                out[outOffset + j + 2] = byte5;
                out[outOffset + j + 3] = byte4;
                out[outOffset + j + 4] = byte3;
                out[outOffset + j + 5] = byte2;
                out[outOffset + j + 6] = byte1;
                out[outOffset + j + 7] = byte0;
            }
        }
    }

    private void p_digestFinal(byte[] in, int inputLength, int inputOffset, long totalMessageLength) {
        int tempInputLen;
        int tempInputOffset = inputOffset;
        for (tempInputLen = inputLength; tempInputLen >= 2 * this._ivLength; tempInputLen -= 2 * this._ivLength) {
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(in, this._IV_And_Length, tempInputOffset, 0, 2 * this._ivLength, !this._isSHA256);
            } else {
                System.arraycopy((Object)in, tempInputOffset, (Object)this._IV_And_Length, 0, 2 * this._ivLength);
            }
            if (this._isSHA256) {
                JITFullHardwareDigest.sha256(this._IV_And_Length);
            } else {
                JITFullHardwareDigest.sha512(this._IV_And_Length);
            }
            tempInputOffset += 2 * this._ivLength;
        }
        if (tempInputLen >= 0) {
            System.arraycopy((Object)in, tempInputOffset, (Object)this._IV_And_Length, 0, tempInputLen);
            if (this._isSHA256) {
                this.p_padAndDigestFinalBlocks256(tempInputLen, totalMessageLength);
            } else {
                this.p_padAndDigestFinalBlocks512(tempInputLen, totalMessageLength);
            }
        }
    }

    private void p_padAndDigestFinalBlocks256(int offset, long totalMessageLength) {
        long totoalMessageBits = totalMessageLength * 8L + 1L;
        long modBits = totoalMessageBits % 512L;
        if (modBits < 448L) {
            long zeroBits = 448L - modBits;
            assert (zeroBits > 0L && 0L == (zeroBits + 1L) % 8L);
            this._IV_And_Length[offset++] = -128;
            for (long i = 0L; i < (zeroBits + 1L) / 8L - 1L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            this.dumpTotalMessageLengthAs64BitBinary(offset, totalMessageLength);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha256(this._IV_And_Length);
        } else {
            long i;
            long zeroBits = 448L + (512L - modBits);
            assert (zeroBits > 0L && 0L == (zeroBits + 1L) % 8L);
            long bytesInCurrentBlock = (512L - modBits + 1L) / 8L;
            assert (0L < bytesInCurrentBlock);
            this._IV_And_Length[offset++] = -128;
            for (i = 0L; i < bytesInCurrentBlock - 1L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha256(this._IV_And_Length);
            offset = 0;
            for (i = 0L; i < 56L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            this.dumpTotalMessageLengthAs64BitBinary(offset, totalMessageLength);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha256(this._IV_And_Length);
        }
    }

    private void p_padAndDigestFinalBlocks512(int offset, long totalMessageLength) {
        long totoalMessageBits = totalMessageLength * 8L + 1L;
        long modBits = totoalMessageBits % 1024L;
        if (modBits < 896L) {
            long zeroBits = 896L - modBits;
            assert (zeroBits > 0L && 0L == (zeroBits + 1L) % 8L);
            this._IV_And_Length[offset++] = -128;
            for (long i = 0L; i < (zeroBits + 1L) / 8L - 1L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            this.dumpTotalMessageLengthAs128BitBinary(offset, totalMessageLength);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha512(this._IV_And_Length);
        } else {
            long i;
            long zeroBits = 896L + (1024L - modBits);
            assert (zeroBits > 0L && 0L == (zeroBits + 1L) % 8L);
            long bytesInCurrentBlock = (1024L - modBits + 1L) / 8L;
            assert (0L < bytesInCurrentBlock);
            this._IV_And_Length[offset++] = -128;
            for (i = 0L; i < bytesInCurrentBlock - 1L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha512(this._IV_And_Length);
            offset = 0;
            for (i = 0L; i < 112L; ++i) {
                this._IV_And_Length[offset++] = 0;
            }
            this.dumpTotalMessageLengthAs128BitBinary(offset, totalMessageLength);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(this._IV_And_Length, this._IV_And_Length, 0, 0, 2 * this._ivLength, !this._isSHA256);
            }
            JITFullHardwareDigest.sha512(this._IV_And_Length);
        }
    }

    private void z_digestFinal(byte[] in, int inputLength, int inputOffset, long totalMessageLength) {
        assert (hardware == hw.zseries);
        int indexOfLength = this._ivLength + this._messageLengthFieldLength - 9;
        if (this._messageLengthFieldLength > 8) {
            this._IV_And_Length[indexOfLength++] = (byte)(totalMessageLength >> 61 & 7L);
        } else {
            ++indexOfLength;
        }
        this.dumpTotalMessageLengthAs64BitBinary(indexOfLength, totalMessageLength);
        this.z_digest(in, inputLength, inputOffset);
    }

    private void dumpTotalMessageLengthAs64BitBinary(int offset, long totalMessageLength) {
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 53 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 45 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 37 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 29 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 21 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 13 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 5 & 0xFFL);
        this._IV_And_Length[offset++] = (byte)(totalMessageLength << 3 & 0xF8L);
    }

    private void dumpTotalMessageLengthAs128BitBinary(int offset, long totalMessageLength) {
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = 0;
        this._IV_And_Length[offset++] = (byte)(totalMessageLength >> 61 & 0xFFL);
        this.dumpTotalMessageLengthAs64BitBinary(offset, totalMessageLength);
    }

    public void update(byte[] in, int inputLength, int inputOffset) {
        if (hardware == hw.zseries) {
            this.z_update(in, inputLength, inputOffset);
        } else if (hardware == hw.pseries) {
            this.p_update(in, inputLength, inputOffset);
        }
    }

    private void p_update(byte[] in, int inputLength, int inputOffset) {
        int tempInputOffset = inputOffset;
        for (int tempInputLen = inputLength; tempInputLen >= 2 * this._ivLength; tempInputLen -= 2 * this._ivLength) {
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(in, this._IV_And_Length, tempInputOffset, 0, 2 * this._ivLength, !this._isSHA256);
            } else {
                System.arraycopy((Object)in, tempInputOffset, (Object)this._IV_And_Length, 0, 2 * this._ivLength);
            }
            if (this._isSHA256) {
                JITFullHardwareDigest.sha256(this._IV_And_Length);
            } else {
                JITFullHardwareDigest.sha512(this._IV_And_Length);
            }
            tempInputOffset += 2 * this._ivLength;
        }
    }

    public void init(byte[] IV) {
        if (hardware == hw.zseries) {
            this.z_init(IV);
        } else if (hardware == hw.pseries) {
            this.p_init(IV);
        }
    }

    private void z_init(byte[] IV) {
        assert (IV.length == this._ivLength);
        if (this._IV_And_Length == null || this._messageLengthFieldLength + this._ivLength > this._IV_And_Length.length) {
            this._IV_And_Length = new byte[this._messageLengthFieldLength + this._ivLength];
        }
        System.arraycopy((Object)IV, 0, (Object)this._IV_And_Length, 0, this._ivLength);
        Arrays.fill(this._IV_And_Length, this._ivLength, this._ivLength + this._messageLengthFieldLength, (byte)0);
    }

    private void p_init(byte[] IV) {
        if (this._IV_And_Length == null || this._messageLengthFieldLength + this._ivLength > this._IV_And_Length.length) {
            this._IV_And_Length = new byte[this._messageLengthFieldLength + this._ivLength];
        }
        if (0 == (cryptoHardwareFeatures & 1)) {
            System.arraycopy((Object)IV, 0, (Object)this._IV_And_Length, this._messageLengthFieldLength, this._ivLength);
            return;
        }
        JITFullHardwareDigest.flipMessageBlockBytesLE(IV, this._IV_And_Length, 0, this._messageLengthFieldLength, this._ivLength, !this._isSHA256);
    }

    public static boolean isSupportedByHardware(String algorithm) {
        if (hardware == hw.xseries || disableHardwareAcceleration) {
            return false;
        }
        JITFullHardwareDigest element = null;
        for (int i = 0; i < knownParms.length; ++i) {
            element = knownParms[i];
            if (element._algorithmName.equals(algorithm)) break;
            element = null;
        }
        if (element == null) {
            return false;
        }
        if (hardware == hw.zseries) {
            if ((supportedKIMD[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) == 0) {
                return false;
            }
            return (supportedKLMD[element._mode / 8] & (byte)(1 << 7 - element._mode % 8)) != 0;
        }
        boolean ret = element._isSHA256 ? 0 != (cryptoHardwareFeatures & 2) : 0 != (cryptoHardwareFeatures & 4);
        return ret;
    }

    public byte[] getIV(byte[] result, int offset) {
        if (this._ivLength == 0) {
            return null;
        }
        if (hardware == hw.zseries) {
            System.arraycopy((Object)this._IV_And_Length, 0, (Object)result, offset, result.length - offset);
        } else {
            System.arraycopy((Object)this._IV_And_Length, this._messageLengthFieldLength, (Object)result, offset, result.length - offset);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(result, result, 0, 0, this._ivLength, !this._isSHA256);
            }
        }
        return result;
    }

    public byte[] getState(byte[] result, int offset, int length) {
        if (this._ivLength == 0) {
            return null;
        }
        if (hardware == hw.zseries) {
            System.arraycopy((Object)this._IV_And_Length, 0, (Object)result, offset, length);
        } else {
            System.arraycopy((Object)this._IV_And_Length, this._messageLengthFieldLength, (Object)result, offset, length);
            if (0 != (cryptoHardwareFeatures & 1)) {
                JITFullHardwareDigest.flipMessageBlockBytesLE(result, result, 0, 0, length, !this._isSHA256);
            }
        }
        return result;
    }

    public int getIVSize() {
        return this._ivLength;
    }

    @CallerSensitive
    public static JITFullHardwareDigest getDigest(String algorithm) {
        ClassLoader callerClassLoader = Reflection.getCallerClass().getClassLoader();
        if (callerClassLoader != null && callerClassLoader != VM.getVMLangAccess().getExtClassLoader()) {
            throw new SecurityException(JITFullHardwareDigest.class.getName());
        }
        for (int i = 0; i < knownParms.length; ++i) {
            JITFullHardwareDigest element = knownParms[i];
            if (!element._algorithmName.equals(algorithm)) continue;
            return JITFullHardwareDigest.copy(element);
        }
        return null;
    }

    private JITFullHardwareDigest() {
        this._algorithmName = null;
        this._mode = 0;
        this._messageLengthFieldLength = 0;
        this._ivLength = 0;
        this._lengthOffset = 0;
        this._IV_And_Length = null;
        this._isSHA256 = false;
    }

    private JITFullHardwareDigest(String algorithm, int messageLengthFieldLength, byte mode, int lengthOffset) {
        this._algorithmName = algorithm;
        this._mode = mode;
        this._lengthOffset = lengthOffset;
        this._ivLength = lengthOffset;
        this._messageLengthFieldLength = messageLengthFieldLength;
        this._isSHA256 = this._algorithmName.equalsIgnoreCase("SHA-256");
    }

    private static JITFullHardwareDigest copy(JITFullHardwareDigest in) {
        if (hardware == hw.zseries || hardware == hw.pseries) {
            return new JITFullHardwareDigest(in._algorithmName, in._messageLengthFieldLength, in._mode, in._lengthOffset);
        }
        return null;
    }

    private void z_update(byte[] in, int inputLength, int inputOffset) {
        JITFullHardwareDigest.z_kimd(in, inputLength, inputOffset, this._IV_And_Length, this._mode);
    }

    private void z_digest(byte[] in, int inputLength, int inputOffset) {
        JITFullHardwareDigest.z_klmd(in, inputLength, inputOffset, this._IV_And_Length, this._mode);
    }

    private static void z_kimd(byte[] in, int inputLength, int inputOffset, byte[] key_IV, int mode) {
        JITFullHardwareDigest.z_kimd_native(in, inputLength, inputOffset, key_IV, mode);
    }

    private static void z_klmd(byte[] in, int inputLength, int inputOffset, byte[] key_IV, int mode) {
        JITFullHardwareDigest.z_klmd_native(in, inputLength, inputOffset, key_IV, mode);
    }

    private static void zos_kmac(byte[] in, int inputLength, int inputOffset, byte[] key_IV, int mode) {
        JITFullHardwareDigest.z_kmac_native(in, inputLength, inputOffset, key_IV, mode);
    }

    private static native void z_kimd_native(byte[] var0, int var1, int var2, byte[] var3, int var4);

    private static native void z_klmd_native(byte[] var0, int var1, int var2, byte[] var3, int var4);

    private static native void z_kmac_native(byte[] var0, int var1, int var2, byte[] var3, int var4);

    private static native void z_kimd_supported(byte[] var0);

    private static native void z_klmd_supported(byte[] var0);

    private static native void z_kmac_supported(byte[] var0);

    private static native void sha256(byte[] var0);

    private static native void sha512(byte[] var0);

    private static native int getCryptoHardwareFeatures();

    static {
        disableHardwareAcceleration = null != System.getSecurityManager() ? "true".equalsIgnoreCase((String)AccessController.doPrivileged(new PriviAction("com.ibm.jit.crypto.nohardwaredigest", "false"))) : "true".equalsIgnoreCase(System.getProperty("com.ibm.jit.crypto.nohardwaredigest", "false"));
        if (JITAESCryptInHardware.osArch.equals("s390x") || JITAESCryptInHardware.osArch.equals("s390")) {
            hardware = hw.zseries;
            supportedKIMD = new byte[16];
            supportedKLMD = new byte[16];
            supportedKMAC = new byte[16];
            JITFullHardwareDigest.z_kimd_supported(supportedKIMD);
            JITFullHardwareDigest.z_klmd_supported(supportedKLMD);
            JITFullHardwareDigest.z_kmac_supported(supportedKMAC);
            knownParms = new JITFullHardwareDigest[3];
            JITFullHardwareDigest.knownParms[0] = new JITFullHardwareDigest("SHA-1", 8, 1, 20);
            JITFullHardwareDigest.knownParms[1] = new JITFullHardwareDigest("SHA-256", 8, 2, 32);
            JITFullHardwareDigest.knownParms[2] = new JITFullHardwareDigest("SHA-512", 16, 3, 64);
        } else if (JITAESCryptInHardware.osArch.equals("x86") || JITAESCryptInHardware.osArch.equals("amd64")) {
            hardware = hw.xseries;
        } else {
            cryptoHardwareFeatures = JITFullHardwareDigest.getCryptoHardwareFeatures();
            hardware = hw.pseries;
            knownParms = new JITFullHardwareDigest[2];
            JITFullHardwareDigest.knownParms[0] = new JITFullHardwareDigest("SHA-256", 256, 2, 32);
            JITFullHardwareDigest.knownParms[1] = new JITFullHardwareDigest("SHA-512", 640, 3, 64);
        }
    }

    private static enum hw {
        zseries,
        pseries,
        xseries;

    }
}

