/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed.reflect;

import com.ibm.jvm.packed.ImportPacked;
import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.types.PackedBoolean;
import com.ibm.jvm.packed.types.PackedByte;
import com.ibm.jvm.packed.types.PackedChar;
import com.ibm.jvm.packed.types.PackedDouble;
import com.ibm.jvm.packed.types.PackedFloat;
import com.ibm.jvm.packed.types.PackedInt;
import com.ibm.jvm.packed.types.PackedLong;
import com.ibm.jvm.packed.types.PackedShort;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;

@ImportPacked(value={"com/ibm/jvm/packed/types/PackedBoolean", "com/ibm/jvm/packed/types/PackedByte", "com/ibm/jvm/packed/types/PackedShort", "com/ibm/jvm/packed/types/PackedChar", "com/ibm/jvm/packed/types/PackedInt", "com/ibm/jvm/packed/types/PackedLong", "com/ibm/jvm/packed/types/PackedFloat", "com/ibm/jvm/packed/types/PackedDouble"})
public final class PackedArray {
    private PackedArray() {
    }

    private static void assertArrayIndexValid(PackedObject array, int index) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (null == array) {
            throw new NullPointerException("array");
        }
        if (!array.isPackedArray()) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index >= PackedArray.getLengthImpl(array)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public static <T extends PackedObject> T newArray(Class<T> packedArrayClass, int elementCount) throws IllegalArgumentException, NegativeArraySizeException, NullPointerException {
        if (null == packedArrayClass) {
            throw new NullPointerException();
        }
        if (elementCount < 0) {
            throw new NegativeArraySizeException();
        }
        if (!PackedObject.isPackedClass(packedArrayClass)) {
            throw new IllegalArgumentException(Msg.getString("PACKED2"));
        }
        if (!PackedObject.isPackedArray(packedArrayClass)) {
            throw new IllegalArgumentException(Msg.getString("PACKED4"));
        }
        Unsafe.getUnsafe().ensureClassInitialized(packedArrayClass);
        return PackedArray.newArrayImpl(packedArrayClass, elementCount);
    }

    private static native <T extends PackedObject> T newArrayImpl(Class<T> var0, int var1) throws IllegalArgumentException, NegativeArraySizeException, NullPointerException;

    @CallerSensitive
    public static <T extends PackedObject> T newNativeArray(Class<T> packedArrayClass, int elementCount, long dataPtr) throws IllegalArgumentException, NegativeArraySizeException, NullPointerException, SecurityException {
        if (dataPtr != 0L) {
            VM.ensureCalledFromBootstrapClass();
        }
        if (0 > elementCount) {
            throw new NegativeArraySizeException();
        }
        return PackedArray.newNativeArrayImpl(packedArrayClass, elementCount, dataPtr);
    }

    public static <T extends PackedObject> T newNativeArray(Class<T> packedArrayClass, int elementCount) throws IllegalArgumentException, NegativeArraySizeException, NullPointerException {
        if (0 > elementCount) {
            throw new NegativeArraySizeException();
        }
        return PackedArray.newNativeArrayImpl(packedArrayClass, elementCount, 0L);
    }

    private static native <T extends PackedObject> T newNativeArrayImpl(Class<T> var0, int var1, long var2) throws IllegalArgumentException, NegativeArraySizeException, NullPointerException;

    public static int getLength(PackedObject packedArray) {
        if (null == packedArray) {
            throw new NullPointerException();
        }
        if (!PackedObject.isPackedArray(packedArray.getClass())) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        return PackedArray.getLengthImpl(packedArray);
    }

    private static native int getLengthImpl(PackedObject var0);

    public static <T extends PackedObject> T at(PackedObject packedArray, int index) {
        if (null == packedArray) {
            throw new NullPointerException();
        }
        if (!PackedObject.isPackedArray(packedArray.getClass())) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        if (index < 0 || index >= PackedArray.getLengthImpl(packedArray)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return PackedArray.atImpl(packedArray, index);
    }

    private static native <T extends PackedObject> T atImpl(PackedObject var0, int var1);

    public static Class<? extends PackedObject> getComponentType(Class<? extends PackedObject> packedArrayClass) {
        if (null == packedArrayClass) {
            throw new NullPointerException();
        }
        return PackedArray.getComponentTypeImpl(packedArrayClass);
    }

    private static native Class<? extends PackedObject> getComponentTypeImpl(Class<? extends PackedObject> var0);

    public static Class<? extends PackedObject> getPackedArrayClass(Class<? extends PackedObject> packedClass) throws ClassNotFoundException, IllegalArgumentException {
        if (null == packedClass) {
            throw new NullPointerException();
        }
        Class<? extends PackedObject> arrayClass = PackedArray.getPackedArrayClassImpl(packedClass);
        if (null == arrayClass) {
            String arrayClassName = packedClass.getName() + "$Array";
            Class<?> foundClass = Class.forName(arrayClassName, true, packedClass.getClassLoader());
            if (!PackedObject.isPackedArray(foundClass)) {
                throw new ClassNotFoundException(Msg.getString("PACKED3", arrayClassName));
            }
            arrayClass = foundClass.asSubclass(PackedObject.class);
        }
        return arrayClass;
    }

    private static native Class<? extends PackedObject> getPackedArrayClassImpl(Class<? extends PackedObject> var0) throws IllegalArgumentException;

    public static boolean getBoolean(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedBoolean.class)) {
            return ((PackedBoolean)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static byte getByte(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static short getShort(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedShort.class)) {
            return ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static char getChar(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedChar.class)) {
            return ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static int getInt(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedChar.class)) {
            return ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedShort.class)) {
            return ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedInt.class)) {
            return ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static long getLong(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedChar.class)) {
            return ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedShort.class)) {
            return ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedInt.class)) {
            return ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedLong.class)) {
            return ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static float getFloat(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedChar.class)) {
            return ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedShort.class)) {
            return ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedInt.class)) {
            return ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedLong.class)) {
            return ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedFloat.class)) {
            return ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static double getDouble(PackedObject array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            return ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedChar.class)) {
            return ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedShort.class)) {
            return ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedInt.class)) {
            return ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedLong.class)) {
            return ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedFloat.class)) {
            return ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        if (componentType.equals(PackedDouble.class)) {
            return ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value;
        }
        throw new IllegalArgumentException();
    }

    public static PackedObject getPackedObject(PackedObject array, int index) throws ArrayIndexOutOfBoundsException {
        return PackedArray.at(array, index);
    }

    public static void setBoolean(PackedObject array, int index, boolean value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (!componentType.equals(PackedBoolean.class)) {
            throw new IllegalArgumentException();
        }
        ((PackedBoolean)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
    }

    public static void setByte(PackedObject array, int index, byte value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedByte.class)) {
            ((PackedByte)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedShort.class)) {
            ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedInt.class)) {
            ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedLong.class)) {
            ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setShort(PackedObject array, int index, short value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedShort.class)) {
            ((PackedShort)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedInt.class)) {
            ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedLong.class)) {
            ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setChar(PackedObject array, int index, char value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedChar.class)) {
            ((PackedChar)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedInt.class)) {
            ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedLong.class)) {
            ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setInt(PackedObject array, int index, int value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedInt.class)) {
            ((PackedInt)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedLong.class)) {
            ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setLong(PackedObject array, int index, long value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedLong.class)) {
            ((PackedLong)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setFloat(PackedObject array, int index, float value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (componentType.equals(PackedFloat.class)) {
            ((PackedFloat)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else if (componentType.equals(PackedDouble.class)) {
            ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void setDouble(PackedObject array, int index, double value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        Class<? extends PackedObject> componentType = PackedArray.getComponentTypeImpl(array.getClass());
        if (!componentType.equals(PackedDouble.class)) {
            throw new IllegalArgumentException();
        }
        ((PackedDouble)PackedArray.atImpl((PackedObject)array, (int)index)).value = value;
    }

    public static void setNestedPackedObject(PackedObject array, int index, PackedObject value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        PackedArray.assertArrayIndexValid(array, index);
        if (null == value) {
            throw new NullPointerException("value");
        }
        if (PackedArray.getComponentTypeImpl(array.getClass()) != value.getClass()) {
            throw new IllegalArgumentException();
        }
        ((PackedObject)PackedArray.atImpl(array, index)).copyFrom(value);
    }

    public static <T extends PackedObject> T copyOf(T original, int newLength) {
        if (null == original) {
            throw new NullPointerException();
        }
        if (!original.isPackedArray()) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        if (newLength < 0) {
            throw new NegativeArraySizeException();
        }
        Object copy = null;
        copy = original.isNativePacked() ? PackedArray.newNativeArray(original.getClass(), newLength, 0L) : PackedArray.newArray(original.getClass(), newLength);
        if (newLength > PackedArray.getLengthImpl(original)) {
            newLength = PackedArray.getLengthImpl(original);
        }
        for (int i = 0; i < newLength; ++i) {
            ((PackedObject)PackedArray.at((PackedObject)copy, i)).copyFrom((PackedObject)PackedArray.at(original, i));
        }
        return (T)copy;
    }

    public static <T extends PackedObject> T copyOfRange(T original, int from, int to) {
        if (null == original) {
            throw new NullPointerException();
        }
        if (!original.isPackedArray()) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        if (from < 0 || from > PackedArray.getLengthImpl(original)) {
            throw new ArrayIndexOutOfBoundsException("from: " + from);
        }
        if (to < from) {
            throw new IllegalArgumentException("from: " + from + ", to: " + to);
        }
        Object copy = null;
        int newLength = to - from;
        copy = original.isNativePacked() ? PackedArray.newNativeArray(original.getClass(), newLength, 0L) : PackedArray.newArray(original.getClass(), newLength);
        if (to > PackedArray.getLengthImpl(original)) {
            to = PackedArray.getLengthImpl(original);
        }
        for (int i = from; i < to; ++i) {
            ((PackedObject)PackedArray.at((PackedObject)copy, i - from)).copyFrom((PackedObject)PackedArray.at(original, i));
        }
        return (T)copy;
    }

    public static void fill(PackedObject array, PackedObject value) throws ArrayStoreException, NullPointerException {
        PackedArray.fill(array, 0, PackedArray.getLength(array), value);
    }

    public static void fill(PackedObject array, int from, int to, PackedObject value) throws ArrayIndexOutOfBoundsException, ArrayStoreException, IllegalArgumentException, NullPointerException {
        if (null == array || null == value) {
            throw new NullPointerException();
        }
        if (!array.isPackedArray()) {
            throw new IllegalArgumentException(Msg.getString("PACKED5"));
        }
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("from: " + from);
        }
        if (to > PackedArray.getLengthImpl(array)) {
            throw new ArrayIndexOutOfBoundsException("to: " + to);
        }
        if (to < from) {
            throw new IllegalArgumentException("from: " + from + ", to: " + to);
        }
        if (value.getClass() != PackedArray.getComponentType(array.getClass())) {
            throw new ArrayStoreException();
        }
        if (from < to) {
            Object tempval;
            try {
                tempval = PackedObject.newPackedObject(value.getClass());
            }
            catch (InstantiationException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
            ((PackedObject)tempval).copyFrom(value);
            for (int i = from; i < to; ++i) {
                ((PackedObject)PackedArray.at(array, i)).copyFrom((PackedObject)tempval);
            }
        }
    }

    public static String toString(PackedObject a) {
        if (null == a) {
            return "null";
        }
        if (0 == PackedArray.getLength(a)) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        sb.append(((PackedObject)PackedArray.at(a, 0)).toString());
        for (int i = 1; i < PackedArray.getLength(a); ++i) {
            sb.append(", ");
            sb.append(((PackedObject)PackedArray.at(a, i)).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean equals(PackedObject a1, PackedObject a2) {
        if (null == a1) {
            return a2 == null;
        }
        if (null == a2) {
            return false;
        }
        if (!a1.isPackedArray()) {
            throw new IllegalArgumentException("a1: " + Msg.getString("PACKED5"));
        }
        if (!a2.isPackedArray()) {
            throw new IllegalArgumentException("a2: " + Msg.getString("PACKED5"));
        }
        int length = PackedArray.getLengthImpl(a1);
        if (length != PackedArray.getLengthImpl(a2)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (((PackedObject)PackedArray.atImpl(a1, i)).equals(PackedArray.atImpl(a2, i))) continue;
            return false;
        }
        return true;
    }

    static {
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
    }
}

