/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.packed.reflect;

import com.ibm.jvm.packed.Length;
import com.ibm.jvm.packed.PackedObject;
import com.ibm.jvm.packed.Unpacked;
import com.ibm.jvm.packed.reflect.PackedUnsafe;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.oti.vm.VMLangAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class PackedField
extends AccessibleObject
implements Member {
    private final FieldData fieldData;
    private static final Method checkMemberAccess;
    private static final VMLangAccess vma;

    private PackedField(Field field) throws IllegalArgumentException {
        Class<?> fieldClass = field.getType();
        if (Modifier.isStatic(field.getModifiers()) || PackedObject.isPackedArray(field.getDeclaringClass()) || !PackedObject.class.isAssignableFrom(field.getDeclaringClass())) {
            throw new IllegalArgumentException();
        }
        if (fieldClass == Boolean.TYPE) {
            this.fieldData = new BooleanFieldData(field);
        } else if (fieldClass == Byte.TYPE) {
            this.fieldData = new ByteFieldData(field);
        } else if (fieldClass == Short.TYPE) {
            this.fieldData = new ShortFieldData(field);
        } else if (fieldClass == Character.TYPE) {
            this.fieldData = new CharFieldData(field);
        } else if (fieldClass == Integer.TYPE) {
            this.fieldData = new IntFieldData(field);
        } else if (fieldClass == Long.TYPE) {
            this.fieldData = new LongFieldData(field);
        } else if (fieldClass == Float.TYPE) {
            this.fieldData = new FloatFieldData(field);
        } else if (fieldClass == Double.TYPE) {
            this.fieldData = new DoubleFieldData(field);
        } else if (field.isAnnotationPresent(Unpacked.class)) {
            this.fieldData = new ORefFieldData(field);
        } else if (PackedObject.isPackedArray(fieldClass)) {
            this.fieldData = field.isAnnotationPresent(Length.class) ? new NestedArrayFieldData(field) : new ORefFieldData(field);
        } else if (PackedObject.isPackedClass(fieldClass)) {
            this.fieldData = new NestedFieldData(field);
        } else if (Object.class.isAssignableFrom(fieldClass)) {
            this.fieldData = new ORefFieldData(field);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static native Field getDeclaredFieldImpl(Class<? extends PackedObject> var0, String var1) throws NoSuchFieldException, NullPointerException;

    private static native Field[] getDeclaredFieldsImpl(Class<? extends PackedObject> var0);

    private static native Field getFieldImpl(Class<? extends PackedObject> var0, String var1) throws NoSuchFieldException, NullPointerException;

    private static native Field[] getFieldsImpl(Class<? extends PackedObject> var0);

    private static boolean isInstanceField(Field field) {
        return false == Modifier.isStatic(field.getModifiers());
    }

    private static Field[] filterUnpackedFields(Class<? extends PackedObject> declaringClass, Field[] fields) {
        int keepIdx = 0;
        for (int lookIdx = 0; lookIdx < fields.length; ++lookIdx) {
            if (!PackedField.isInstanceField(fields[lookIdx])) continue;
            fields[keepIdx] = fields[lookIdx];
            ++keepIdx;
        }
        if (keepIdx < fields.length) {
            fields = Arrays.copyOf(fields, keepIdx);
        }
        return fields;
    }

    @CallerSensitive
    public static PackedField getDeclaredField(Class<? extends PackedObject> declaringClass, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException {
        Field field;
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == declaringClass) {
            throw new NullPointerException();
        }
        if (null == fieldName) {
            throw new NullPointerException();
        }
        if (!PackedObject.class.isAssignableFrom(declaringClass)) {
            throw new IllegalArgumentException(declaringClass + "." + fieldName);
        }
        if (PackedObject.isPackedArray(declaringClass)) {
            throw new NoSuchFieldException(declaringClass + "." + fieldName);
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                ClassLoader callerClassLoader = vma.getClassloader(Reflection.getCallerClass());
                checkMemberAccess.invoke(declaringClass, security, callerClassLoader, 1);
            }
            catch (IllegalArgumentException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SecurityException) {
                    throw (SecurityException)e.getCause();
                }
                throw (InternalError)new InternalError().initCause(e);
            }
        }
        if (null != (field = PackedField.getDeclaredFieldImpl(declaringClass, fieldName))) {
            if (PackedField.isInstanceField(field)) {
                PackedField pf = new PackedField(field);
                return pf;
            }
            throw new IllegalArgumentException(declaringClass + "." + fieldName);
        }
        throw new NoSuchFieldException(declaringClass + "." + fieldName);
    }

    @CallerSensitive
    public static PackedField[] getDeclaredFields(Class<? extends PackedObject> declaringClass) throws NullPointerException, SecurityException {
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == declaringClass) {
            throw new NullPointerException();
        }
        if (!PackedObject.class.isAssignableFrom(declaringClass)) {
            return new PackedField[0];
        }
        if (PackedObject.isPackedArray(declaringClass)) {
            return new PackedField[0];
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                ClassLoader callerClassLoader = vma.getClassloader(Reflection.getCallerClass());
                checkMemberAccess.invoke(declaringClass, security, callerClassLoader, 1);
            }
            catch (IllegalArgumentException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SecurityException) {
                    throw (SecurityException)e.getCause();
                }
                throw (InternalError)new InternalError().initCause(e);
            }
        }
        Field[] fa = PackedField.filterUnpackedFields(declaringClass, PackedField.getDeclaredFieldsImpl(declaringClass));
        PackedField[] pfa = new PackedField[fa.length];
        for (int i = 0; i < pfa.length; ++i) {
            pfa[i] = new PackedField(fa[i]);
        }
        return pfa;
    }

    @CallerSensitive
    public static PackedField getField(Class<? extends PackedObject> lookupClass, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException {
        Field field;
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == lookupClass) {
            throw new NullPointerException();
        }
        if (null == fieldName) {
            throw new NullPointerException();
        }
        if (!PackedObject.class.isAssignableFrom(lookupClass)) {
            throw new IllegalArgumentException(lookupClass + "." + fieldName);
        }
        if (PackedObject.isPackedArray(lookupClass)) {
            throw new NoSuchFieldException(lookupClass + "." + fieldName);
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                ClassLoader callerClassLoader = vma.getClassloader(Reflection.getCallerClass());
                checkMemberAccess.invoke(lookupClass, security, callerClassLoader, 0);
            }
            catch (IllegalArgumentException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SecurityException) {
                    throw (SecurityException)e.getCause();
                }
                throw (InternalError)new InternalError().initCause(e);
            }
        }
        if (null != (field = PackedField.getFieldImpl(lookupClass, fieldName))) {
            if (PackedField.isInstanceField(field)) {
                PackedField pf = new PackedField(field);
                return pf;
            }
            throw new IllegalArgumentException(lookupClass + "." + fieldName);
        }
        throw new NoSuchFieldException(lookupClass + "." + fieldName);
    }

    @CallerSensitive
    public static PackedField[] getFields(Class<? extends PackedObject> lookupClass) throws NullPointerException, SecurityException {
        if (!PackedObject.isPackedSupportEnabled()) {
            throw new UnsupportedOperationException(Msg.getString("PACKED1"));
        }
        if (null == lookupClass) {
            throw new NullPointerException();
        }
        if (!PackedObject.class.isAssignableFrom(lookupClass)) {
            return new PackedField[0];
        }
        if (PackedObject.isPackedArray(lookupClass)) {
            return new PackedField[0];
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                ClassLoader callerClassLoader = vma.getClassloader(Reflection.getCallerClass());
                checkMemberAccess.invoke(lookupClass, security, callerClassLoader, 0);
            }
            catch (IllegalArgumentException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (InternalError)new InternalError().initCause(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof SecurityException) {
                    throw (SecurityException)e.getCause();
                }
                throw (InternalError)new InternalError().initCause(e);
            }
        }
        Field[] fa = PackedField.filterUnpackedFields(lookupClass, PackedField.getFieldsImpl(lookupClass));
        PackedField[] pfa = new PackedField[fa.length];
        for (int i = 0; i < pfa.length; ++i) {
            pfa[i] = new PackedField(fa[i]);
        }
        return pfa;
    }

    public boolean equals(Object o) {
        if (o instanceof PackedField) {
            return this.fieldData.reflectField.equals(((PackedField)o).fieldData.reflectField);
        }
        return false;
    }

    public int hashCode() {
        return this.fieldData.reflectField.hashCode();
    }

    public String toString() {
        return this.fieldData.reflectField.toString();
    }

    public String toGenericString() {
        return this.fieldData.reflectField.toGenericString();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.fieldData.reflectField.getDeclaringClass();
    }

    @Override
    public int getModifiers() {
        return this.fieldData.reflectField.getModifiers();
    }

    @Override
    public String getName() {
        return this.fieldData.reflectField.getName();
    }

    @Override
    public boolean isSynthetic() {
        return this.fieldData.reflectField.isSynthetic();
    }

    public boolean isNestedPacked() {
        return this.fieldData instanceof NestedFieldData;
    }

    public boolean isEnumConstant() {
        return this.fieldData.reflectField.isEnumConstant();
    }

    public Class<?> getType() {
        return this.fieldData.reflectField.getType();
    }

    public Type getGenericType() {
        return this.fieldData.reflectField.getGenericType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.fieldData.reflectField.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.fieldData.reflectField.getDeclaredAnnotations();
    }

    public int getNestedArrayLength() throws IllegalArgumentException {
        return this.fieldData.getNestedArrayLength();
    }

    @CallerSensitive
    public boolean getBoolean(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getBoolean(packedObject, callingClass);
    }

    @CallerSensitive
    public byte getByte(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getByte(packedObject, callingClass);
    }

    @CallerSensitive
    public char getChar(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getChar(packedObject, callingClass);
    }

    @CallerSensitive
    public short getShort(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getShort(packedObject, callingClass);
    }

    @CallerSensitive
    public int getInt(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getInt(packedObject, callingClass);
    }

    @CallerSensitive
    public long getLong(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getLong(packedObject, callingClass);
    }

    @CallerSensitive
    public float getFloat(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getFloat(packedObject, callingClass);
    }

    @CallerSensitive
    public double getDouble(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getDouble(packedObject, callingClass);
    }

    @CallerSensitive
    public Object getObject(PackedObject packedObject) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        return this.fieldData.getObject(packedObject, callingClass);
    }

    @CallerSensitive
    public void setBoolean(PackedObject packedObject, boolean value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setBoolean(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setByte(PackedObject packedObject, byte value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setByte(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setChar(PackedObject packedObject, char value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setChar(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setShort(PackedObject packedObject, short value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setShort(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setInt(PackedObject packedObject, int value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setInt(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setLong(PackedObject packedObject, long value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setLong(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setFloat(PackedObject packedObject, float value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setFloat(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setDouble(PackedObject packedObject, double value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setDouble(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setObject(PackedObject packedObject, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setObject(packedObject, value, callingClass);
    }

    @CallerSensitive
    public void setNestedPackedObject(PackedObject packedObject, PackedObject value) throws IllegalAccessException, IllegalArgumentException {
        Class callingClass = null;
        if (!this.isAccessible()) {
            callingClass = Reflection.getCallerClass();
        }
        this.fieldData.setNestedObject(packedObject, value, callingClass);
    }

    static {
        vma = VM.getVMLangAccess();
        Method m = null;
        try {
            m = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws NoSuchMethodException {
                    Method m2 = Class.class.getDeclaredMethod("checkMemberAccess", SecurityManager.class, ClassLoader.class, Integer.TYPE);
                    m2.setAccessible(true);
                    return m2;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (InternalError)new InternalError().initCause(e.getCause());
        }
        checkMemberAccess = m;
    }

    private static final class ORefFieldData
    extends PrimitiveFieldData {
        ORefFieldData(Field field) {
            super(field);
            if (this.isStatic) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getObject(packedObject, this.fieldOffset);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            Class<? extends Object> fieldClass = this.reflectField.getType();
            if (null != value && !fieldClass.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException();
            }
            unsafe.putObject(packedObject, this.fieldOffset, value);
        }
    }

    private static final class NestedArrayFieldData
    extends NestedFieldData {
        private final int arrayLength;

        NestedArrayFieldData(Field field) {
            super(field);
            this.arrayLength = NestedArrayFieldData.arrayLengthImpl(field);
            if (this.arrayLength < 0) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        int getNestedArrayLength() {
            return this.arrayLength;
        }

        @Override
        PackedObject getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getNestedPackedArray(packedObject, this.fieldOffset, this.reflectField.getType().asSubclass(PackedObject.class), this.arrayLength);
        }
    }

    private static class NestedFieldData
    extends PrimitiveFieldData {
        NestedFieldData(Field field) {
            super(field);
        }

        @Override
        PackedObject getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getNestedPackedObject(packedObject, this.fieldOffset, this.reflectField.getType().asSubclass(PackedObject.class));
        }

        @Override
        void setNestedObject(PackedObject packedObject, PackedObject value, Class<?> callingClass) throws IllegalAccessException, IllegalArgumentException {
            this.checkInstanceSet(packedObject, callingClass);
            if (null == value) {
                throw new NullPointerException();
            }
            if (value.getClass() != this.reflectField.getType()) {
                throw new IllegalArgumentException();
            }
            ((PackedObject)this.getObject(packedObject, (Class)callingClass)).copyFrom(value);
        }
    }

    private static final class DoubleFieldData
    extends PrimitiveFieldData {
        DoubleFieldData(Field field) {
            super(field);
        }

        protected double getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getDouble(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, double value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putDouble(packedObject, this.fieldOffset, value);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setInt(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setLong(PackedObject packedObject, long value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setFloat(PackedObject packedObject, float value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setDouble(PackedObject packedObject, double value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (value instanceof Byte) {
                this.setValue(packedObject, ((Byte)value).doubleValue(), callingClass);
            } else if (value instanceof Short) {
                this.setValue(packedObject, ((Short)value).doubleValue(), callingClass);
            } else if (value instanceof Character) {
                this.setValue(packedObject, ((Character)value).charValue(), callingClass);
            } else if (value instanceof Integer) {
                this.setValue(packedObject, ((Integer)value).doubleValue(), callingClass);
            } else if (value instanceof Long) {
                this.setValue(packedObject, ((Long)value).doubleValue(), callingClass);
            } else if (value instanceof Float) {
                this.setValue(packedObject, ((Float)value).doubleValue(), callingClass);
            } else if (value instanceof Double) {
                this.setValue(packedObject, (Double)value, callingClass);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static final class FloatFieldData
    extends PrimitiveFieldData {
        FloatFieldData(Field field) {
            super(field);
        }

        protected float getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getFloat(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, float value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putFloat(packedObject, this.fieldOffset, value);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return Float.valueOf(this.getValue(packedObject, callingClass));
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setInt(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setLong(PackedObject packedObject, long value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setFloat(PackedObject packedObject, float value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (value instanceof Byte) {
                this.setValue(packedObject, ((Byte)value).floatValue(), callingClass);
            } else if (value instanceof Short) {
                this.setValue(packedObject, ((Short)value).floatValue(), callingClass);
            } else if (value instanceof Character) {
                this.setValue(packedObject, ((Character)value).charValue(), callingClass);
            } else if (value instanceof Integer) {
                this.setValue(packedObject, ((Integer)value).floatValue(), callingClass);
            } else if (value instanceof Long) {
                this.setValue(packedObject, ((Long)value).floatValue(), callingClass);
            } else if (value instanceof Float) {
                this.setValue(packedObject, ((Float)value).floatValue(), callingClass);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static final class LongFieldData
    extends PrimitiveFieldData {
        LongFieldData(Field field) {
            super(field);
        }

        protected long getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getLong(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, long value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putLong(packedObject, this.fieldOffset, value);
        }

        @Override
        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setInt(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setLong(PackedObject packedObject, long value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (value instanceof Byte) {
                this.setValue(packedObject, ((Byte)value).longValue(), callingClass);
            } else if (value instanceof Short) {
                this.setValue(packedObject, ((Short)value).longValue(), callingClass);
            } else if (value instanceof Character) {
                this.setValue(packedObject, ((Character)value).charValue(), callingClass);
            } else if (value instanceof Integer) {
                this.setValue(packedObject, ((Integer)value).longValue(), callingClass);
            } else if (value instanceof Long) {
                this.setValue(packedObject, (Long)value, callingClass);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static final class IntFieldData
    extends PrimitiveFieldData {
        IntFieldData(Field field) {
            super(field);
        }

        protected int getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getInt(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putInt(packedObject, this.fieldOffset, value);
        }

        @Override
        int getInt(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setInt(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (value instanceof Byte) {
                this.setValue(packedObject, ((Byte)value).intValue(), callingClass);
            } else if (value instanceof Short) {
                this.setValue(packedObject, ((Short)value).intValue(), callingClass);
            } else if (value instanceof Character) {
                this.setValue(packedObject, ((Character)value).charValue(), callingClass);
            } else if (value instanceof Integer) {
                this.setValue(packedObject, (Integer)value, callingClass);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static final class CharFieldData
    extends PrimitiveFieldData {
        CharFieldData(Field field) {
            super(field);
        }

        protected char getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getChar(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putChar(packedObject, this.fieldOffset, value);
        }

        @Override
        char getChar(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        int getInt(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return Character.valueOf(this.getValue(packedObject, callingClass));
        }

        @Override
        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (!(value instanceof Character)) {
                throw new IllegalArgumentException();
            }
            this.setValue(packedObject, ((Character)value).charValue(), callingClass);
        }
    }

    private static final class ShortFieldData
    extends PrimitiveFieldData {
        ShortFieldData(Field field) {
            super(field);
        }

        protected short getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getShort(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putShort(packedObject, this.fieldOffset, value);
        }

        @Override
        short getShort(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        int getInt(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (value instanceof Byte) {
                this.setValue(packedObject, ((Byte)value).shortValue(), callingClass);
            } else if (value instanceof Short) {
                this.setValue(packedObject, (Short)value, callingClass);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private static final class ByteFieldData
    extends PrimitiveFieldData {
        ByteFieldData(Field field) {
            super(field);
        }

        protected byte getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getByte(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putByte(packedObject, this.fieldOffset, value);
        }

        @Override
        byte getByte(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        short getShort(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        int getInt(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (!(value instanceof Byte)) {
                throw new IllegalArgumentException();
            }
            this.setValue(packedObject, (Byte)value, callingClass);
        }
    }

    private static final class BooleanFieldData
    extends PrimitiveFieldData {
        BooleanFieldData(Field field) {
            super(field);
        }

        protected boolean getValue(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceGet(packedObject, callingClass);
            return unsafe.getBoolean(packedObject, this.fieldOffset);
        }

        protected void setValue(PackedObject packedObject, boolean value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.checkInstanceSet(packedObject, callingClass);
            unsafe.putBoolean(packedObject, this.fieldOffset, value);
        }

        @Override
        boolean getBoolean(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            return this.getValue(packedObject, callingClass);
        }

        @Override
        void setBoolean(PackedObject packedObject, boolean value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(packedObject, value, callingClass);
        }

        @Override
        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            if (null == value) {
                throw new IllegalArgumentException();
            }
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            this.setValue(packedObject, (Boolean)value, callingClass);
        }
    }

    private static abstract class PrimitiveFieldData
    extends FieldData {
        PrimitiveFieldData(Field field) {
            super(field);
            if (this.isStatic) {
                throw new IllegalArgumentException();
            }
            if (!PackedObject.isPackedClass(field.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
        }
    }

    private static abstract class FieldData {
        protected static PackedUnsafe unsafe = PackedUnsafe.getUnsafe();
        protected final Field reflectField;
        protected final boolean isStatic;
        protected final int fieldModifiers;
        protected final long fieldOffset;
        private static final VMLangAccess vma = VM.getVMLangAccess();

        protected static native long fieldOffsetImpl(Field var0);

        protected static native int arrayLengthImpl(Field var0);

        protected FieldData(Field field) throws IllegalArgumentException {
            this.reflectField = field;
            this.fieldModifiers = field.getModifiers();
            this.isStatic = Modifier.isStatic(this.fieldModifiers);
            this.fieldOffset = FieldData.fieldOffsetImpl(field);
        }

        private IllegalAccessException newIllegalAccessException(Class<?> callingClass, Class<?> declaringClass, int testModifiers) {
            String msg = "Class " + callingClass.getName() + " cannot access a" + (testModifiers != 0 ? " " + Modifier.toString(testModifiers) + " " : " ") + "field in class " + declaringClass.getName();
            return new IllegalAccessException(msg);
        }

        private void checkClassValidity(Class<?> clazz) {
        }

        private static boolean isSamePackage(Class<?> callingClass, Class<?> declaringClass) {
            if (callingClass == declaringClass) {
                return true;
            }
            return vma.getPackageName(callingClass).equals(vma.getPackageName(declaringClass));
        }

        private void checkAccess(Class<?> declaringClass, int testModifiers, Class<?> callingClass, Class<?> runtimeClass) throws IllegalAccessException {
            if (!Modifier.isPublic(testModifiers)) {
                if (Modifier.isPrivate(testModifiers)) {
                    if (callingClass != declaringClass) {
                        throw this.newIllegalAccessException(callingClass, declaringClass, testModifiers);
                    }
                } else if (Modifier.isProtected(testModifiers)) {
                    if (!FieldData.isSamePackage(callingClass, declaringClass)) {
                        if (!declaringClass.isAssignableFrom(callingClass)) {
                            throw this.newIllegalAccessException(callingClass, declaringClass, testModifiers);
                        }
                        if (!callingClass.isAssignableFrom(runtimeClass)) {
                            throw this.newIllegalAccessException(callingClass, declaringClass, testModifiers);
                        }
                    }
                } else if (!FieldData.isSamePackage(callingClass, declaringClass)) {
                    throw this.newIllegalAccessException(callingClass, declaringClass, testModifiers);
                }
            }
        }

        protected void checkInstanceGet(PackedObject packedObject, Class<?> callingClass) throws IllegalAccessException, IllegalArgumentException {
            if (this.isStatic) {
                throw new IllegalArgumentException();
            }
            if (null == packedObject) {
                throw new NullPointerException("The specified object is null but the method is not static");
            }
            this.checkGet(packedObject.getClass(), callingClass);
        }

        protected void checkGet(Class<?> runtimeClass, Class<?> callingClass) throws IllegalAccessException, IllegalArgumentException {
            Class<?> declaringClass = this.reflectField.getDeclaringClass();
            if (!this.isStatic && !declaringClass.isAssignableFrom(runtimeClass)) {
                throw new IllegalArgumentException("The specified object should be an instance of " + declaringClass);
            }
            if (null != callingClass) {
                this.checkAccess(declaringClass, declaringClass.getModifiers(), callingClass, runtimeClass);
                this.checkAccess(declaringClass, this.fieldModifiers, callingClass, runtimeClass);
            }
            this.checkClassValidity(declaringClass);
        }

        protected void checkInstanceSet(PackedObject packedObject, Class<?> callingClass) throws IllegalAccessException, IllegalArgumentException {
            if (this.isStatic) {
                throw new IllegalArgumentException();
            }
            if (null == packedObject) {
                throw new NullPointerException("The specified object is null but the method is not static");
            }
            this.checkSet(packedObject.getClass(), callingClass);
        }

        protected void checkSet(Class<?> runtimeClass, Class<?> callingClass) throws IllegalAccessException, IllegalArgumentException {
            Class<?> declaringClass = this.reflectField.getDeclaringClass();
            if (!this.isStatic && !declaringClass.isAssignableFrom(runtimeClass)) {
                throw new IllegalArgumentException("The specified object should be an instance of " + declaringClass);
            }
            if (null != callingClass) {
                this.checkAccess(declaringClass, declaringClass.getModifiers(), callingClass, runtimeClass);
                this.checkAccess(declaringClass, this.fieldModifiers, callingClass, runtimeClass);
                if (Modifier.isFinal(this.fieldModifiers)) {
                    throw this.newIllegalAccessException(callingClass, declaringClass, this.fieldModifiers);
                }
            }
            this.checkClassValidity(declaringClass);
        }

        int getNestedArrayLength() throws IllegalArgumentException {
            throw new IllegalArgumentException();
        }

        boolean getBoolean(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        byte getByte(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        short getShort(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        char getChar(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        int getInt(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        long getLong(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        float getFloat(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        double getDouble(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        Object getObject(PackedObject packedObject, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setBoolean(PackedObject packedObject, boolean value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setByte(PackedObject packedObject, byte value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setShort(PackedObject packedObject, short value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setChar(PackedObject packedObject, char value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setInt(PackedObject packedObject, int value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setLong(PackedObject packedObject, long value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setFloat(PackedObject packedObject, float value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setDouble(PackedObject packedObject, double value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setNestedObject(PackedObject packedObject, PackedObject value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }

        void setObject(PackedObject packedObject, Object value, Class<?> callingClass) throws IllegalArgumentException, IllegalAccessException {
            throw new IllegalArgumentException();
        }
    }
}

