/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.CpuLoadCalculationConstants;
import com.ibm.lang.management.SysinfoCpuTime;

public class CpuUtilizationHelper
implements CpuLoadCalculationConstants {
    SysinfoCpuTime oldestTime = null;
    SysinfoCpuTime interimTime = null;
    SysinfoCpuTime latestTime = null;

    public synchronized double getSystemCpuLoad() {
        double cpuLoad = -1.0;
        this.latestTime = SysinfoCpuTime.getCpuUtilizationImpl();
        if (null == this.latestTime) {
            return -4.0;
        }
        int status = this.latestTime.getStatus();
        if (status < 0) {
            return status;
        }
        if (null == this.oldestTime) {
            this.oldestTime = this.interimTime = this.latestTime;
            return -1.0;
        }
        if (this.latestTime.getTimestamp() - this.interimTime.getTimestamp() >= 10000000L) {
            cpuLoad = this.calculateCpuLoad(this.latestTime, this.interimTime);
            if (cpuLoad >= 0.0) {
                this.oldestTime = this.interimTime;
                this.interimTime = this.latestTime;
                return cpuLoad;
            }
            this.interimTime = this.latestTime;
        }
        if (this.latestTime.getTimestamp() - this.oldestTime.getTimestamp() >= 10000000L && (cpuLoad = this.calculateCpuLoad(this.latestTime, this.oldestTime)) < 0.0) {
            this.oldestTime = this.latestTime;
        }
        return cpuLoad;
    }

    private double calculateCpuLoad(SysinfoCpuTime endRecord, SysinfoCpuTime startRecord) {
        double timestampDelta = endRecord.getTimestamp() - startRecord.getTimestamp();
        double cpuDelta = endRecord.getCpuTime() - startRecord.getCpuTime();
        if (timestampDelta <= 0.0 || cpuDelta < 0.0) {
            return -1.0;
        }
        return Math.min(cpuDelta / ((double)endRecord.getNumberOfCpus() * timestampDelta), 1.0);
    }
}

