/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.management.PlatformLoggingMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanInfo;

public class LoggingMXBeanImpl
extends DynamicMXBeanImpl
implements LoggingMXBean,
PlatformLoggingMXBean {
    private static LoggingMXBeanImpl instance = new LoggingMXBeanImpl();

    LoggingMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.util.logging:type=Logging"));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(LoggingMXBean.class.getName()));
        }
        return this.info;
    }

    static LoggingMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Level level = logger.getLevel();
            result = level != null ? level.getName() : "";
        }
        return result;
    }

    @Override
    public List<String> getLoggerNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
        }
        return result;
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        String result = null;
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger != null) {
            Logger parent = logger.getParent();
            result = parent != null ? parent.getName() : "";
        }
        return result;
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null) {
            throw new IllegalArgumentException(Msg.getString("K05E7", loggerName));
        }
        Level newLevel = Level.parse(levelName);
        logger.setLevel(newLevel);
    }
}

