/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.BufferPoolMXBeanImpl;
import com.ibm.lang.management.ClassLoadingMXBeanImpl;
import com.ibm.lang.management.CompilationMXBeanImpl;
import com.ibm.lang.management.ExtendedOperatingSystem;
import com.ibm.lang.management.GarbageCollectorMXBean;
import com.ibm.lang.management.GarbageCollectorMXBeanImpl;
import com.ibm.lang.management.JvmCpuMonitorInfo;
import com.ibm.lang.management.LoggingMXBeanImpl;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.PlatformMbeanListProvider;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.RuntimeMXBean;
import com.ibm.lang.management.RuntimeMXBeanImpl;
import com.ibm.lang.management.ThreadMXBean;
import com.ibm.lang.management.ThreadMXBeanImpl;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import com.ibm.lang.management.UnixOperatingSystemMXBean;
import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.GuestOSMemoryUsage;
import com.ibm.virtualization.management.GuestOSProcessorUsage;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.LockInfo;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryType;
import java.lang.management.MonitorInfo;
import java.lang.management.PlatformManagedObject;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcaster;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class ManagementUtils {
    private static Map<String, MBeanInfo> infoMap = ManagementUtils.buildInfoMap();
    private static CompositeType MEMORYUSAGE_COMPOSITETYPE;
    private static CompositeType MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType THREADINFO_COMPOSITETYPE;
    private static CompositeType MONITORINFO_COMPOSITETYPE;
    private static CompositeType LOCKINFO_COMPOSITETYPE;
    private static CompositeType STACKTRACEELEMENT_COMPOSITETYPE;
    private static CompositeType CILMMEMORYUSAGE_COMPOSITETYPE;
    private static CompositeType PROCESSORUSAGE_COMPOSITETYPE;
    private static CompositeType GUESTOSPROCESSORUSAGE_COMPOSITETYPE;
    private static CompositeType GUESTOSMEMORYUSAGE_COMPOSITETYPE;
    private static final boolean isUnix;
    public static final boolean VERBOSE_MODE;
    private static CompositeType JVMCPUMONITORINFO_COMPOSITETYPE;

    public static ClassLoadingMXBeanImpl getClassLoadingBean() {
        return ClassLoadingMXBeanImpl.getInstance();
    }

    private static boolean checkVerboseProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("com.ibm.lang.management.verbose") != null;
            }
        });
    }

    static MBeanInfo getMBeanInfo(String name) {
        Class MBeanInterface = null;
        Class commonInterface = null;
        Class ibmInterface = null;
        boolean isIBMInterface = false;
        StandardMBean smb = null;
        MBeanInfo mbinfo = null;
        try {
            if (!infoMap.containsKey(name)) {
                HashMap<String, Class> commonInterfaces = ManagementUtils.getLocalAvailableInterfaces();
                HashMap<String, Class> ibmInterfaces = ManagementUtils.getLocalIBMAvailableInterfaces();
                HashMap<String, Object> impls = ManagementUtils.getLocalAvailableImpls();
                if (commonInterfaces.containsKey(name) || ibmInterfaces.containsKey(name)) {
                    commonInterface = commonInterfaces.get(name);
                    ibmInterface = ibmInterfaces.get(name);
                    if (ibmInterface != null) {
                        isIBMInterface = true;
                        MBeanInterface = ibmInterface;
                    } else {
                        MBeanInterface = commonInterface;
                    }
                    smb = new StandardMBean(impls.get(name), MBeanInterface, true);
                    if (NotificationBroadcaster.class.isInstance(impls.get(name))) {
                        MBeanInfo mbi = smb.getMBeanInfo();
                        mbinfo = new MBeanInfo(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), ((NotificationBroadcaster)impls.get(name)).getNotificationInfo(), mbi.getDescriptor());
                    } else {
                        mbinfo = smb.getMBeanInfo();
                    }
                    infoMap.put(MBeanInterface.getName(), mbinfo);
                    if (isIBMInterface) {
                        infoMap.put(commonInterface.getName(), mbinfo);
                        Class alias = ManagementUtils.getAliasIBMAvailableInterfaces().get(MBeanInterface.getName());
                        if (alias != null) {
                            infoMap.put(alias.getName(), mbinfo);
                        }
                    }
                } else {
                    List<Class> interfacesFromVMUtils = ManagementUtils.getInterfacesFromVMUtils();
                    if (interfacesFromVMUtils != null) {
                        int index = -1;
                        for (int i = 0; i < interfacesFromVMUtils.size(); ++i) {
                            if (!name.equalsIgnoreCase(interfacesFromVMUtils.get(i).getName())) continue;
                            index = i;
                        }
                        if (index != -1) {
                            List<PlatformManagedObject> beansFromVMUtils = ManagementUtils.getBeansFromVMUtils();
                            MBeanInterface = interfacesFromVMUtils.get(index);
                            smb = new StandardMBean(beansFromVMUtils.get(index), MBeanInterface, true);
                            if (NotificationBroadcaster.class.isInstance(beansFromVMUtils.get(index))) {
                                MBeanInfo mbi = smb.getMBeanInfo();
                                mbinfo = new MBeanInfo(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), ((NotificationBroadcaster)((Object)beansFromVMUtils.get(index))).getNotificationInfo(), mbi.getDescriptor());
                            } else {
                                mbinfo = smb.getMBeanInfo();
                            }
                            infoMap.put(MBeanInterface.getName(), mbinfo);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return infoMap.get(name);
    }

    private static List<Class> getInterfacesFromVMUtils() {
        List<Class> interfacesFromVMUtils;
        block5: {
            interfacesFromVMUtils = null;
            try {
                Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                interfacesFromVMUtils = pmp.getAllAvailableMBeanInterfaces();
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                if (VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (InstantiationException e) {
                if (!VERBOSE_MODE) break block5;
                e.printStackTrace(System.err);
            }
        }
        return interfacesFromVMUtils;
    }

    private static List<PlatformManagedObject> getBeansFromVMUtils() {
        List<PlatformManagedObject> beansFromVMUtils;
        block5: {
            beansFromVMUtils = null;
            try {
                Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                beansFromVMUtils = pmp.getAllAvailableMBeans();
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                if (VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (InstantiationException e) {
                if (!VERBOSE_MODE) break block5;
                e.printStackTrace(System.err);
            }
        }
        return beansFromVMUtils;
    }

    private static Map<String, MBeanInfo> buildInfoMap() {
        HashMap<String, MBeanInfo> map = new HashMap<String, MBeanInfo>();
        CompilationMXBeanImpl.addCompilationBeanInfo(map);
        return map;
    }

    private static HashMap<String, Class> getLocalAvailableInterfaces() {
        HashMap<String, Class> ret = new HashMap<String, Class>();
        ret.put("java.lang.management.ClassLoadingMXBean", ClassLoadingMXBean.class);
        ret.put("java.lang.management.CompilationMXBean", CompilationMXBean.class);
        ret.put("java.util.logging.LoggingMXBean", LoggingMXBean.class);
        ret.put("java.lang.management.MemoryManagerMXBean", MemoryManagerMXBean.class);
        ret.put("java.lang.management.GarbageCollectorMXBean", java.lang.management.GarbageCollectorMXBean.class);
        ret.put("java.lang.management.MemoryMXBean", java.lang.management.MemoryMXBean.class);
        ret.put("java.lang.management.MemoryPoolMXBean", java.lang.management.MemoryPoolMXBean.class);
        ret.put("java.lang.management.OperatingSystemMXBean", java.lang.management.OperatingSystemMXBean.class);
        ret.put("java.lang.management.RuntimeMXBean", java.lang.management.RuntimeMXBean.class);
        ret.put("java.lang.management.ThreadMXBean", java.lang.management.ThreadMXBean.class);
        ret.put("com.ibm.lang.management.GarbageCollectorMXBean", java.lang.management.GarbageCollectorMXBean.class);
        ret.put("com.ibm.lang.management.MemoryMXBean", java.lang.management.MemoryMXBean.class);
        ret.put("com.ibm.lang.management.MemoryPoolMXBean", java.lang.management.MemoryPoolMXBean.class);
        ret.put("com.ibm.lang.management.OperatingSystemMXBean", java.lang.management.OperatingSystemMXBean.class);
        ret.put("com.ibm.lang.management.RuntimeMXBean", java.lang.management.RuntimeMXBean.class);
        ret.put("com.ibm.lang.management.ThreadMXBean", java.lang.management.ThreadMXBean.class);
        if (ManagementUtils.isRunningOnUnix()) {
            ret.put("com.ibm.lang.management.UnixOperatingSystemMXBean", java.lang.management.OperatingSystemMXBean.class);
        }
        return ret;
    }

    private static HashMap<String, Class> getLocalIBMAvailableInterfaces() {
        HashMap<String, Class> ret = new HashMap<String, Class>();
        ret.put("java.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBean.class);
        ret.put("java.lang.management.MemoryMXBean", MemoryMXBean.class);
        ret.put("java.lang.management.MemoryPoolMXBean", MemoryPoolMXBean.class);
        if (ManagementUtils.isRunningOnUnix()) {
            ret.put("java.lang.management.OperatingSystemMXBean", UnixOperatingSystemMXBean.class);
        } else {
            ret.put("java.lang.management.OperatingSystemMXBean", OperatingSystemMXBean.class);
        }
        ret.put("java.lang.management.RuntimeMXBean", RuntimeMXBean.class);
        ret.put("com.ibm.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBean.class);
        ret.put("com.ibm.lang.management.MemoryMXBean", MemoryMXBean.class);
        ret.put("com.ibm.lang.management.MemoryPoolMXBean", MemoryPoolMXBean.class);
        if (ManagementUtils.isRunningOnUnix()) {
            ret.put("com.ibm.lang.management.OperatingSystemMXBean", UnixOperatingSystemMXBean.class);
            ret.put("com.ibm.lang.management.UnixOperatingSystemMXBean", UnixOperatingSystemMXBean.class);
        } else {
            ret.put("com.ibm.lang.management.OperatingSystemMXBean", OperatingSystemMXBean.class);
        }
        ret.put("com.ibm.lang.management.RuntimeMXBean", RuntimeMXBean.class);
        ret.put("com.ibm.lang.management.ThreadMXBean", ThreadMXBean.class);
        return ret;
    }

    private static Map<String, Class> getAliasIBMAvailableInterfaces() {
        if (ManagementUtils.isRunningOnUnix()) {
            HashMap<String, Class> ret = new HashMap<String, Class>();
            ret.put("com.ibm.lang.management.UnixOperatingSystemMXBean", OperatingSystemMXBean.class);
            return ret;
        }
        return Collections.EMPTY_MAP;
    }

    private static HashMap<String, Object> getLocalAvailableImpls() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("java.lang.management.ClassLoadingMXBean", ClassLoadingMXBeanImpl.getInstance());
        ret.put("java.lang.management.CompilationMXBean", CompilationMXBeanImpl.getInstance());
        ret.put("java.util.logging.LoggingMXBean", LoggingMXBeanImpl.getInstance());
        ret.put("java.lang.management.MemoryManagerMXBean", MemoryManagerMXBeanImpl.getInstanceFromMgmtUtils());
        ret.put("java.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBeanImpl.getInstanceFromMgmtUtils());
        ret.put("java.lang.management.MemoryMXBean", MemoryMXBeanImpl.getInstance());
        ret.put("java.lang.management.MemoryPoolMXBean", MemoryPoolMXBeanImpl.getInstanceFromMgmtUtils());
        ret.put("java.lang.management.OperatingSystemMXBean", ExtendedOperatingSystem.getInstance());
        ret.put("java.lang.management.RuntimeMXBean", RuntimeMXBeanImpl.getInstance());
        ret.put("java.lang.management.ThreadMXBean", ThreadMXBeanImpl.getInstance());
        ret.put("com.ibm.lang.management.GarbageCollectorMXBean", GarbageCollectorMXBeanImpl.getInstanceFromMgmtUtils());
        ret.put("com.ibm.lang.management.MemoryMXBean", MemoryMXBeanImpl.getInstance());
        ret.put("com.ibm.lang.management.MemoryPoolMXBean", MemoryPoolMXBeanImpl.getInstanceFromMgmtUtils());
        ret.put("com.ibm.lang.management.OperatingSystemMXBean", ExtendedOperatingSystem.getInstance());
        ret.put("com.ibm.lang.management.RuntimeMXBean", RuntimeMXBeanImpl.getInstance());
        ret.put("com.ibm.lang.management.ThreadMXBean", ThreadMXBeanImpl.getInstance());
        if (ManagementUtils.isRunningOnUnix()) {
            ret.put("com.ibm.lang.management.UnixOperatingSystemMXBean", ExtendedOperatingSystem.getInstance());
        }
        return ret;
    }

    public static MemoryMXBeanImpl getMemoryBean() {
        return MemoryMXBeanImpl.getInstance();
    }

    public static ThreadMXBeanImpl getThreadBean() {
        return ThreadMXBeanImpl.getInstance();
    }

    public static RuntimeMXBeanImpl getRuntimeBean() {
        return RuntimeMXBeanImpl.getInstance();
    }

    public static ExtendedOperatingSystem getOperatingSystemBean() {
        return ExtendedOperatingSystem.getInstance();
    }

    public static CompilationMXBeanImpl getCompilationBean() {
        return CompilationMXBeanImpl.getInstance();
    }

    public static LoggingMXBeanImpl getLoggingBean() {
        return LoggingMXBeanImpl.getInstance();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return new LinkedList<MemoryManagerMXBean>(ManagementUtils.getMemoryBean().getMemoryManagerMXBeans());
    }

    public static List<java.lang.management.MemoryPoolMXBean> getMemoryPoolMXBeans() {
        HashSet<java.lang.management.MemoryPoolMXBean> set = new HashSet<java.lang.management.MemoryPoolMXBean>();
        LinkedList<java.lang.management.MemoryPoolMXBean> result = new LinkedList<java.lang.management.MemoryPoolMXBean>();
        for (MemoryManagerMXBean bean : ManagementUtils.getMemoryManagerMXBeans()) {
            MemoryManagerMXBeanImpl beanImpl = (MemoryManagerMXBeanImpl)bean;
            for (java.lang.management.MemoryPoolMXBean memoryPoolMXBean : beanImpl.getMemoryPoolMXBeans()) {
                if (set.contains(memoryPoolMXBean)) continue;
                result.add(memoryPoolMXBean);
                set.add(memoryPoolMXBean);
            }
        }
        return result;
    }

    public static List<java.lang.management.GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<java.lang.management.GarbageCollectorMXBean> result = new LinkedList<java.lang.management.GarbageCollectorMXBean>();
        for (MemoryManagerMXBean b : ManagementUtils.getMemoryBean().getMemoryManagerMXBeans()) {
            if (!(b instanceof java.lang.management.GarbageCollectorMXBean)) continue;
            result.add((java.lang.management.GarbageCollectorMXBean)b);
        }
        return result;
    }

    public static List<BufferPoolMXBean> getBufferPoolMXBeans() {
        return new LinkedList<BufferPoolMXBean>(BufferPoolMXBeanImpl.getBufferPoolMXBeans());
    }

    public static List<PlatformManagedObject> getAllAvailableMXBeans() {
        HashSet<Object> beanSet = new HashSet<Object>();
        beanSet.add(ManagementUtils.getClassLoadingBean());
        beanSet.add(ManagementUtils.getCompilationBean());
        beanSet.add(ManagementUtils.getLoggingBean());
        beanSet.add(ManagementUtils.getMemoryBean());
        beanSet.add(ManagementUtils.getThreadBean());
        beanSet.add(ManagementUtils.getRuntimeBean());
        beanSet.add(ManagementUtils.getOperatingSystemBean());
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getBufferPoolMXBeans()) {
            beanSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getMemoryPoolMXBeans()) {
            beanSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getGarbageCollectorMXBeans()) {
            beanSet.add(platformManagedObject);
        }
        for (PlatformManagedObject platformManagedObject : ManagementUtils.getMemoryManagerMXBeans()) {
            beanSet.add(platformManagedObject);
        }
        beanSet.remove(null);
        return new ArrayList<PlatformManagedObject>(beanSet);
    }

    public static void verifyFieldTypes(CompositeData cd, String[] expectedNames, String[] expectedTypes) {
        Object[] allVals = cd.getAll(expectedNames);
        if (allVals.length != expectedTypes.length) {
            throw new IllegalArgumentException(Msg.getString("K05E8"));
        }
        for (int i = 0; i < allVals.length; ++i) {
            String actualType;
            String expectedType = expectedTypes[i];
            Object actualVal = allVals[i];
            if (actualVal == null || (actualType = actualVal.getClass().getName()).equals(expectedType)) continue;
            if (expectedType.equals(CompositeData.class.getName())) {
                if (!(actualVal instanceof CompositeData)) continue;
                continue;
            }
            throw new IllegalArgumentException(Msg.getString("K05E9", expectedType, actualType));
        }
    }

    public static void verifyFieldNames(CompositeData cd, String[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (cd.containsKey(expected[i])) continue;
            throw new IllegalArgumentException(Msg.getString("K05EA", expected[i]));
        }
    }

    public static void verifyFieldNumber(CompositeData cd, int i) {
        if (cd == null) {
            throw new NullPointerException(Msg.getString("K05EB"));
        }
        if (cd.values().size() != i) {
            throw new IllegalArgumentException(Msg.getString("K05EC"));
        }
    }

    public static CompositeData toMemoryUsageCompositeData(java.lang.management.MemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (usage == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"init", "used", "committed", "max"};
            Object[] values = new Object[]{new Long(usage.getInit()), new Long(usage.getUsed()), new Long(usage.getCommitted()), new Long(usage.getMax())};
            CompositeType cType = ManagementUtils.getMemoryUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getMemoryUsageCompositeType() {
        block3: {
            if (MEMORYUSAGE_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"init", "used", "committed", "max"};
                String[] typeDescs = new String[]{"init", "used", "committed", "max"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                try {
                    MEMORYUSAGE_COMPOSITETYPE = new CompositeType(java.lang.management.MemoryUsage.class.getName(), java.lang.management.MemoryUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toMemoryNotificationInfoCompositeData(MemoryNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"poolName", "usage", "count"};
            Object[] values = new Object[]{new String(info.getPoolName()), ManagementUtils.toMemoryUsageCompositeData(info.getUsage()), new Long(info.getCount())};
            CompositeType cType = ManagementUtils.getMemoryNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private static CompositeType getMemoryNotificationInfoCompositeType() {
        block3: {
            if (MEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"poolName", "usage", "count"};
                String[] typeDescs = new String[]{"poolName", "usage", "count"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, ManagementUtils.getMemoryUsageCompositeType(), SimpleType.LONG};
                try {
                    MEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(MemoryNotificationInfo.class.getName(), MemoryNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getProcessingCapacityNotificationInfoCompositeType() {
        block3: {
            if (PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newProcessingCapacity"};
                String[] typeDescs = new String[]{"newProcessingCapacity"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.INTEGER};
                try {
                    PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(ProcessingCapacityNotificationInfo.class.getName(), ProcessingCapacityNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getTotalPhysicalMemoryNotificationInfoCompositeType() {
        block3: {
            if (TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newTotalPhysicalMemory"};
                String[] typeDescs = new String[]{"newTotalPhysicalMemory"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.LONG};
                try {
                    TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(TotalPhysicalMemoryNotificationInfo.class.getName(), TotalPhysicalMemoryNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getAvailableProcessorsNotificationInfoCompositeType() {
        block3: {
            if (AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newAvailableProcessors"};
                String[] typeDescs = new String[]{"newAvailableProcessors"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.INTEGER};
                try {
                    AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(AvailableProcessorsNotificationInfo.class.getName(), AvailableProcessorsNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toProcessingCapacityNotificationInfoCompositeData(ProcessingCapacityNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newProcessingCapacity"};
            Object[] values = new Object[]{new Integer(info.getNewProcessingCapacity())};
            CompositeType cType = ManagementUtils.getProcessingCapacityNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toTotalPhysicalMemoryNotificationInfoCompositeData(TotalPhysicalMemoryNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newTotalPhysicalMemory"};
            Object[] values = new Object[]{new Long(info.getNewTotalPhysicalMemory())};
            CompositeType cType = ManagementUtils.getTotalPhysicalMemoryNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toAvailableProcessorsNotificationInfoCompositeData(AvailableProcessorsNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newAvailableProcessors"};
            Object[] values = new Object[]{new Integer(info.getNewAvailableProcessors())};
            CompositeType cType = ManagementUtils.getAvailableProcessorsNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toThreadInfoCompositeData(ThreadInfo info) {
        CompositeDataSupport result;
        block6: {
            if (info == null) {
                return null;
            }
            result = null;
            StackTraceElement[] st = info.getStackTrace();
            CompositeData[] stArray = new CompositeData[st.length];
            for (int i = 0; i < st.length; ++i) {
                stArray[i] = ManagementUtils.toStackTraceElementCompositeData(st[i]);
            }
            MonitorInfo[] lockedMonitors = info.getLockedMonitors();
            CompositeData[] lmArray = new CompositeData[lockedMonitors.length];
            for (int i = 0; i < lmArray.length; ++i) {
                lmArray[i] = ManagementUtils.toMonitorInfoCompositeData(lockedMonitors[i]);
            }
            LockInfo[] lockedSynchronizers = info.getLockedSynchronizers();
            CompositeData[] lsArray = new CompositeData[lockedSynchronizers.length];
            for (int i = 0; i < lsArray.length; ++i) {
                lsArray[i] = ManagementUtils.toLockInfoCompositeData(lockedSynchronizers[i]);
            }
            String[] names = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
            Object[] values = new Object[]{new Long(info.getThreadId()), new String(info.getThreadName()), new String(info.getThreadState().name()), new Boolean(info.isSuspended()), new Boolean(info.isInNative()), new Long(info.getBlockedCount()), new Long(info.getBlockedTime()), new Long(info.getWaitedCount()), new Long(info.getWaitedTime()), info.getLockInfo() != null ? ManagementUtils.toLockInfoCompositeData(info.getLockInfo()) : null, info.getLockName() != null ? new String(info.getLockName()) : null, new Long(info.getLockOwnerId()), info.getLockOwnerName() != null ? new String(info.getLockOwnerName()) : null, stArray, lmArray, lsArray};
            CompositeType cType = ManagementUtils.getThreadInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block6;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toMonitorInfoCompositeData(MonitorInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            StackTraceElement frame = info.getLockedStackFrame();
            CompositeData frameCD = ManagementUtils.toStackTraceElementCompositeData(frame);
            Object[] values = new Object[]{new String(info.getClassName()), new Integer(info.getIdentityHashCode()), frameCD, new Integer(info.getLockedStackDepth())};
            CompositeType cType = ManagementUtils.getMonitorInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toLockInfoCompositeData(LockInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "identityHashCode"};
            Object[] values = new Object[]{new String(info.getClassName()), new Integer(info.getIdentityHashCode())};
            CompositeType cType = ManagementUtils.getLockInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toStackTraceElementCompositeData(StackTraceElement element) {
        CompositeDataSupport result;
        block3: {
            if (element == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
            String fileName = element.getFileName();
            String fileNameValue = fileName == null ? null : new String(fileName);
            Object[] values = new Object[]{new String(element.getClassName()), new String(element.getMethodName()), fileNameValue, new Integer(element.getLineNumber()), new Boolean(element.isNativeMethod())};
            CompositeType cType = ManagementUtils.getStackTraceElementCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private static CompositeType getMonitorInfoCompositeType() {
        block3: {
            if (MONITORINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    String[] typeDescs = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, ManagementUtils.getStackTraceElementCompositeType(), SimpleType.INTEGER};
                    MONITORINFO_COMPOSITETYPE = new CompositeType(MonitorInfo.class.getName(), MonitorInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MONITORINFO_COMPOSITETYPE;
    }

    public static CompositeType getLockInfoCompositeType() {
        block3: {
            if (LOCKINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"className", "identityHashCode"};
                    String[] typeDescs = new String[]{"className", "identityHashCode"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
                    LOCKINFO_COMPOSITETYPE = new CompositeType(LockInfo.class.getName(), LockInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return LOCKINFO_COMPOSITETYPE;
    }

    public static CompositeType getThreadInfoCompositeType() {
        block3: {
            if (THREADINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    String[] typeDescs = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, ManagementUtils.getLockInfoCompositeType(), SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, ManagementUtils.getStackTraceElementCompositeType()), new ArrayType(1, ManagementUtils.getMonitorInfoCompositeType()), new ArrayType(1, ManagementUtils.getLockInfoCompositeType())};
                    THREADINFO_COMPOSITETYPE = new CompositeType(ThreadInfo.class.getName(), ThreadInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return THREADINFO_COMPOSITETYPE;
    }

    private static CompositeType getStackTraceElementCompositeType() {
        block3: {
            if (STACKTRACEELEMENT_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                String[] typeDescs = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
                try {
                    STACKTRACEELEMENT_COMPOSITETYPE = new CompositeType(StackTraceElement.class.getName(), StackTraceElement.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return STACKTRACEELEMENT_COMPOSITETYPE;
    }

    public static List<String> convertStringArrayToList(String[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < data.length; ++i) {
            result.add(data[i]);
        }
        return result;
    }

    public static Object convertTabularDataToMap(TabularData data) {
        if (data == null) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Set<String> cdKeySet = data.getTabularType().getRowType().keySet();
        if (cdKeySet.size() != 2) {
            throw new IllegalArgumentException(Msg.getString("K05ED"));
        }
        String[] keysArray = new String[2];
        int count = 0;
        Iterator<String> keysIt = cdKeySet.iterator();
        while (keysIt.hasNext()) {
            keysArray[count++] = keysIt.next();
        }
        Collection<?> rows = data.values();
        for (CompositeData rowCD : rows) {
            result.put(rowCD.get(keysArray[0]), rowCD.get(keysArray[1]));
        }
        return result;
    }

    public static <T> T convertFromCompositeData(CompositeData data, Class<T> realClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Method forMethod = realClass.getMethod("from", CompositeData.class);
        return (T)forMethod.invoke(null, data);
    }

    public static <T> T convertFromOpenType(Object data, Class<?> openClass, Class<T> realClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Object result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            result = Array.newInstance(realElementClass, dataArray.length);
            for (int i = 0; i < Array.getLength(result); ++i) {
                Array.set(result, i, ManagementUtils.convertFromOpenType(dataArray[i], openElementClass, realElementClass));
            }
        } else if (openClass.equals(CompositeData.class)) {
            result = ManagementUtils.convertFromCompositeData((CompositeData)data, realClass);
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.convertTabularDataToMap((TabularData)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                result = ManagementUtils.convertStringArrayToList((String[])data);
            }
        } else if (openClass.equals(String.class) && realClass.equals(MemoryType.class)) {
            result = ManagementUtils.convertStringToMemoryType((String)data);
        }
        return (T)result;
    }

    private static MemoryType convertStringToMemoryType(String data) {
        MemoryType result;
        block2: {
            result = null;
            try {
                result = MemoryType.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                if (!VERBOSE_MODE) break block2;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static <T> T convertToOpenType(Object data, Class<T> openClass, Class<?> realClass) {
        if (data == null) {
            return null;
        }
        Object result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            result = Array.newInstance(openElementClass, dataArray.length);
            for (int i = 0; i < Array.getLength(result); ++i) {
                Array.set(result, i, ManagementUtils.convertToOpenType(dataArray[i], openElementClass, realElementClass));
            }
        } else if (openClass.equals(CompositeData.class)) {
            if (realClass.equals(ThreadInfo.class)) {
                result = ManagementUtils.toThreadInfoCompositeData((ThreadInfo)data);
            } else if (realClass.equals(java.lang.management.MemoryUsage.class)) {
                result = ManagementUtils.toMemoryUsageCompositeData((java.lang.management.MemoryUsage)data);
            } else if (realClass.equals(MonitorInfo.class)) {
                result = ManagementUtils.toMonitorInfoCompositeData((MonitorInfo)data);
            } else if (realClass.equals(LockInfo.class)) {
                result = ManagementUtils.toLockInfoCompositeData((LockInfo)data);
            } else if (realClass.equals(JvmCpuMonitorInfo.class)) {
                result = ManagementUtils.toJvmCpuMonitorInfoCompositeData((JvmCpuMonitorInfo)data);
            } else if (realClass.equals(MemoryUsage.class)) {
                result = ManagementUtils.toCILMMemoryUsageCompositeData((MemoryUsage)data);
            } else if (realClass.equals(ProcessorUsage.class)) {
                result = ManagementUtils.toProcessorUsageCompositeData((ProcessorUsage)data);
            } else if (realClass.equals(GuestOSProcessorUsage.class)) {
                result = ManagementUtils.toGuestOSProcessorUsageCompositeData((GuestOSProcessorUsage)data);
            } else if (realClass.equals(GuestOSMemoryUsage.class)) {
                result = ManagementUtils.toGuestOSMemoryUsageCompositeData((GuestOSMemoryUsage)data);
            }
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.toSystemPropertiesTabularData((Map)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                result = ManagementUtils.convertListToArray((List)data, openClass, openClass.getComponentType());
            }
        } else if (openClass.equals(String.class) && realClass.isEnum()) {
            result = ((Enum)data).name();
        }
        return (T)result;
    }

    private static <T, E> T convertListToArray(List<E> list, Class<T> arrayType, Class<E> elementType) {
        Object result = Array.newInstance(elementType, list.size());
        Iterator<E> it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            E element = it.next();
            Array.set(result, count++, element);
        }
        return (T)result;
    }

    public static TabularData toSystemPropertiesTabularData(Map<String, String> propsMap) {
        if (propsMap == null) {
            return null;
        }
        TabularDataSupport result = null;
        try {
            String[] rtItemNames = new String[]{"key", "value"};
            String[] rtItemDescs = new String[]{"key", "value"};
            OpenType[] rtItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType rowType = new CompositeType(propsMap.getClass().getName(), propsMap.getClass().getName(), rtItemNames, rtItemDescs, rtItemTypes);
            TabularType sysPropsType = new TabularType(propsMap.getClass().getName(), propsMap.getClass().getName(), rowType, new String[]{"key"});
            result = new TabularDataSupport(sysPropsType);
            Set<String> keys = propsMap.keySet();
            for (String propKey : keys) {
                String propVal = propsMap.get(propKey);
                result.put(new CompositeDataSupport(rowType, rtItemNames, new String[]{propKey, propVal}));
            }
        }
        catch (OpenDataException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            result = null;
        }
        return result;
    }

    public static Class getClassMaybePrimitive(String name) throws ClassNotFoundException {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        Class<Object> result = null;
        try {
            result = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            if (name.equals(Boolean.TYPE.getName())) {
                result = Boolean.TYPE;
            }
            if (name.equals(Character.TYPE.getName())) {
                result = Character.TYPE;
            }
            if (name.equals(Byte.TYPE.getName())) {
                result = Byte.TYPE;
            }
            if (name.equals(Short.TYPE.getName())) {
                result = Short.TYPE;
            }
            if (name.equals(Integer.TYPE.getName())) {
                result = Integer.TYPE;
            }
            if (name.equals(Long.TYPE.getName())) {
                result = Long.TYPE;
            }
            if (name.equals(Float.TYPE.getName())) {
                result = Float.TYPE;
            }
            if (name.equals(Double.TYPE.getName())) {
                result = Double.TYPE;
            }
            if (name.equals(Void.TYPE.getName())) {
                result = Void.TYPE;
            }
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
        return result;
    }

    public static boolean isWrapperClass(Class<? extends Object> wrapper, Class primitive) {
        boolean result = true;
        if (primitive.equals(Boolean.TYPE) && !wrapper.equals(Boolean.class)) {
            result = false;
        } else if (primitive.equals(Character.TYPE) && !wrapper.equals(Character.class)) {
            result = false;
        } else if (primitive.equals(Byte.TYPE) && !wrapper.equals(Byte.class)) {
            result = false;
        } else if (primitive.equals(Short.TYPE) && !wrapper.equals(Short.class)) {
            result = false;
        } else if (primitive.equals(Integer.TYPE) && !wrapper.equals(Integer.class)) {
            result = false;
        } else if (primitive.equals(Long.TYPE) && !wrapper.equals(Long.class)) {
            result = false;
        } else if (primitive.equals(Float.TYPE) && !wrapper.equals(Float.class)) {
            result = false;
        } else if (primitive.equals(Double.TYPE) && !wrapper.equals(Double.class)) {
            result = false;
        }
        return result;
    }

    public static <T> boolean isANotificationEmitter(Class<T> mxbeanInterface) {
        MBeanNotificationInfo[] notifications;
        boolean result = false;
        MBeanInfo info = ManagementUtils.getMBeanInfo(mxbeanInterface.getName());
        if (info != null && (notifications = info.getNotifications()) != null && notifications.length > 0) {
            result = true;
        }
        return result;
    }

    public static boolean isRunningOnUnix() {
        return isUnix;
    }

    public static StackTraceElement[] getStackTracesFromCompositeDataArray(CompositeData[] stackTraceDataVal) {
        if (stackTraceDataVal == null) {
            return null;
        }
        StackTraceElement[] result = new StackTraceElement[stackTraceDataVal.length];
        for (int i = 0; i < stackTraceDataVal.length; ++i) {
            CompositeData data = stackTraceDataVal[i];
            if (data != null) {
                StackTraceElement element;
                ManagementUtils.verifyFieldNumber(data, 5);
                String[] attributeNames = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                ManagementUtils.verifyFieldNames(data, attributeNames);
                String[] attributeTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
                ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
                Object[] attributeVals = data.getAll(attributeNames);
                String classNameVal = (String)attributeVals[0];
                String methodNameVal = (String)attributeVals[1];
                String fileNameVal = (String)attributeVals[2];
                int lineNumberVal = (Integer)attributeVals[3];
                boolean nativeMethodVal = (Boolean)attributeVals[4];
                result[i] = element = new StackTraceElement(classNameVal, methodNameVal, fileNameVal, lineNumberVal);
                continue;
            }
            result[i] = null;
        }
        return result;
    }

    public static LockInfo getLockInfosFromCompositeData(CompositeData compositeData) {
        ManagementUtils.verifyFieldNumber(compositeData, 2);
        String[] attributeNames = new String[]{"className", "identityHashCode"};
        ManagementUtils.verifyFieldNames(compositeData, attributeNames);
        String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer"};
        ManagementUtils.verifyFieldTypes(compositeData, attributeNames, attributeTypes);
        Object[] attributeVals = compositeData.getAll(attributeNames);
        String className = (String)attributeVals[0];
        int idHashCode = (Integer)attributeVals[1];
        LockInfo element = new LockInfo(className, idHashCode);
        return element;
    }

    public static LockInfo[] getLockInfosFromCompositeDataArray(CompositeData[] lockInfosCDArray) {
        if (lockInfosCDArray == null) {
            return null;
        }
        LockInfo[] result = new LockInfo[lockInfosCDArray.length];
        for (int i = 0; i < lockInfosCDArray.length; ++i) {
            result[i] = ManagementUtils.getLockInfosFromCompositeData(lockInfosCDArray[i]);
        }
        return result;
    }

    public static MonitorInfo[] getMonitorInfosFromCompositeDataArray(CompositeData[] monitorInfosCDArray) {
        if (monitorInfosCDArray == null) {
            return null;
        }
        MonitorInfo[] result = new MonitorInfo[monitorInfosCDArray.length];
        for (int i = 0; i < monitorInfosCDArray.length; ++i) {
            CompositeData data = monitorInfosCDArray[i];
            ManagementUtils.verifyFieldNumber(data, 4);
            String[] attributeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            ManagementUtils.verifyFieldNames(data, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
            result[i] = MonitorInfo.from(data);
        }
        return result;
    }

    public static StackTraceElement getStackTraceFromCompositeData(CompositeData stackTraceCD) {
        return ManagementUtils.getStackTracesFromCompositeDataArray(new CompositeData[]{stackTraceCD})[0];
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName createObjectName(String domain, String name) {
        try {
            return new ObjectName(domain + ",name=" + name);
        }
        catch (MalformedObjectNameException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static CompositeData toCILMMemoryUsageCompositeData(MemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (null == usage) {
                return null;
            }
            result = null;
            String[] names = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
            Object[] values = new Object[]{new Long(usage.getTotal()), new Long(usage.getFree()), new Long(usage.getSwapTotal()), new Long(usage.getSwapFree()), new Long(usage.getCached()), new Long(usage.getBuffered()), new Long(usage.getTimestamp())};
            CompositeType cType = ManagementUtils.getCILMMemoryUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getCILMMemoryUsageCompositeType() {
        block3: {
            if (null == CILMMEMORYUSAGE_COMPOSITETYPE) {
                try {
                    String[] typeNames = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
                    String[] typeDescs = new String[]{"total", "free", "swapTotal", "swapFree", "cached", "buffered", "timestamp"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                    CILMMEMORYUSAGE_COMPOSITETYPE = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return CILMMEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toProcessorUsageCompositeData(ProcessorUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (null == usage) {
                return null;
            }
            result = null;
            String[] names = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
            Object[] values = new Object[]{new Long(usage.getUser()), new Long(usage.getSystem()), new Long(usage.getIdle()), new Long(usage.getWait()), new Long(usage.getBusy()), new Integer(usage.getId()), new Integer(usage.getOnline()), new Long(usage.getTimestamp())};
            CompositeType cType = ManagementUtils.getProcessorUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getProcessorUsageCompositeType() {
        block3: {
            if (null == PROCESSORUSAGE_COMPOSITETYPE) {
                try {
                    String[] typeNames = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
                    String[] typeDescs = new String[]{"user", "system", "idle", "wait", "busy", "id", "online", "timestamp"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG};
                    PROCESSORUSAGE_COMPOSITETYPE = new CompositeType(ProcessorUsage.class.getName(), ProcessorUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return PROCESSORUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toGuestOSProcessorUsageCompositeData(GuestOSProcessorUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (null == usage) {
                return null;
            }
            result = null;
            String[] names = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
            Object[] values = new Object[]{new Long(usage.getCpuTime()), new Long(usage.getTimestamp()), new Float(usage.getCpuEntitlement()), new Long(usage.getHostCpuClockSpeed())};
            CompositeType cType = ManagementUtils.getGuestOSProcessorUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getGuestOSProcessorUsageCompositeType() {
        block3: {
            if (null == GUESTOSPROCESSORUSAGE_COMPOSITETYPE) {
                try {
                    String[] typeNames = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
                    String[] typeDescs = new String[]{"cpuTime", "timestamp", "cpuEntitlement", "hostCpuClockSpeed"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.FLOAT, SimpleType.LONG};
                    GUESTOSPROCESSORUSAGE_COMPOSITETYPE = new CompositeType(GuestOSProcessorUsage.class.getName(), GuestOSProcessorUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return GUESTOSPROCESSORUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toGuestOSMemoryUsageCompositeData(GuestOSMemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (null == usage) {
                return null;
            }
            result = null;
            String[] names = new String[]{"memUsed", "timestamp", "maxMemLimit"};
            Object[] values = new Object[]{new Long(usage.getMemUsed()), new Long(usage.getTimestamp()), new Long(usage.getMaxMemLimit())};
            CompositeType cType = ManagementUtils.getGuestOSMemoryUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getGuestOSMemoryUsageCompositeType() {
        block3: {
            if (null == GUESTOSMEMORYUSAGE_COMPOSITETYPE) {
                try {
                    String[] typeNames = new String[]{"memUsed", "timestamp", "maxMemLimit"};
                    String[] typeDescs = new String[]{"memUsed", "timestamp", "maxMemLimit"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                    GUESTOSMEMORYUSAGE_COMPOSITETYPE = new CompositeType(GuestOSMemoryUsage.class.getName(), GuestOSMemoryUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return GUESTOSMEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toJvmCpuMonitorInfoCompositeData(JvmCpuMonitorInfo jcmInfo) {
        CompositeDataSupport result;
        block4: {
            if (null == jcmInfo) {
                return null;
            }
            result = null;
            long[] tData = jcmInfo.getApplicationUserCpuTime();
            long[] applicationUserCpuTimeData = new long[tData.length];
            for (int i = 0; i < applicationUserCpuTimeData.length; ++i) {
                applicationUserCpuTimeData[i] = tData[i];
            }
            String[] names = new String[]{"timestamp", "applicationCpuTime", "resourceMonitorCpuTime", "systemJvmCpuTime", "gcCpuTime", "jitCpuTime", "applicationUserCpuTime"};
            Object[] values = new Object[]{new Long(jcmInfo.getTimestamp()), new Long(jcmInfo.getApplicationCpuTime()), new Long(jcmInfo.getResourceMonitorCpuTime()), new Long(jcmInfo.getSystemJvmCpuTime()), new Long(jcmInfo.getGcCpuTime()), new Long(jcmInfo.getJitCpuTime()), applicationUserCpuTimeData};
            CompositeType cType = ManagementUtils.getJvmCpuMonitorInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block4;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getJvmCpuMonitorInfoCompositeType() {
        block3: {
            if (null == JVMCPUMONITORINFO_COMPOSITETYPE) {
                try {
                    String[] typeNames = new String[]{"timestamp", "applicationCpuTime", "resourceMonitorCpuTime", "systemJvmCpuTime", "gcCpuTime", "jitCpuTime", "applicationUserCpuTime"};
                    String[] typeDescs = new String[]{"timestamp", "applicationCpuTime", "resourceMonitorCpuTime", "systemJvmCpuTime", "gcCpuTime", "jitCpuTime", "applicationUserCpuTime"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, new ArrayType(SimpleType.LONG, true)};
                    JVMCPUMONITORINFO_COMPOSITETYPE = new CompositeType(JvmCpuMonitorInfo.class.getName(), JvmCpuMonitorInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return JVMCPUMONITORINFO_COMPOSITETYPE;
    }

    static {
        VERBOSE_MODE = ManagementUtils.checkVerboseProperty();
        String thisOs = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        isUnix = thisOs.equalsIgnoreCase("linux") || thisOs.equalsIgnoreCase("aix") || thisOs.equalsIgnoreCase("z/OS");
    }
}

