/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public class MemoryManagerMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryManagerMXBean {
    protected final String name;
    protected final int id;
    private List<MemoryPoolMXBean> managedPoolList;
    private static MemoryManagerMXBeanImpl tempInstance = new MemoryManagerMXBeanImpl();

    MemoryManagerMXBeanImpl(ObjectName objectName, String name, int id, MemoryMXBeanImpl memBean) {
        super(objectName);
        this.name = name;
        this.id = id;
        this.managedPoolList = new LinkedList<MemoryPoolMXBean>();
        this.createMemoryPools(id, memBean);
    }

    MemoryManagerMXBeanImpl() {
        super(null);
        this.id = -1;
        this.name = null;
    }

    static MemoryManagerMXBeanImpl getInstanceFromMgmtUtils() {
        return tempInstance;
    }

    protected void initializeInfo() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(MemoryManagerMXBean.class.getName()));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.initializeInfo();
        }
        return this.info;
    }

    private native void createMemoryPools(int var1, MemoryMXBeanImpl var2);

    private void createMemoryPoolHelper(String name, boolean isHeap, int internalID, MemoryMXBeanImpl memBean) {
        if (isHeap) {
            this.managedPoolList.add(MemoryPoolMXBeanImpl.getJavaHeapMemoryPoolMXBean(name, internalID, memBean));
        } else {
            this.managedPoolList.add(new MemoryPoolMXBeanImpl(name, MemoryType.NON_HEAP, internalID, memBean));
        }
    }

    List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return this.managedPoolList;
    }

    @Override
    public String[] getMemoryPoolNames() {
        String[] names = new String[this.managedPoolList.size()];
        int idx = 0;
        Iterator<MemoryPoolMXBean> iter = this.managedPoolList.iterator();
        while (iter.hasNext()) {
            names[idx++] = iter.next().getName();
        }
        return names;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private native boolean isValidImpl();

    @Override
    public boolean isValid() {
        return this.isValidImpl();
    }
}

