/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementPermissionHelper;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryNotificationThread;
import com.ibm.lang.management.MemoryPoolMXBean;
import com.ibm.oti.util.Msg;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.LinkedList;
import javax.management.MBeanInfo;

public final class MemoryPoolMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryPoolMXBean {
    private final String name;
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;
    private static MemoryPoolMXBean javaHeapMemoryPoolMXBean;
    private static MemoryPoolMXBeanImpl tempInstance;

    static synchronized MemoryPoolMXBean getJavaHeapMemoryPoolMXBean(String name, int id, MemoryMXBeanImpl memBean) {
        if (javaHeapMemoryPoolMXBean == null) {
            javaHeapMemoryPoolMXBean = new MemoryPoolMXBeanImpl(name, MemoryType.HEAP, id, memBean);
        }
        return javaHeapMemoryPoolMXBean;
    }

    MemoryPoolMXBeanImpl(String name, MemoryType type, int id, MemoryMXBeanImpl memBean) {
        super(ManagementUtils.createObjectName("java.lang:type=MemoryPool", name));
        this.name = name;
        this.type = type;
        this.id = id;
        this.memBean = memBean;
        if (this.isUsageThresholdSupported() || this.isCollectionUsageThresholdSupported()) {
            MemoryNotificationThread t = new MemoryNotificationThread(memBean, this, id);
            t.setDaemon(true);
            t.setName("MemoryPoolMXBean notification dispatcher");
            t.setPriority(6);
            t.start();
        }
    }

    MemoryPoolMXBeanImpl() {
        super(null);
        this.name = null;
        this.type = null;
        this.id = -1;
        this.memBean = null;
    }

    static MemoryPoolMXBeanImpl getInstanceFromMgmtUtils() {
        return tempInstance;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.MemoryPoolMXBean.class.getName()));
        }
        return this.info;
    }

    private native MemoryUsage getCollectionUsageImpl();

    @Override
    public MemoryUsage getCollectionUsage() {
        return this.getCollectionUsageImpl();
    }

    private native MemoryUsage getPreCollectionUsageImpl();

    @Override
    public MemoryUsage getPreCollectionUsage() {
        return this.getPreCollectionUsageImpl();
    }

    private native long getCollectionUsageThresholdImpl();

    @Override
    public long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdImpl();
    }

    private native long getCollectionUsageThresholdCountImpl();

    @Override
    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdCountImpl();
    }

    @Override
    public String[] getMemoryManagerNames() {
        Iterator<MemoryManagerMXBean> iter = this.memBean.getMemoryManagerMXBeans().iterator();
        LinkedList<String> result = new LinkedList<String>();
        block0: while (iter.hasNext()) {
            MemoryManagerMXBean bean = iter.next();
            String[] managedPools = bean.getMemoryPoolNames();
            for (int i = 0; i < managedPools.length; ++i) {
                if (!managedPools[i].equals(this.name)) continue;
                result.add(bean.getName());
                continue block0;
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private native MemoryUsage getPeakUsageImpl();

    @Override
    public MemoryUsage getPeakUsage() {
        return this.getPeakUsageImpl();
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    private native MemoryUsage getUsageImpl();

    @Override
    public MemoryUsage getUsage() {
        return this.getUsageImpl();
    }

    private native long getUsageThresholdImpl();

    @Override
    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdImpl();
    }

    private native long getUsageThresholdCountImpl();

    @Override
    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdCountImpl();
    }

    private native boolean isCollectionUsageThresholdExceededImpl();

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.isCollectionUsageThresholdExceededImpl();
    }

    private native boolean isCollectionUsageThresholdSupportedImpl();

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return this.isCollectionUsageThresholdSupportedImpl();
    }

    private native boolean isUsageThresholdExceededImpl();

    @Override
    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.isUsageThresholdExceededImpl();
    }

    private native boolean isUsageThresholdSupportedImpl();

    @Override
    public boolean isUsageThresholdSupported() {
        return this.isUsageThresholdSupportedImpl();
    }

    private native boolean isValidImpl();

    @Override
    public boolean isValid() {
        return this.isValidImpl();
    }

    private native void resetPeakUsageImpl();

    @Override
    public void resetPeakUsage() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakUsageImpl();
    }

    private native void setCollectionUsageThresholdImpl(long var1);

    @Override
    public void setCollectionUsageThreshold(long threshold) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FE"));
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException(Msg.getString("K05FF"));
        }
        this.setCollectionUsageThresholdImpl(threshold);
    }

    private native void setUsageThresholdImpl(long var1);

    @Override
    public void setUsageThreshold(long threshold) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F0"));
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException(Msg.getString("K05F1"));
        }
        this.setUsageThresholdImpl(threshold);
    }

    private boolean exceedsMaxPoolSize(long value) {
        MemoryUsage m = this.getUsage();
        return m.getMax() != -1L && m.getMax() < value;
    }

    static {
        tempInstance = new MemoryPoolMXBeanImpl();
    }
}

