/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class MemoryUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long total;
    private long free;
    private long swapTotal;
    private long swapFree;
    private long cached;
    private long buffered;
    private long timestamp;

    public MemoryUsage() {
    }

    private MemoryUsage(long total, long free, long swapTotal, long swapFree, long cached, long buffered, long timestamp) throws IllegalArgumentException {
        if (total < 0L || free < 0L || timestamp < 0L || swapTotal < 0L && swapTotal != -1L || swapFree < 0L && swapFree != -1L || cached < 0L && cached != -1L || buffered < 0L && buffered != -1L || free >= 0L && total >= 0L && free > total || swapFree >= 0L && swapTotal >= 0L && swapFree > swapTotal || total >= 0L && cached >= 0L && buffered >= 0L && free >= 0L && total < cached + buffered + free) {
            throw new IllegalArgumentException();
        }
        this.total = total;
        this.free = free;
        this.swapTotal = swapTotal;
        this.swapFree = swapFree;
        this.cached = cached;
        this.buffered = buffered;
        this.timestamp = timestamp;
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public long getSwapTotal() {
        return this.swapTotal;
    }

    public long getSwapFree() {
        return this.swapFree;
    }

    public long getCached() {
        return this.cached;
    }

    public long getBuffered() {
        return this.buffered;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void updateValues(long total, long free, long swapTotal, long swapFree, long cached, long buffered, long timestamp) {
        this.total = total;
        this.free = free;
        this.swapTotal = swapTotal;
        this.swapFree = swapFree;
        this.cached = cached;
        this.buffered = buffered;
        this.timestamp = timestamp;
    }

    public static MemoryUsage from(CompositeData cd) {
        MemoryUsage result = null;
        if (null != cd) {
            long timestamp;
            long buffered;
            long cached;
            long swapFree;
            long swapTotal;
            long free;
            long total;
            if (!ManagementUtils.getCILMMemoryUsageCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                total = (Long)cd.get("total");
                free = (Long)cd.get("free");
                swapTotal = (Long)cd.get("swapTotal");
                swapFree = (Long)cd.get("swapFree");
                cached = (Long)cd.get("cached");
                buffered = (Long)cd.get("buffered");
                timestamp = (Long)cd.get("timestamp");
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            result = new MemoryUsage(total, free, swapTotal, swapFree, cached, buffered, timestamp);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========== ");
        sb.append(this.getClass().getSimpleName());
        sb.append(" ==========\n\n");
        sb.append("timestamp = ");
        sb.append(this.timestamp);
        sb.append("\n");
        sb.append("total = ");
        sb.append(this.total);
        sb.append("\n");
        sb.append("free = ");
        sb.append(this.free);
        sb.append("\n");
        sb.append("swapTotal = ");
        sb.append(this.swapTotal);
        sb.append("\n");
        sb.append("swapFree = ");
        sb.append(this.swapFree);
        sb.append("\n");
        sb.append("cached = ");
        sb.append(this.cached);
        sb.append("\n");
        sb.append("buffered = ");
        sb.append(this.buffered);
        sb.append("\n");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof MemoryUsage)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MemoryUsage mu = (MemoryUsage)obj;
        if (mu.getTotal() != this.getTotal()) {
            return false;
        }
        if (mu.getFree() != this.getFree()) {
            return false;
        }
        if (mu.getSwapTotal() != this.getSwapTotal()) {
            return false;
        }
        if (mu.getSwapFree() != this.getSwapFree()) {
            return false;
        }
        if (mu.getCached() != this.getCached()) {
            return false;
        }
        if (mu.getBuffered() != this.getBuffered()) {
            return false;
        }
        return mu.getTimestamp() == this.getTimestamp();
    }

    public int hashCode() {
        long mHash = this.getTotal() + this.getFree() + this.getSwapTotal() + this.getSwapFree() + this.getCached() + this.getBuffered() + this.getTimestamp();
        return (int)((mHash >> (int)(32L + mHash) & 0xFFFFFFFL) * 23L);
    }
}

