/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;

public class OpenTypeMappingIHandler
implements InvocationHandler {
    private MBeanServerConnection connection;
    private ObjectName mxBeanObjectName;
    private MBeanInfo info;

    public OpenTypeMappingIHandler(MBeanServerConnection connection, String mxBeanType, String mxBeanName) throws IOException {
        this.connection = connection;
        this.setObjectName(mxBeanName);
        this.checkBeanIsRegistered();
        this.setInfo(mxBeanType);
    }

    private void setInfo(String mxBeanType) {
        this.info = ManagementUtils.getMBeanInfo(mxBeanType);
        if (this.info == null) {
            throw new IllegalArgumentException(Msg.getString("K05F2", mxBeanType));
        }
    }

    private void setObjectName(String mxBeanName) {
        try {
            this.mxBeanObjectName = new ObjectName(mxBeanName);
        }
        catch (Exception e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new IllegalArgumentException(Msg.getString("K05F3"), e);
        }
    }

    private void checkBeanIsRegistered() throws IOException {
        if (!this.connection.isRegistered(this.mxBeanObjectName)) {
            throw new IllegalArgumentException(Msg.getString("K05F4", this.mxBeanObjectName));
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        switch (this.getInvokeType(method.getName())) {
            case ATTRIBUTE_GETTER: {
                result = this.invokeAttributeGetter(method);
                break;
            }
            case ATTRIBUTE_SETTER: {
                result = this.invokeAttributeSetter(method, args);
                break;
            }
            case NOTIFICATION_OP: {
                result = this.invokeNotificationEmitterOperation(method, args);
                break;
            }
            default: {
                result = "toString".equals(method.getName()) && (args == null || args.length == 0) ? "MXBeanProxy(" + this.connection + "[" + this.mxBeanObjectName + "])" : ("getObjectName".equals(method.getName()) && (args == null || args.length == 0) ? this.mxBeanObjectName : this.invokeOperation(method, args));
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object invokeNotificationEmitterOperation(Method method, final Object[] args) throws InstanceNotFoundException, IOException, ListenerNotFoundException {
        MBeanNotificationInfo[] result = null;
        if (method.getName().equals("addNotificationListener")) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, IOException {
                        OpenTypeMappingIHandler.this.connection.addNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                        return null;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)t;
                }
                if (!(t instanceof IOException)) return result;
                throw (IOException)t;
            }
            catch (RuntimeMBeanException e) {
                throw e.getTargetException();
            }
        }
        if (method.getName().equals("getNotificationInfo")) {
            return this.info.getNotifications();
        }
        if (!method.getName().equals("removeNotificationListener")) return result;
        if (args.length == 1) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
                        OpenTypeMappingIHandler.this.connection.removeNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)args[0]);
                        return null;
                    }
                });
                return result;
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)t;
                }
                if (t instanceof ListenerNotFoundException) {
                    throw (ListenerNotFoundException)t;
                }
                if (!(t instanceof IOException)) return result;
                throw (IOException)t;
            }
            catch (RuntimeMBeanException e) {
                throw e.getTargetException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, ListenerNotFoundException, IOException {
                    OpenTypeMappingIHandler.this.connection.removeNotificationListener(OpenTypeMappingIHandler.this.mxBeanObjectName, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
            });
            return result;
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)t;
            }
            if (!(t instanceof IOException)) return result;
            throw (IOException)t;
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
    }

    private Object invokeOperation(final Method method, final Object[] args) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object result = null;
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                    return OpenTypeMappingIHandler.this.connection.invoke(OpenTypeMappingIHandler.this.mxBeanObjectName, method.getName(), args, OpenTypeMappingIHandler.this.getOperationSignature(method));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        String realReturnType = method.getReturnType().getName();
        String openReturnType = this.getOperationOpenReturnType(method);
        if (!realReturnType.equals(openReturnType)) {
            result = ManagementUtils.convertFromOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
        }
        return result;
    }

    private String getOperationOpenReturnType(Method method) {
        String result = null;
        String[] methodSig = this.getOperationSignature(method);
        MBeanOperationInfo[] opInfos = this.info.getOperations();
        for (int i = 0; i < opInfos.length; ++i) {
            MBeanParameterInfo[] opParams;
            MBeanOperationInfo opInfo = opInfos[i];
            if (!opInfo.getName().equals(method.getName()) || (opParams = opInfo.getSignature()).length != methodSig.length) continue;
            boolean matchFound = true;
            for (int j = 0; j < opParams.length; ++j) {
                if (opParams[j].getType().equals(methodSig[j])) continue;
                matchFound = false;
                break;
            }
            if (!matchFound) continue;
            result = opInfo.getReturnType();
            break;
        }
        return result;
    }

    private String[] getOperationSignature(Method method) {
        String[] result = null;
        Class<?>[] args = method.getParameterTypes();
        result = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> clazz = args[i];
            result[i] = clazz.getName();
        }
        return result;
    }

    private Object invokeAttributeSetter(final Method method, final Object[] args) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, InvalidAttributeValueException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
                    OpenTypeMappingIHandler.this.connection.setAttribute(OpenTypeMappingIHandler.this.mxBeanObjectName, new Attribute(OpenTypeMappingIHandler.this.getAttribName(method), args[0]));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        return null;
    }

    private Object invokeAttributeGetter(final Method method) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object result = null;
        String realReturnType = method.getReturnType().getName();
        String openReturnType = this.getAttrOpenType(method.getName());
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
                    return OpenTypeMappingIHandler.this.connection.getAttribute(OpenTypeMappingIHandler.this.mxBeanObjectName, OpenTypeMappingIHandler.this.getAttribName(method));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)t;
            }
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof ReflectionException) {
                throw (ReflectionException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
        if (!realReturnType.equals(openReturnType)) {
            result = ManagementUtils.convertFromOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
        }
        return result;
    }

    private String getAttribName(Method method) {
        MBeanAttributeInfo attribInfo;
        int i;
        String attribName;
        String result = null;
        String methodName = method.getName();
        MBeanAttributeInfo[] attribs = this.info.getAttributes();
        if (methodName.startsWith("get")) {
            attribName = methodName.substring("get".length());
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable()) continue;
                result = attribInfo.getName();
                break;
            }
        }
        if (result == null && methodName.startsWith("is")) {
            attribName = methodName.substring("is".length());
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable() || !attribInfo.isIs()) continue;
                result = attribInfo.getName();
                break;
            }
        }
        if (result == null && methodName.startsWith("set")) {
            attribName = methodName.substring("set".length());
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isWritable()) continue;
                result = attribInfo.getName();
                break;
            }
        }
        return result;
    }

    private String getAttrOpenType(String methodName) {
        MBeanAttributeInfo attrInfo = this.getAttribInfo(methodName);
        return attrInfo.getType();
    }

    private MBeanAttributeInfo getAttribInfo(String methodName) {
        MBeanAttributeInfo attribInfo;
        int i;
        String attribName;
        MBeanAttributeInfo result = null;
        MBeanAttributeInfo[] attribs = this.info.getAttributes();
        if (methodName.startsWith("get")) {
            attribName = methodName.substring("get".length());
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable()) continue;
                result = attribInfo;
                break;
            }
        }
        if (result == null && methodName.startsWith("is")) {
            attribName = methodName.substring("is".length());
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable() || !attribInfo.isIs()) continue;
                result = attribInfo;
                break;
            }
        }
        return result;
    }

    private InvokeType getInvokeType(String methodName) {
        MBeanAttributeInfo attribInfo;
        int i;
        MBeanAttributeInfo[] attribs;
        String attribName;
        InvokeType result = null;
        if (methodName.startsWith("get")) {
            attribName = methodName.substring("get".length());
            attribs = this.info.getAttributes();
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable()) continue;
                result = InvokeType.ATTRIBUTE_GETTER;
                break;
            }
        }
        if (result == null && methodName.startsWith("is")) {
            attribName = methodName.substring("is".length());
            attribs = this.info.getAttributes();
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isReadable() || !attribInfo.isIs()) continue;
                result = InvokeType.ATTRIBUTE_GETTER;
                break;
            }
        }
        if (result == null && methodName.startsWith("set")) {
            attribName = methodName.substring("set".length());
            attribs = this.info.getAttributes();
            for (i = 0; i < attribs.length; ++i) {
                attribInfo = attribs[i];
                if (!attribInfo.getName().equals(attribName) || !attribInfo.isWritable()) continue;
                result = InvokeType.ATTRIBUTE_SETTER;
                break;
            }
        }
        if (result == null) {
            Method[] neMethods = NotificationEmitter.class.getMethods();
            for (int i2 = 0; i2 < neMethods.length; ++i2) {
                if (!neMethods[i2].getName().equals(methodName)) continue;
                result = InvokeType.NOTIFICATION_OP;
                break;
            }
        }
        if (result == null) {
            result = InvokeType.OPERATION;
        }
        return result;
    }

    static enum InvokeType {
        ATTRIBUTE_GETTER,
        ATTRIBUTE_SETTER,
        NOTIFICATION_OP,
        OPERATION;

    }
}

