/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.CpuUtilizationHelper;
import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryUsage;
import com.ibm.lang.management.MemoryUsageRetrievalException;
import com.ibm.lang.management.OperatingSystemMXBean;
import com.ibm.lang.management.OperatingSystemNotificationThread;
import com.ibm.lang.management.ProcessorUsage;
import com.ibm.lang.management.ProcessorUsageRetrievalException;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public abstract class OperatingSystemMXBeanImpl
extends DynamicMXBeanImpl
implements OperatingSystemMXBean,
NotificationEmitter {
    private NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    private final CpuUtilizationHelper cpuUtilizationHelper;
    private HwEmulResult isHwEmulated = HwEmulResult.UNKNOWN;

    OperatingSystemMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=OperatingSystem"));
        if (this.isDLPAREnabled()) {
            OperatingSystemNotificationThread t = new OperatingSystemNotificationThread(this);
            t.setDaemon(true);
            t.setName("OperatingSystemMXBean notification dispatcher");
            t.setPriority(6);
            t.start();
        }
        this.cpuUtilizationHelper = new CpuUtilizationHelper();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.OperatingSystemMXBean.class.getName()));
        }
        return this.info;
    }

    private native boolean isDLPAREnabled();

    @Override
    public String getArch() {
        return System.getProperty("os.arch");
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public String getName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getVersion() {
        return System.getProperty("os.version");
    }

    private native long getTotalPhysicalMemoryImpl();

    @Override
    public long getTotalPhysicalMemory() {
        return this.getTotalPhysicalMemoryImpl();
    }

    private native int getProcessingCapacityImpl();

    @Override
    public int getProcessingCapacity() {
        return this.getProcessingCapacityImpl();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[3];
        String[] notifTypes = new String[]{"com.ibm.management.processing.capacity.change"};
        notifications[0] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Processing Capacity Notification");
        notifTypes = new String[]{"com.ibm.management.total.physical.memory.change"};
        notifications[1] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Total Physical Memory Notification");
        notifTypes = new String[]{"com.ibm.management.available.processors.change"};
        notifications[2] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Available Processors Notification");
        return notifications;
    }

    public void sendNotification(Notification notification) {
        this.notifier.sendNotification(notification);
    }

    private native double getSystemLoadAverageImpl();

    @Override
    public double getSystemLoadAverage() {
        return this.getSystemLoadAverageImpl();
    }

    private native long getProcessCpuTimeImpl();

    @Override
    public long getProcessCpuTime() {
        return this.getProcessCpuTimeImpl();
    }

    @Override
    public long getProcessCpuTimeByNS() {
        return this.getProcessCpuTime() * 100L;
    }

    @Override
    public double getSystemCpuLoad() {
        return this.cpuUtilizationHelper.getSystemCpuLoad();
    }

    private native long getFreePhysicalMemorySizeImpl();

    @Override
    public long getFreePhysicalMemorySize() {
        return this.getFreePhysicalMemorySizeImpl();
    }

    private native long getProcessVirtualMemorySizeImpl();

    @Override
    public long getProcessVirtualMemorySize() {
        return this.getProcessVirtualMemorySizeImpl();
    }

    private native long getProcessPrivateMemorySizeImpl();

    @Override
    public long getProcessPrivateMemorySize() {
        return this.getProcessPrivateMemorySizeImpl();
    }

    private native long getProcessPhysicalMemorySizeImpl();

    @Override
    public long getProcessPhysicalMemorySize() {
        return this.getProcessPhysicalMemorySizeImpl();
    }

    @Override
    public abstract double getProcessCpuLoad();

    @Override
    public abstract long getFreeSwapSpaceSize();

    @Override
    public abstract long getTotalSwapSpaceSize();

    @Override
    public abstract ProcessorUsage retrieveTotalProcessorUsage(ProcessorUsage var1) throws NullPointerException, ProcessorUsageRetrievalException;

    @Override
    public abstract ProcessorUsage retrieveTotalProcessorUsage() throws ProcessorUsageRetrievalException;

    @Override
    public abstract ProcessorUsage[] retrieveProcessorUsage(ProcessorUsage[] var1) throws NullPointerException, ProcessorUsageRetrievalException, IllegalArgumentException;

    @Override
    public abstract ProcessorUsage[] retrieveProcessorUsage() throws ProcessorUsageRetrievalException;

    @Override
    public abstract MemoryUsage retrieveMemoryUsage() throws MemoryUsageRetrievalException;

    @Override
    public abstract MemoryUsage retrieveMemoryUsage(MemoryUsage var1) throws NullPointerException, MemoryUsageRetrievalException;

    @Override
    public abstract String getHardwareModel() throws UnsupportedOperationException;

    private boolean isZosHardwareEmulated(String hwModel) {
        boolean retValue = false;
        ArrayList<String> emuHwVc = new ArrayList<String>();
        emuHwVc.add("1090");
        emuHwVc.add("1091");
        String emuHwProperty = (String)AccessController.doPrivileged(new PriviAction("com.ibm.lang.management.OperatingSystemMXBean.zos.emulatedHardwareModels"));
        if (null != emuHwProperty) {
            emuHwVc.addAll(Arrays.asList(emuHwProperty.split("[;,]")));
        }
        for (int i = 0; !retValue && i < emuHwVc.size(); ++i) {
            retValue = hwModel.equalsIgnoreCase((String)emuHwVc.get(i));
        }
        return retValue;
    }

    @Override
    public boolean isHardwareEmulated() throws UnsupportedOperationException {
        if (HwEmulResult.UNKNOWN == this.isHwEmulated) {
            String osName = (String)AccessController.doPrivileged(new PriviAction("os.name"));
            String hwModel = this.getHardwareModel();
            if (null != osName && null != hwModel) {
                boolean isEmuTmp = false;
                if (osName.equalsIgnoreCase("z/OS")) {
                    isEmuTmp = this.isZosHardwareEmulated(hwModel);
                }
                this.isHwEmulated = isEmuTmp ? HwEmulResult.YES : HwEmulResult.NO;
            } else {
                if (null == hwModel) {
                    String strErr = Msg.getString("K05da");
                    throw new UnsupportedOperationException(strErr);
                }
                throw new UnsupportedOperationException();
            }
        }
        return HwEmulResult.YES == this.isHwEmulated;
    }

    private static enum HwEmulResult {
        UNKNOWN,
        YES,
        NO;

    }
}

