/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ExtendedThreadInfo;
import com.ibm.lang.management.ManagementPermissionHelper;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.ThreadMXBean;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.MBeanInfo;

public final class ThreadMXBeanImpl
extends DynamicMXBeanImpl
implements ThreadMXBean {
    private static ThreadMXBeanImpl instance = new ThreadMXBeanImpl();
    private static Boolean isThreadCpuTimeEnabled = null;
    private static Boolean isThreadCpuTimeSupported = null;

    ThreadMXBeanImpl() {
        super(ManagementUtils.createObjectName("java.lang:type=Threading"));
        this.setMBeanInfo(null);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.setMBeanInfo(ManagementUtils.getMBeanInfo(ThreadMXBean.class.getName()));
        }
        return this.info;
    }

    static ThreadMXBeanImpl getInstance() {
        return instance;
    }

    private native long[] findMonitorDeadlockedThreadsImpl();

    @Override
    public long[] findMonitorDeadlockedThreads() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findMonitorDeadlockedThreadsImpl();
    }

    private native long[] getAllThreadIdsImpl();

    @Override
    public long[] getAllThreadIds() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.getAllThreadIdsImpl();
    }

    @Override
    public long getCurrentThreadCpuTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public long getCurrentThreadUserTime() {
        long result = -1L;
        if (this.isCurrentThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(Thread.currentThread().getId());
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    private native int getDaemonThreadCountImpl();

    @Override
    public int getDaemonThreadCount() {
        return this.getDaemonThreadCountImpl();
    }

    private native int getPeakThreadCountImpl();

    @Override
    public int getPeakThreadCount() {
        return this.getPeakThreadCountImpl();
    }

    private native int getThreadCountImpl();

    @Override
    public int getThreadCount() {
        return this.getThreadCountImpl();
    }

    private native long getThreadCpuTimeImpl(long var1);

    @Override
    public long getThreadCpuTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadCpuTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    @Override
    public ThreadInfo getThreadInfo(long id) {
        return this.getThreadInfo(id, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids) {
        return this.getThreadInfo(ids, 0);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        return this.getMultiThreadInfoImpl(ids, maxDepth, false, false);
    }

    @Override
    public ThreadInfo[] getThreadInfo(long[] ids, boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        return this.getMultiThreadInfoImpl(ids, Integer.MAX_VALUE, lockedMonitors, lockedSynchronizers);
    }

    @Override
    public ThreadInfo getThreadInfo(long id, int maxDepth) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException(Msg.getString("K05F8"));
        }
        return this.getThreadInfoImpl(id, maxDepth);
    }

    private native Thread getThreadByIdImpl(long var1);

    private native ThreadInfo getThreadInfoImpl(long var1, int var3);

    private native LockInfo[] getLockedSynchronizers(long var1);

    private native MonitorInfo[] getLockedMonitors(long var1);

    private native long getThreadUserTimeImpl(long var1);

    @Override
    public long getThreadUserTime(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F7"));
        }
        long result = -1L;
        if (this.isThreadCpuTimeSupported()) {
            if (this.isThreadCpuTimeEnabled()) {
                result = this.getThreadUserTimeImpl(id);
            }
        } else {
            throw new UnsupportedOperationException(Msg.getString("K05F6"));
        }
        return result;
    }

    private native long getTotalStartedThreadCountImpl();

    @Override
    public long getTotalStartedThreadCount() {
        return this.getTotalStartedThreadCountImpl();
    }

    private native boolean isCurrentThreadCpuTimeSupportedImpl();

    @Override
    public boolean isCurrentThreadCpuTimeSupported() {
        return this.isCurrentThreadCpuTimeSupportedImpl();
    }

    private native boolean isThreadContentionMonitoringEnabledImpl();

    @Override
    public boolean isThreadContentionMonitoringEnabled() {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        return this.isThreadContentionMonitoringEnabledImpl();
    }

    private native boolean isThreadContentionMonitoringSupportedImpl();

    @Override
    public boolean isThreadContentionMonitoringSupported() {
        return this.isThreadContentionMonitoringSupportedImpl();
    }

    private native boolean isThreadCpuTimeEnabledImpl();

    @Override
    public boolean isThreadCpuTimeEnabled() {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        if (isThreadCpuTimeEnabled == null) {
            isThreadCpuTimeEnabled = this.isThreadCpuTimeEnabledImpl();
        }
        return isThreadCpuTimeEnabled;
    }

    private native boolean isThreadCpuTimeSupportedImpl();

    @Override
    public boolean isThreadCpuTimeSupported() {
        if (isThreadCpuTimeSupported == null) {
            isThreadCpuTimeSupported = this.isThreadCpuTimeSupportedImpl();
        }
        return isThreadCpuTimeSupported;
    }

    private native void resetPeakThreadCountImpl();

    @Override
    public void resetPeakThreadCount() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakThreadCountImpl();
    }

    private native void setThreadContentionMonitoringEnabledImpl(boolean var1);

    @Override
    public void setThreadContentionMonitoringEnabled(boolean enable) {
        if (!this.isThreadContentionMonitoringSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FA"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadContentionMonitoringEnabledImpl(enable);
    }

    private native void setThreadCpuTimeEnabledImpl(boolean var1);

    @Override
    public void setThreadCpuTimeEnabled(boolean enable) {
        if (!this.isThreadCpuTimeSupported() && !this.isCurrentThreadCpuTimeSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05F9"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setThreadCpuTimeEnabledImpl(enable);
        isThreadCpuTimeEnabled = enable;
    }

    @Override
    public boolean isObjectMonitorUsageSupported() {
        return this.isObjectMonitorUsageSupportedImpl();
    }

    private native boolean isObjectMonitorUsageSupportedImpl();

    @Override
    public boolean isSynchronizerUsageSupported() {
        return this.isSynchronizerUsageSupportedImpl();
    }

    private native boolean isSynchronizerUsageSupportedImpl();

    @Override
    public long[] findDeadlockedThreads() {
        if (!this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.findDeadlockedThreadsImpl();
    }

    private native long[] findDeadlockedThreadsImpl();

    @Override
    public ThreadInfo[] dumpAllThreads(boolean lockedMonitors, boolean lockedSynchronizers) {
        if (lockedMonitors && !this.isObjectMonitorUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FC"));
        }
        if (lockedSynchronizers && !this.isSynchronizerUsageSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05FB"));
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        return this.dumpAllThreadsImpl(lockedMonitors, lockedSynchronizers);
    }

    private native ThreadInfo[] dumpAllThreadsImpl(boolean var1, boolean var2);

    private native ThreadInfo[] getMultiThreadInfoImpl(long[] var1, int var2, boolean var3, boolean var4);

    @Override
    public long[] getNativeThreadIds(long[] threadIDs) throws IllegalArgumentException, SecurityException {
        long[] localThreadIDs;
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        for (long iter : localThreadIDs = (long[])threadIDs.clone()) {
            if (iter > 0L) continue;
            throw new IllegalArgumentException(Msg.getString("K05FD", iter));
        }
        long[] nativeIDs = new long[threadIDs.length];
        this.getNativeThreadIdsImpl(localThreadIDs, nativeIDs);
        return nativeIDs;
    }

    @Override
    public long getNativeThreadId(long threadId) throws IllegalArgumentException, SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (null != security) {
            security.checkPermission(ManagementPermissionHelper.MPMONITOR);
        }
        if (threadId <= 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FD", threadId));
        }
        return ThreadMXBeanImpl.findNativeThreadIDImpl(threadId);
    }

    @Override
    public ExtendedThreadInfo[] dumpAllExtendedThreads(boolean lockedMonitors, boolean lockedSynchronizers) throws SecurityException, UnsupportedOperationException, InternalError {
        ThreadInfo[] threadInfos = this.dumpAllThreads(lockedMonitors, lockedSynchronizers);
        ExtendedThreadInfo[] resultArray = new ExtendedThreadInfo[threadInfos.length];
        for (int iter = 0; iter < resultArray.length; ++iter) {
            resultArray[iter] = new ExtendedThreadInfo(threadInfos[iter]);
        }
        return resultArray;
    }

    private native void getNativeThreadIdsImpl(long[] var1, long[] var2);

    private static native long findNativeThreadIDImpl(long var0);
}

