/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import com.ibm.oti.reflect.AnnotationParser;
import com.ibm.oti.reflect.Annotations;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;

public class Method {
    private final java.lang.reflect.Method method;
    private SoftReference<Annotations> annotations;
    private SoftReference<Object> srDefaultValue;

    public Method(java.lang.reflect.Method method) {
        this.method = method;
    }

    private synchronized Annotations getAnnotations() {
        Annotations ans;
        if (this.annotations == null || (ans = this.annotations.get()) == null) {
            ans = new Annotations(AnnotationParser.parseAnnotations(this.method));
            this.annotations = new SoftReference<Annotations>(ans);
        }
        return ans;
    }

    public <T extends Annotation> T getAnnotation(Class<T> cl) {
        if (cl == null) {
            throw new NullPointerException();
        }
        return this.getAnnotations().getAnnotation(cl);
    }

    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.getAnnotations().getAnnotations().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDefaultValue() {
        Object defaultValue;
        Method method = this;
        synchronized (method) {
            if (this.srDefaultValue == null || (defaultValue = this.srDefaultValue.get()) == null) {
                defaultValue = AnnotationParser.parseDefaultValue(this.method);
                this.srDefaultValue = new SoftReference<Object>(defaultValue);
            }
        }
        return defaultValue;
    }

    public Annotation[][] getParameterAnnotations() {
        return AnnotationParser.parseParameterAnnotations(this.method);
    }
}

