/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.AbstractClassLoader;
import com.ibm.oti.vm.VM;
import java.io.FilePermission;

public final class BootstrapClassLoader
extends AbstractClassLoader {
    private static BootstrapClassLoader singleton;

    private BootstrapClassLoader() {
        int count = VM.getClassPathCount();
        this.types = new int[count];
        this.cache = new Object[count];
        this.parsedPath = new String[count];
        VM.initializeClassLoader(this, true, false);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class loadedClass = VM.findClassOrNull(className, this);
        return loadedClass;
    }

    public static ClassLoader singleton() {
        if (singleton != null) {
            throw new SecurityException(Msg.getString("K0084"));
        }
        singleton = new BootstrapClassLoader();
        return singleton;
    }

    @Override
    protected Package getPackage(String name) {
        return VM.getVMLangAccess().getSystemPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        return VM.getVMLangAccess().getSystemPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToClassPathForInstrumentation(String jarPath) throws Throwable {
        Object object = cacheLock;
        synchronized (object) {
            int newCount = this.addJar(Util.getBytes(jarPath));
            int[] newTypes = new int[newCount];
            System.arraycopy((Object)this.types, 0, (Object)newTypes, 0, newCount - 1);
            this.types = newTypes;
            Object[] newCache = new Object[newCount];
            System.arraycopy((Object)this.cache, 0, (Object)newCache, 0, newCount - 1);
            this.cache = newCache;
            String[] newParsedPath = new String[newCount];
            System.arraycopy((Object)this.parsedPath, 0, (Object)newParsedPath, 0, newCount - 1);
            this.parsedPath = newParsedPath;
            if (this.permissions != null) {
                FilePermission[] newPermissions = new FilePermission[newCount];
                System.arraycopy((Object)this.permissions, 0, (Object)newPermissions, 0, newCount - 1);
                this.permissions = newPermissions;
            }
            this.resourceCacheRef = null;
        }
    }

    private native int addJar(byte[] var1);
}

