/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.javaSE.Advertisement;
import com.ibm.tools.attach.javaSE.Attachment;
import com.ibm.tools.attach.javaSE.CommonDirectory;
import com.ibm.tools.attach.javaSE.FileLock;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.Reply;
import com.ibm.tools.attach.javaSE.TargetDirectory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;

public class AttachHandler
extends Thread {
    private static final String VMID_PROPERTY = "com.ibm.tools.attach.id";
    private static final String DISPLAYNAME_PROPERTY = "com.ibm.tools.attach.displayName";
    static final String LOGGING_ENABLE_PROPERTY = "com.ibm.tools.attach.logging";
    static final String LOG_NAME_PROPERTY = "com.ibm.tools.attach.log.name";
    static final String VMID_VALID_PATTERN = "\\p{Alpha}\\w*";
    static final long shutdownTimeoutMs = Integer.getInteger("com.ibm.tools.attach.shutdown_timeout", 10000).intValue();
    static AttachHandler mainHandler = new AttachHandler();
    static volatile Thread currentAttachThread = mainHandler;
    private Vector<Attachment> attachments = new Vector();
    private static String vmId = "";
    private String displayName;
    private static AttachStateValues attachState = AttachStateValues.ATTACH_UNINITIALIZED;
    private static boolean waitingForSemaphore = false;
    private static AttachStateSync stateSync = new AttachStateSync();
    private static int notificationCount;
    private static boolean doCancelNotify;
    private final syncObject ignoreNotification = new syncObject();
    private static final syncObject accessorMutex;
    private Exception lastException;
    private static Exception factoryException;
    private static String nameProperty;
    private static String pidProperty;
    private static int numberOfTargets;
    private FileLock syncFileLock;

    private AttachHandler() {
        this.setDaemon(true);
        this.setName("Attach API initializer");
    }

    static void initializeAttachAPI() {
        String enableAttachProp;
        if (IPC.isUsingDefaultUid()) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        boolean enableAttach = true;
        String osName = System.getProperty("os.name");
        if (null != osName && osName.equalsIgnoreCase("z/OS")) {
            enableAttach = false;
        }
        if (null != (enableAttachProp = System.getProperty("com.ibm.tools.attach.enable"))) {
            if (enableAttachProp.equalsIgnoreCase("no")) {
                enableAttach = false;
            } else if (enableAttachProp.equalsIgnoreCase("yes")) {
                enableAttach = true;
            }
        }
        if (enableAttach) {
            Runtime.getRuntime().addShutdownHook(new teardownHook());
            mainHandler.start();
        } else {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
        }
    }

    private static String validateVmId(String id) {
        if (null != id && !id.matches(VMID_VALID_PATTERN)) {
            id = null;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFiles(String newDisplayName) throws IOException {
        try {
            if (CommonDirectory.tryObtainMasterLock()) {
                CommonDirectory.deleteStaleDirectories(pidProperty);
            } else {
                CommonDirectory.obtainMasterLock();
            }
            if (IPC.loggingEnabled) {
                IPC.logMessage("AttachHandler obtained master lock");
            }
            CommonDirectory.createNotificationFile();
            if (AttachHandler.isAttachApiTerminated()) {
                boolean bl = false;
                return bl;
            }
            String myId = TargetDirectory.createMyDirectory(pidProperty, false);
            if (null == myId) {
                boolean bl = false;
                return bl;
            }
            AttachHandler.setVmId(myId);
            this.setDisplayName(newDisplayName);
            CommonDirectory.openSemaphore();
            CommonDirectory.obtainAttachLock();
            Advertisement.createAdvertisementFile(AttachHandler.getVmId(), newDisplayName);
        }
        finally {
            CommonDirectory.releaseAttachLock();
            CommonDirectory.releaseMasterLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        VM.markCurrentThreadAsSystem();
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            if (AttachStateValues.ATTACH_UNINITIALIZED != AttachHandler.getAttachState()) {
                return;
            }
            AttachHandler.setAttachState(AttachStateValues.ATTACH_STARTING);
        }
        try {
            if (!this.initialize()) {
                IPC.logMessage("ERROR: failed to initialize");
                return;
            }
            WaitLoop waiter = new WaitLoop();
            AttachStateSync attachStateSync2 = stateSync;
            synchronized (attachStateSync2) {
                if (AttachHandler.isAttachApiTerminated()) {
                    return;
                }
                AttachHandler.setAttachState(AttachStateValues.ATTACH_INITIALIZED);
                currentAttachThread = waiter;
            }
            waiter.start();
        }
        catch (OutOfMemoryError e) {
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
        catch (IOException e) {
            AttachHandler.setFactoryException(e);
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialize() throws IOException {
        String loggingProperty = System.getProperty(LOGGING_ENABLE_PROPERTY);
        String logName = System.getProperty(LOG_NAME_PROPERTY);
        logName = null != logName && !logName.equals("") ? logName + '_' : "";
        nameProperty = System.getProperty(DISPLAYNAME_PROPERTY);
        pidProperty = AttachHandler.validateVmId(System.getProperty(VMID_PROPERTY));
        if (null == pidProperty || 0 == pidProperty.length()) {
            long pid = IPC.getProcessId();
            pidProperty = Long.toString(pid);
        }
        if (null == nameProperty) {
            nameProperty = System.getProperty("sun.java.command");
        }
        if (null == IPC.logStream && null != loggingProperty && loggingProperty.equalsIgnoreCase("yes")) {
            File logFile = new File(logName + pidProperty + ".log");
            IPC.setLogStream(new PrintStream(logFile));
            IPC.loggingEnabled = true;
            IPC.setDefaultVmId(pidProperty);
            IPC.logMessage("AttachHandler initialize");
        }
        AttachStateSync logFile = stateSync;
        synchronized (logFile) {
            if (AttachHandler.isAttachApiTerminated()) {
                return false;
            }
            CommonDirectory.prepareCommonDirectory();
        }
        try {
            if (!this.createFiles(nameProperty)) {
                return false;
            }
        }
        catch (IOException e) {
            IPC.logMessage("AttachHandler IOException while creating files: ", e.getMessage());
            this.terminate(false);
            return false;
        }
        File syncFileObjectTemp = TargetDirectory.getSyncFileObject();
        if (AttachHandler.isAttachApiTerminated() || null == syncFileObjectTemp) {
            return false;
        }
        this.syncFileLock = new FileLock(syncFileObjectTemp.getAbsolutePath(), 438);
        return true;
    }

    Attachment connectToAttacher() throws IOException {
        Reply attacherReply = Reply.readReply(TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
        Attachment at = null;
        if (null != attacherReply) {
            int portNumber = attacherReply.getPortNumber();
            IPC.logMessage(notificationCount + " connectToAttacher reply on port ", portNumber);
            if (portNumber >= 0) {
                at = new Attachment(mainHandler, attacherReply);
                this.addAttachment(at);
                at.start();
            }
        } else if (IPC.loggingEnabled) {
            IPC.logMessage("connectToAttacher ", notificationCount, " waitForNotification no reply file");
        }
        return at;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean terminate(boolean wakeHandler) {
        if (IPC.loggingEnabled) {
            IPC.logMessage("AttachHandler terminate: Attach API is being shut down");
        }
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues myAttachState = AttachHandler.getAttachState();
            AttachHandler.setAttachState(AttachStateValues.ATTACH_TERMINATED);
            switch (myAttachState) {
                case ATTACH_UNINITIALIZED: {
                    return false;
                }
                case ATTACH_STARTING: {
                    break;
                }
                case ATTACH_INITIALIZED: {
                    break;
                }
                case ATTACH_TERMINATED: {
                    return false;
                }
            }
        }
        currentAttachThread.interrupt();
        if (wakeHandler) {
            if (IPC.loggingEnabled) {
                IPC.logMessage("AttachHandler terminate removing contents of directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyFiles();
        } else {
            if (IPC.loggingEnabled) {
                IPC.logMessage("AttachHandler terminate removing directory : ", TargetDirectory.getTargetDirectoryPath(AttachHandler.getVmId()));
            }
            TargetDirectory.deleteMyDirectory(false);
        }
        for (Attachment a : this.attachments) {
            if (null == a) continue;
            a.teardown();
        }
        FileLock.shutDown();
        boolean destroySemaphore = this.terminateWaitLoop(wakeHandler);
        return destroySemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean terminateWaitLoop(boolean wakeHandler) {
        boolean gotLock = false;
        boolean destroySemaphore = false;
        long lockDeadline = System.nanoTime() + shutdownTimeoutMs * 1000000L / 10L;
        try {
            gotLock = CommonDirectory.tryObtainMasterLock();
            while (!gotLock && AttachHandler.isWaitingForSemaphore()) {
                Thread.sleep(10L);
                gotLock = CommonDirectory.tryObtainMasterLock();
                if (System.nanoTime() <= lockDeadline) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            IPC.logMessage("InterruptedException while waiting to shut down");
        }
        catch (IOException e) {
            IPC.logMessage("IOException in tryObtainMasterLock");
        }
        if (!AttachHandler.isWaitingForSemaphore()) {
            wakeHandler = false;
            if (IPC.loggingEnabled) {
                IPC.logMessage("VM already notified for temination, abandoning master lock");
            }
            if (gotLock) {
                CommonDirectory.releaseMasterLock();
                gotLock = false;
            }
        }
        if (gotLock) {
            try {
                if (IPC.loggingEnabled) {
                    IPC.logMessage("AttachHandler terminate obtained master lock");
                }
                int numTargets = CommonDirectory.countTargetDirectories();
                AttachHandler.setNumberOfTargets(numTargets);
                if (numTargets <= 1) {
                    AttachHandler.setDoCancelNotify(false);
                    if (wakeHandler) {
                        CommonDirectory.notifyVm(1);
                    }
                    destroySemaphore = true;
                    return destroySemaphore;
                }
                if (!wakeHandler) return destroySemaphore;
                AttachHandler.setDoCancelNotify(true);
                CommonDirectory.notifyVm(numTargets);
                return destroySemaphore;
            }
            finally {
                CommonDirectory.releaseMasterLock();
                if (IPC.loggingEnabled) {
                    IPC.logMessage("AttachHandler terminate released master lock");
                }
            }
        } else {
            IPC.logMessage("AttachHandler tryObtainMasterLock failed");
        }
        return destroySemaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForAttachApiInitialization() {
        boolean status;
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachStateValues currentState = AttachHandler.getAttachState();
            if (AttachStateValues.ATTACH_INITIALIZED == currentState) {
                status = true;
            } else if (AttachStateValues.ATTACH_TERMINATED == currentState) {
                status = false;
            } else {
                int waitCycles = 2;
                status = false;
                block10: while (waitCycles > 0) {
                    --waitCycles;
                    try {
                        stateSync.wait(100000L);
                        currentState = AttachHandler.getAttachState();
                        switch (currentState) {
                            case ATTACH_STARTING: {
                                continue block10;
                            }
                            case ATTACH_INITIALIZED: {
                                status = true;
                                waitCycles = 0;
                                continue block10;
                            }
                            case ATTACH_TERMINATED: {
                                waitCycles = 0;
                                continue block10;
                            }
                        }
                        waitCycles = 0;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setNumberOfTargets(int numberOfTargets) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            AttachHandler.numberOfTargets = numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNumberOfTargets() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return numberOfTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttachment(Attachment at) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.attachments.add(at);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAttachment(Attachment attachment) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            int pos = this.attachments.indexOf(attachment);
            if (pos > 0) {
                this.attachments.remove(pos);
            }
        }
    }

    static Properties getAgentProperties() {
        String[] agentPropertyNames = new String[]{"com.sun.management.jmxremote.localConnectorAddress", "sun.jvm.args", "sun.jvm.flags", "sun.java.command"};
        Properties agentProperties = new Properties();
        for (String pName : agentPropertyNames) {
            String pValue = System.getProperty(pName);
            if (null == pValue) continue;
            agentProperties.put(pName, pValue);
        }
        return agentProperties;
    }

    public static boolean isAttachApiInitialized() {
        return AttachStateValues.ATTACH_INITIALIZED == AttachHandler.getAttachState();
    }

    static boolean isAttachApiTerminated() {
        return AttachStateValues.ATTACH_TERMINATED == AttachHandler.getAttachState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttachStateValues getAttachState() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return attachState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean startWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = attachState != AttachStateValues.ATTACH_TERMINATED;
            return waitingForSemaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endWaitingForSemaphore() {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            waitingForSemaphore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAttachState(AttachStateValues attachState) {
        AttachStateSync attachStateSync = stateSync;
        synchronized (attachStateSync) {
            AttachHandler.attachState = attachState;
            stateSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getDisplayName() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplayName(String displayName) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.displayName = displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getlastException() {
        AttachHandler mh = AttachHandler.getMainHandler();
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            Exception temp = mh.lastException;
            mh.lastException = null;
            return temp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastException(Exception lastException) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            this.lastException = lastException;
        }
    }

    static Exception getFactoryException() {
        return factoryException;
    }

    static void setFactoryException(Exception factoryException) {
        AttachHandler.factoryException = factoryException;
    }

    Object getIgnoreNotification() {
        return this.ignoreNotification;
    }

    static AttachHandler getMainHandler() {
        return mainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVmId() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return vmId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setVmId(String id) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            vmId = id;
        }
    }

    public static long getProcessId() {
        return IPC.getProcessId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean getDoCancelNotify() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return doCancelNotify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDoCancelNotify(boolean doCancel) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            doCancelNotify = doCancel;
        }
    }

    static {
        accessorMutex = new syncObject();
    }

    static final class teardownHook
    extends Thread {
        teardownHook() {
        }

        @Override
        public void run() {
            try {
                block19: {
                    Thread.currentThread().setName("Attach API teardown");
                    VM.markCurrentThreadAsSystem();
                    if (IPC.loggingEnabled) {
                        IPC.logMessage("shutting down attach API");
                    }
                    if (null == mainHandler) {
                        return;
                    }
                    long shutdownDeadlineNs = System.nanoTime() + shutdownTimeoutMs * 1000000L;
                    boolean destroySemaphore = mainHandler.terminate(true);
                    try {
                        mainHandler.join(shutdownTimeoutMs / 2L);
                        int timeout = 100;
                        while (System.nanoTime() < shutdownDeadlineNs) {
                            currentAttachThread.join(timeout);
                            if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                                IPC.logMessage("Timeout waiting for wait loop termination.  Retry");
                                timeout *= 2;
                                mainHandler.terminateWaitLoop(true);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        IPC.logMessage("teardown join with attach handler interrupted");
                    }
                    if (currentAttachThread.getState() != Thread.State.TERMINATED) {
                        IPC.logMessage("Attach API not terminated");
                    }
                    TargetDirectory.deleteMyDirectory(true);
                    if (destroySemaphore) {
                        try {
                            if (CommonDirectory.tryObtainMasterLock()) {
                                CommonDirectory.destroySemaphore();
                                if (IPC.loggingEnabled) {
                                    IPC.logMessage("AttachHandler destroyed semaphore");
                                }
                                break block19;
                            }
                            if (IPC.loggingEnabled) {
                                IPC.logMessage("could not obtain lock, semaphore not destroyed");
                            }
                            CommonDirectory.closeSemaphore();
                        }
                        catch (IOException e) {
                            IPC.logMessage("exception when locking master lock");
                        }
                    } else {
                        CommonDirectory.closeSemaphore();
                        if (IPC.loggingEnabled) {
                            IPC.logMessage("AttachHandler closed semaphore");
                        }
                    }
                }
                if (null != IPC.logStream) {
                    IPC.logStream.close();
                }
            }
            catch (OutOfMemoryError e) {
                IPC.tracepoint(-3, e.getMessage());
                return;
            }
        }
    }

    static final class WaitLoop
    extends Thread {
        WaitLoop() {
            this.setDaemon(true);
            this.setName("Attach API wait loop");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Attachment waitForNotification(boolean retry) throws IOException {
            Object myIN = mainHandler.getIgnoreNotification();
            if (IPC.loggingEnabled) {
                IPC.logMessage("iteration ", notificationCount, " waitForNotification ignoreNotification entering");
            }
            Object object = myIN;
            synchronized (object) {
                if (IPC.loggingEnabled) {
                    IPC.logMessage("iteration ", notificationCount, " waitForNotification ignoreNotification entered");
                }
            }
            if (IPC.loggingEnabled) {
                IPC.logMessage("iteration ", notificationCount, " waitForNotification starting wait");
            }
            int status = 0;
            if (AttachHandler.startWaitingForSemaphore()) {
                status = CommonDirectory.waitSemaphore(vmId);
                AttachHandler.endWaitingForSemaphore();
            }
            if (IPC.loggingEnabled) {
                IPC.logMessage("iteration ", notificationCount, " waitForNotification ended wait");
            }
            if (AttachHandler.isAttachApiTerminated()) {
                if (AttachHandler.getDoCancelNotify()) {
                    if (IPC.loggingEnabled) {
                        IPC.logMessage("iteration ", notificationCount, " waitForNotification cancelNotify");
                    }
                    CommonDirectory.cancelNotify(AttachHandler.getNumberOfTargets());
                }
                return null;
            }
            if (status != 0) {
                if (retry) {
                    IPC.logMessage("iteration ", notificationCount, " waitForNotification reopen semaphore");
                    AttachStateSync attachStateSync = stateSync;
                    synchronized (attachStateSync) {
                        if (!AttachHandler.isAttachApiTerminated()) {
                            try {
                                CommonDirectory.obtainMasterLock();
                                status = CommonDirectory.reopenSemaphore();
                                CommonDirectory.releaseMasterLock();
                            }
                            catch (IOException e) {
                                IPC.logMessage("waitForNotification: IOError on master lock : ", e.toString());
                            }
                        }
                    }
                    if (0 == status && TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                        if (CommonDirectory.tryObtainMasterLock()) {
                            IPC.logMessage("semaphore recovery: send test post");
                            int numTargets = CommonDirectory.countTargetDirectories();
                            AttachHandler.setNumberOfTargets(numTargets);
                            CommonDirectory.notifyVm(numTargets);
                            CommonDirectory.releaseMasterLock();
                        }
                        return this.waitForNotification(false);
                    }
                }
                mainHandler.terminate(false);
                return null;
            }
            Attachment at = this.checkReplyAndCreateAttachment();
            return at;
        }

        private Attachment checkReplyAndCreateAttachment() throws IOException {
            Attachment at = mainHandler.connectToAttacher();
            if (!TargetDirectory.ensureMyAdvertisementExists(AttachHandler.getVmId())) {
                mainHandler.terminate(false);
            }
            if (IPC.loggingEnabled) {
                IPC.logMessage("checkReplyAndCreateAttachment iteration " + notificationCount + " waitForNotification obtainLock");
            }
            if (!mainHandler.syncFileLock.lockFile(true)) {
                TargetDirectory.createMySyncFile();
            } else {
                if (IPC.loggingEnabled) {
                    IPC.logMessage("iteration ", notificationCount, " checkReplyAndCreateAttachment releaseLock");
                }
                mainHandler.syncFileLock.unlockFile();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return at;
            }
            return at;
        }

        @Override
        public void run() {
            VM.markCurrentThreadAsSystem();
            while (!AttachHandler.isAttachApiTerminated()) {
                try {
                    this.waitForNotification(true);
                }
                catch (IOException e) {
                    IPC.logMessage("exception in waitForNotification ", e.toString());
                    mainHandler.setLastException(e);
                }
                catch (OutOfMemoryError e) {
                    IPC.tracepoint(-2, e.getMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        continue;
                    }
                }
                ++notificationCount;
            }
            mainHandler.syncFileLock = null;
        }
    }

    private static final class syncObject {
        private syncObject() {
        }
    }

    private static final class AttachStateSync {
        private AttachStateSync() {
        }
    }

    private static enum AttachStateValues {
        ATTACH_UNINITIALIZED,
        ATTACH_TERMINATED,
        ATTACH_STARTING,
        ATTACH_INITIALIZED;

    }
}

