/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachine;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.Advertisement;
import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.CommonDirectory;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.Permissions;
import com.ibm.tools.attach.javaSE.TargetDirectory;
import com.ibm.tools.attach.javaSE.VirtualMachineDescriptorImpl;
import com.ibm.tools.attach.javaSE.VirtualMachineImpl;
import com.ibm.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttachProviderImpl
extends AttachProvider {
    @Override
    public VirtualMachine attachVirtualMachine(String id) throws AttachNotSupportedException, IOException {
        AttachProviderImpl.checkAttachSecurity();
        try {
            VirtualMachineImpl vm = new VirtualMachineImpl(this, id);
            vm.attachTarget();
            return vm;
        }
        catch (NullPointerException e) {
            AttachNotSupportedException exc = new AttachNotSupportedException(Msg.getString("K0554"));
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public VirtualMachine attachVirtualMachine(VirtualMachineDescriptor descriptor) throws AttachNotSupportedException, IOException {
        AttachProviderImpl.checkAttachSecurity();
        AttachProvider provider = descriptor.provider();
        if (provider.getClass() != this.getClass()) {
            throw new AttachNotSupportedException(Msg.getString("K0543"));
        }
        VirtualMachineImpl vm = new VirtualMachineImpl(this, descriptor.id());
        vm.attachTarget();
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        AttachHandler.waitForAttachApiInitialization();
        File commonDir = CommonDirectory.getCommonDirFileObject();
        ArrayList<VirtualMachineDescriptor> descriptors = new ArrayList<VirtualMachineDescriptor>();
        if (null == commonDir) {
            IPC.logMessage("listVirtualMachines() error getting common directory");
            return null;
        }
        if (!commonDir.exists()) {
            IPC.logMessage("listVirtualMachines() common directory is absent");
            return descriptors;
        }
        if (!commonDir.isDirectory()) {
            IPC.logMessage("listVirtualMachines() common directory is mis-configured");
            return null;
        }
        try {
            CommonDirectory.obtainMasterLock();
        }
        catch (IOException e) {
            IPC.logMessage("listVirtualMachines() IOError on master lock : ", e.toString());
            return descriptors;
        }
        try {
            File[] vmDirs = commonDir.listFiles();
            if (vmDirs == null) {
                ArrayList<VirtualMachineDescriptor> arrayList = descriptors;
                return arrayList;
            }
            long myUid = IPC.getUid();
            for (File f : vmDirs) {
                if (!f.isDirectory() || !CommonDirectory.isFileOwnedByUid(f, myUid)) continue;
                boolean staleDirectory = true;
                File advertisment = new File(f, Advertisement.getFilename());
                long uid = 0L;
                if (advertisment.exists()) {
                    VirtualMachineDescriptorImpl descriptor = VirtualMachineDescriptorImpl.fromAdvertisement(this, advertisment);
                    if (null != descriptor) {
                        long pid = descriptor.getProcessId();
                        uid = descriptor.getUid();
                        if (0L == pid || IPC.processExists(pid)) {
                            descriptors.add(descriptor);
                            staleDirectory = false;
                        }
                    }
                    if (myUid != 0L && 0L == uid) {
                        uid = CommonDirectory.getFileOwner(advertisment.getAbsolutePath());
                    }
                }
                if (!staleDirectory || myUid != 0L && uid != myUid) continue;
                IPC.logMessage("listVirtualMachines() removing stale directory : ", f.getName());
                TargetDirectory.deleteTargetDirectory(f.getName());
            }
        }
        finally {
            CommonDirectory.releaseMasterLock();
        }
        return descriptors;
    }

    VirtualMachineDescriptor getDescriptor(String id) {
        List<VirtualMachineDescriptor> vmds = this.listVirtualMachines();
        if (null != vmds) {
            for (VirtualMachineDescriptor vmd : vmds) {
                if (!vmd.id().equalsIgnoreCase(id)) continue;
                return vmd;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "IBM";
    }

    @Override
    public String type() {
        return "Java SE";
    }

    private static void checkAttachSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.ATTACH_VM);
        }
    }
}

