/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.javaSE.Advertisement;
import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.FileLock;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.TargetDirectory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;

abstract class CommonDirectory {
    private static final String ATTACH_LOCK = "_attachlock";
    private static final String COM_IBM_TOOLS_ATTACH_DIRECTORY = "com.ibm.tools.attach.directory";
    private static final int COMMON_DIRECTORY_PERMISSIONS = 1023;
    private static final int COMMON_LOCK_FILE_PERMISSIONS = 438;
    private static final String MASTER_LOCKFILE = "_master";
    static final String MASTER_NOTIFIER = "_notifier";
    static final int SEMAPHORE_OKAY = 0;
    private static final String TRASH_PREFIX = ".trash_";
    private static final syncObject accessorMutex = new syncObject();
    private static FileLock attachLock;
    private static File commonDirFile;
    private static FileLock masterLock;
    private static String semaphoreId;
    private static String systemTmpDir;
    static final int J9PORT_INFO_SHSEM_OPENED_STALE = 103;

    CommonDirectory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCommonDirFileObject(File dir) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            commonDirFile = dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getCommonDirFileObject() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == commonDirFile) {
                CommonDirectory.initialize();
            }
            return commonDirFile;
        }
    }

    static String getCommonDirPath() {
        return CommonDirectory.getCommonDirFileObject().getAbsolutePath();
    }

    private static void initialize() {
        String ipcDirProperty = System.getProperty(COM_IBM_TOOLS_ATTACH_DIRECTORY, new File(systemTmpDir, ".com_ibm_tools_attach").getPath());
        if (IPC.loggingEnabled) {
            IPC.logMessage("IPC Directory", ipcDirProperty);
        }
        File cd = new File(ipcDirProperty);
        CommonDirectory.setCommonDirFileObject(cd);
    }

    static void prepareCommonDirectory() throws IOException {
        File cd = CommonDirectory.getCommonDirFileObject();
        if (IPC.loggingEnabled) {
            IPC.logMessage("createDirectoryAndSemaphore ", cd.getAbsolutePath());
        }
        if (cd.exists()) {
            if (!cd.canWrite()) {
                IPC.logMessage("could not write ", cd.getAbsolutePath());
                throw new IOException(cd.getAbsolutePath());
            }
            if (!cd.isDirectory()) {
                if (!cd.delete()) {
                    IPC.logMessage("could not delete ", cd.getAbsolutePath());
                    throw new IOException(cd.getAbsolutePath());
                }
                IPC.logMessage("deleted ", cd.getAbsolutePath());
                IPC.mkdirWithPermissions(cd.getAbsolutePath(), 1023);
            }
        } else {
            IPC.mkdirWithPermissions(cd.getAbsolutePath(), 1023);
        }
    }

    static void obtainMasterLock() throws IOException {
        CommonDirectory.getMasterLock().lockFile(true);
    }

    static boolean tryObtainMasterLock() throws IOException {
        return CommonDirectory.getMasterLock().lockFile(false);
    }

    static void releaseMasterLock() {
        CommonDirectory.getMasterLock().unlockFile();
    }

    static void obtainAttachLock() throws IOException {
        CommonDirectory.getAttachLock().lockFile(true);
    }

    static void releaseAttachLock() {
        try {
            CommonDirectory.getAttachLock().unlockFile();
        }
        catch (NullPointerException e) {
            return;
        }
    }

    static void createNotificationFile() throws IOException {
        File notifierFile = new File(CommonDirectory.getCommonDirFileObject(), MASTER_NOTIFIER);
        if (notifierFile.createNewFile()) {
            IPC.chmod(notifierFile.getAbsolutePath(), 438);
        }
    }

    static String openSemaphore() throws IOException {
        String semName = MASTER_NOTIFIER;
        int status = IPC.openSemaphore(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), semName);
        if (0 != status) {
            throw new IOException(Msg.getString("K0538", semName, status));
        }
        return semName;
    }

    static int reopenSemaphore() {
        int status = 0;
        IPC.logMessage("reopenSemaphore");
        CommonDirectory.closeSemaphore();
        status = IPC.openSemaphore(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), MASTER_NOTIFIER);
        return status;
    }

    static int waitSemaphore(String myVmId) {
        int status = IPC.waitSemaphore();
        if (0 != status) {
            IPC.logMessage("waitSemaphore status != JNI_OK, ==", status);
        }
        return status;
    }

    static int notifyVm(int numberOfTargets) {
        if (IPC.loggingEnabled) {
            IPC.logMessage("notifyVm ", numberOfTargets, " targets");
        }
        return IPC.notifyVm(CommonDirectory.getCommonDirFileObject().getAbsolutePath(), MASTER_NOTIFIER, numberOfTargets);
    }

    static int cancelNotify(int numberOfTargets) {
        return IPC.cancelNotify(CommonDirectory.getCommonDirPath(), MASTER_NOTIFIER, numberOfTargets);
    }

    static void closeSemaphore() {
        IPC.closeSemaphore();
    }

    static void destroySemaphore() {
        IPC.destroySemaphore();
    }

    static int countTargetDirectories() {
        File dir = CommonDirectory.getCommonDirFileObject();
        if (!dir.isDirectory()) {
            return 0;
        }
        File[] vmDirs = dir.listFiles();
        if (null == vmDirs) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < vmDirs.length; ++i) {
            String dirMemberName = vmDirs[i].getName();
            if (dirMemberName.startsWith(TRASH_PREFIX) || CommonDirectory.isCommonControlFile(dirMemberName)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isCommonControlFile(String dirMemberName) {
        return ATTACH_LOCK.equalsIgnoreCase(dirMemberName) || MASTER_LOCKFILE.equalsIgnoreCase(dirMemberName) || MASTER_NOTIFIER.equalsIgnoreCase(dirMemberName);
    }

    static void deleteStaleDirectories(String myId) {
        long myUid = IPC.getUid();
        File[] vmDirs = CommonDirectory.getCommonDirFileObject().listFiles(new DirectorySampler());
        if (null == vmDirs) {
            return;
        }
        for (File dirMember : vmDirs) {
            long pid;
            if (AttachHandler.isAttachApiTerminated()) break;
            if (!CommonDirectory.isFileOwnedByUid(dirMember, myUid)) continue;
            String dirMemberName = dirMember.getName();
            if (IPC.loggingEnabled) {
                IPC.logMessage("deleteStaleDirectories checking ", dirMemberName);
            }
            if (dirMember.isFile()) {
                if (CommonDirectory.isCommonControlFile(dirMemberName) || !dirMemberName.startsWith(TRASH_PREFIX)) continue;
                IPC.logMessage("delete trash file ", dirMemberName);
                if (dirMember.delete()) continue;
                IPC.logMessage("error deleting ", dirMemberName);
                continue;
            }
            if (dirMemberName.equalsIgnoreCase(myId)) continue;
            if (Character.isDigit(dirMemberName.charAt(0))) {
                try {
                    pid = Long.parseLong(dirMemberName);
                    long uid = CommonDirectory.getFileOwner(dirMember.getAbsolutePath());
                    if (0L != myUid && uid != myUid) {
                        pid = 0L;
                    }
                }
                catch (NumberFormatException e) {
                    pid = CommonDirectory.getPidFromFile(dirMember, myUid);
                }
            } else {
                pid = CommonDirectory.getPidFromFile(dirMember, myUid);
            }
            if (0L == pid || IPC.processExists(pid)) continue;
            IPC.logMessage("delete defunct directory ", dirMemberName);
            TargetDirectory.deleteTargetDirectory(dirMemberName);
        }
    }

    static boolean isFileOwnedByUid(File f, long myUid) {
        return 0L == myUid || myUid == CommonDirectory.getFileOwner(f.getAbsolutePath());
    }

    private static long getPidFromFile(File dirMember, long myUid) {
        Advertisement advert;
        long pid = 0L;
        File advertFile = new File(dirMember, Advertisement.getFilename());
        if (!advertFile.exists() || 0L == advertFile.length()) {
            IPC.logMessage("delete stale directory ", dirMember.getName());
            TargetDirectory.deleteTargetDirectory(dirMember.getName());
        }
        try {
            FileInputStream propStream = new FileInputStream(advertFile);
            advert = Advertisement.readAdvertisementFile(propStream);
            propStream.close();
        }
        catch (IOException e) {
            return 0L;
        }
        pid = advert.getProcessId();
        long uid = advert.getUid();
        if (IPC.loggingEnabled) {
            IPC.logMessage("getPidFromFile pid = ", (int)pid, dirMember.getName());
        }
        if (0L == uid) {
            uid = CommonDirectory.getFileOwner(dirMember.getAbsolutePath());
        }
        if (IPC.loggingEnabled) {
            IPC.logMessage("getPidFromFile uid = ", (int)uid);
        }
        if (0L != myUid && uid != myUid) {
            pid = 0L;
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileLock getAttachLock() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == attachLock) {
                attachLock = new FileLock(new File(CommonDirectory.getCommonDirFileObject(), ATTACH_LOCK).getAbsolutePath(), 438);
            }
        }
        return attachLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileLock getMasterLock() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == masterLock) {
                File commonDirFileObject = new File(CommonDirectory.getCommonDirFileObject(), MASTER_LOCKFILE);
                String commonDirPath = commonDirFileObject.getAbsolutePath();
                masterLock = new FileLock(commonDirPath, 438);
            }
        }
        return masterLock;
    }

    static native long getFileOwner(String var0);

    static {
        systemTmpDir = IPC.getTmpDir();
    }

    private static final class DirectorySampler
    implements FileFilter {
        private int acceptCount = 16;
        private long skip;
        private long range = 2L;

        private DirectorySampler() {
        }

        @Override
        public boolean accept(File candidate) {
            if (this.acceptCount > 0) {
                --this.acceptCount;
                return true;
            }
            if (this.skip > 0L) {
                --this.skip;
                return false;
            }
            this.skip = System.currentTimeMillis() % this.range;
            this.range *= 2L;
            return true;
        }
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

