/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Util;
import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.AttachmentConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Random;

public class IPC {
    static final int JNI_OK = 0;
    static final int TRACEPOINT_STATUS_NORMAL = 0;
    static final int TRACEPOINT_STATUS_LOGGING = 1;
    static final int TRACEPOINT_STATUS_ERROR = -1;
    static final int TRACEPOINT_STATUS_OOM_DURING_WAIT = -2;
    static final int TRACEPOINT_STATUS_OOM_DURING_TERMINATE = -3;
    static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static Random randomGen;
    static PrintStream logStream;
    static volatile boolean loggingEnabled;
    static String defaultVmId;
    private static final syncObject accessorMutex;

    static native int chmod(String var0, int var1);

    static native int chownFileToTargetUid(String var0, long var1);

    static int mkdirWithPermissions(String absolutePath, int perms) throws IOException {
        int status = IPC.mkdirWithPermissionsImpl(absolutePath, perms);
        if (0 != status) {
            throw new IOException(absolutePath);
        }
        return status;
    }

    static native int mkdirWithPermissionsImpl(String var0, int var1);

    static native int openSemaphore(String var0, String var1);

    static native int waitSemaphore();

    static native int notifyVm(String var0, String var1, int var2);

    static native int cancelNotify(String var0, String var1, int var2);

    static native void closeSemaphore();

    static native int destroySemaphore();

    static native long getUid();

    static native boolean isUsingDefaultUid();

    static native long getProcessId();

    public static boolean processExists(long pid) {
        int rc = IPC.processExistsImpl(pid);
        return rc > 0;
    }

    private static native int processExistsImpl(long var0);

    static void createFileWithPermissions(String path, int perms) throws IOException {
        int rc = IPC.createFileWithPermissionsImpl(path, perms);
        if (0 != rc) {
            throw new IOException(path);
        }
    }

    private static native int createFileWithPermissionsImpl(String var0, int var1);

    static String getTmpDir() {
        byte[] tmpDirBytes = IPC.getTmpDirImpl();
        String tmpDir = null != tmpDirBytes ? Util.toString(tmpDirBytes, 0, tmpDirBytes.length) : System.getProperty("java.io.tmpdir");
        return tmpDir;
    }

    private static native byte[] getTmpDirImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRandomNumber() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == randomGen) {
                randomGen = new Random(System.nanoTime());
            }
            return randomGen.nextInt();
        }
    }

    static native void tracepoint(int var0, String var1);

    static void logMessage(String msg) {
        if (loggingEnabled) {
            IPC.printLogMessage(msg);
        }
    }

    public static void logMessage(String string1, String string2) {
        if (loggingEnabled) {
            IPC.printLogMessage(string1 + string2);
        }
    }

    static void logMessage(String string1, int int1) {
        if (loggingEnabled) {
            IPC.printLogMessage(string1 + Integer.toString(int1));
        }
    }

    public static void logMessage(String string1, int int1, String string2) {
        if (loggingEnabled) {
            IPC.printLogMessage(string1 + Integer.toString(int1) + string2);
        }
    }

    public static void logMessage(String string1, int int1, String string2, String string3) {
        if (loggingEnabled) {
            IPC.printLogMessage(string1 + Integer.toString(int1) + string2 + string3);
        }
    }

    private static synchronized void printLogMessage(String msg) {
        IPC.tracepoint(1, msg);
        long currentTime = System.currentTimeMillis();
        PrintStream log = IPC.getLogStream();
        log.print(currentTime);
        log.print(" ");
        String id = AttachHandler.getVmId();
        if (0 == id.length()) {
            id = defaultVmId;
        }
        log.print(id);
        log.print(": ");
        log.print(Thread.currentThread().getId());
        log.print(" [");
        log.print(Thread.currentThread().getName());
        log.print("]: ");
        log.println(msg);
        log.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrintStream getLogStream() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            return logStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLogStream(PrintStream log) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            logStream = log;
        }
    }

    static void setDefaultVmId(String id) {
        defaultVmId = id;
    }

    static void sendProperties(Properties props, OutputStream outStream) throws IOException {
        ByteArrayOutputStream propsBuffer = new ByteArrayOutputStream();
        props.store(propsBuffer, "");
        outStream.write(propsBuffer.toByteArray());
        outStream.write(0);
    }

    static Properties receiveProperties(InputStream inStream, boolean requireNull) throws IOException {
        byte[] msgBuff = AttachmentConnection.streamReceiveBytes(inStream, 0, requireNull);
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(msgBuff));
        return props;
    }

    static {
        accessorMutex = new syncObject();
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

