/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.Advertisement;
import com.ibm.tools.attach.javaSE.IPC;
import com.ibm.tools.attach.javaSE.TargetDirectory;
import com.ibm.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

final class VirtualMachineDescriptorImpl
extends VirtualMachineDescriptor {
    private final String replyFile;
    private final String attachSyncFileValue;
    private final long processId;
    private final long uid;

    @Override
    public boolean equals(Object comparand) {
        return super.equals(comparand);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    VirtualMachineDescriptorImpl(AttachProvider provider, String id, String displayName) {
        super(provider, id, displayName);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
    }

    VirtualMachineDescriptorImpl(AttachProvider provider, String id) {
        super(provider, id);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
    }

    VirtualMachineDescriptorImpl(AttachProvider provider, Advertisement advert) {
        super(provider, advert.getVmId(), advert.getDisplayName());
        this.replyFile = advert.getReplyFile();
        this.attachSyncFileValue = advert.getNotificationSync();
        this.processId = advert.getProcessId();
        this.uid = advert.getUid();
    }

    long getProcessId() {
        return this.processId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VirtualMachineDescriptorImpl fromAdvertisement(AttachProvider provider, File advertFile) {
        Advertisement advert = null;
        FileInputStream propStream = null;
        try {
            propStream = new FileInputStream(advertFile);
            advert = Advertisement.readAdvertisementFile(propStream);
        }
        catch (IOException e) {
            IPC.logMessage("could not read advertisement file ", advertFile.getAbsolutePath());
            VirtualMachineDescriptorImpl virtualMachineDescriptorImpl = null;
            return virtualMachineDescriptorImpl;
        }
        finally {
            if (null != propStream) {
                IPC.logMessage("fromAdvertisement closing advertisement file ", advertFile.getAbsolutePath());
                try {
                    propStream.close();
                }
                catch (IOException e) {
                    IPC.logMessage("IOException closing advertisement file ", advertFile.getAbsolutePath());
                }
            }
        }
        VirtualMachineDescriptorImpl vmd = new VirtualMachineDescriptorImpl(provider, advert);
        return vmd;
    }

    String getReplyFile() {
        return this.replyFile;
    }

    String getAttachSyncFileValue() {
        String asFile = this.attachSyncFileValue;
        if (null == asFile) {
            asFile = TargetDirectory.createSyncFileObject(this.id()).getAbsolutePath();
        }
        return asFile;
    }

    long getUid() {
        return this.uid;
    }
}

