/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.HypervisorInfoRetrievalException;
import com.ibm.virtualization.management.HypervisorMXBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class HypervisorMXBeanImpl
implements HypervisorMXBean {
    private static int HYPERVISOR_NOT_SUPPORTED = -100001;
    private static int RUNNING_ON_HYPERVISOR = 1;
    private static int NOT_RUNNING_ON_HYPERVISOR = 0;
    private static HypervisorMXBeanImpl instance = new HypervisorMXBeanImpl();
    private int isVirtual = this.isEnvironmentVirtualImpl();
    private String hypervisorName = this.getVendorImpl();

    public static HypervisorMXBeanImpl getInstance() {
        return instance;
    }

    @Override
    public String getVendor() {
        return this.hypervisorName;
    }

    @Override
    public boolean isEnvironmentVirtual() throws UnsupportedOperationException, HypervisorInfoRetrievalException {
        if (this.isVirtual == HYPERVISOR_NOT_SUPPORTED) {
            throw new UnsupportedOperationException(Msg.getString("K0565"));
        }
        if (this.isVirtual < 0) {
            throw new HypervisorInfoRetrievalException(Msg.getString("K0566", this.isVirtual));
        }
        if (this.isVirtual == RUNNING_ON_HYPERVISOR) {
            return true;
        }
        if (this.isVirtual == NOT_RUNNING_ON_HYPERVISOR) {
            return false;
        }
        return false;
    }

    @Override
    public ObjectName getObjectName() {
        try {
            ObjectName name = new ObjectName("com.ibm.virtualization.management:type=Hypervisor");
            return name;
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    private native int isEnvironmentVirtualImpl();

    private native String getVendorImpl();
}

