/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.Unsafe;
import sun.reflect.misc.ReflectUtil;

final class J9VMInternals {
    private static final int j9Version = 100926064;
    private static final long j9Config = 8314596480236151296L;
    static final JITHelpers jitHelpers = JITHelpers.getHelpers();
    private static Map exceptions;
    static boolean initialized;
    private static Unsafe unsafe;

    private J9VMInternals() {
    }

    private static void completeInitialization() {
        initialized = true;
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        Thread.currentThread().completeInitialization();
    }

    static native boolean isXaggressiveImpl();

    static void initialize(Class<?> clazz) {
        if (null != clazz.initializationLock) {
            Unsafe localUnsafe = unsafe;
            if (null == localUnsafe) {
                localUnsafe = unsafe = Unsafe.getUnsafe();
            }
            localUnsafe.ensureClassInitialized(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializationAlreadyFailed(Class clazz) {
        NoClassDefFoundError notFound = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
        if (exceptions != null) {
            Map map = exceptions;
            synchronized (map) {
                Throwable reason;
                SoftReference weakReason = (SoftReference)exceptions.get(clazz);
                if (weakReason != null && (reason = (Throwable)weakReason.get()) != null) {
                    reason = J9VMInternals.copyThrowable(reason);
                    notFound.initCause(reason);
                }
            }
        }
        throw notFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordInitializationFailure(Class clazz, Throwable err) {
        if (initialized) {
            if (exceptions == null) {
                exceptions = new WeakHashMap();
            }
            Map map = exceptions;
            synchronized (map) {
                Throwable cause = err;
                if (err instanceof ExceptionInInitializerError && (cause = ((ExceptionInInitializerError)err).getException()) == null) {
                    cause = err;
                }
                exceptions.put(clazz, new SoftReference<Throwable>(J9VMInternals.copyThrowable(cause)));
            }
        }
        J9VMInternals.ensureError(err);
    }

    private static void ensureError(Throwable err) {
        if (err instanceof Error) {
            throw (Error)err;
        }
        throw new ExceptionInInitializerError(err);
    }

    private static native Throwable newInstance(Class var0, Class var1);

    private static Throwable cloneThrowable(final Throwable throwable, final HashMap hashMapThrowable) {
        return (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Throwable clone;
                try {
                    Class cls = throwable.getClass();
                    clone = J9VMInternals.newInstance(cls, Object.class);
                    while (cls != null) {
                        Field[] fields = cls.getDeclaredFields();
                        for (int i = 0; i < fields.length; ++i) {
                            Object value;
                            if (Modifier.isStatic(fields[i].getModifiers()) || cls == Throwable.class && fields[i].getName().equals("walkback")) continue;
                            fields[i].setAccessible(true);
                            if (cls == Throwable.class && fields[i].getName().equals("cause")) {
                                value = clone;
                            } else {
                                value = fields[i].get(throwable);
                                if (value instanceof Throwable) {
                                    value = J9VMInternals.copyThrowable((Throwable)value, hashMapThrowable);
                                }
                            }
                            fields[i].set(clone, value);
                        }
                        cls = J9VMInternals.getSuperclass(cls);
                    }
                }
                catch (Throwable e) {
                    clone = new Throwable(Msg.getString("K05c3", e, throwable.toString()));
                }
                return clone;
            }
        });
    }

    private static Throwable copyThrowable(Throwable throwable) {
        HashMap hashMapThrowable = new HashMap();
        return J9VMInternals.copyThrowable(throwable, hashMapThrowable);
    }

    private static Throwable copyThrowable(Throwable throwable, HashMap hashMapThrowable) {
        if (hashMapThrowable.get(throwable) != null) {
            return throwable;
        }
        hashMapThrowable.put(throwable, throwable);
        Throwable root = J9VMInternals.cloneThrowable(throwable, hashMapThrowable);
        root.setStackTrace(throwable.getStackTrace());
        Throwable parent = root;
        for (Throwable cause = throwable.getCause(); cause != null && hashMapThrowable.get(cause) == null; cause = cause.getCause()) {
            hashMapThrowable.put(cause, cause);
            Throwable child = J9VMInternals.cloneThrowable(cause, hashMapThrowable);
            child.setStackTrace(cause.getStackTrace());
            parent.setCause(child);
            parent = child;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.group.remove(thread);
        }
        finally {
            thread.cleanup();
            Thread thread2 = thread;
            synchronized (thread2) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(final Class clazz, ProtectionDomain pd) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sm.checkPackageAccess(clazz.getPackageName());
                    if (Proxy.isProxyClass(clazz)) {
                        ClassLoader cl = clazz.getClassLoaderImpl();
                        ReflectUtil.checkProxyPackageAccess(cl, clazz.getInterfaces());
                    }
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{pd}));
        }
    }

    private static void runFinalize(Object obj) {
        try {
            obj.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static native StackTraceElement[] getStackTrace(Throwable var0, boolean var1);

    private static native void prepareClassImpl(Class var0);

    static void prepare(Class clazz) {
        if (clazz.initializationLock == null) {
            return;
        }
        J9VMInternals.prepareClassImpl(clazz);
    }

    static native Class getSuperclass(Class var0);

    static native Class[] getInterfaces(Class var0);

    static native Object newInstanceImpl(Class var0) throws IllegalAccessException, InstantiationException;

    static int fastIdentityHashCode(Object anObject) {
        JITHelpers h = jitHelpers;
        if (h == null) {
            return J9VMInternals.identityHashCode(anObject);
        }
        Class<? extends Object> aClazz = anObject.getClass();
        if (h.is32Bit()) {
            int ptr = h.getIntFromObject(anObject, 0L);
            if ((ptr & VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0 && !aClazz.isArray()) {
                int j9clazz = h.getJ9ClassFromClass32(aClazz);
                if (!VM.PACKED_SUPPORT_ENABLED || !h.isPackedObject32(j9clazz)) {
                    return h.getIntFromObject(anObject, h.getBackfillOffsetFromJ9Class32(j9clazz));
                }
            }
        } else {
            long ptr;
            long l = ptr = VM.FJ9OBJECT_SIZE == 4 ? (long)h.getIntFromObject(anObject, 0L) : h.getLongFromObject(anObject, 0L);
            if ((ptr & (long)VM.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS) != 0L && !aClazz.isArray()) {
                long j9clazz = h.getJ9ClassFromClass64(aClazz);
                if (!VM.PACKED_SUPPORT_ENABLED || !h.isPackedObject64(j9clazz)) {
                    return h.getIntFromObject(anObject, h.getBackfillOffsetFromJ9Class64(j9clazz));
                }
            }
        }
        return J9VMInternals.identityHashCode(anObject);
    }

    static native int identityHashCode(Object var0);

    static native Object primitiveClone(Object var0) throws CloneNotSupportedException;

    public static native void dumpString(String var0);

    private static String[] getClassInfoStrings(final Class<?> clazz, String classPath) {
        String classLoader;
        if (classPath != null) {
            classLoader = Msg.getString("K0630");
        } else {
            classLoader = clazz.getClassLoader().toString();
            classPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String path = null;
                    try {
                        path = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                    }
                    catch (Exception e) {
                        path = Msg.getString("K0629");
                    }
                    return path;
                }
            });
        }
        String[] strings = new String[]{classPath, classLoader};
        return strings;
    }

    public static String formatNoSuchMethod(String methodSig, Class<?> clazz1, String classPath1, Class<?> clazz2, String classPath2) {
        try {
            String[] callingClassInfo = J9VMInternals.getClassInfoStrings(clazz1, classPath1);
            String[] calledClassInfo = J9VMInternals.getClassInfoStrings(clazz2, classPath2);
            Object[] args = new String[]{methodSig, callingClassInfo[0], callingClassInfo[1], clazz2.toString(), calledClassInfo[0], calledClassInfo[1]};
            return Msg.getString("K0628", args);
        }
        catch (Exception e) {
            return methodSig;
        }
    }

    static final class ClassInitializationLock {
        Class theClass;

        ClassInitializationLock() {
        }
    }
}

