/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;

public final class StringBuilder
implements Serializable,
CharSequence,
Appendable {
    private static final long serialVersionUID = 4383685877147921099L;
    private static final int INITIAL_SIZE = 16;
    private static boolean TOSTRING_COPY_BUFFER_ENABLED = false;
    private transient int count;
    private transient char[] value;
    private transient boolean shared;

    public StringBuilder() {
        this(16);
    }

    public StringBuilder(int capacity) {
        this.count = 0;
        this.value = new char[capacity];
    }

    public StringBuilder(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public StringBuilder append(char[] chars) {
        int newSize = this.count + chars.length;
        if (newSize > this.value.length) {
            this.ensureCapacityImpl(newSize);
        }
        System.arraycopy((Object)chars, 0, (Object)this.value, this.count, chars.length);
        this.count = newSize;
        return this;
    }

    public StringBuilder append(char[] chars, int start, int length) {
        if (start >= 0 && 0 <= length && length <= chars.length - start) {
            int newSize = this.count + length;
            if (newSize > this.value.length) {
                this.ensureCapacityImpl(newSize);
            }
            System.arraycopy((Object)chars, start, (Object)this.value, this.count, length);
            this.count = newSize;
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public StringBuilder append(char ch) {
        if (this.count >= this.value.length) {
            this.ensureCapacityImpl(this.count + 1);
        }
        this.value[this.count] = ch;
        ++this.count;
        return this;
    }

    public StringBuilder append(double value) {
        return this.append(String.valueOf(value));
    }

    public StringBuilder append(float value) {
        return this.append(String.valueOf(value));
    }

    public StringBuilder append(int value) {
        if (value == Integer.MIN_VALUE) {
            return this.append("-2147483648");
        }
        int appendSize = value < 0 ? Integer.stringSize(-value) + 1 : Integer.stringSize(value);
        int newCount = this.count + appendSize;
        if (newCount > this.value.length) {
            this.ensureCapacityImpl(newCount);
        }
        Integer.getChars((int)value, (int)newCount, (char[])this.value);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(long value) {
        if (value == Long.MIN_VALUE) {
            return this.append("-9223372036854775808");
        }
        int appendSize = value < 0L ? Long.stringSize(-value) + 1 : Long.stringSize(value);
        int newCount = this.count + appendSize;
        if (newCount > this.value.length) {
            this.ensureCapacityImpl(newCount);
        }
        Long.getChars((long)value, (int)newCount, (char[])this.value);
        this.count = newCount;
        return this;
    }

    public StringBuilder append(Object value) {
        return this.append(String.valueOf(value));
    }

    public StringBuilder append(String string) {
        int adding;
        int newSize;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((newSize = this.count + (adding = string.length())) > this.value.length) {
            this.ensureCapacityImpl(newSize);
        }
        string.getChars(0, adding, this.value, this.count);
        this.count = newSize;
        return this;
    }

    public StringBuilder append(boolean value) {
        return this.append(String.valueOf(value));
    }

    public int capacity() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        try {
            if (index < this.count) {
                return this.value[index];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuilder delete(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int length = this.count - end;
                try {
                    if (!this.shared) {
                        if (length > 0) {
                            System.arraycopy((Object)this.value, end, (Object)this.value, start, length);
                        }
                    } else {
                        char[] newData = new char[this.value.length];
                        if (start > 0) {
                            System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        }
                        if (length > 0) {
                            System.arraycopy((Object)this.value, end, (Object)newData, start, length);
                        }
                        this.value = newData;
                        this.shared = false;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new StringIndexOutOfBoundsException();
                }
                this.count -= end - start;
                return this;
            }
            if (start == end) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder deleteCharAt(int location) {
        if (0 <= location && location < this.count) {
            int length = this.count - location - 1;
            try {
                if (!this.shared) {
                    if (length > 0) {
                        System.arraycopy((Object)this.value, location + 1, (Object)this.value, location, length);
                    }
                } else {
                    char[] newData = new char[this.value.length];
                    if (location > 0) {
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, location);
                    }
                    if (length > 0) {
                        System.arraycopy((Object)this.value, location + 1, (Object)newData, location, length);
                    }
                    this.value = newData;
                    this.shared = false;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new StringIndexOutOfBoundsException(location);
            }
            --this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(location);
    }

    public void ensureCapacity(int min) {
        if (min > this.value.length) {
            this.ensureCapacityImpl(min);
        }
    }

    private void ensureCapacityImpl(int min) {
        int twice = (this.value.length << 1) + 2;
        char[] newData = new char[min > twice ? min : twice];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, this.count);
        this.value = newData;
        this.shared = false;
    }

    public void getChars(int start, int end, char[] buffer, int index) {
        try {
            if (start <= this.count && end <= this.count) {
                System.arraycopy((Object)this.value, start, (Object)buffer, index, end - start);
                return;
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder insert(int index, char[] chars) {
        if (0 <= index && index <= this.count) {
            this.move(chars.length, index);
            System.arraycopy((Object)chars, 0, (Object)this.value, index, chars.length);
            this.count += chars.length;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuilder insert(int index, char[] chars, int start, int length) {
        if (0 <= index && index <= this.count) {
            if (start >= 0 && 0 <= length && length <= chars.length - start) {
                this.move(length, index);
                System.arraycopy((Object)chars, start, (Object)this.value, index, length);
                this.count += length;
                return this;
            }
            throw new StringIndexOutOfBoundsException();
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuilder insert(int index, char ch) {
        if (0 <= index && index <= this.count) {
            this.move(1, index);
            this.value[index] = ch;
            ++this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuilder insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuilder insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuilder insert(int index, int value) {
        return this.insert(index, Integer.toString(value));
    }

    public StringBuilder insert(int index, long value) {
        return this.insert(index, Long.toString(value));
    }

    public StringBuilder insert(int index, Object value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuilder insert(int index, String string) {
        if (0 <= index && index <= this.count) {
            if (string == null) {
                string = String.valueOf(string);
            }
            int min = string.length();
            this.move(min, index);
            string.getChars(0, min, this.value, index);
            this.count += min;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuilder insert(int index, boolean value) {
        return this.insert(index, String.valueOf(value));
    }

    @Override
    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        int newSize;
        if (this.value.length - this.count >= size) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, index, (Object)this.value, index + size, this.count - index);
                return;
            }
            newSize = this.value.length;
        } else {
            int a = this.count + size;
            int b = (this.value.length << 1) + 2;
            newSize = a > b ? a : b;
        }
        char[] newData = new char[newSize];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, index);
        System.arraycopy((Object)this.value, index, (Object)newData, index + size, this.count - index);
        this.value = newData;
        this.shared = false;
    }

    public StringBuilder replace(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, end, (Object)this.value, start + stringLength, this.count - end);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        System.arraycopy((Object)this.value, end, (Object)newData, start + stringLength, this.count - end);
                        this.value = newData;
                        this.shared = false;
                    }
                } else if (diff < 0) {
                    this.move(-diff, end);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                string.getChars(0, stringLength, this.value, start);
                this.count -= diff;
                return this;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException();
                }
                return this.insert(start, string);
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder reverse() {
        if (this.count < 2) {
            return this;
        }
        if (!this.shared) {
            int end = this.count - 1;
            char frontHigh = this.value[0];
            char endLow = this.value[end];
            boolean allowFrontSur = true;
            boolean allowEndSur = true;
            int i = 0;
            int mid = this.count / 2;
            while (i < mid) {
                char frontLow = this.value[i + 1];
                char endHigh = this.value[end - 1];
                boolean surAtFront = false;
                boolean surAtEnd = false;
                if (allowFrontSur && frontLow >= '\udc00' && frontLow <= '\udfff' && frontHigh >= '\ud800' && frontHigh <= '\udbff') {
                    surAtFront = true;
                    if (this.count < 3) {
                        return this;
                    }
                }
                if (allowEndSur && endHigh >= '\ud800' && endHigh <= '\udbff' && endLow >= '\udc00' && endLow <= '\udfff') {
                    surAtEnd = true;
                }
                allowFrontSur = true;
                allowEndSur = true;
                if (surAtFront == surAtEnd) {
                    if (surAtFront) {
                        this.value[end] = frontLow;
                        this.value[end - 1] = frontHigh;
                        this.value[i] = endHigh;
                        this.value[i + 1] = endLow;
                        frontHigh = this.value[i + 2];
                        endLow = this.value[end - 2];
                        ++i;
                        --end;
                    } else {
                        this.value[end] = frontHigh;
                        this.value[i] = endLow;
                        frontHigh = frontLow;
                        endLow = endHigh;
                    }
                } else if (surAtFront) {
                    this.value[end] = frontLow;
                    this.value[i] = endLow;
                    endLow = endHigh;
                    allowFrontSur = false;
                } else {
                    this.value[end] = frontHigh;
                    this.value[i] = endHigh;
                    frontHigh = frontLow;
                    allowEndSur = false;
                }
                ++i;
                --end;
            }
            if (!((this.count & 1) != 1 || allowFrontSur && allowEndSur)) {
                this.value[end] = allowFrontSur ? endLow : frontHigh;
            }
        } else {
            char[] newData = new char[this.value.length];
            int end = this.count;
            for (int i = 0; i < this.count; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    newData[--end] = low;
                    ++i;
                }
                newData[--end] = high;
            }
            this.value = newData;
            this.shared = false;
        }
        return this;
    }

    public void setCharAt(int index, char ch) {
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        if (0 > index || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public void setLength(int length) {
        if (length > this.value.length) {
            this.ensureCapacityImpl(length);
        } else if (length > this.count) {
            if (length > this.count) {
                try {
                    Arrays.fill(this.value, this.count, length, '\u0000');
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IndexOutOfBoundsException();
                }
            }
        } else if (this.shared) {
            if (length < 0) {
                throw new IndexOutOfBoundsException();
            }
            char[] newData = new char[this.value.length];
            if (length > 0) {
                System.arraycopy((Object)this.value, 0, (Object)newData, 0, length);
            }
            this.value = newData;
            this.shared = false;
        } else if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.count = length;
    }

    public String substring(int start) {
        if (0 <= start && start <= this.count) {
            return new String(this.value, start, this.count - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (0 <= start && start <= end && end <= this.count) {
            return new String(this.value, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    static void initFromSystemProperties(Properties props) {
        String prop = props.getProperty("java.lang.string.create.unique");
        TOSTRING_COPY_BUFFER_ENABLED = "true".equals(prop) || "StringBuilder".equals(prop);
    }

    @Override
    public String toString() {
        if (!TOSTRING_COPY_BUFFER_ENABLED) {
            int wasted = this.value.length - this.count;
            if (wasted >= 768 || wasted >= 16 && wasted >= this.value.length >> 1) {
                return new String(this.value, 0, this.count);
            }
            this.shared = true;
            return new String(0, this.count, this.value);
        }
        int roundedCount = this.count + 3 & 0xFFFFFFFC;
        if (roundedCount < this.value.length) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(0, this.count, this.value);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.count);
        if (this.value.length - this.count >= 128) {
            char[] data = new char[this.count];
            System.arraycopy((Object)this.value, 0, (Object)data, 0, this.count);
            stream.writeObject(data);
        } else {
            stream.writeObject(this.value);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int streamCount = stream.readInt();
        char[] streamValue = (char[])stream.readObject();
        if (streamCount > streamValue.length) {
            throw new InvalidObjectException(Msg.getString("K0199"));
        }
        this.value = streamValue;
        this.count = streamCount;
        this.shared = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder append(StringBuffer buffer) {
        if (buffer == null) {
            return this.append((String)null);
        }
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            return this.append(buffer.getValue(), 0, buffer.length());
        }
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i;
                boolean found = false;
                for (i = start; i < this.count; ++i) {
                    if (this.value[i] != firstChar) continue;
                    found = true;
                    break;
                }
                if (!found || subCount + i > this.count) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count || start == 0 ? start : this.count;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i >= 0; --i) {
                        if (this.value[i] != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    public StringBuilder(CharSequence sequence) {
        int size = sequence.length();
        if (size < 0) {
            size = 0;
        }
        this.value = new char[size + 16];
        if (sequence instanceof String) {
            this.append((String)sequence);
            return;
        }
        if (sequence instanceof StringBuffer) {
            this.append((StringBuffer)sequence);
            return;
        }
        this.count = size;
        for (int i = 0; i < size; ++i) {
            this.value[i] = sequence.charAt(i);
        }
    }

    @Override
    public StringBuilder append(CharSequence sequence) {
        if (sequence == null) {
            return this.append(String.valueOf(sequence));
        }
        if (sequence instanceof String) {
            return this.append((String)sequence);
        }
        if (sequence instanceof StringBuffer) {
            return this.append((StringBuffer)sequence);
        }
        if (sequence instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)sequence;
            return this.append(builder.value, 0, builder.count);
        }
        int newSize = this.count + sequence.length();
        if (newSize > this.count) {
            if (newSize > this.value.length) {
                this.ensureCapacityImpl(newSize);
            }
            for (int i = 0; i < sequence.length(); ++i) {
                this.value[this.count + i] = sequence.charAt(i);
            }
            this.count = newSize;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder append(CharSequence sequence, int start, int end) {
        if (sequence == null) {
            return this.append(String.valueOf(sequence), start, end);
        }
        if (sequence instanceof String) {
            return this.append(((String)sequence).substring(start, end));
        }
        if (start >= 0 && end >= 0 && start <= end && end <= sequence.length()) {
            if (sequence instanceof StringBuffer) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    return this.append(((StringBuffer)sequence).getValue(), start, end - start);
                }
            }
            if (sequence instanceof StringBuilder) {
                return this.append(((StringBuilder)sequence).value, start, end - start);
            }
            int len = end - start;
            if (len > 0) {
                int newSize = this.count + len;
                if (newSize > this.value.length) {
                    this.ensureCapacityImpl(newSize);
                }
                for (int i = 0; i < len; ++i) {
                    this.value[this.count + i] = sequence.charAt(start + i);
                }
                this.count = newSize;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder insert(int index, CharSequence sequence) {
        if (index >= 0 && index <= this.count) {
            if (sequence == null) {
                return this.insert(index, String.valueOf(sequence));
            }
            if (sequence instanceof String) {
                return this.insert(index, (String)sequence);
            }
            if (sequence instanceof StringBuffer) {
                CharSequence charSequence = sequence;
                synchronized (charSequence) {
                    return this.insert(index, ((StringBuffer)sequence).getValue(), 0, sequence.length());
                }
            }
            if (sequence instanceof StringBuilder) {
                StringBuilder builder = (StringBuilder)sequence;
                return this.insert(index, builder.value, 0, builder.count);
            }
            int min = sequence.length();
            if (min > 0) {
                this.move(min, index);
                for (int i = 0; i < sequence.length(); ++i) {
                    this.value[index + i] = sequence.charAt(i);
                }
                this.count += min;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder insert(int index, CharSequence sequence, int start, int end) {
        if (index >= 0 && index <= this.count) {
            if (sequence == null) {
                return this.insert(index, String.valueOf(sequence), start, end);
            }
            if (sequence instanceof String) {
                return this.insert(index, ((String)sequence).substring(start, end));
            }
            if (start >= 0 && end >= 0 && start <= end && end <= sequence.length()) {
                if (sequence instanceof StringBuffer) {
                    CharSequence charSequence = sequence;
                    synchronized (charSequence) {
                        return this.insert(index, ((StringBuffer)sequence).getValue(), start, end - start);
                    }
                }
                if (sequence instanceof StringBuilder) {
                    return this.insert(index, ((StringBuilder)sequence).value, start, end - start);
                }
                int min = end - start;
                if (min > 0) {
                    this.move(min, index);
                    for (int i = 0; i < min; ++i) {
                        this.value[index + i] = sequence.charAt(start + i);
                    }
                    this.count += min;
                }
                return this;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void trimToSize() {
        if (!this.shared && this.value.length != this.count) {
            char[] newValue = new char[this.count];
            System.arraycopy((Object)this.value, 0, (Object)newValue, 0, this.count);
            this.value = newValue;
        }
    }

    public int codePointAt(int index) {
        if (index >= 0 && index < this.count) {
            char low;
            char high = this.value[index];
            if (index + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[index + 1]) >= '\udc00' && low <= '\udfff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return high;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointBefore(int index) {
        if (index > 0 && index <= this.count) {
            char high;
            char low = this.value[index - 1];
            if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[index - 2]) >= '\ud800' && high <= '\udbff') {
                return 65536 + (high - 55296 << 10) + (low - 56320);
            }
            return low;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public int codePointCount(int start, int end) {
        if (start >= 0 && start <= end && end <= this.count) {
            int count = 0;
            for (int i = start; i < end; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < end && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    ++i;
                }
                ++count;
            }
            return count;
        }
        throw new IndexOutOfBoundsException();
    }

    public int offsetByCodePoints(int start, int codePointCount) {
        if (start >= 0 && start <= this.count) {
            int index = start;
            if (codePointCount == 0) {
                return start;
            }
            if (codePointCount > 0) {
                for (int i = 0; i < codePointCount; ++i) {
                    char low;
                    if (index == this.count) {
                        throw new IndexOutOfBoundsException();
                    }
                    char high = this.value[index];
                    if (index + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[index + 1]) >= '\udc00' && low <= '\udfff') {
                        ++index;
                    }
                    ++index;
                }
            } else {
                for (int i = codePointCount; i < 0; ++i) {
                    char high;
                    if (index < 1) {
                        throw new IndexOutOfBoundsException();
                    }
                    char low = this.value[index - 1];
                    if (index > 1 && low >= '\udc00' && low <= '\udfff' && (high = this.value[index - 2]) >= '\ud800' && high <= '\udbff') {
                        --index;
                    }
                    --index;
                }
            }
            return index;
        }
        throw new IndexOutOfBoundsException();
    }

    public StringBuilder appendCodePoint(int codePoint) {
        if (codePoint >= 0) {
            if (codePoint < 65536) {
                return this.append((char)codePoint);
            }
            if (codePoint < 0x110000) {
                if (this.count + 2 > this.value.length) {
                    this.ensureCapacityImpl(this.count + 2);
                }
                this.value[this.count] = (char)(55296 + ((codePoint -= 65536) >> 10));
                this.value[this.count + 1] = (char)(56320 + (codePoint & 0x3FF));
                this.count += 2;
                return this;
            }
        }
        throw new IllegalArgumentException();
    }

    char[] getValue() {
        return this.value;
    }
}

