/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jit.JITHelpers;
import com.ibm.jvm.io.ConsoleInputStream;
import com.ibm.jvm.io.ConsolePrintStream;
import com.ibm.jvm.packed.reflect.PackedUnsafe;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public final class System {
    public static final InputStream in = null;
    public static final PrintStream out = null;
    public static final PrintStream err = null;
    private static final Runtime RUNTIME = Runtime.getRuntime();
    private static Properties systemProperties;
    private static SecurityManager security;
    private static volatile Console console;
    private static volatile boolean consoleInitialized;
    private static String lineSeparator;
    private static JavaLangAccess accessor;
    private static boolean propertiesInitialized;
    private static String platformEncoding;
    private static String fileEncoding;
    private static String osEncoding;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    private static void initEncodings() {
        platformEncoding = System.getEncoding(1);
        String definedFileEncoding = System.getEncoding(2);
        String definedOSEncoding = System.getEncoding(3);
        if (definedFileEncoding != null) {
            fileEncoding = definedFileEncoding;
            if (definedOSEncoding == null) {
                osEncoding = platformEncoding;
            }
        } else {
            fileEncoding = platformEncoding;
        }
        if (osEncoding == null) {
            osEncoding = definedOSEncoding;
        }
    }

    static void afterClinitInitialization() {
        System.ensureProperties();
        if (com.ibm.oti.vm.VM.PACKED_SUPPORT_ENABLED) {
            Reflection.registerMethodsToFilter(PackedUnsafe.class, (String[])new String[]{"getUnsafe"});
        }
        if (null == com.ibm.oti.vm.VM.getVMLangAccess()) {
            com.ibm.oti.vm.VM.setVMLangAccess(new VMAccess());
        }
        try {
            VM.saveAndRemoveProperties((Properties)systemProperties);
        }
        catch (NoSuchMethodError e) {
            // empty catch block
        }
        try {
            Field f = J9VMInternals.class.getDeclaredField("jitHelpers");
            Unsafe unsafe = Unsafe.getUnsafe();
            unsafe.putObject(unsafe.staticFieldBase(f), unsafe.staticFieldOffset(f), JITHelpers.getHelpers());
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        String enableCopyProperty = System.getProperty("java.lang.string.constructor.copy.substrings");
        String.enableCopy = enableCopyProperty == null || !enableCopyProperty.equalsIgnoreCase("false");
        String disableCopyInSubstringProperty = System.getProperty("java.lang.string.substring.nocopy");
        String.disableCopyInSubstring = disableCopyInSubstringProperty != null && disableCopyInSubstringProperty.equalsIgnoreCase("true");
        StringCoding.encode((char[])new char[1], (int)0, (int)1);
        System.setErr(ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), (boolean)true));
        System.setOut(ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), (boolean)true));
    }

    static void runInitializationHook(String hookName) {
        try {
            Class<?> systemInitialization = Class.forName("com.ibm.misc.SystemIntialization");
            Method hook = systemInitialization.getMethod(hookName, null);
            hook.invoke(null, null);
            return;
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (Exception e) {
            throw new InternalError(e.toString());
        }
    }

    static void completeInitialization() {
        System.runInitializationHook("firstChanceHook");
        System.setIn(ConsoleInputStream.localize((InputStream)new BufferedInputStream(new FileInputStream(FileDescriptor.in))));
        Terminator.setup();
        accessor = new Access();
        SharedSecrets.setJavaLangAccess((JavaLangAccess)accessor);
        System.runInitializationHook("lastChanceHook");
    }

    public static void setIn(InputStream newIn) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("in", newIn);
    }

    public static void setOut(PrintStream newOut) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("out", newOut);
    }

    public static void setErr(PrintStream newErr) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("err", newErr);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] A1, int offset1, Object[] A2, int offset2, int length) {
        if (A1 == null || A2 == null) {
            throw new NullPointerException();
        }
        if (offset1 >= 0 && offset2 >= 0 && length >= 0 && length <= A1.length - offset1 && length <= A2.length - offset2) {
            if (A1 != A2 || offset1 > offset2 || offset1 + length <= offset2) {
                for (int i = 0; i < length; ++i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            } else {
                for (int i = length - 1; i >= 0; --i) {
                    A2[offset2 + i] = A1[offset1 + i];
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties() {
        String info;
        String key;
        systemProperties = new Properties();
        if (osEncoding != null) {
            systemProperties.put("os.encoding", osEncoding);
        }
        systemProperties.put("ibm.system.encoding", platformEncoding);
        systemProperties.put("sun.jnu.encoding", platformEncoding);
        systemProperties.put("file.encoding", fileEncoding);
        systemProperties.put("file.encoding.pkg", "sun.io");
        systemProperties.put("java.version", "1.8.0");
        systemProperties.put("java.specification.version", "1.8");
        systemProperties.put("java.specification.vendor", "Oracle Corporation");
        systemProperties.put("java.specification.name", "Java Platform API Specification");
        systemProperties.put("com.ibm.oti.configuration", "scar");
        String[] list = System.getPropertyList();
        for (int i = 0; i < list.length && (key = list[i]) != null; i += 2) {
            systemProperties.put(key, list[i + 1]);
        }
        propertiesInitialized = true;
        StringBuffer.initFromSystemProperties(systemProperties);
        StringBuilder.initFromSystemProperties(systemProperties);
        systemProperties.put("com.ibm.oti.jcl.build", "20170722_357405");
        String thisVersion = "\nJ9CL - " + systemProperties.get("com.ibm.oti.jcl.build");
        String fullVersion = systemProperties.getProperty("java.fullversion");
        if (fullVersion != null) {
            systemProperties.put("java.fullversion", fullVersion + thisVersion);
        }
        if ((info = systemProperties.getProperty("java.vm.info")) != null) {
            systemProperties.put("java.vm.info", info + thisVersion);
        }
        lineSeparator = System.getProperty("line.separator", null);
    }

    public static void exit(int code) {
        RUNTIME.exit(code);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getenv(String var) {
        if (var == null) {
            throw new NullPointerException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv." + var));
        }
        return ProcessEnvironment.getenv(var);
    }

    public static Properties getProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init");
        }
        return systemProperties;
    }

    public static String getProperty(String prop) {
        return System.getProperty(prop, null);
    }

    public static String getProperty(String prop, String defaultValue) {
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertyAccess(prop);
        }
        if (!(propertiesInitialized || prop.equals("com.ibm.IgnoreMalformedInput") || prop.equals("file.encoding.pkg") || prop.equals("sun.nio.cs.map"))) {
            if (prop.equals("os.encoding")) {
                return osEncoding;
            }
            if (prop.equals("ibm.system.encoding")) {
                return platformEncoding;
            }
            if (prop.equals("file.encoding")) {
                return fileEncoding;
            }
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        return systemProperties.getProperty(prop, defaultValue);
    }

    public static String setProperty(String prop, String value) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.setProperty(prop, value);
    }

    private static native String[] getPropertyList();

    private static native String getEncoding(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static int identityHashCode(Object anObject) {
        if (anObject == null) {
            return 0;
        }
        return J9VMInternals.fastIdentityHashCode(anObject);
    }

    @CallerSensitive
    public static void load(String pathName) {
        SecurityManager smngr = System.getSecurityManager();
        if (smngr != null) {
            smngr.checkLink(pathName);
        }
        ClassLoader.loadLibraryWithPath(pathName, ClassLoader.callerClassLoader(), null);
    }

    @CallerSensitive
    public static void loadLibrary(String libName) {
        ClassLoader.loadLibraryWithClassLoader(libName, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean flag) {
        Runtime.runFinalizersOnExit((boolean)flag);
    }

    public static void setProperties(Properties p) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (p == null) {
            System.ensureProperties();
        } else {
            systemProperties = p;
        }
    }

    public static void setSecurityManager(final SecurityManager s) {
        final SecurityManager currentSecurity = security;
        if (s != null) {
            try {
                s.checkPackageAccess("java.lang");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ProtectionDomain newDomain;
                        ProtectionDomain oldDomain = currentSecurity == null ? System.class.getPDImpl() : currentSecurity.getClass().getPDImpl();
                        if (oldDomain != (newDomain = s.getClass().getPDImpl())) {
                            Msg.getString("K002c");
                            newDomain.implies(new AllPermission());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (currentSecurity != null) {
            currentSecurity.checkPermission(RuntimePermission.permissionToSetSecurityManager);
        }
        security = s;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);

    @CallerSensitive
    static Class getCallerClass() {
        return Class.getStackClass(2);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static native long nanoTime();

    public static String clearProperty(String prop) {
        if (!propertiesInitialized) {
            throw new Error("bootstrap error, system property access before init: " + prop);
        }
        if (prop.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(prop, "write"));
        }
        return (String)systemProperties.remove(prop);
    }

    public static Map<String, String> getenv() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Console console() {
        if (consoleInitialized) {
            return console;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (consoleInitialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return console;
            }
            console = SharedSecrets.getJavaIOAccess().console();
            consoleInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return console;
        }
    }

    private static void longMultiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int L2;
        int L1;
        int newDestPos;
        int newSrcPos;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
        int destLeafPos = newDestPos % numOfElemsPerLeaf;
        if (srcLeafPos < destLeafPos) {
            if (isFwd) {
                L1 = numOfElemsPerLeaf - destLeafPos;
                L2 = numOfElemsPerLeaf - (srcLeafPos + L1);
            } else {
                L1 = srcLeafPos + 1;
                L2 = destLeafPos - srcLeafPos;
            }
        } else if (isFwd) {
            L1 = numOfElemsPerLeaf - srcLeafPos;
            L2 = numOfElemsPerLeaf - (destLeafPos + L1);
        } else {
            L1 = destLeafPos + 1;
            L2 = srcLeafPos - destLeafPos;
        }
        int L3 = numOfElemsPerLeaf - L2;
        int offset = isFwd ? 0 : L1 - 1;
        System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L1);
        newSrcPos = isFwd ? newSrcPos + L1 : newSrcPos - L1;
        newDestPos = isFwd ? newDestPos + L1 : newDestPos - L1;
        length -= L1;
        while (length >= numOfElemsPerLeaf) {
            offset = isFwd ? 0 : L2 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L2);
            newSrcPos = isFwd ? newSrcPos + L2 : newSrcPos - L2;
            newDestPos = isFwd ? newDestPos + L2 : newDestPos - L2;
            offset = isFwd ? 0 : L3 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L3);
            newSrcPos = isFwd ? newSrcPos + L3 : newSrcPos - L3;
            newDestPos = isFwd ? newDestPos + L3 : newDestPos - L3;
            length -= numOfElemsPerLeaf;
        }
        if (length > L2) {
            offset = isFwd ? 0 : L2 - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, L2);
            newSrcPos = isFwd ? newSrcPos + L2 : newSrcPos - L2;
            newDestPos = isFwd ? newDestPos + L2 : newDestPos - L2;
            length -= L2;
        }
        if (length > 0) {
            offset = isFwd ? 0 : length - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, length);
        }
    }

    private static void simpleMultiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int iterLength;
        int newDestPos;
        int newSrcPos;
        int count = 0;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        for (count = 0; count < length; count += iterLength) {
            int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
            int destLeafPos = newDestPos % numOfElemsPerLeaf;
            iterLength = isFwd && srcLeafPos >= destLeafPos || !isFwd && srcLeafPos < destLeafPos ? (isFwd ? numOfElemsPerLeaf - srcLeafPos : srcLeafPos + 1) : (isFwd ? numOfElemsPerLeaf - destLeafPos : destLeafPos + 1);
            if (length - count < iterLength) {
                iterLength = length - count;
            }
            int offset = isFwd ? 0 : iterLength - 1;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength);
            if (isFwd) {
                newSrcPos += iterLength;
                newDestPos += iterLength;
                continue;
            }
            newSrcPos -= iterLength;
            newDestPos -= iterLength;
        }
    }

    private static void multiLeafArrayCopy(Object src, int srcPos, Object dest, int destPos, int length, int elementSize, int leafSize) {
        int newDestPos;
        int newSrcPos;
        int count = 0;
        boolean isFwd = src != dest || srcPos > destPos || srcPos + length <= destPos;
        int numOfElemsPerLeaf = leafSize / elementSize;
        if (isFwd) {
            newSrcPos = srcPos;
            newDestPos = destPos;
        } else {
            newSrcPos = srcPos + length - 1;
            newDestPos = destPos + length - 1;
        }
        int iterLength1 = 0;
        int iterLength2 = 0;
        while (count < length) {
            int secondPos;
            int firstPos;
            int srcLeafPos = newSrcPos % numOfElemsPerLeaf;
            int destLeafPos = newDestPos % numOfElemsPerLeaf;
            if (isFwd && srcLeafPos >= destLeafPos || !isFwd && srcLeafPos < destLeafPos) {
                firstPos = srcLeafPos;
                secondPos = newDestPos;
            } else {
                firstPos = destLeafPos;
                secondPos = newSrcPos;
            }
            int offset = 0;
            iterLength1 = isFwd ? numOfElemsPerLeaf - firstPos : firstPos + 1;
            if (length - count < iterLength1) {
                iterLength1 = length - count;
            }
            if (isFwd) {
                iterLength2 = numOfElemsPerLeaf - (secondPos + iterLength1) % numOfElemsPerLeaf;
            } else {
                iterLength2 = (secondPos - iterLength1) % numOfElemsPerLeaf + 1;
                offset = iterLength1 - 1;
            }
            if (length - count - iterLength1 < iterLength2) {
                iterLength2 = length - count - iterLength1;
            }
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength1);
            offset = 0;
            if (isFwd) {
                newSrcPos += iterLength1;
                newDestPos += iterLength1;
            } else {
                newSrcPos -= iterLength1;
                newDestPos -= iterLength1;
                offset = iterLength2 - 1;
            }
            if (iterLength2 <= 0) break;
            System.arraycopy(src, newSrcPos - offset, dest, newDestPos - offset, iterLength2);
            if (isFwd) {
                newSrcPos += iterLength2;
                newDestPos += iterLength2;
            } else {
                newSrcPos -= iterLength2;
                newDestPos -= iterLength2;
            }
            count += iterLength1 + iterLength2;
        }
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    static {
        propertiesInitialized = false;
        System.initEncodings();
    }
}

