/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.Interruptible;
import sun.reflect.CallerSensitive;

public class Thread
implements Runnable {
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static int createCount = -1;
    private static Object uniqueIdLock = new UniqueIdLock();
    private static long uniqueIdCount = 1L;
    private static final int NANOS_MAX = 999999;
    private static final int INITIAL_LOCAL_STORAGE_CAPACITY = 5;
    static final long NO_REF = 0L;
    private long threadRef;
    long stackSize = 0L;
    private volatile boolean started;
    private String name;
    private int priority = 5;
    private boolean isDaemon;
    ThreadGroup group;
    private Runnable runnable;
    private boolean stopCalled = false;
    private ClassLoader contextClassLoader;
    ThreadLocal.ThreadLocalMap threadLocals;
    private AccessControlContext inheritedAccessControlContext;
    private Object lock = new ThreadLock();
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    private volatile Interruptible blockOn;
    int threadLocalsIndex;
    int inheritableThreadLocalsIndex;
    private volatile UncaughtExceptionHandler exceptionHandler;
    private long uniqueId;
    volatile Object parkBlocker;
    private static ThreadGroup systemThreadGroup;
    private static ThreadGroup mainGroup;
    private static volatile UncaughtExceptionHandler defaultExceptionHandler;
    long threadLocalRandomSeed;
    int threadLocalRandomProbe;
    int threadLocalRandomSecondarySeed;

    public Thread() {
        this(null, null, Thread.newName(), null);
    }

    private Thread(String vmName, Object vmThreadGroup, int vmPriority, boolean vmIsDaemon) {
        String threadName = vmName == null ? Thread.newName() : vmName;
        this.setNameImpl(this.threadRef, threadName);
        this.name = threadName;
        this.isDaemon = vmIsDaemon;
        this.priority = vmPriority;
        ThreadGroup threadGroup = null;
        boolean booting = false;
        if (mainGroup == null) {
            booting = true;
            mainGroup = new ThreadGroup(systemThreadGroup);
        }
        threadGroup = vmThreadGroup == null ? mainGroup : (ThreadGroup)vmThreadGroup;
        this.initialize(booting, threadGroup, null, null);
        this.group.add(this);
        if (booting) {
            System.completeInitialization();
        }
    }

    void completeInitialization() {
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }

    public Thread(Runnable runnable) {
        this(null, runnable, Thread.newName(), null);
    }

    Thread(Runnable runnable, AccessControlContext acc) {
        this(null, runnable, Thread.newName(), acc);
    }

    public Thread(Runnable runnable, String threadName) {
        this(null, runnable, threadName, null);
    }

    public Thread(String threadName) {
        this(null, null, threadName, null);
    }

    public Thread(ThreadGroup group, Runnable runnable) {
        this(group, runnable, Thread.newName(), null);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName, long stack) {
        this(group, runnable, threadName, null);
        this.stackSize = stack;
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName) {
        this(group, runnable, threadName, null);
    }

    private Thread(ThreadGroup group, Runnable runnable, String threadName, AccessControlContext acc) {
        SecurityManager currentManager;
        if (threadName == null) {
            throw new NullPointerException();
        }
        this.name = threadName;
        this.runnable = runnable;
        Thread currentThread = Thread.currentThread();
        this.isDaemon = currentThread.isDaemon();
        if (group == null && (currentManager = System.getSecurityManager()) != null) {
            group = currentManager.getThreadGroup();
        }
        if (group == null) {
            group = currentThread.getThreadGroup();
        }
        this.initialize(false, group, currentThread, acc);
        this.setPriority(currentThread.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(boolean booting, ThreadGroup threadGroup, Thread parentThread, AccessControlContext acc) {
        Object object = uniqueIdLock;
        synchronized (object) {
            this.uniqueId = uniqueIdCount++;
        }
        this.group = threadGroup;
        if (booting) {
            System.afterClinitInitialization();
        }
        if (parentThread != null) {
            boolean override;
            if (parentThread.inheritableThreadLocals != null) {
                this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parentThread.inheritableThreadLocals);
            }
            SecurityManager sm = System.getSecurityManager();
            final Class<? extends Object> implClass = this.getClass();
            final Class<Thread> thisClass = Thread.class;
            if (sm != null && implClass != thisClass && (override = ((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Method method;
                    try {
                        method = implClass.getMethod("getContextClassLoader", new Class[0]);
                        if (method.getDeclaringClass() != thisClass) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    try {
                        method = implClass.getDeclaredMethod("setContextClassLoader", ClassLoader.class);
                        if (method.getDeclaringClass() != thisClass) {
                            return Boolean.TRUE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return Boolean.FALSE;
                }
            })).booleanValue())) {
                sm.checkPermission(new RuntimePermission("enableContextClassLoaderOverride"));
            }
            this.contextClassLoader = parentThread.getContextClassLoader();
        } else {
            if (booting) {
                try {
                    Class.forName("com.ibm.jit.JITHelpers");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                ClassLoader.initializeClassLoaders();
            }
            this.contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        threadGroup.checkAccess();
        threadGroup.checkNewThread(this);
        this.inheritedAccessControlContext = acc == null ? AccessController.getContext() : acc;
    }

    public Thread(ThreadGroup group, String threadName) {
        this(group, null, threadName, null);
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkAccess(this);
        }
    }

    @Deprecated
    public int countStackFrames() {
        return 0;
    }

    public static native Thread currentThread();

    @Deprecated
    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        return Thread.currentThread().getThreadGroup().enumerate(threads, true);
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        ClassLoader callerClassLoader;
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null && ClassLoader.needsClassLoaderPermissionCheck(callerClassLoader = ClassLoader.callerClassLoader(), this.contextClassLoader)) {
            currentManager.checkPermission(RuntimePermission.permissionToGetClassLoader);
        }
        return this.contextClassLoader;
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null && Thread.currentThread() != this) {
            currentManager.checkAccess(this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.interruptImpl();
            Interruptible localBlockOn = this.blockOn;
            if (localBlockOn != null) {
                localBlockOn.interrupt(this);
            }
        }
    }

    public static native boolean interrupted();

    private native void interruptImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAlive() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadRef != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDead() {
        Object object = this.lock;
        synchronized (object) {
            return this.started && this.threadRef == 0L;
        }
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.lock;
        synchronized (object) {
            return this.isInterruptedImpl();
        }
    }

    private native boolean isInterruptedImpl();

    public final synchronized void join() throws InterruptedException {
        if (this.started) {
            while (!this.isDead()) {
                this.wait(0L);
            }
        }
    }

    public final void join(long timeoutInMilliseconds) throws InterruptedException {
        this.join(timeoutInMilliseconds, 0);
    }

    public final synchronized void join(long timeoutInMilliseconds, int nanos) throws InterruptedException {
        if (timeoutInMilliseconds < 0L || nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException();
        }
        if (!this.started || this.isDead()) {
            return;
        }
        long totalWaited = 0L;
        long toWait = timeoutInMilliseconds;
        boolean timedOut = false;
        if (timeoutInMilliseconds == 0L & nanos > 0) {
            if (nanos < 500000) {
                timedOut = true;
            } else {
                toWait = 1L;
            }
        }
        while (!timedOut && !this.isDead()) {
            long start = System.currentTimeMillis();
            this.wait(toWait);
            long waited = System.currentTimeMillis() - start;
            toWait -= waited;
            timedOut = (totalWaited += waited) >= timeoutInMilliseconds;
        }
    }

    private static synchronized String newName() {
        if (createCount == -1) {
            ++createCount;
            return "main";
        }
        return "Thread-" + createCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void resume() {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            this.resumeImpl();
        }
    }

    private native void resumeImpl();

    @Override
    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        SecurityManager currentManager = System.getSecurityManager();
        if (currentManager != null) {
            currentManager.checkPermission(RuntimePermission.permissionToSetContextClassLoader);
        }
        this.contextClassLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDaemon(boolean isDaemon) {
        this.checkAccess();
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.isDaemon = isDaemon;
            } else if (this.isAlive()) {
                throw new IllegalThreadStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String threadName) {
        this.checkAccess();
        if (threadName == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.started && this.threadRef != 0L) {
                this.setNameImpl(this.threadRef, threadName);
            }
            this.name = threadName;
        }
    }

    private native void setNameImpl(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int priority) {
        this.checkAccess();
        if (1 <= priority && priority <= 10) {
            int finalPriority = priority;
            int threadGroupMaxPriority = this.getThreadGroup().getMaxPriority();
            if (threadGroupMaxPriority < priority) {
                finalPriority = threadGroupMaxPriority;
            }
            this.priority = finalPriority;
            Object object = this.lock;
            synchronized (object) {
                if (this.started && this.threadRef != 0L) {
                    this.setPriorityNoVMAccessImpl(this.threadRef, finalPriority);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    private native void setPriorityNoVMAccessImpl(long var1, int var3);

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    public static native void sleep(long var0, int var2) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        boolean success = false;
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.started) {
                    throw new IllegalThreadStateException(Msg.getString("K0341"));
                }
                this.group.add(this);
                this.startImpl();
                success = true;
            }
        }
        finally {
            if (!success && !this.started) {
                this.group.remove(this);
            }
        }
    }

    private native void startImpl();

    @Deprecated
    public final void stop() {
        if (!this.isDead()) {
            this.stopWithThrowable(new ThreadDeath());
        }
    }

    @Deprecated
    public final void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void stopWithThrowable(Throwable throwable) {
        SecurityManager currentManager;
        this.checkAccess();
        if (!(Thread.currentThread() == this && throwable instanceof ThreadDeath || (currentManager = System.getSecurityManager()) == null)) {
            currentManager.checkPermission(RuntimePermission.permissionToStopThread);
        }
        Object object = this.lock;
        synchronized (object) {
            if (throwable != null) {
                if (!this.started) {
                    this.stopCalled = true;
                } else {
                    this.stopImpl(throwable);
                }
            } else {
                throw new NullPointerException();
            }
        }
    }

    private native void stopImpl(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void suspend() {
        this.checkAccess();
        if (Thread.currentThread() == this) {
            this.suspendImpl();
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.suspendImpl();
            }
        }
    }

    private native void suspendImpl();

    public String toString() {
        ThreadGroup localGroup = this.getThreadGroup();
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + (null == localGroup ? "" : localGroup.getName()) + "]";
    }

    public static native void yield();

    public static native boolean holdsLock(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockedOn(Interruptible interruptible) {
        Object object = this.lock;
        synchronized (object) {
            this.blockOn = interruptible;
        }
    }

    private native Throwable getStackTraceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace() {
        Throwable t;
        SecurityManager security;
        if (Thread.currentThread() != this && (security = System.getSecurityManager()) != null) {
            security.checkPermission(new RuntimePermission("getStackTrace"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive()) {
                return new StackTraceElement[0];
            }
            t = this.getStackTraceImpl();
        }
        return J9VMInternals.getStackTrace(t, false);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getStackTrace"));
            security.checkPermission(RuntimePermission.permissionToModifyThreadGroup);
        }
        int count = systemThreadGroup.activeCount() + 20;
        Thread[] threads = new Thread[count];
        count = systemThreadGroup.enumerate(threads);
        HashMap<Thread, StackTraceElement[]> result = new HashMap<Thread, StackTraceElement[]>(count * 4 / 3);
        for (int i = 0; i < count; ++i) {
            result.put(threads[i], threads[i].getStackTrace());
        }
        return result;
    }

    public long getId() {
        return this.uniqueId;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.exceptionHandler == null) {
            return this.getThreadGroup();
        }
        return this.exceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultExceptionHandler;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultExceptionHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.threadRef == 0L) {
                if (this.isDead()) {
                    return State.TERMINATED;
                }
                return State.NEW;
            }
            return State.values()[this.getStateImpl(this.threadRef)];
        }
    }

    private native int getStateImpl(long var1);

    void uncaughtException(Throwable e) {
        UncaughtExceptionHandler handler = this.getUncaughtExceptionHandler();
        if (handler != null) {
            handler.uncaughtException(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        this.group = null;
        this.runnable = null;
        this.inheritedAccessControlContext = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        Object object = this.lock;
        synchronized (object) {
            this.threadRef = 0L;
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    private static final class ThreadLock {
        private ThreadLock() {
        }
    }

    private static final class UniqueIdLock {
        private UniqueIdLock() {
        }
    }
}

