/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Throwable
implements Serializable {
    private static final long serialVersionUID = -3042686055658047285L;
    private String detailMessage;
    private transient Object walkback;
    private Throwable cause = this;
    private StackTraceElement[] stackTrace;
    private static final Throwable[] ZeroElementArray = new Throwable[0];
    private static final StackTraceElement[] ZeroStackTraceElementArray = new StackTraceElement[0];
    private List<Throwable> suppressedExceptions = Collections.EMPTY_LIST;
    private transient boolean enableWritableStackTrace = true;

    public Throwable() {
        this.fillInStackTrace();
    }

    public Throwable(String detailMessage) {
        this();
        this.detailMessage = detailMessage;
    }

    public Throwable(String detailMessage, Throwable throwable) {
        this();
        this.detailMessage = detailMessage;
        this.cause = throwable;
    }

    public Throwable(Throwable throwable) {
        this();
        this.detailMessage = throwable == null ? null : throwable.toString();
        this.cause = throwable;
    }

    protected Throwable(String detailMessage, Throwable throwable, boolean enableSuppression, boolean enableWritableStackTrace) {
        this.detailMessage = detailMessage;
        this.cause = throwable;
        if (!enableSuppression) {
            this.suppressedExceptions = null;
        }
        if (!enableWritableStackTrace) {
            this.enableWritableStackTrace = false;
        } else {
            this.fillInStackTrace();
        }
    }

    public native Throwable fillInStackTrace();

    public String getMessage() {
        return this.detailMessage;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getInternalStackTrace().clone();
    }

    public void setStackTrace(StackTraceElement[] trace) {
        if (trace == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i] != null) continue;
            throw new NullPointerException();
        }
        if (!this.enableWritableStackTrace) {
            return;
        }
        this.stackTrace = (StackTraceElement[])trace.clone();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private static int countDuplicates(StackTraceElement[] currentStack, StackTraceElement[] parentStack) {
        StackTraceElement parentFrame;
        int duplicates = 0;
        int parentIndex = parentStack.length;
        int i = currentStack.length;
        while (--i >= 0 && --parentIndex >= 0 && (parentFrame = parentStack[parentIndex]).equals(currentStack[i])) {
            ++duplicates;
        }
        return duplicates;
    }

    StackTraceElement[] getInternalStackTrace() {
        if (!this.enableWritableStackTrace) {
            return ZeroStackTraceElementArray;
        }
        if (this.stackTrace == null) {
            this.stackTrace = J9VMInternals.getStackTrace(this, true);
        }
        return this.stackTrace;
    }

    public void printStackTrace(PrintStream err) {
        StackTraceElement[] stack = this.printStackTrace(err, null, 0, false);
        for (Throwable throwable = this.getCause(); throwable != null && stack != null; throwable = throwable.getCause()) {
            stack = throwable.printStackTrace(err, stack, 0, false);
        }
    }

    public void printStackTrace(PrintWriter err) {
        StackTraceElement[] stack = this.printStackTrace(err, null, 0, false);
        for (Throwable throwable = this.getCause(); throwable != null && stack != null; throwable = throwable.getCause()) {
            stack = throwable.printStackTrace(err, stack, 0, false);
        }
    }

    public String toString() {
        String msg = this.getLocalizedMessage();
        String name = this.getClass().getName();
        if (msg == null) {
            return name;
        }
        int length = name.length() + 2 + msg.length();
        StringBuilder buffer = new StringBuilder(length);
        return buffer.append(name).append(": ").append(msg).toString();
    }

    public synchronized Throwable initCause(Throwable throwable) {
        return this.setCause(throwable);
    }

    Throwable setCause(Throwable throwable) {
        if (this.cause == this) {
            if (throwable != this) {
                this.cause = throwable;
                return this;
            }
            throw new IllegalArgumentException(Msg.getString("K05c8"));
        }
        throw new IllegalStateException(Msg.getString("K05c9"));
    }

    public Throwable getCause() {
        if (this.cause == this) {
            return null;
        }
        return this.cause;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.getInternalStackTrace();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        boolean bl = this.enableWritableStackTrace = this.stackTrace != null;
        if (this.stackTrace != null) {
            if (this.stackTrace.length == 1) {
                if (this.stackTrace[0] == null) {
                    throw new NullPointerException(Msg.getString("K0560"));
                }
                if (this.stackTrace[0].equals(new StackTraceElement("", "", null, Integer.MIN_VALUE))) {
                    this.stackTrace = null;
                }
            } else {
                for (int i = 0; i < this.stackTrace.length; ++i) {
                    if (this.stackTrace[i] != null) continue;
                    throw new NullPointerException(Msg.getString("K0560"));
                }
            }
        }
        if (this.suppressedExceptions != null) {
            if (this.suppressedExceptions.size() == 0) {
                this.suppressedExceptions = Collections.EMPTY_LIST;
            } else {
                for (Throwable t : this.suppressedExceptions) {
                    if (t == null) {
                        throw new NullPointerException(Msg.getString("K0561"));
                    }
                    if (t != this) continue;
                    throw new IllegalArgumentException(Msg.getString("K0562"));
                }
            }
        }
    }

    static void appendTo(Appendable buf, CharSequence s) {
        StackTraceElement.appendTo(buf, s);
    }

    static void appendTo(Appendable buf, CharSequence s, int indents) {
        for (int i = 0; i < indents; ++i) {
            StackTraceElement.appendTo(buf, "\t");
        }
        StackTraceElement.appendTo(buf, s);
    }

    static void appendTo(Appendable buf, int i) {
        StackTraceElement.appendTo(buf, i);
    }

    static void appendLnTo(Appendable buf) {
        if (buf instanceof PrintStream) {
            ((PrintStream)buf).println();
        } else if (buf instanceof PrintWriter) {
            ((PrintWriter)buf).println();
        } else {
            Throwable.appendTo(buf, "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackTraceElement[] printStackTrace(Appendable err, StackTraceElement[] parentStack, int indents, boolean suppressed) {
        StackTraceElement[] stack;
        if (err == null) {
            throw new NullPointerException();
        }
        boolean outOfMemory = this instanceof OutOfMemoryError;
        if (parentStack != null) {
            if (suppressed) {
                Throwable.appendTo(err, "Suppressed: ", indents);
            } else {
                Throwable.appendTo(err, "Caused by: ", indents);
            }
        }
        if (!outOfMemory) {
            try {
                Throwable.appendTo(err, this.toString());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        if (outOfMemory) {
            try {
                Throwable.appendTo(err, this.getClass().getName());
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
                Throwable.appendTo(err, "java.lang.OutOfMemoryError(?)");
            }
            try {
                String message = this.getLocalizedMessage();
                if (message != null) {
                    Throwable.appendTo(err, ": ");
                    Throwable.appendTo(err, message);
                }
            }
            catch (OutOfMemoryError e) {
                outOfMemory = true;
            }
        }
        Throwable.appendLnTo(err);
        int duplicates = 0;
        try {
            stack = this.getInternalStackTrace();
            if (parentStack != null) {
                duplicates = Throwable.countDuplicates(stack, parentStack);
            }
        }
        catch (OutOfMemoryError e) {
            Throwable.appendTo(err, "\tat ?", indents);
            Throwable.appendLnTo(err);
            return null;
        }
        for (int i = 0; i < stack.length - duplicates; ++i) {
            if (!outOfMemory) {
                try {
                    Throwable.appendTo(err, "\tat " + stack[i], indents);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Throwable.appendTo(err, "\tat ", indents);
                stack[i].appendTo(err);
            }
            Throwable.appendLnTo(err);
        }
        if (duplicates > 0) {
            if (!outOfMemory) {
                try {
                    Throwable.appendTo(err, "\t... " + duplicates + " more", indents);
                }
                catch (OutOfMemoryError e) {
                    outOfMemory = true;
                }
            }
            if (outOfMemory) {
                Throwable.appendTo(err, "\t... ", indents);
                Throwable.appendTo(err, duplicates);
                Throwable.appendTo(err, " more");
            }
            Throwable.appendLnTo(err);
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions != null) {
                for (Throwable t : this.suppressedExceptions) {
                    StackTraceElement[] stackSuppressed = t.printStackTrace(err, stack, indents + 1, true);
                    for (Throwable throwableSuppressed = t.getCause(); throwableSuppressed != null && stackSuppressed != null; throwableSuppressed = throwableSuppressed.getCause()) {
                        stackSuppressed = throwableSuppressed.printStackTrace(err, stackSuppressed, indents + 1, false);
                    }
                }
            }
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSuppressed(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException(Msg.getString("K0563"));
        }
        if (exception == this) {
            throw new IllegalArgumentException(Msg.getString("K0559"));
        }
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions != null) {
                if (this.suppressedExceptions.size() == 0) {
                    this.suppressedExceptions = new ArrayList<Throwable>(2);
                }
                this.suppressedExceptions.add(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable[] getSuppressed() {
        Throwable throwable = this;
        synchronized (throwable) {
            if (this.suppressedExceptions == null || this.suppressedExceptions.size() == 0) {
                return ZeroElementArray;
            }
            return this.suppressedExceptions.toArray(new Throwable[this.suppressedExceptions.size()]);
        }
    }
}

