/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithInt;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class CollectHandle
extends MethodHandle {
    final MethodHandle next;
    final int collectArraySize;
    private static final ThunkTable _thunkTable = new ThunkTable();

    CollectHandle(MethodHandle next, int collectArraySize) {
        super(CollectHandle.collectMethodType(next.type(), collectArraySize), null, null, 10, next.rawModifiers, new Integer(collectArraySize));
        this.collectArraySize = collectArraySize;
        this.next = next;
        this.vmSlot = 0L;
    }

    CollectHandle(CollectHandle original, MethodType newType) {
        super(original, newType);
        this.collectArraySize = original.collectArraySize;
        this.next = original.next;
        this.vmSlot = original.vmSlot;
    }

    private static final MethodType collectMethodType(MethodType type, int collectArraySize) {
        int parameterCount = type.parameterCount();
        if (parameterCount == 0) {
            throw new IllegalArgumentException(Msg.getString("K05ca"));
        }
        Class<?> arrayComponent = type.lastParameterType().getComponentType();
        if (arrayComponent == null) {
            throw new IllegalArgumentException(Msg.getString("K05ca"));
        }
        MethodType newType = type.changeParameterType(parameterCount - 1, arrayComponent);
        if (collectArraySize == 0) {
            newType = newType.dropParameterTypes(parameterCount - 1, parameterCount);
        } else if (collectArraySize > 1) {
            Class[] classes = new Class[collectArraySize - 1];
            for (int j = 0; j < classes.length; ++j) {
                classes[j] = arrayComponent;
            }
            newType = newType.insertParameterTypes(newType.parameterCount(), classes);
        }
        return newType;
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new CollectHandle(this, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @Override
    protected final ThunkTuple computeThunks(Object arg) {
        int collectArraySize = (Integer)arg;
        return this.thunkTable().get(new ThunkKeyWithInt(ThunkKey.computeThunkableType(this.type()), collectArraySize));
    }

    private final Object allocateArray() {
        return Array.newInstance(this.next.type().lastParameterType().getComponentType(), this.collectArraySize);
    }

    private static native int numArgsToPassThrough();

    private static native int numArgsToCollect();

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) throws Throwable {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        ILGenMacros.populateArray(ILGenMacros.push(this.allocateArray()), ILGenMacros.lastN(CollectHandle.numArgsToCollect(), argPlaceholder));
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(CollectHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.pop_L()));
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof CollectHandle) {
            ((CollectHandle)right).compareWithCollect(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithCollect(CollectHandle left, Comparator c) {
        c.compareStructuralParameter(left.collectArraySize, this.collectArraySize);
        c.compareChildHandle(left.next, this.next);
    }
}

