/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ConstantDoubleHandle;
import java.lang.invoke.ConstantFloatHandle;
import java.lang.invoke.ConstantIntHandle;
import java.lang.invoke.ConstantLongHandle;
import java.lang.invoke.ConstantObjectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleCache;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;

abstract class ConstantHandle
extends MethodHandle {
    private static final ThunkTable _thunkTable = new ThunkTable();
    private static final ConstantHandle constantHandleInt_0 = new ConstantIntHandle(MethodType.methodType(Integer.TYPE), 0);
    private static final ConstantHandle constantHandleInt_1 = new ConstantIntHandle(MethodType.methodType(Integer.TYPE), 1);
    private static final ConstantHandle constantHandleDouble_0 = new ConstantDoubleHandle(MethodType.methodType(Double.TYPE), 0.0);
    private static final ConstantHandle constantHandleDouble_1 = new ConstantDoubleHandle(MethodType.methodType(Double.TYPE), 1.0);
    private static final ConstantHandle constantHandleLong_0 = new ConstantLongHandle(MethodType.methodType(Long.TYPE), 0L);
    private static final ConstantHandle constantHandleLong_1 = new ConstantLongHandle(MethodType.methodType(Long.TYPE), 1L);

    ConstantHandle(MethodType type, String name, int kind) {
        super(type, null, name, kind, null);
    }

    ConstantHandle(ConstantHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    public static ConstantHandle get(Class<?> constantType, Object constantValue) {
        MethodType methodType = MethodType.methodType(constantType);
        if (!constantType.isPrimitive()) {
            if (null != constantValue) {
                return new ConstantObjectHandle(methodType, constantValue);
            }
            MethodHandleCache methodHandleCache = MethodHandleCache.getCache(constantType);
            return (ConstantHandle)methodHandleCache.getNullConstantObjectHandle();
        }
        char charValue = '\u0000';
        if (constantValue instanceof Character) {
            charValue = ((Character)constantValue).charValue();
        }
        if (constantType == Double.TYPE) {
            double value = constantValue instanceof Number ? ((Number)constantValue).doubleValue() : (double)charValue;
            if (0.0 == value) {
                return constantHandleDouble_0;
            }
            if (1.0 == value) {
                return constantHandleDouble_1;
            }
            return new ConstantDoubleHandle(methodType, value);
        }
        if (constantType == Long.TYPE) {
            long value = constantValue instanceof Number ? ((Number)constantValue).longValue() : (long)charValue;
            if (0L == value) {
                return constantHandleLong_0;
            }
            if (1L == value) {
                return constantHandleLong_1;
            }
            return new ConstantLongHandle(methodType, value);
        }
        if (constantType == Float.TYPE) {
            float value = constantValue instanceof Number ? ((Number)constantValue).floatValue() : (float)charValue;
            return new ConstantFloatHandle(methodType, value);
        }
        int value = constantValue instanceof Number ? ((Number)constantValue).intValue() : (constantValue instanceof Boolean ? ((Boolean)constantValue != false ? 1 : 0) : (int)charValue);
        if (Integer.TYPE == constantType) {
            if (0 == value) {
                return constantHandleInt_0;
            }
            if (1 == value) {
                return constantHandleInt_1;
            }
        }
        return new ConstantIntHandle(methodType, value);
    }
}

