/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

final class FilterArgumentsHandle
extends MethodHandle {
    private final MethodHandle next;
    private final int startPos;
    private final MethodHandle[] filters;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected FilterArgumentsHandle(MethodHandle next, int startPos, MethodHandle[] filters, MethodType newType) {
        super(newType, FilterArgumentsHandle.class, "FilterArgumentsHandle", 29, 0, FilterArgumentsHandle.infoAffectingThunks(startPos, filters));
        this.next = next;
        this.startPos = startPos;
        this.filters = filters;
    }

    FilterArgumentsHandle(FilterArgumentsHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.startPos = originalHandle.startPos;
        this.filters = originalHandle.filters;
    }

    public static FilterArgumentsHandle get(MethodHandle next, int startPos, MethodHandle[] filters, MethodType newType) {
        return new FilterArgumentsHandle(next, startPos, filters, newType);
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static native int numPrefixArgs();

    private static native int numSuffixArgs();

    private static native int numArgsToFilter();

    private static native int filterArguments(MethodHandle[] var0, int var1);

    private static Object[] infoAffectingThunks(int startPos, MethodHandle[] filters) {
        Object[] result = new Object[1 + filters.length];
        result[0] = startPos;
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null) continue;
            result[i + 1] = ThunkKey.computeThunkableType(filters[i].type);
        }
        return result;
    }

    @Override
    protected final ThunkTuple computeThunks(Object arg) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])arg));
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
            this.undoCustomizationLogic(this.filters);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(FilterArgumentsHandle.numPrefixArgs(), argPlaceholder), FilterArgumentsHandle.filterArguments(this.filters, ILGenMacros.middleN(FilterArgumentsHandle.numPrefixArgs(), FilterArgumentsHandle.numArgsToFilter(), argPlaceholder)), ILGenMacros.lastN(FilterArgumentsHandle.numSuffixArgs(), argPlaceholder)));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new FilterArgumentsHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof FilterArgumentsHandle) {
            ((FilterArgumentsHandle)right).compareWithFilterArguments(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithFilterArguments(FilterArgumentsHandle left, Comparator c) {
        c.compareStructuralParameter(left.startPos, this.startPos);
        c.compareStructuralParameter(left.filters.length, this.filters.length);
        c.compareChildHandle(left.next, this.next);
        for (int i = 0; i < left.filters.length && i < this.filters.length; ++i) {
            c.compareChildHandle(left.filters[i], this.filters[i]);
        }
    }
}

