/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.FoldNonvoidHandle;
import java.lang.invoke.FoldVoidHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObject;
import java.lang.invoke.ThunkTuple;

abstract class FoldHandle
extends MethodHandle {
    protected final MethodHandle next;
    protected final MethodHandle combiner;

    protected FoldHandle(MethodHandle next, MethodHandle combiner, MethodType type, Class<?> definingClass, String name) {
        super(type, definingClass, name, 27, 0, combiner.type());
        this.next = next;
        this.combiner = combiner;
    }

    FoldHandle(FoldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.combiner = originalHandle.combiner;
    }

    public static FoldHandle get(MethodHandle next, MethodHandle combiner, MethodType type) {
        if (combiner.type().returnType() == Void.TYPE) {
            return new FoldVoidHandle(next, combiner, type);
        }
        return new FoldNonvoidHandle(next, combiner, type);
    }

    @Override
    protected final ThunkTuple computeThunks(Object combinerType) {
        return this.thunkTable().get(new ThunkKeyWithObject(ThunkKey.computeThunkableType(this.type()), ThunkKey.computeThunkableType((MethodType)combinerType)));
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof FoldHandle) {
            ((FoldHandle)right).compareWithFold(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithFold(FoldHandle left, Comparator c) {
        c.compareChildHandle(left.next, this.next);
        c.compareChildHandle(left.combiner, this.combiner);
    }
}

