/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithIntArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;

class InsertHandle
extends MethodHandle {
    final MethodHandle next;
    final int insertionIndex;
    private final Object[] values;
    private static final ThunkTable _thunkTable = new ThunkTable();

    InsertHandle(MethodType type, MethodHandle next, int insertionIndex, Object[] values) {
        super(type, next.definingClass, "InsertHandle", 20, InsertHandle.infoAffectingThunks(insertionIndex, values.length));
        this.next = next;
        this.insertionIndex = insertionIndex;
        this.values = values;
    }

    InsertHandle(InsertHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.insertionIndex = originalHandle.insertionIndex;
        this.values = originalHandle.values;
    }

    @Override
    protected ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static int[] infoAffectingThunks(int insertionIndex, int numberOfValues) {
        int[] result = new int[]{insertionIndex, numberOfValues};
        return result;
    }

    @Override
    protected ThunkTuple computeThunks(Object arg) {
        int[] info = (int[])arg;
        return this.thunkTable().get(new ThunkKeyWithIntArray(ThunkKey.computeThunkableType(this.type()), info));
    }

    static native int numPrefixArgs();

    static native int numSuffixArgs();

    private static native int numValuesToInsert();

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(InsertHandle.numPrefixArgs(), argPlaceholder), ILGenMacros.arrayElements(this.values, 0, InsertHandle.numValuesToInsert()), ILGenMacros.lastN(InsertHandle.numSuffixArgs(), argPlaceholder)));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new InsertHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof InsertHandle) {
            ((InsertHandle)right).compareWithInsert(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithInsert(InsertHandle left, Comparator c) {
        c.compareStructuralParameter(left.insertionIndex, this.insertionIndex);
        c.compareStructuralParameter(left.values.length, this.values.length);
        for (int i = 0; i < left.values.length && i < this.values.length; ++i) {
            c.compareUserSuppliedParameter(left.values[i], this.values[i]);
        }
        c.compareChildHandle(left.next, this.next);
    }
}

