/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.jit.JITHelpers;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.ArgumentMoverHandle;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.BruteArgumentMoverHandle;
import java.lang.invoke.CacheKey;
import java.lang.invoke.CallSite;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.ConvertHandle;
import java.lang.invoke.DirectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.InterfaceHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.PermuteHandle;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.SpreadHandle;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.invoke.VirtualHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;
import sun.reflect.ConstantPool;

public abstract class MethodHandle {
    static final int KIND_BOUND = 0;
    static final int KIND_GETFIELD = 1;
    static final int KIND_GETSTATICFIELD = 2;
    static final int KIND_PUTFIELD = 3;
    static final int KIND_PUTSTATICFIELD = 4;
    static final int KIND_VIRTUAL = 5;
    static final int KIND_STATIC = 6;
    static final int KIND_SPECIAL = 7;
    static final int KIND_CONSTRUCTOR = 8;
    static final int KIND_INTERFACE = 9;
    static final int KIND_COLLECT = 10;
    static final int KIND_INVOKEEXACT = 11;
    static final int KIND_INVOKEGENERIC = 12;
    static final int KIND_ASTYPE = 13;
    static final int KIND_DYNAMICINVOKER = 14;
    static final int KIND_FILTERRETURN = 15;
    static final int KIND_EXPLICITCAST = 16;
    static final int KIND_VARARGSCOLLECT = 17;
    static final int KIND_PASSTHROUGH = 18;
    static final int KIND_SPREAD = 19;
    static final int KIND_INSERT = 20;
    static final int KIND_PERMUTE = 21;
    static final int KIND_CONSTANTOBJECT = 22;
    static final int KIND_CONSTANTINT = 23;
    static final int KIND_CONSTANTFLOAT = 24;
    static final int KIND_CONSTANTLONG = 25;
    static final int KIND_CONSTANTDOUBLE = 26;
    static final int KIND_FOLDHANDLE = 27;
    static final int KIND_GUARDWITHTEST = 28;
    static final int KIND_FILTERARGUMENTS = 29;
    static final int PUBLIC_FINAL_NATIVE = 4369;
    private static final int CUSTOM_THUNK_INVOCATION_COUNT = 1000;
    private static final int DONT_CHECK_FOR_A_WHILE_COUNT = -1000000000;
    final MethodType type;
    long vmSlot;
    int rawModifiers;
    final int kind;
    final Class<?> definingClass;
    Class<?> defc;
    int invocationCount;
    ThunkTuple thunks;
    static final int VTABLE_ENTRY_SIZE = VM.ADDRESS_SIZE;
    static final int VTABLE_ENTRY_SHIFT = 31 - Integer.numberOfLeadingZeros(VTABLE_ENTRY_SIZE);
    static final int J9CLASS_OFFSET = MethodHandle.vmRefFieldOffset();
    static final long INTRP_VTABLE_OFFSET = VM.J9CLASS_SIZE;
    static final int HEADER_SIZE = VM.OBJECT_HEADER_SIZE;
    static final Class<?>[] EMPTY_CLASS_ARRAY;
    final String name;
    Class<?> specialCaller;
    CacheKey cacheKey;
    private MethodHandle previousAsType;
    private static final int BSM_ARGUMENT_SIZE = 2;
    private static final int BSM_ARGUMENT_COUNT_OFFSET = 2;
    private static final int BSM_ARGUMENTS_OFFSET = 4;
    private static final int BSM_LOOKUP_ARGUMENT_INDEX = 0;
    private static final int BSM_NAME_ARGUMENT_INDEX = 1;
    private static final int BSM_TYPE_ARGUMENT_INDEX = 2;
    private static final int BSM_OPTIONAL_ARGUMENTS_START_INDEX = 3;

    static final Unsafe getUnsafe() {
        return UnsafeGetter.myUnsafe;
    }

    static final JITHelpers getJITHelpers() {
        return JITHelpersGetter.myJITHelpers;
    }

    final void doCustomizationLogic() {
        if (++this.invocationCount > 1000) {
            this.requestCustomThunk();
            this.invocationCount = -1000000000;
        }
    }

    final void undoCustomizationLogic(MethodHandle callee) {
        --callee.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle callee1, MethodHandle callee2) {
        --callee1.invocationCount;
        --callee2.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle callee1, MethodHandle callee2, MethodHandle callee3) {
        --callee1.invocationCount;
        --callee2.invocationCount;
        --callee3.invocationCount;
    }

    final void undoCustomizationLogic(MethodHandle ... callees) {
        for (MethodHandle callee : callees) {
            if (callee == null) continue;
            --callee.invocationCount;
        }
    }

    final void requestCustomThunk() {
        this.thunks = ThunkTuple.copyOf(this.thunks);
        this.requestCustomThunkFromJit(this.thunks);
    }

    private native void requestCustomThunkFromJit(ThunkTuple var1);

    abstract ThunkTable thunkTable();

    ThunkTuple computeThunks(Object arg) {
        return this.thunkTable().get(new ThunkKey(ThunkKey.computeThunkableType(this.type())));
    }

    final long invokeExactTargetAddress() {
        return this.thunks.invokeExactThunk;
    }

    static long getJ9ClassFromClass(Class<?> c) {
        JITHelpers h = MethodHandle.getJITHelpers();
        if (h.is32Bit()) {
            return h.getJ9ClassFromClass32(c);
        }
        return h.getJ9ClassFromClass64(c);
    }

    abstract MethodHandle cloneWithNewType(MethodType var1);

    private static MethodHandle asType(MethodHandle mh, MethodType newType) {
        return mh.asType(newType);
    }

    MethodHandle(MethodType type, Class<?> definingClass, String name, int kind, int modifiers, Object thunkArg) {
        this.definingClass = definingClass;
        this.defc = definingClass;
        this.name = name;
        this.kind = kind;
        this.rawModifiers = modifiers;
        this.type = this.computeHandleType(type);
        MethodHandle.enforceArityLimit(this.type);
        this.thunks = this.computeThunks(thunkArg);
        MethodHandle.getJ9ClassFromClass(MethodHandle.class);
    }

    MethodHandle(MethodType type, Class<?> definingClass, String name, int kind, Object thunkArg) {
        this(type, definingClass, name, kind, 0, thunkArg);
    }

    MethodHandle(MethodHandle original, MethodType newType) {
        this.definingClass = original.definingClass;
        this.defc = original.defc;
        this.name = original.name;
        this.kind = original.kind;
        this.type = newType;
        MethodHandle.enforceArityLimit(newType);
        this.thunks = original.thunks;
        this.rawModifiers = original.rawModifiers;
        this.specialCaller = original.specialCaller;
        this.vmSlot = original.vmSlot;
        this.previousAsType = original.previousAsType;
    }

    @PolymorphicSignature
    public final native Object invokeExact(Object ... var1) throws Throwable, WrongMethodTypeException;

    @PolymorphicSignature
    public final native Object invoke(Object ... var1) throws Throwable, WrongMethodTypeException, ClassCastException;

    private native Class<?> lookupMethod(Class<?> var1, String var2, String var3, int var4, Class<?> var5);

    final native Class<?> lookupField(Class<?> var1, String var2, String var3, int var4, Class<?> var5);

    static native boolean setVMSlotAndRawModifiersFromField(MethodHandle var0, Field var1);

    static native boolean setVMSlotAndRawModifiersFromMethod(MethodHandle var0, Class<?> var1, Method var2, int var3, Class<?> var4);

    static native boolean setVMSlotAndRawModifiersFromConstructor(MethodHandle var0, Constructor<?> var1);

    private static native boolean lookupVMDispatchTargets(long[] var0);

    MethodType computeHandleType(MethodType incomingType) {
        return incomingType;
    }

    static native boolean setVMSlotAndRawModifiersFromSpecialHandle(VirtualHandle var0, DirectHandle var1);

    final Class<?> finishMethodInitialization(Class<?> specialToken, MethodType oldType) throws NoSuchMethodException, IllegalAccessException {
        try {
            String signature = oldType.toMethodDescriptorString();
            return this.lookupMethod(this.definingClass, this.name, signature, this.kind, specialToken);
        }
        catch (NoSuchMethodError e) {
            throw new NoSuchMethodException(e.getMessage());
        }
        catch (IncompatibleClassChangeError e) {
            throw new IllegalAccessException(e.getMessage());
        }
    }

    public MethodType type() {
        return this.type;
    }

    public MethodHandle asSpreader(Class<?> arrayClass, int spreadCount) throws IllegalArgumentException, WrongMethodTypeException {
        MethodType collectType;
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException();
        }
        if (spreadCount < 0 || spreadCount > this.type.parameterCount()) {
            MethodHandle.throwIllegalArgumentExceptionForMHArgCount();
        }
        MethodHandle adapted = this;
        if (spreadCount == 0) {
            collectType = this.type.appendParameterTypes(arrayClass);
        } else {
            int length = this.type.parameterCount();
            Class<?> componentType = arrayClass.getComponentType();
            collectType = this.type.changeParameterType(length - spreadCount, arrayClass);
            if (spreadCount > 1) {
                collectType = collectType.dropParameterTypes(length + 1 - spreadCount, length);
            }
            Object[] parameters = (Class[])this.type.arguments.clone();
            Arrays.fill(parameters, length - spreadCount, length, componentType);
            adapted = this.asType(MethodType.methodType(this.type.returnType, parameters));
        }
        return new SpreadHandle(adapted, collectType, arrayClass, spreadCount);
    }

    public MethodHandle asCollector(Class<?> arrayClass, int collectCount) throws IllegalArgumentException, WrongMethodTypeException, NullPointerException {
        int parameterCount = this.type.parameterCount();
        if (parameterCount == 0 || collectCount < 0 || collectCount > 255) {
            throw new IllegalArgumentException();
        }
        arrayClass.getClass();
        Class<?> lastClass = this.type.lastParameterType();
        if (!arrayClass.isArray() || !lastClass.isAssignableFrom(arrayClass)) {
            throw new IllegalArgumentException(Msg.getString("K05cc", arrayClass.toString(), this.type.toString()));
        }
        return new CollectHandle(this.asType(this.type.changeParameterType(parameterCount - 1, arrayClass)), collectCount);
    }

    public MethodHandle asType(MethodType newType) throws ClassCastException {
        if (this.type.equals(newType)) {
            return this;
        }
        MethodHandle localPreviousAsType = this.previousAsType;
        if (localPreviousAsType != null && localPreviousAsType.type == newType) {
            return localPreviousAsType;
        }
        MethodHandle handle = this;
        Class<?> fromReturn = this.type.returnType;
        Class<?> toReturn = newType.returnType;
        if (fromReturn != toReturn) {
            if (toReturn.isAssignableFrom(fromReturn)) {
                handle = this.cloneWithNewType(MethodType.methodType(toReturn, this.type.arguments));
            } else {
                MethodHandle filter = ConvertHandle.FilterHelpers.getReturnFilter(fromReturn, toReturn, false);
                handle = new FilterReturnHandle(this, filter);
            }
        }
        if (handle.type != newType) {
            handle = new AsTypeHandle(handle, newType);
        }
        this.previousAsType = handle;
        return handle;
    }

    private static final native int vmRefFieldOffset();

    public Object invokeWithArguments(Object ... args) throws Throwable, WrongMethodTypeException, ClassCastException {
        int argsLength = 0;
        if (args != null) {
            argsLength = args.length;
        }
        if (argsLength != this.type.arguments.length) {
            throw new WrongMethodTypeException();
        }
        if (argsLength < 253) {
            return IWAContainer.getMH(this.type.arguments.length).invokeExact(this, args);
        }
        return this.asSpreader(Object[].class, argsLength).invoke(args);
    }

    private static native Object invokeWithArgumentsHelper(MethodHandle var0, Object[] var1);

    public Object invokeWithArguments(List<?> args) throws Throwable, WrongMethodTypeException, ClassCastException, NullPointerException {
        return this.invokeWithArguments(args.toArray());
    }

    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (!arrayParameter.isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> lastArgType = this.type().lastParameterType();
        if (!lastArgType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException();
        }
        return new VarargsCollectorHandle(this, arrayParameter);
    }

    public boolean isVarargsCollector() {
        return this instanceof VarargsCollectorHandle;
    }

    boolean canRevealDirect() {
        return false;
    }

    boolean directHandleOriginatedInFindVirtual() {
        return false;
    }

    public MethodHandle asFixedArity() {
        return this;
    }

    public MethodHandle bindTo(Object value) throws IllegalArgumentException, ClassCastException {
        Class<?> firstParameterType = this.type().parameterType(0);
        if (firstParameterType.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        value = firstParameterType.cast(value);
        if (this.getClass() == DirectHandle.class) {
            return new ReceiverBoundHandle(this, value, MethodHandles.insertArguments(this, 0, value));
        }
        if (value != null && this instanceof IndirectHandle) {
            try {
                MethodHandle result = MethodHandles.Lookup.internalPrivilegedLookup.bind(value, this.name, this.type().dropFirstParameterType());
                if (this instanceof InterfaceHandle && (result.rawModifiers & 1) == 0) {
                    throw new IllegalAccessException();
                }
                return result;
            }
            catch (IllegalAccessException e) {
                return MethodHandles.insertArguments(this, 0, value);
            }
            catch (NoSuchMethodException e) {
                throw new Error(e);
            }
        }
        return MethodHandles.insertArguments(this, 0, value);
    }

    MethodHandle permuteArguments(MethodType permuteType, int ... permute) {
        MethodHandle result = new PermuteHandle(permuteType, this, permute);
        result = new BruteArgumentMoverHandle(permuteType, this, permute, EMPTY_CLASS_ARRAY, result);
        return result;
    }

    MethodHandle insertArguments(MethodHandle equivalent, MethodHandle unboxingHandle, int location, Object ... values) {
        MethodHandle result = equivalent;
        int numValues = values.length;
        MethodType mtype = equivalent.type();
        int[] permute = ArgumentMoverHandle.insertPermute(ArgumentMoverHandle.identityPermute(mtype), location, numValues, -1);
        result = new BruteArgumentMoverHandle(mtype, unboxingHandle, permute, values, result);
        return result;
    }

    private static final native int getCPTypeAt(Class<?> var0, int var1);

    private static final native MethodType getCPMethodTypeAt(Class<?> var0, int var1);

    private static final native MethodHandle getCPMethodHandleAt(Class<?> var0, int var1);

    private static final MethodHandle resolveInvokeDynamic(Class<?> clazz, String name, String methodDescriptor, long bsmData) throws Throwable {
        Unsafe unsafe = MethodHandle.getUnsafe();
        MethodHandle result = null;
        MethodType type = null;
        try {
            type = MethodType.fromMethodDescriptorString(methodDescriptor, VM.getVMLangAccess().getClassloader(clazz));
            short bsmIndex = unsafe.getShort(bsmData);
            int bsmArgCount = unsafe.getShort(bsmData + 2L);
            long bsmArgs = bsmData + 4L;
            MethodHandle bsm = MethodHandle.getCPMethodHandleAt(clazz, bsmIndex);
            if (null == bsm) {
                throw new NullPointerException(Msg.getString("K05cd", clazz.toString(), bsmIndex));
            }
            Object[] staticArgs = new Object[3 + bsmArgCount];
            staticArgs[0] = new MethodHandles.Lookup(clazz, false);
            staticArgs[1] = name;
            staticArgs[2] = type;
            ConstantPool cp = SharedSecrets.getJavaLangAccess().getConstantPool(clazz);
            boolean treatLastArgAsVarargs = bsm.isVarargsCollector();
            Class<?> varargsComponentType = bsm.type.lastParameterType().getComponentType();
            int bsmTypeArgCount = bsm.type.parameterCount();
            for (int i = 0; i < bsmArgCount; ++i) {
                int staticArgIndex = 3 + i;
                short index = unsafe.getShort(bsmArgs + (long)(i * 2));
                int cpType = MethodHandle.getCPTypeAt(clazz, index);
                Object cpEntry = null;
                switch (cpType) {
                    case 1: {
                        cpEntry = cp.getClassAt((int)index);
                        break;
                    }
                    case 2: {
                        cpEntry = cp.getStringAt((int)index);
                        break;
                    }
                    case 3: {
                        int cpValue = cp.getIntAt((int)index);
                        Class<?> argClass = treatLastArgAsVarargs && staticArgIndex >= bsmTypeArgCount - 1 ? varargsComponentType : bsm.type.parameterType(staticArgIndex);
                        if (argClass == Short.TYPE) {
                            cpEntry = (short)cpValue;
                            break;
                        }
                        if (argClass == Boolean.TYPE) {
                            cpEntry = cpValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        if (argClass == Byte.TYPE) {
                            cpEntry = (byte)cpValue;
                            break;
                        }
                        if (argClass == Character.TYPE) {
                            cpEntry = Character.valueOf((char)cpValue);
                            break;
                        }
                        cpEntry = cpValue;
                        break;
                    }
                    case 4: {
                        cpEntry = Float.valueOf(cp.getFloatAt((int)index));
                        break;
                    }
                    case 5: {
                        cpEntry = cp.getLongAt((int)index);
                        break;
                    }
                    case 6: {
                        cpEntry = cp.getDoubleAt((int)index);
                        break;
                    }
                    case 13: {
                        cpEntry = MethodHandle.getCPMethodTypeAt(clazz, index);
                        break;
                    }
                    case 14: {
                        cpEntry = MethodHandle.getCPMethodHandleAt(clazz, index);
                        break;
                    }
                }
                cpEntry.getClass();
                staticArgs[staticArgIndex] = cpEntry;
            }
            CallSite cs = null;
            switch (staticArgs.length) {
                case 3: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2]);
                    break;
                }
                case 4: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3]);
                    break;
                }
                case 5: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4]);
                    break;
                }
                case 6: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5]);
                    break;
                }
                case 7: {
                    cs = bsm.invoke(staticArgs[0], staticArgs[1], staticArgs[2], staticArgs[3], staticArgs[4], staticArgs[5], staticArgs[6]);
                    break;
                }
                default: {
                    cs = (CallSite)bsm.invokeWithArguments(staticArgs);
                }
            }
            if (cs != null) {
                if (cs.getTarget().type() != type) {
                    throw new WrongMethodTypeException();
                }
                result = cs.dynamicInvoker();
            }
        }
        catch (Throwable e) {
            if (type == null) {
                throw new BootstrapMethodError();
            }
            try {
                MethodHandle thrower = MethodHandles.throwException(type.returnType(), BootstrapMethodError.class);
                MethodHandle constructor = MethodHandles.Lookup.IMPL_LOOKUP.findConstructor(BootstrapMethodError.class, MethodType.methodType(Void.TYPE, Throwable.class));
                result = MethodHandles.foldArguments(thrower, constructor.bindTo(e));
                result = MethodHandles.dropArguments(result, 0, type.parameterList());
            }
            catch (IllegalAccessException iae) {
                throw new Error(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new Error(nsme);
            }
        }
        return result;
    }

    public String toString() {
        return "MethodHandle" + this.type.toString();
    }

    private final MethodHandle forGenericInvoke(MethodType newType, boolean dropFirstArg) {
        if (this.type == newType) {
            return this;
        }
        if (dropFirstArg) {
            return this.asType(newType.dropFirstParameterType());
        }
        return this.asType(newType);
    }

    private static final MethodHandle sendResolveMethodHandle(int cpRefKind, Class<?> currentClass, Class<?> definingClass, String name, String typeDescriptor, ClassLoader loader) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        MethodHandles.Lookup lookup = new MethodHandles.Lookup(currentClass, false);
        MethodType type = null;
        switch (cpRefKind) {
            case 1: {
                return lookup.findGetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 2: {
                return lookup.findStaticGetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 3: {
                return lookup.findSetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 4: {
                return lookup.findStaticSetter(definingClass, name, MethodHandle.resolveFieldHandleHelper(typeDescriptor, loader));
            }
            case 5: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findVirtual(definingClass, name, type);
            }
            case 6: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findStatic(definingClass, name, type);
            }
            case 7: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findSpecial(definingClass, name, type, currentClass);
            }
            case 8: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findConstructor(definingClass, type);
            }
            case 9: {
                type = MethodType.fromMethodDescriptorString(typeDescriptor, loader);
                return lookup.findVirtual(definingClass, name, type);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final Class<?> resolveFieldHandleHelper(String typeDescriptor, ClassLoader loader) {
        MethodType mt = MethodType.fromMethodDescriptorString("(" + typeDescriptor + ")V", loader);
        return mt.parameterType(0);
    }

    private MethodHandle returnFilterPlaceHolder() {
        return this;
    }

    private MethodHandle foldHandlePlaceHolder() {
        return this;
    }

    private MethodHandle guardWithTestPlaceHolder() {
        return this;
    }

    private MethodHandle filterArgumentsPlaceHolder(int index, int parentOffset, int nextOffset) {
        return this;
    }

    private static Object constructorPlaceHolder(Object newObjectRef) {
        return newObjectRef;
    }

    abstract void compareWith(MethodHandle var1, Comparator var2);

    final void initializeClassIfRequired() {
        if (Modifier.isStatic(this.rawModifiers)) {
            long defcClass = MethodHandle.getJ9ClassFromClass(this.defc);
            Unsafe unsafe = MethodHandle.getUnsafe();
            int initStatus = 0;
            initStatus = 4 == VM.ADDRESS_SIZE ? unsafe.getInt(defcClass + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET) : (int)unsafe.getLong(defcClass + (long)VM.J9CLASS_INITIALIZE_STATUS_OFFSET);
            if (initStatus != 1) {
                unsafe.ensureClassInitialized(this.defc);
            }
        }
    }

    static final void enforceArityLimit(MethodType type) {
        if (type.argSlots > 254) {
            MethodHandle.throwIllegalArgumentExceptionForMTArgCount(type.argSlots);
        }
    }

    static void throwIllegalArgumentExceptionForMTArgCount(int argSlots) {
        throw new IllegalArgumentException(Msg.getString("K0578", argSlots + 1));
    }

    static void throwIllegalArgumentExceptionForMHArgCount() {
        throw new IllegalArgumentException(Msg.getString("K0579"));
    }

    String mapKindToBytecode() {
        switch (this.kind) {
            case 1: {
                return "getField";
            }
            case 2: {
                return "getStatic";
            }
            case 3: {
                return "putField";
            }
            case 4: {
                return "putStatic";
            }
            case 0: 
            case 5: {
                return "invokeVirtual";
            }
            case 6: {
                return "invokeStatic";
            }
            case 7: {
                return "invokeSpecial";
            }
            case 8: {
                return "newInvokeSpecial";
            }
            case 9: {
                return "invokeInterface";
            }
            case 17: {
                return ((VarargsCollectorHandle)this).next.mapKindToBytecode();
            }
        }
        return "KIND_#" + this.kind;
    }

    static {
        ComputedCalls.load();
        ThunkKey.load();
        ThunkTuple.load();
        ILGenMacros.load();
        EMPTY_CLASS_ARRAY = new Class[0];
    }

    static final class IWAContainer {
        static final MethodHandle spreader_0 = MethodHandles.spreadInvoker(MethodType.genericMethodType(0), 0);
        static final MethodHandle spreader_1 = MethodHandles.spreadInvoker(MethodType.genericMethodType(1), 0);
        static final MethodHandle spreader_2 = MethodHandles.spreadInvoker(MethodType.genericMethodType(2), 0);
        static final MethodHandle spreader_3 = MethodHandles.spreadInvoker(MethodType.genericMethodType(3), 0);
        static final MethodHandle spreader_4 = MethodHandles.spreadInvoker(MethodType.genericMethodType(4), 0);
        static final MethodHandle spreader_5 = MethodHandles.spreadInvoker(MethodType.genericMethodType(5), 0);
        static final MethodHandle spreader_6 = MethodHandles.spreadInvoker(MethodType.genericMethodType(6), 0);
        static final MethodHandle spreader_7 = MethodHandles.spreadInvoker(MethodType.genericMethodType(7), 0);

        IWAContainer() {
        }

        static MethodHandle getMH(int len) {
            switch (len) {
                case 0: {
                    return spreader_0;
                }
                case 1: {
                    return spreader_1;
                }
                case 2: {
                    return spreader_2;
                }
                case 3: {
                    return spreader_3;
                }
                case 4: {
                    return spreader_4;
                }
                case 5: {
                    return spreader_5;
                }
                case 6: {
                    return spreader_6;
                }
                case 7: {
                    return spreader_7;
                }
            }
            return MethodHandles.spreadInvoker(MethodType.genericMethodType(len), 0);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface FrameIteratorSkip {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface PolymorphicSignature {
    }

    private static final class JITHelpersGetter {
        public static final JITHelpers myJITHelpers = JITHelpers.getHelpers();

        private JITHelpersGetter() {
        }
    }

    private static final class UnsafeGetter {
        public static final Unsafe myUnsafe = Unsafe.getUnsafe();

        private UnsafeGetter() {
        }
    }
}

