/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VMLangAccess;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.AsTypeHandle;
import java.lang.invoke.CollectHandle;
import java.lang.invoke.FilterReturnHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ReceiverBoundHandle;
import java.lang.invoke.VarargsCollectorHandle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.IOUtils;
import sun.misc.Unsafe;

final class SecurityFrameInjector {
    static Map<ClassLoader, WeakReference<Class<?>>> LoaderToSecurityFrameClassMap = Collections.synchronizedMap(new WeakHashMap());
    static byte[] securityFrameClassBytes = null;
    static SecurityFrameInjectorLoaderLock loaderLock = new SecurityFrameInjectorLoaderLock();
    private static final int CALLER_SENSITIVE_BIT = 0x100000;

    SecurityFrameInjector() {
    }

    static boolean virtualCallAllowed(MethodHandle handle, Class<?> sensitiveMethodDefiningClass) {
        if (handle.defc == sensitiveMethodDefiningClass) {
            return true;
        }
        int modifiers = handle.rawModifiers;
        if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) {
            return false;
        }
        return sensitiveMethodDefiningClass.isAssignableFrom(handle.defc) || handle.defc.isInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] initializeSecurityFrameClassBytes() {
        if (securityFrameClassBytes != null) return securityFrameClassBytes;
        Class<SecurityFrameInjector> clazz = SecurityFrameInjector.class;
        synchronized (SecurityFrameInjector.class) {
            if (securityFrameClassBytes != null) return securityFrameClassBytes;
            securityFrameClassBytes = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        InputStream is = MethodHandles.Lookup.class.getResourceAsStream("/java/lang/invoke/SecurityFrame.class");
                        return IOUtils.readFully((InputStream)is, (int)-1, (boolean)true);
                    }
                    catch (IOException e) {
                        throw new Error(Msg.getString("K056A"), e);
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return securityFrameClassBytes;
        }
    }

    static Class<?> probeLoaderToSecurityFrameMap(ClassLoader loader) {
        WeakReference<Class<?>> weakRef = LoaderToSecurityFrameClassMap.get(loader);
        if (weakRef != null) {
            return (Class)weakRef.get();
        }
        return null;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrame(MethodHandle handle, final Class<?> context) {
        SecurityFrameInjector.initializeSecurityFrameClassBytes();
        boolean isVarargs = MethodHandles.Lookup.isVarargs(handle.rawModifiers) || handle.isVarargsCollector();
        final MethodHandle tempFinalHandle = handle;
        MethodType originalType = handle.type;
        try {
            Object o = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                private Class<?> injectSecurityFrameIntoLoader(ClassLoader loader, ProtectionDomain pd) {
                    return Unsafe.getUnsafe().defineClass("java.lang.invoke.SecurityFrame", securityFrameClassBytes, 0, securityFrameClassBytes.length, loader, pd);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    VMLangAccess vma = MethodHandles.Lookup.getVMLangAccess();
                    ClassLoader rawLoader = vma.getClassloader(context);
                    Class<?> injectedSecurityFrameClass = SecurityFrameInjector.probeLoaderToSecurityFrameMap(rawLoader);
                    if (injectedSecurityFrameClass == null) {
                        SecurityFrameInjectorLoaderLock securityFrameInjectorLoaderLock = loaderLock;
                        synchronized (securityFrameInjectorLoaderLock) {
                            injectedSecurityFrameClass = SecurityFrameInjector.probeLoaderToSecurityFrameMap(rawLoader);
                            if (injectedSecurityFrameClass == null) {
                                injectedSecurityFrameClass = this.injectSecurityFrameIntoLoader(rawLoader, context.getProtectionDomain());
                                LoaderToSecurityFrameClassMap.put(rawLoader, new WeakReference(injectedSecurityFrameClass));
                            }
                        }
                    }
                    try {
                        Constructor<?> constructor = injectedSecurityFrameClass.getConstructor(MethodHandle.class, Class.class);
                        constructor.setAccessible(true);
                        return constructor.newInstance(tempFinalHandle, context);
                    }
                    catch (ReflectiveOperationException | SecurityException e) {
                        throw new Error(e);
                    }
                }
            });
            handle = MethodHandles.Lookup.internalPrivilegedLookup.bind(o, "invoke", MethodType.methodType(Object.class, Object[].class));
            handle = handle.asType(originalType);
            if (isVarargs) {
                handle = handle.asVarargsCollector(originalType.lastParameterType());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
        return handle;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrameIfRequired(MethodHandles.Lookup lookup, MethodHandle handle) throws IllegalAccessException {
        if (SecurityFrameInjector.isCallerSensitive(handle)) {
            if (lookup.isWeakenedLookup()) {
                throw new IllegalAccessException(Msg.getString("K0589"));
            }
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrame(handle, lookup.accessClass);
        }
        return handle;
    }

    static boolean isCallerSensitive(MethodHandle mh) {
        return 0x100000 == (mh.rawModifiers & 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle penetrateSecurityFrame(MethodHandle potentialInjectFrame, MethodHandles.Lookup lookup) {
        MethodType originalMT = potentialInjectFrame.type;
        boolean mustBeVarags = false;
        if (potentialInjectFrame.kind == 17) {
            mustBeVarags = true;
            potentialInjectFrame = ((VarargsCollectorHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 13) {
            potentialInjectFrame = ((AsTypeHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 15) {
            potentialInjectFrame = ((FilterReturnHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 10) {
            potentialInjectFrame = ((CollectHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 13) {
            potentialInjectFrame = ((AsTypeHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 15) {
            potentialInjectFrame = ((FilterReturnHandle)potentialInjectFrame).next;
        }
        if (potentialInjectFrame.kind == 0) {
            ReceiverBoundHandle rbh = (ReceiverBoundHandle)potentialInjectFrame;
            final Object receiver = rbh.receiver;
            VMLangAccess vma = MethodHandles.Lookup.getVMLangAccess();
            ClassLoader rawLoader = vma.getClassloader(receiver.getClass());
            Class<?> injectedSecurityFrame = null;
            SecurityFrameInjectorLoaderLock securityFrameInjectorLoaderLock = loaderLock;
            synchronized (securityFrameInjectorLoaderLock) {
                injectedSecurityFrame = SecurityFrameInjector.probeLoaderToSecurityFrameMap(rawLoader);
            }
            if (injectedSecurityFrame == null || !injectedSecurityFrame.isInstance(receiver)) {
                return null;
            }
            final Class<?> finalInjectedSecurityFrame = injectedSecurityFrame;
            MethodHandle target = AccessController.doPrivileged(new PrivilegedAction<MethodHandle>(){

                @Override
                public MethodHandle run() {
                    try {
                        Field targetField = finalInjectedSecurityFrame.getDeclaredField("target");
                        targetField.setAccessible(true);
                        return (MethodHandle)targetField.get(receiver);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw (InternalError)new InternalError().initCause(e);
                    }
                }
            });
            Class targetAccessClass = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        Field targetField = finalInjectedSecurityFrame.getDeclaredField("accessClass");
                        targetField.setAccessible(true);
                        return (Class)targetField.get(receiver);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw (InternalError)new InternalError().initCause(e);
                    }
                }
            });
            if (lookup.accessMode != 16 && targetAccessClass != lookup.accessClass) {
                return null;
            }
            if (target.type == originalMT && MethodHandles.Lookup.isVarargs(target.rawModifiers) == mustBeVarags) {
                return target;
            }
        }
        return null;
    }

    static final class SecurityFrameInjectorLoaderLock {
        SecurityFrameInjectorLoaderLock() {
        }
    }
}

