/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;

public class LockInfo {
    String className;
    int identityHashCode;

    private LockInfo(Object object) {
        this.className = object.getClass().getName();
        this.identityHashCode = System.identityHashCode(object);
    }

    public LockInfo(String className, int identityHashCode) {
        if (className == null) {
            throw new NullPointerException(Msg.getString("K0600"));
        }
        this.className = className;
        this.identityHashCode = identityHashCode;
    }

    public String getClassName() {
        return this.className;
    }

    public int getIdentityHashCode() {
        return this.identityHashCode;
    }

    public static LockInfo from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        return ManagementUtils.getLockInfosFromCompositeData(compositeData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        sb.append('@');
        sb.append(Integer.toHexString(this.identityHashCode));
        return sb.toString();
    }
}

