/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.OpenTypeMappingIHandler;
import com.ibm.lang.management.PlatformMbeanListProvider;
import com.ibm.lang.management.UnixOperatingSystemMXBean;
import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformLoggingMXBean;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

public class ManagementFactory {
    private static MBeanServer platformServer;
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    private static final String BUFFERPOOL_MXBEAN_DOMAIN_TYPE = "java.nio:type=BufferPool";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    private static Map<String, String[]> interfaceNameLookupTable;
    private static Set<String> multiInstanceBeanNames;

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementUtils.getClassLoadingBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementUtils.getCompilationBean();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementUtils.getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementUtils.getMemoryManagerMXBeans();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementUtils.getMemoryBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementUtils.getMemoryPoolMXBeans();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementUtils.getOperatingSystemBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new MBeanServerPermission("createMBeanServer"));
        }
        Class<ManagementFactory> clazz = ManagementFactory.class;
        synchronized (ManagementFactory.class) {
            if (platformServer == null) {
                platformServer = MBeanServerFactory.createMBeanServer();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ManagementFactory.registerPlatformBeans(platformServer);
                        return null;
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return platformServer;
        }
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementUtils.getRuntimeBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementUtils.getThreadBean();
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection connection, String mxbeanName, Class<T> mxbeanInterface) throws IOException {
        ManagementFactory.verifyNamedMXBean(mxbeanName, mxbeanInterface);
        Object result = null;
        Class[] interfaces = null;
        interfaces = ManagementUtils.isANotificationEmitter(mxbeanInterface) ? new Class[]{mxbeanInterface, NotificationEmitter.class} : new Class[]{mxbeanInterface};
        result = Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)new OpenTypeMappingIHandler(connection, mxbeanInterface.getName(), mxbeanName));
        return (T)result;
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> mxbeanInterface) {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0601", mxbeanInterface.getName()));
        }
        if (multiInstanceBeanNames.contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0602", mxbeanInterface.getName()));
        }
        for (PlatformManagedObject bean : ManagementUtils.getAllAvailableMXBeans()) {
            if (!mxbeanInterface.isAssignableFrom(bean.getClass())) continue;
            return (T)bean;
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> mxbeanInterface) throws IllegalArgumentException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0601", mxbeanInterface.getName()));
        }
        LinkedList<PlatformManagedObject> matchedBeans = new LinkedList<PlatformManagedObject>();
        for (PlatformManagedObject bean : ManagementUtils.getAllAvailableMXBeans()) {
            if (!mxbeanInterface.isAssignableFrom(bean.getClass())) continue;
            matchedBeans.add(bean);
        }
        return matchedBeans;
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IOException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0601", mxbeanInterface.getName()));
        }
        if (multiInstanceBeanNames.contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0602", mxbeanInterface.getName()));
        }
        Set<ObjectName> beanNames = connection.queryNames(null, null);
        for (ObjectName objectName : beanNames) {
            boolean matches;
            block5: {
                matches = false;
                try {
                    matches = connection.isInstanceOf(objectName, mxbeanInterface.getName());
                }
                catch (InstanceNotFoundException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block5;
                    e.printStackTrace(System.err);
                }
            }
            if (!matches) continue;
            return (T)((PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(connection, objectName.toString(), mxbeanInterface));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection connection, Class<T> mxbeanInterface) throws IllegalArgumentException, IOException {
        if (!ManagementFactory.getPlatformManagementInterfaces().contains(mxbeanInterface)) {
            throw new IllegalArgumentException(Msg.getString("K0601", mxbeanInterface.getName()));
        }
        LinkedList<PlatformManagedObject> matchedBeans = new LinkedList<PlatformManagedObject>();
        Set<ObjectName> beanNames = connection.queryNames(null, null);
        for (ObjectName objectName : beanNames) {
            boolean matches;
            block4: {
                matches = false;
                try {
                    matches = connection.isInstanceOf(objectName, mxbeanInterface.getName());
                }
                catch (InstanceNotFoundException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block4;
                    e.printStackTrace(System.err);
                }
            }
            if (!matches) continue;
            PlatformManagedObject beanProxy = (PlatformManagedObject)ManagementFactory.newPlatformMXBeanProxy(connection, objectName.toString(), mxbeanInterface);
            matchedBeans.add(beanProxy);
        }
        return matchedBeans;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        List<Class> interfacesFromVMUtils;
        HashSet<Class<? extends PlatformManagedObject>> interfaces;
        block8: {
            interfaces = new HashSet<Class<? extends PlatformManagedObject>>();
            interfaces.add(ClassLoadingMXBean.class);
            interfaces.add(CompilationMXBean.class);
            interfaces.add(GarbageCollectorMXBean.class);
            interfaces.add(MemoryMXBean.class);
            interfaces.add(MemoryManagerMXBean.class);
            interfaces.add(MemoryPoolMXBean.class);
            interfaces.add(OperatingSystemMXBean.class);
            interfaces.add(RuntimeMXBean.class);
            interfaces.add(ThreadMXBean.class);
            interfaces.add(BufferPoolMXBean.class);
            interfaces.add(PlatformLoggingMXBean.class);
            interfaces.add(com.ibm.lang.management.GarbageCollectorMXBean.class);
            interfaces.add(com.ibm.lang.management.MemoryMXBean.class);
            interfaces.add(com.ibm.lang.management.MemoryPoolMXBean.class);
            interfaces.add(com.ibm.lang.management.OperatingSystemMXBean.class);
            if (ManagementUtils.isRunningOnUnix()) {
                interfaces.add(UnixOperatingSystemMXBean.class);
            }
            interfacesFromVMUtils = null;
            try {
                Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                interfacesFromVMUtils = pmp.getAllAvailableMBeanInterfaces();
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (InstantiationException e) {
                if (!ManagementUtils.VERBOSE_MODE) break block8;
                e.printStackTrace(System.err);
            }
        }
        if (interfacesFromVMUtils != null) {
            for (int i = 0; i < interfacesFromVMUtils.size(); ++i) {
                interfaces.add(interfacesFromVMUtils.get(i));
            }
        }
        return interfaces;
    }

    private static void verifyNamedMXBean(String mxbeanName, Class<?> mxbeanInterface) {
        String mxbeanInterfaceName;
        block11: {
            ObjectName mxbeanObjectName;
            if (mxbeanName == null) {
                throw new NullPointerException(Msg.getString("K0603"));
            }
            try {
                mxbeanObjectName = new ObjectName(mxbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException(Msg.getString("K0604", mxbeanName), e);
            }
            mxbeanInterfaceName = mxbeanInterface.getName();
            String[] validObjectNames = interfaceNameLookupTable.get(mxbeanInterfaceName);
            if (validObjectNames == null) break block11;
            if (multiInstanceBeanNames.contains(mxbeanInterfaceName)) {
                for (String expectedObjectName : validObjectNames) {
                    if (!mxbeanName.startsWith(expectedObjectName)) continue;
                    return;
                }
                for (String expectedObjectName : validObjectNames) {
                    try {
                        boolean isKeySame;
                        ObjectName on1 = new ObjectName(expectedObjectName);
                        String keyProperty1 = on1.getKeyProperty("type");
                        String keyProperty2 = mxbeanObjectName.getKeyProperty("type");
                        boolean bl = null == keyProperty1 ? null == keyProperty2 : (isKeySame = keyProperty1.equals(keyProperty2));
                        if (!on1.getDomain().equals(mxbeanObjectName.getDomain()) || !isKeySame) continue;
                        return;
                    }
                    catch (MalformedObjectNameException e) {
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            } else {
                for (String expectedObjectName : validObjectNames) {
                    if (!expectedObjectName.equals(mxbeanName)) continue;
                    return;
                }
            }
        }
        throw new IllegalArgumentException(Msg.getString("K0605", mxbeanName, mxbeanInterfaceName));
    }

    private static void registerPlatformBeans(MBeanServer platformServer) {
        block16: {
            List<PlatformManagedObject> beansFromVMUtils;
            block15: {
                beansFromVMUtils = null;
                try {
                    Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                    PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                    beansFromVMUtils = pmp.getAllAvailableMBeans();
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalAccessException e) {
                    if (ManagementUtils.VERBOSE_MODE) {
                        e.printStackTrace(System.err);
                    }
                }
                catch (InstantiationException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block15;
                    e.printStackTrace(System.err);
                }
            }
            try {
                List<PlatformManagedObject> beans = ManagementUtils.getAllAvailableMXBeans();
                if (beansFromVMUtils != null) {
                    beans.addAll(beansFromVMUtils);
                }
                for (PlatformManagedObject bean : beans) {
                    ObjectName objectName = bean.getObjectName();
                    if (platformServer.isRegistered(objectName)) continue;
                    platformServer.registerMBean(bean, objectName);
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (MBeanRegistrationException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (NotCompliantMBeanException e) {
                e.printStackTrace();
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (NullPointerException e) {
                if (!ManagementUtils.VERBOSE_MODE) break block16;
                e.printStackTrace(System.err);
            }
        }
    }

    static {
        List<PlatformManagedObject> beansFromVMUtils;
        List<Class> interfacesFromVMUtils;
        block14: {
            block13: {
                interfaceNameLookupTable = new HashMap<String, String[]>();
                interfaceNameLookupTable.put("java.lang.management.ClassLoadingMXBean", new String[]{CLASS_LOADING_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.MemoryMXBean", new String[]{MEMORY_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.ThreadMXBean", new String[]{THREAD_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.RuntimeMXBean", new String[]{RUNTIME_MXBEAN_NAME});
                interfaceNameLookupTable.put("com.ibm.lang.management.RuntimeMXBean", new String[]{RUNTIME_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.OperatingSystemMXBean", new String[]{OPERATING_SYSTEM_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.CompilationMXBean", new String[]{COMPILATION_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.GarbageCollectorMXBean", new String[]{GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.MemoryManagerMXBean", new String[]{MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE, GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.MemoryPoolMXBean", new String[]{MEMORY_POOL_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("java.lang.management.PlatformLoggingMXBean", new String[]{"java.util.logging:type=Logging"});
                interfaceNameLookupTable.put("java.util.logging.LoggingMXBean", new String[]{"java.util.logging:type=Logging"});
                interfaceNameLookupTable.put("com.ibm.lang.management.GarbageCollectorMXBean", new String[]{GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("com.ibm.lang.management.MemoryMXBean", new String[]{MEMORY_MXBEAN_NAME});
                interfaceNameLookupTable.put("com.ibm.lang.management.MemoryPoolMXBean", new String[]{MEMORY_POOL_MXBEAN_DOMAIN_TYPE});
                interfaceNameLookupTable.put("com.ibm.lang.management.OperatingSystemMXBean", new String[]{OPERATING_SYSTEM_MXBEAN_NAME});
                interfaceNameLookupTable.put("java.lang.management.BufferPoolMXBean", new String[]{BUFFERPOOL_MXBEAN_DOMAIN_TYPE});
                if (ManagementUtils.isRunningOnUnix()) {
                    interfaceNameLookupTable.put("com.ibm.lang.management.UnixOperatingSystemMXBean", new String[]{OPERATING_SYSTEM_MXBEAN_NAME});
                }
                interfacesFromVMUtils = null;
                try {
                    Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                    PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                    interfacesFromVMUtils = pmp.getAllAvailableMBeanInterfaces();
                }
                catch (ClassNotFoundException e) {
                }
                catch (IllegalAccessException e) {
                    if (ManagementUtils.VERBOSE_MODE) {
                        e.printStackTrace(System.err);
                    }
                }
                catch (InstantiationException e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block13;
                    e.printStackTrace(System.err);
                }
            }
            beansFromVMUtils = null;
            try {
                Class<?> object = Class.forName("com.ibm.lang.management.VmManagementUtils");
                PlatformMbeanListProvider pmp = (PlatformMbeanListProvider)object.newInstance();
                beansFromVMUtils = pmp.getAllAvailableMBeans();
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalAccessException e) {
                if (ManagementUtils.VERBOSE_MODE) {
                    e.printStackTrace(System.err);
                }
            }
            catch (InstantiationException e) {
                if (!ManagementUtils.VERBOSE_MODE) break block14;
                e.printStackTrace(System.err);
            }
        }
        String interfaceName = null;
        String objectName = null;
        if (interfacesFromVMUtils != null) {
            for (int i = 0; i < interfacesFromVMUtils.size(); ++i) {
                interfaceName = interfacesFromVMUtils.get(i).getName();
                objectName = beansFromVMUtils.get(i).getObjectName().toString();
                interfaceNameLookupTable.put(interfaceName, new String[]{objectName});
            }
        }
        multiInstanceBeanNames = new HashSet<String>();
        multiInstanceBeanNames.add("java.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryManagerMXBean");
        multiInstanceBeanNames.add("java.lang.management.MemoryPoolMXBean");
        multiInstanceBeanNames.add("com.ibm.lang.management.MemoryPoolMXBean");
    }
}

