/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class ThreadInfo {
    private long threadId;
    private long nativeTId;
    private String threadName;
    private Thread.State threadState;
    private boolean suspended;
    private boolean inNative;
    private long blockedCount;
    private long blockedTime;
    private long waitedCount;
    private long waitedTime;
    private String lockName;
    private long lockOwnerId = -1L;
    private String lockOwnerName;
    private StackTraceElement[] stackTraces = new StackTraceElement[0];
    private LockInfo lockInfo;
    private LockInfo[] lockedSynchronizers = new LockInfo[0];
    private MonitorInfo[] lockedMonitors = new MonitorInfo[0];
    private String TOSTRING_VALUE;

    private ThreadInfo(long threadIdVal, String threadNameVal, Thread.State threadStateVal, boolean suspendedVal, boolean inNativeVal, long blockedCountVal, long blockedTimeVal, long waitedCountVal, long waitedTimeVal, String lockNameVal, long lockOwnerIdVal, String lockOwnerNameVal, StackTraceElement[] stackTraceVal, LockInfo lockInfo, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this.threadId = threadIdVal;
        this.threadName = threadNameVal;
        this.threadState = threadStateVal;
        this.suspended = suspendedVal;
        this.inNative = inNativeVal;
        this.blockedCount = blockedCountVal;
        this.blockedTime = blockedTimeVal;
        this.waitedCount = waitedCountVal;
        this.waitedTime = waitedTimeVal;
        this.lockName = lockNameVal;
        this.lockOwnerId = lockOwnerIdVal;
        this.lockOwnerName = lockOwnerNameVal;
        this.stackTraces = stackTraceVal;
        this.lockInfo = lockInfo;
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
    }

    private ThreadInfo(Thread thread, long nativeId, int state, boolean isSuspended, boolean isInNative, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, Object blockingMonitor, Thread lockOwner) {
        this.threadId = thread.getId();
        this.nativeTId = nativeId;
        this.threadName = thread.getName();
        this.threadState = Thread.State.values()[state];
        this.suspended = isSuspended;
        this.inNative = isInNative;
        this.blockedCount = blockedCount;
        this.blockedTime = blockedTime;
        this.waitedCount = waitedCount;
        this.waitedTime = waitedTime;
        if (lockOwner != null) {
            this.lockOwnerId = lockOwner.getId();
            this.lockOwnerName = lockOwner.getName();
        }
        this.stackTraces = stackTrace;
        if (blockingMonitor != null) {
            this.lockName = blockingMonitor.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(blockingMonitor));
        }
    }

    private ThreadInfo(Thread thread, long nativeId, int state, boolean isSuspended, boolean isInNative, long blockedCount, long blockedTime, long waitedCount, long waitedTime, StackTraceElement[] stackTrace, Object blockingObject, Thread blockingObjectOwner, MonitorInfo[] lockedMonitors, LockInfo[] lockedSynchronizers) {
        this(thread, nativeId, state, isSuspended, isInNative, blockedCount, blockedTime, waitedCount, waitedTime, stackTrace, blockingObject, blockingObjectOwner);
        this.lockedMonitors = lockedMonitors;
        this.lockedSynchronizers = lockedSynchronizers;
        if (blockingObject != null) {
            this.lockInfo = new LockInfo(blockingObject.getClass().getName(), System.identityHashCode(blockingObject));
        }
        if (this.lockInfo != null) {
            this.lockName = this.lockInfo.toString();
        }
    }

    public long getBlockedCount() {
        return this.blockedCount;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTraces;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public MonitorInfo[] getLockedMonitors() {
        return this.lockedMonitors;
    }

    public LockInfo[] getLockedSynchronizers() {
        return this.lockedSynchronizers;
    }

    public static ThreadInfo from(CompositeData cd) {
        ThreadInfo result = null;
        if (cd != null) {
            StackTraceElement[] stackTraceVals;
            String lockOwnerNameVal;
            long lockOwnerIdVal;
            String lockNameVal;
            long waitedTimeVal;
            long waitedCountVal;
            long blockedTimeVal;
            long blockedCountVal;
            boolean inNativeVal;
            boolean suspendedVal;
            Thread.State threadStateVal;
            String threadNameVal;
            long threadIdVal;
            if (!ManagementUtils.getThreadInfoCompositeType().isValue(cd)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                threadIdVal = (Long)cd.get("threadId");
                threadNameVal = (String)cd.get("threadName");
                String threadStateStringVal = (String)cd.get("threadState");
                try {
                    threadStateVal = Thread.State.valueOf(threadStateStringVal);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(Msg.getString("K0612", e));
                }
                suspendedVal = (Boolean)cd.get("suspended");
                inNativeVal = (Boolean)cd.get("inNative");
                blockedCountVal = (Long)cd.get("blockedCount");
                blockedTimeVal = (Long)cd.get("blockedTime");
                waitedCountVal = (Long)cd.get("waitedCount");
                waitedTimeVal = (Long)cd.get("waitedTime");
                lockNameVal = cd.get("lockName") != null ? (String)cd.get("lockName") : null;
                lockOwnerIdVal = (Long)cd.get("lockOwnerId");
                lockOwnerNameVal = cd.get("lockOwnerName") != null ? (String)cd.get("lockOwnerName") : null;
                CompositeData[] stackTraceDataVal = (CompositeData[])cd.get("stackTrace");
                stackTraceVals = ManagementUtils.getStackTracesFromCompositeDataArray(stackTraceDataVal);
            }
            catch (InvalidKeyException e) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            LockInfo lockInfoVal = ThreadInfo.recoverLockInfoAttribute(cd, lockNameVal);
            MonitorInfo[] lockedMonitorVals = ThreadInfo.recoverLockedMonitors(cd);
            LockInfo[] lockedSynchronizerVals = ThreadInfo.recoverLockedSynchronizers(cd);
            result = new ThreadInfo(threadIdVal, threadNameVal, threadStateVal, suspendedVal, inNativeVal, blockedCountVal, blockedTimeVal, waitedCountVal, waitedTimeVal, lockNameVal, lockOwnerIdVal, lockOwnerNameVal, stackTraceVals, lockInfoVal, lockedMonitorVals, lockedSynchronizerVals);
        }
        return result;
    }

    private static LockInfo[] recoverLockedSynchronizers(CompositeData cd) {
        LockInfo[] result;
        try {
            CompositeData[] lockedSynchronizersDataVal = (CompositeData[])cd.get("lockedSynchronizers");
            result = ManagementUtils.getLockInfosFromCompositeDataArray(lockedSynchronizersDataVal);
        }
        catch (InvalidKeyException e) {
            result = new LockInfo[]{};
        }
        return result;
    }

    private static MonitorInfo[] recoverLockedMonitors(CompositeData cd) {
        MonitorInfo[] result;
        try {
            CompositeData[] lockedMonitorsDataVal = (CompositeData[])cd.get("lockedMonitors");
            result = ManagementUtils.getMonitorInfosFromCompositeDataArray(lockedMonitorsDataVal);
        }
        catch (InvalidKeyException e) {
            result = new MonitorInfo[]{};
        }
        return result;
    }

    private static LockInfo recoverLockInfoAttribute(CompositeData cd, String lockNameVal) {
        LockInfo result = null;
        try {
            CompositeData lockInfoCDVal;
            CompositeData compositeData = lockInfoCDVal = cd.get("lockInfo") != null ? (CompositeData)cd.get("lockInfo") : null;
            if (lockInfoCDVal != null) {
                if (!ManagementUtils.getLockInfoCompositeType().isValue(lockInfoCDVal)) {
                    throw new IllegalArgumentException(Msg.getString("K05E5"));
                }
                result = new LockInfo((String)lockInfoCDVal.get("className"), (Integer)lockInfoCDVal.get("identityHashCode"));
            }
        }
        catch (InvalidKeyException e) {
            result = ThreadInfo.createLockInfoFromLockName(lockNameVal);
        }
        return result;
    }

    public String toString() {
        if (this.TOSTRING_VALUE == null) {
            StringBuilder result = new StringBuilder();
            result.append(this.threadName + " " + this.threadId + " " + (Object)((Object)this.threadState));
            if (this.stackTraces != null && this.stackTraces.length > 0) {
                result.append("\n");
                for (StackTraceElement element : this.stackTraces) {
                    result.append(element.toString());
                    result.append("\n");
                }
            } else {
                result.append(" null\n");
            }
            this.TOSTRING_VALUE = result.toString();
        }
        return this.TOSTRING_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreadInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ThreadInfo ti = (ThreadInfo)obj;
        if (ti.getBlockedCount() != this.getBlockedCount()) {
            return false;
        }
        if (ti.getBlockedTime() != this.getBlockedTime()) {
            return false;
        }
        if (ti.getLockName() != null && this.getLockName() != null ? !ti.getLockName().equals(this.getLockName()) : ti.getLockName() != this.getLockName()) {
            return false;
        }
        if (ti.getLockOwnerId() != this.getLockOwnerId()) {
            return false;
        }
        if (ti.getLockOwnerName() != null && this.getLockOwnerName() != null ? !ti.getLockOwnerName().equals(this.getLockOwnerName()) : ti.getLockOwnerName() != this.getLockOwnerName()) {
            return false;
        }
        if (ti.getLockInfo() != null && this.getLockInfo() != null ? !ti.getLockInfo().toString().equals(this.getLockInfo().toString()) : ti.getLockInfo() != this.getLockInfo()) {
            return false;
        }
        if (!Arrays.equals(ti.getStackTrace(), this.getStackTrace())) {
            return false;
        }
        if (ti.getThreadId() != this.getThreadId()) {
            return false;
        }
        if (!ti.getThreadName().equals(this.getThreadName())) {
            return false;
        }
        if (!ti.getThreadState().equals((Object)this.getThreadState())) {
            return false;
        }
        if (ti.getWaitedCount() != this.getWaitedCount()) {
            return false;
        }
        if (ti.getWaitedTime() != this.getWaitedTime()) {
            return false;
        }
        if (ti.isInNative() != this.isInNative()) {
            return false;
        }
        return ti.isSuspended() == this.isSuspended();
    }

    public int hashCode() {
        return new String(Long.toString(this.getBlockedCount()) + Long.toString(this.getBlockedTime()) + this.getLockName() + Long.toString(this.getLockOwnerId()) + this.getLockOwnerName() + Integer.toString(this.getStackTrace().length) + Long.toString(this.getThreadId()) + this.getThreadName() + this.getThreadState().toString() + Long.toString(this.getWaitedCount()) + Long.toString(this.getWaitedTime()) + Boolean.toString(this.isInNative()) + Boolean.toString(this.isSuspended())).hashCode();
    }

    private static LockInfo createLockInfoFromLockName(String lockString) {
        StringTokenizer strTok;
        LockInfo result = null;
        if (lockString != null && lockString.length() > 0 && (strTok = new StringTokenizer(lockString, "@")).countTokens() == 2) {
            try {
                result = new LockInfo(strTok.nextToken(), Integer.valueOf(strTok.nextToken(), 16));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

