/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.ibm.oti.vm.VM;
import java.lang.ref.ReferenceQueue;

public abstract class Reference<T> {
    private static final int STATE_INITIAL = 0;
    private static final int STATE_CLEARED = 1;
    private static final int STATE_ENQUEUED = 2;
    private T referent;
    private ReferenceQueue queue;
    private int state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Reference reference = this;
        synchronized (reference) {
            this.referent = null;
            if (0 == this.state) {
                this.state = 1;
            }
        }
    }

    public boolean enqueue() {
        return this.enqueueImpl();
    }

    public T get() {
        if (VM.J9_GC_POLICY != VM.J9_GC_POLICY_METRONOME) {
            return this.referent;
        }
        return this.getImpl();
    }

    private native T getImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueImpl() {
        T tempReferent = this.referent;
        Reference reference = this;
        synchronized (reference) {
            ReferenceQueue tempQueue = this.queue;
            this.queue = null;
            if (this.state == 2 || tempQueue == null) {
                return false;
            }
            boolean result = tempQueue.enqueue(this);
            if (result) {
                this.state = 2;
                if (null != tempReferent) {
                    this.reprocess();
                }
            }
            return result;
        }
    }

    private native void reprocess();

    Reference() {
    }

    void initReference(T r) {
        this.state = 0;
        this.referent = r;
    }

    void initReference(T r, ReferenceQueue q) {
        this.queue = q;
        this.state = 0;
        this.referent = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue() {
        Reference reference = this;
        synchronized (reference) {
            this.state = 1;
        }
    }
}

