/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public final class Array {
    private Array() {
    }

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<? extends Object> arrayClass = array.getClass();
        if (arrayClass == int[].class) {
            return ((int[])array)[index];
        }
        if (arrayClass == boolean[].class) {
            return ((boolean[])array)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (arrayClass == float[].class) {
            return Float.valueOf(((float[])array)[index]);
        }
        if (arrayClass == char[].class) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (arrayClass == double[].class) {
            return ((double[])array)[index];
        }
        if (arrayClass == long[].class) {
            return ((long[])array)[index];
        }
        if (arrayClass == short[].class) {
            return ((short[])array)[index];
        }
        if (arrayClass == byte[].class) {
            return new Byte(((byte[])array)[index]);
        }
        try {
            return ((Object[])array)[index];
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static boolean getBoolean(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((boolean[])array)[index];
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((byte[])array)[index];
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static char getChar(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            return ((char[])array)[index];
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == double[].class) {
            return ((double[])array)[index];
        }
        return Array.getFloat(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == float[].class) {
            return ((float[])array)[index];
        }
        return Array.getLong(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<? extends Object> arrayClass = array.getClass();
        if (arrayClass == int[].class) {
            return ((int[])array)[index];
        }
        if (arrayClass == char[].class) {
            return ((char[])array)[index];
        }
        return Array.getShort(array, index);
    }

    public static int getLength(Object array) throws IllegalArgumentException {
        Class<? extends Object> arrayClass = array.getClass();
        if (arrayClass == int[].class) {
            return ((int[])array).length;
        }
        if (arrayClass == boolean[].class) {
            return ((boolean[])array).length;
        }
        if (arrayClass == float[].class) {
            return ((float[])array).length;
        }
        if (arrayClass == char[].class) {
            return ((char[])array).length;
        }
        if (arrayClass == double[].class) {
            return ((double[])array).length;
        }
        if (arrayClass == long[].class) {
            return ((long[])array).length;
        }
        if (arrayClass == short[].class) {
            return ((short[])array).length;
        }
        if (arrayClass == byte[].class) {
            return ((byte[])array).length;
        }
        try {
            return ((Object[])array).length;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == long[].class) {
            return ((long[])array)[index];
        }
        return Array.getInt(array, index);
    }

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == short[].class) {
            return ((short[])array)[index];
        }
        return Array.getByte(array, index);
    }

    private static native Object multiNewArrayImpl(Class var0, int var1, int[] var2);

    private static native Object newArrayImpl(Class var0, int var1);

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws NegativeArraySizeException, IllegalArgumentException {
        if (componentType == null) {
            throw new NullPointerException();
        }
        int length = dimensions.length;
        if (length < 1) {
            throw new IllegalArgumentException();
        }
        int[] reversed = new int[length];
        for (int i = 0; i < length; ++i) {
            if (dimensions[i] < 0) {
                throw new NegativeArraySizeException();
            }
            reversed[length - i - 1] = dimensions[i];
        }
        return Array.multiNewArrayImpl(componentType, length, reversed);
    }

    public static Object newInstance(Class<?> componentType, int size) throws NegativeArraySizeException {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (size < 0) {
            throw new NegativeArraySizeException();
        }
        return Array.newArrayImpl(componentType, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType != null && componentType.isPrimitive()) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            Class<? extends Object> valueClass = value.getClass();
            if (valueClass == Integer.class) {
                Array.setInt(array, index, (Integer)value);
                return;
            } else if (valueClass == Float.class) {
                Array.setFloat(array, index, ((Float)value).floatValue());
                return;
            } else if (valueClass == Double.class) {
                Array.setDouble(array, index, (Double)value);
                return;
            } else if (valueClass == Long.class) {
                Array.setLong(array, index, (Long)value);
                return;
            } else if (valueClass == Short.class) {
                Array.setShort(array, index, (Short)value);
                return;
            } else if (valueClass == Byte.class) {
                Array.setByte(array, index, (Byte)value);
                return;
            } else if (valueClass == Boolean.class) {
                Array.setBoolean(array, index, (Boolean)value);
                return;
            } else {
                if (valueClass != Character.class) throw new IllegalArgumentException();
                Array.setChar(array, index, ((Character)value).charValue());
            }
            return;
        }
        try {
            ((Object[])array)[index] = value;
            return;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void setBoolean(Object array, int index, boolean value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            ((boolean[])array)[index] = value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void setByte(Object array, int index, byte value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == byte[].class) {
            ((byte[])array)[index] = value;
        } else {
            Array.setShort(array, index, value);
        }
    }

    public static void setChar(Object array, int index, char value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == char[].class) {
            ((char[])array)[index] = value;
        } else {
            Array.setInt(array, index, value);
        }
    }

    public static void setDouble(Object array, int index, double value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            ((double[])array)[index] = value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static void setFloat(Object array, int index, float value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == float[].class) {
            ((float[])array)[index] = value;
        } else {
            Array.setDouble(array, index, value);
        }
    }

    public static void setInt(Object array, int index, int value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == int[].class) {
            ((int[])array)[index] = value;
        } else {
            Array.setLong(array, index, value);
        }
    }

    public static void setLong(Object array, int index, long value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == long[].class) {
            ((long[])array)[index] = value;
        } else {
            Array.setFloat(array, index, value);
        }
    }

    public static void setShort(Object array, int index, short value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array.getClass() == short[].class) {
            ((short[])array)[index] = value;
        } else {
            Array.setInt(array, index, value);
        }
    }
}

