/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.ArrayList;

public final class AccessControlContext {
    static final int STATE_NOT_AUTHORIZED = 0;
    static final int STATE_AUTHORIZED = 1;
    static final int STATE_UNKNOWN = 2;
    private static int debugSetting = -1;
    private static ArrayList<String> debugPermClassArray;
    private static ArrayList<String> debugPermNameArray;
    private static ArrayList<String> debugPermActionsArray;
    static ArrayList<URL> debugCodeBaseArray;
    private static final int DEBUG_UNINITIALIZED_HASCODEBASE = 0;
    private static final int DEBUG_NO_CODEBASE = 1;
    private static final int DEBUG_HAS_CODEBASE = 2;
    static final int DEBUG_DISABLED = 0;
    static final int DEBUG_ACCESS_DENIED = 1;
    static final int DEBUG_ENABLED = 2;
    DomainCombiner domainCombiner;
    ProtectionDomain[] context;
    int authorizeState = 2;
    private boolean containPrivilegedContext = false;
    private ProtectionDomain callerPD;
    AccessControlContext doPrivilegedAcc;
    boolean isLimitedContext = false;
    Permission[] limitedPerms;
    AccessControlContext nextStackAcc;
    private int debugHasCodebase;
    private static final SecurityPermission createAccessControlContext;
    private static final SecurityPermission getDomainCombiner;
    static final int DEBUG_ACCESS = 1;
    static final int DEBUG_ACCESS_STACK = 2;
    static final int DEBUG_ACCESS_DOMAIN = 4;
    static final int DEBUG_ACCESS_FAILURE = 8;
    static final int DEBUG_ACCESS_THREAD = 16;
    static final int DEBUG_ALL = 255;
    static final int CACHE_ARRAY_SIZE = 3;
    static final int CACHE_INDEX_PDS_IMPLIED = 0;
    static final int CACHE_INDEX_PERMS_IMPLIED = 1;
    static final int CACHE_INDEX_PERMS_NOT_IMPLIED = 2;

    static int debugSetting() {
        if (debugSetting != -1) {
            return debugSetting;
        }
        debugSetting = 0;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (value == null) {
            return debugSetting;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(value));
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 0x10FFFF);
        tokenizer.quoteChar(34);
        tokenizer.whitespaceChars(44, 44);
        try {
            while (tokenizer.nextToken() != -1) {
                String keyword = tokenizer.sval;
                if (keyword.equals("all")) {
                    debugSetting = 255;
                    return debugSetting;
                }
                if (keyword.startsWith("access:")) {
                    debugSetting |= 1;
                    keyword = keyword.substring(7);
                }
                if (keyword.equals("access")) {
                    debugSetting |= 1;
                    continue;
                }
                if (keyword.equals("stack")) {
                    debugSetting |= 2;
                    continue;
                }
                if (keyword.equals("domain")) {
                    debugSetting |= 4;
                    continue;
                }
                if (keyword.equals("failure")) {
                    debugSetting |= 8;
                    continue;
                }
                if (keyword.equals("thread")) {
                    debugSetting |= 0x10;
                    continue;
                }
                if (keyword.startsWith("permission=")) {
                    String debugPermClass = keyword.substring(11);
                    if (debugPermClass.isEmpty() && tokenizer.nextToken() != -1) {
                        debugPermClass = tokenizer.sval;
                    }
                    if (null == debugPermClassArray) {
                        debugPermClassArray = new ArrayList();
                    }
                    debugPermClassArray.add(debugPermClass);
                    continue;
                }
                if (keyword.startsWith("codebase=")) {
                    String codebase = keyword.substring(9);
                    if (codebase.isEmpty() && tokenizer.nextToken() != -1) {
                        codebase = tokenizer.sval;
                    }
                    URL debugCodeBase = null;
                    try {
                        debugCodeBase = new URL(codebase);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("Error setting -Djava.security.debug=access:codebase - " + e);
                    }
                    if (null == debugCodeBase) continue;
                    if (null == debugCodeBaseArray) {
                        debugCodeBaseArray = new ArrayList();
                    }
                    debugCodeBaseArray.add(debugCodeBase);
                    continue;
                }
                if (keyword.startsWith("permname=")) {
                    String debugPermName = keyword.substring(9);
                    if (debugPermName.isEmpty() && tokenizer.nextToken() != -1) {
                        debugPermName = tokenizer.sval;
                    }
                    if (null == debugPermNameArray) {
                        debugPermNameArray = new ArrayList();
                    }
                    debugPermNameArray.add(debugPermName);
                    continue;
                }
                if (!keyword.startsWith("permactions=")) continue;
                String debugPermActions = keyword.substring(12);
                if (debugPermActions.isEmpty() && tokenizer.nextToken() != -1) {
                    debugPermActions = tokenizer.sval;
                }
                if (null == debugPermActionsArray) {
                    debugPermActionsArray = new ArrayList();
                }
                debugPermActionsArray.add(debugPermActions);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (0 == (debugSetting & 1)) {
            debugSetting = 0;
        }
        return debugSetting;
    }

    static boolean debugPermission(Permission perm) {
        boolean result = true;
        if (debugPermClassArray != null) {
            result = false;
            String permClassName = perm.getClass().getName();
            for (String debugPermClass : debugPermClassArray) {
                if (!debugPermClass.equals(permClassName)) continue;
                return true;
            }
        }
        if (debugPermNameArray != null) {
            result = false;
            String permName = perm.getName();
            for (String debugPermName : debugPermNameArray) {
                if (!debugPermName.equals(permName)) continue;
                return true;
            }
        }
        if (debugPermActionsArray != null) {
            result = false;
            String permActions = perm.getActions();
            for (String debugPermActions : debugPermActionsArray) {
                if (!debugPermActions.equals(permActions)) continue;
                return true;
            }
        }
        return result;
    }

    boolean hasDebugCodeBase() {
        if (this.debugHasCodebase != 0) {
            return this.debugHasCodebase == 2;
        }
        ProtectionDomain[] pds = this.context;
        if (pds != null) {
            for (int i = 0; i < pds.length; ++i) {
                CodeSource cs;
                ProtectionDomain pd = this.context[i];
                CodeSource codeSource = cs = null == pd ? null : pd.getCodeSource();
                if (cs == null || !AccessControlContext.debugCodeBase(cs.getLocation())) continue;
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.doPrivilegedAcc != null && this.doPrivilegedAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
            if (this.nextStackAcc != null && this.nextStackAcc.hasDebugCodeBase()) {
                this.debugHasCodebase = 2;
                return true;
            }
        }
        this.debugHasCodebase = 1;
        return false;
    }

    static boolean debugCodeBase(URL location) {
        if (location != null) {
            for (URL debugCodeBase : debugCodeBaseArray) {
                if (!debugCodeBase.equals(location)) continue;
                return true;
            }
        }
        return false;
    }

    static void debugPrintAccess() {
        System.err.print("access: ");
        if ((AccessControlContext.debugSetting() & 0x10) == 16) {
            System.err.print("(" + Thread.currentThread() + ")");
        }
    }

    public AccessControlContext(ProtectionDomain[] fromContext) {
        int length = fromContext.length;
        if (length == 0) {
            this.context = null;
        } else {
            int domainIndex = 0;
            this.context = new ProtectionDomain[length];
            block0: for (int i = 0; i < length; ++i) {
                ProtectionDomain current = fromContext[i];
                if (current == null) continue;
                for (int j = 0; j < i; ++j) {
                    if (current == this.context[j]) continue block0;
                }
                this.context[domainIndex++] = current;
            }
            if (domainIndex == 0) {
                this.context = null;
            } else if (domainIndex != length) {
                ProtectionDomain[] copy = new ProtectionDomain[domainIndex];
                System.arraycopy((Object)this.context, 0, (Object)copy, 0, domainIndex);
                this.context = copy;
            }
        }
    }

    AccessControlContext(ProtectionDomain[] context, int authorizeState) {
        switch (authorizeState) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
        }
        this.context = context;
        this.authorizeState = authorizeState;
        this.containPrivilegedContext = true;
    }

    AccessControlContext(AccessControlContext acc, ProtectionDomain[] context, int authorizeState) {
        switch (authorizeState) {
            default: {
                throw new IllegalArgumentException();
            }
            case 1: {
                if (null == acc) break;
                this.domainCombiner = acc.domainCombiner;
            }
            case 0: 
        }
        this.doPrivilegedAcc = acc;
        this.context = context;
        this.authorizeState = authorizeState;
        this.containPrivilegedContext = true;
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        this(acc, combiner, false);
    }

    AccessControlContext(AccessControlContext acc, DomainCombiner combiner, boolean preauthorized) {
        SecurityManager security;
        if (!preauthorized && null != (security = System.getSecurityManager())) {
            security.checkPermission(createAccessControlContext);
        }
        this.authorizeState = 1;
        this.context = acc.context;
        this.domainCombiner = combiner;
        this.containPrivilegedContext = acc.containPrivilegedContext;
        this.isLimitedContext = acc.isLimitedContext;
        this.limitedPerms = acc.limitedPerms;
        this.nextStackAcc = acc.nextStackAcc;
        this.doPrivilegedAcc = acc.doPrivilegedAcc;
    }

    private static Object[] combineObjs(boolean objPDs, Object[] checked, Object[] toBeCombined, int start, int len, boolean justCombine) {
        if (null == toBeCombined) {
            return checked;
        }
        int lenChecked = null == checked ? 0 : checked.length;
        int lenTobeCombined = len > toBeCombined.length - start ? toBeCombined.length - start : len;
        Object[] answer = null;
        answer = objPDs ? new ProtectionDomain[lenChecked + lenTobeCombined] : new Permission[lenChecked + lenTobeCombined];
        if (null != checked) {
            System.arraycopy((Object)checked, 0, (Object)answer, 0, lenChecked);
        }
        if (justCombine) {
            System.arraycopy((Object)toBeCombined, start, (Object)answer, lenChecked, lenTobeCombined);
        } else {
            int counter = 0;
            for (int i = 0; i < lenTobeCombined; ++i) {
                if (null == toBeCombined[start + i]) continue;
                boolean found = false;
                for (int j = lenChecked + counter - 1; j >= 0; --j) {
                    if (toBeCombined[start + i] != answer[j]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                answer[lenChecked + counter++] = toBeCombined[start + i];
            }
            Object[] result = null;
            result = objPDs ? new ProtectionDomain[lenChecked + counter] : new Permission[lenChecked + counter];
            System.arraycopy((Object)answer, 0, (Object)result, 0, lenChecked + counter);
            answer = result;
        }
        return answer;
    }

    static ProtectionDomain[] combinePDObjs(ProtectionDomain[] checked, Object[] toBeCombined) {
        return (ProtectionDomain[])AccessControlContext.combineObjs(true, checked, toBeCombined, 0, null != toBeCombined ? toBeCombined.length : 0, false);
    }

    static Permission[] combinePermObjs(Permission[] checked, Permission[] toBeCombined, int start, int len, boolean justCombine) {
        return (Permission[])AccessControlContext.combineObjs(false, checked, toBeCombined, start, len, justCombine);
    }

    static int checkPermWithCachedPDsImplied(Permission perm, Object[] toCheck, Object[] cacheChecked) {
        if (null == toCheck) {
            return -1;
        }
        ProtectionDomain[] pdsImplied = null;
        if (null != cacheChecked) {
            pdsImplied = (ProtectionDomain[])cacheChecked[0];
        } else {
            cacheChecked = new Object[3];
        }
        for (int i = toCheck.length - 1; i >= 0; --i) {
            if (null == toCheck[i]) continue;
            if (null != pdsImplied) {
                boolean found = false;
                for (int j = 0; j < pdsImplied.length; ++j) {
                    boolean bl = found = toCheck[i] == pdsImplied[j];
                    if (found) break;
                }
                if (found) continue;
            }
            if (((ProtectionDomain)toCheck[i]).implies(perm)) continue;
            return i;
        }
        cacheChecked[0] = AccessControlContext.combinePDObjs(pdsImplied, toCheck);
        return -1;
    }

    static boolean checkPermWithCachedPermImplied(Permission perm, Permission[] permsLimited, Object[] cacheChecked) {
        if (null == permsLimited) {
            return false;
        }
        Permission[] permsImplied = null;
        Permission[] permsNotImplied = null;
        if (null != cacheChecked) {
            permsImplied = (Permission[])cacheChecked[1];
            permsNotImplied = (Permission[])cacheChecked[2];
        } else {
            cacheChecked = new Object[3];
        }
        boolean success = false;
        int lenNotImplied = permsLimited.length;
        for (int j = 0; j < permsLimited.length; ++j) {
            if (null == permsLimited[j]) continue;
            if (null != permsImplied) {
                for (int k = 0; k < permsImplied.length; ++k) {
                    if (permsLimited[j] != permsImplied[k]) continue;
                    success = true;
                    break;
                }
                if (success) {
                    lenNotImplied = j;
                    break;
                }
            }
            boolean notImplied = false;
            if (null != permsNotImplied) {
                for (int k = 0; k < permsNotImplied.length; ++k) {
                    if (permsLimited[j] != permsNotImplied[k]) continue;
                    notImplied = true;
                    lenNotImplied = j;
                    break;
                }
            }
            if (notImplied || !permsLimited[j].implies(perm)) continue;
            success = true;
            cacheChecked[1] = AccessControlContext.combinePermObjs(permsImplied, permsLimited, j, 1, true);
            lenNotImplied = j;
            break;
        }
        if (0 < lenNotImplied) {
            cacheChecked[2] = AccessControlContext.combinePermObjs(permsNotImplied, permsLimited, 0, lenNotImplied, false);
        }
        return success;
    }

    static boolean checkPermissionWithCache(Permission perm, Object[] pdsContext, int debug, AccessControlContext accCurrent, boolean isLimited, Permission[] permsLimited, AccessControlContext accNext, Object[] cacheChecked) throws AccessControlException {
        int i;
        if ((debug & 2) != 0 && (AccessControlContext.debugSetting() & 4) != 0) {
            AccessControlContext.debugPrintAccess();
            if (pdsContext == null || pdsContext.length == 0) {
                System.err.println("domain (context is null)");
            } else {
                for (i = 0; i < pdsContext.length; ++i) {
                    System.err.println("domain " + i + " " + pdsContext[i]);
                }
            }
        }
        i = pdsContext == null ? 0 : pdsContext.length;
        i = AccessControlContext.checkPermWithCachedPDsImplied(perm, pdsContext, cacheChecked);
        if (0 <= i) {
            if ((debug & 1) != 0 && (AccessControlContext.debugSetting() & 1) != 0) {
                AccessControlContext.debugPrintAccess();
                System.err.println("access denied " + perm);
            }
            if ((debug & 1) != 0 && (AccessControlContext.debugSetting() & 8) != 0) {
                new Exception("Stack trace").printStackTrace();
                System.err.println("domain that failed " + pdsContext[i]);
            }
            throw new AccessControlException(Msg.getString("K002c", perm), perm);
        }
        if (null != accCurrent && (null != accCurrent.context || null != accCurrent.doPrivilegedAcc || null != accCurrent.limitedPerms || null != accCurrent.nextStackAcc)) {
            AccessControlContext.checkPermissionWithCache(perm, accCurrent.context, debug, accCurrent.doPrivilegedAcc, accCurrent.isLimitedContext, accCurrent.limitedPerms, accCurrent.nextStackAcc, cacheChecked);
        }
        if (isLimited && null != permsLimited) {
            if (AccessControlContext.checkPermWithCachedPermImplied(perm, permsLimited, cacheChecked)) {
                return true;
            }
            if (null != accNext) {
                AccessControlContext.checkPermissionWithCache(perm, accNext.context, debug, accNext.doPrivilegedAcc, accNext.isLimitedContext, accNext.limitedPerms, accNext.nextStackAcc, cacheChecked);
            }
            return false;
        }
        if ((debug & 2) != 0) {
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + perm);
        }
        return true;
    }

    private boolean debugHelper(Permission perm) {
        boolean debug = true;
        if (debugCodeBaseArray != null) {
            debug = this.hasDebugCodeBase();
        }
        if (debug) {
            debug = AccessControlContext.debugPermission(perm);
        }
        if (debug && (AccessControlContext.debugSetting() & 2) != 0) {
            new Exception("Stack trace for " + perm).printStackTrace();
        }
        return debug;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        boolean debug;
        if (perm == null) {
            throw new NullPointerException();
        }
        if (null != this.context && 1 != this.authorizeState && this.containPrivilegedContext && null != System.getSecurityManager()) {
            if (2 == this.authorizeState) {
                this.authorizeState = null == this.callerPD || this.callerPD.implies(createAccessControlContext) ? 1 : 0;
                this.callerPD = null;
            }
            if (0 == this.authorizeState) {
                throw new AccessControlException(Msg.getString("K002d", perm, createAccessControlContext), perm);
            }
        }
        boolean bl = debug = (AccessControlContext.debugSetting() & 1) != 0;
        if (debug) {
            debug = this.debugHelper(perm);
        }
        AccessControlContext.checkPermissionWithCache(perm, this.context, debug ? 3 : 0, this.doPrivilegedAcc, this.isLimitedContext, this.limitedPerms, this.nextStackAcc, new Object[3]);
    }

    public boolean equals(Object o) {
        int olength;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessControlContext otherContext = (AccessControlContext)o;
        if (null == this.domainCombiner && null != otherContext.domainCombiner || null != this.domainCombiner && !this.domainCombiner.equals(otherContext.domainCombiner)) {
            return false;
        }
        if (this.isLimitedContext != otherContext.isLimitedContext) {
            return false;
        }
        ProtectionDomain[] otherDomains = otherContext.context;
        int length = this.context == null ? 0 : this.context.length;
        int n = olength = otherDomains == null ? 0 : otherDomains.length;
        if (length != olength) {
            return false;
        }
        block0: for (int i = 0; i < length; ++i) {
            ProtectionDomain current = this.context[i];
            for (int j = 0; j < length; ++j) {
                if (null == current && null == otherDomains[j] || null != current && current.equals(otherDomains[j])) continue block0;
            }
            return false;
        }
        if (null != this.doPrivilegedAcc && !this.doPrivilegedAcc.equals(otherContext.doPrivilegedAcc)) {
            return false;
        }
        if (this.isLimitedContext) {
            int opermsLen;
            Permission[] otherLimitedPerms = otherContext.limitedPerms;
            int permsLen = null == this.limitedPerms ? 0 : this.limitedPerms.length;
            int n2 = opermsLen = null == otherLimitedPerms ? 0 : otherLimitedPerms.length;
            if (permsLen != opermsLen) {
                return false;
            }
            block2: for (int i = 0; i < permsLen; ++i) {
                Permission current = this.limitedPerms[i];
                for (int j = 0; j < opermsLen; ++j) {
                    if (null == current && null == otherLimitedPerms[j] || null != current && current.equals(otherLimitedPerms[j])) continue block2;
                }
                return false;
            }
            if (null != this.nextStackAcc) {
                return this.nextStackAcc.equals(otherContext.nextStackAcc);
            }
        }
        return true;
    }

    public int hashCode() {
        int i;
        int result = 0;
        int n = i = this.context == null ? 0 : this.context.length;
        while (--i >= 0) {
            result ^= this.context[i].hashCode();
        }
        if (null != this.doPrivilegedAcc) {
            result ^= this.doPrivilegedAcc.hashCode();
        }
        if (this.isLimitedContext) {
            int n2 = i = this.limitedPerms == null ? 0 : this.limitedPerms.length;
            while (--i >= 0) {
                if (null == this.limitedPerms[i]) continue;
                result ^= this.limitedPerms[i].hashCode();
            }
            if (null != this.nextStackAcc) {
                result ^= this.nextStackAcc.hashCode();
            }
        }
        return result;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(getDomainCombiner);
        }
        return this.domainCombiner;
    }

    DomainCombiner getCombiner() {
        return this.domainCombiner;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    AccessControlContext(ProtectionDomain[] domains, AccessControlContext acc) {
        int len = 0;
        int size = domains == null ? 0 : domains.length;
        int extra = 0;
        if (acc != null && acc.context != null) {
            extra = acc.context.length;
        }
        ProtectionDomain[] answer = new ProtectionDomain[size + extra];
        for (int i = 0; i < size; ++i) {
            boolean found = false;
            answer[len] = domains[i];
            if (answer[len] == null) break;
            if (acc != null && acc.context != null) {
                for (int j = 0; j < acc.context.length; ++j) {
                    if (answer[len] != acc.context[j]) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            ++len;
        }
        if (len == 0 && acc != null) {
            this.context = acc.context;
        } else if (len + extra == 0) {
            this.context = null;
        } else {
            if (len < size) {
                ProtectionDomain[] copy = new ProtectionDomain[len + extra];
                System.arraycopy((Object)answer, 0, (Object)copy, 0, len);
                answer = copy;
            }
            if (acc != null && acc.context != null) {
                System.arraycopy((Object)acc.context, 0, (Object)answer, len, acc.context.length);
            }
            this.context = answer;
        }
        this.authorizeState = 1;
        this.containPrivilegedContext = true;
        if (null != acc && 1 == acc.authorizeState) {
            this.domainCombiner = acc.domainCombiner;
        }
    }

    AccessControlContext optimize() {
        return this;
    }

    static {
        createAccessControlContext = new SecurityPermission("createAccessControlContext");
        getDomainCombiner = new SecurityPermission("getDomainCombiner");
    }
}

