/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

final class ZipEntryExtraInfo {
    static final short HEADER_ID_ExtendedTimestamp = 21589;
    static final short HEADER_ID_NTFS = 10;
    final byte[] extra;
    final int offset;
    final short headerId;
    final short dataSize;

    private ZipEntryExtraInfo(byte[] extra, int offset, short headerId, short dataSize) {
        this.extra = extra;
        this.offset = offset;
        this.headerId = headerId;
        this.dataSize = dataSize;
    }

    static int read2Bytes(byte[] data, int offset) {
        int low = Byte.toUnsignedInt(data[offset]);
        int high = Byte.toUnsignedInt(data[offset + 1]) << 8;
        return high | low;
    }

    static long read4Bytes(byte[] data, int offset) {
        int low = ZipEntryExtraInfo.read2Bytes(data, offset);
        int high = ZipEntryExtraInfo.read2Bytes(data, offset + 2) << 16;
        return (long)(high | low) & 0xFFFFFFFFL;
    }

    static long read8Bytes(byte[] data, int offset) {
        long low = ZipEntryExtraInfo.read4Bytes(data, offset);
        long high = ZipEntryExtraInfo.read4Bytes(data, offset + 4) << 32;
        return high | low;
    }

    static short readShort(byte[] data, int offset) {
        return (short)ZipEntryExtraInfo.read2Bytes(data, offset);
    }

    static int readInt(byte[] data, int offset) {
        return (int)ZipEntryExtraInfo.read4Bytes(data, offset);
    }

    static long readLong(byte[] data, int offset) {
        return ZipEntryExtraInfo.read8Bytes(data, offset);
    }

    static ZipEntryExtraInfo fromExtra(byte[] extra, int offset) {
        if (null == extra) {
            return null;
        }
        int infoLen = extra.length - offset;
        if (infoLen < 4) {
            return null;
        }
        int pos = offset;
        short headerId = ZipEntryExtraInfo.readShort(extra, pos);
        int dataLenLimit = infoLen - 4;
        short dataSize = ZipEntryExtraInfo.readShort(extra, pos + 2);
        if (dataLenLimit < dataSize) {
            return null;
        }
        return new ZipEntryExtraInfo(extra, offset, headerId, dataSize);
    }

    final short getDataSize() {
        return this.dataSize;
    }

    final int getDataOffset() {
        return this.offset + 4;
    }

    final int getTotalLength() {
        return this.dataSize + 4;
    }
}

