/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import sun.misc.VM;
import sun.nio.cs.AbstractCharsetProvider;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class ExtendedCharsets
extends AbstractCharsetProvider {
    static volatile ExtendedCharsets instance = null;
    private boolean initialized = false;
    private static volatile boolean swapLF = false;
    private static final String EXCLUDE_LIST_NAME = "/sun/nio/cs/ext/sfj-excludes-charsets";
    private static final boolean empty;
    private static final Set<String> excludedCharsetsList;

    public ExtendedCharsets() {
        super("sun.nio.cs.ext");
        this.charset("hp-roman8", "Roman8", new String[]{"hp-roman8", "r8", "ibm-1051", "roman8", "ibm1051", "1051", "cp1051"});
        this.charset("x-IBM1088", "IBM1088", new String[]{"cp1088", "ibm-1088", "1088", "ibm1088"});
        this.charset("x-IBM808", "IBM808", new String[]{"cp808", "ibm-808", "ibm808", "808"});
        this.charset("x-IBM859", "IBM859", new String[]{"cp859", "ibm-859", "ibm859", "859"});
        this.charset("IBM00924", "IBM924", new String[]{"cp924", "ibm-924", "ibm00924", "ccsid00924", "cp00924", "ibm924", "924", "ebcdic-latin9--euro"});
        this.charset("x-IBM924_LF", "IBM924_LF", new String[]{"cp924_lf", "ibm-924_lf", "ibm924_lf", "924_lf"});
        this.charset("ISO-8859-10", "ISO8859_10", new String[]{"8859_10", "iso-ir-157", "iso-8859-10", "iso8859-10", "latin6", "iso8859_10", "l6", "csisolatin6", "iso_8859-10:1992", "ibm-919", "ibm919", "cp919", "919", "8859-10"});
        this.charset("ISO-8859-14", "ISO8859_14", new String[]{"8859_14", "iso-ir-199", "iso-8859-14", "iso8859-14", "latin8", "l8", "iso-celtic", "isoceltic", "iso_8859-14", "iso8859_14", "iso_8859-14:1998", "8859-14"});
        this.charset("ISO-8859-16", "ISO8859_16", new String[]{"8859_16", "iso-8859-16", "iso-ir-226", "iso_8859-16:2001", "iso_8859-16", "latin10", "iso8859_16", "l10", "iso8859-16", "8859-16"});
        this.charset("x-KOI8_RU", "KOI8_RU", new String[]{"koi8-ru", "ibm-1167", "ibm1167", "cp1167", "1167", "koi8_ru"});
        this.charset("PTCP154", "PTCP154", new String[]{"ibm-1169", "ibm1169", "cp1169", "1169", "ptcp154", "pt154", "csptcp154", "cyrillic-asian"});
        this.charset("Big5", "Big5", new String[]{"csBig5", "big5-0"});
        this.charset("x-MS950-HKSCS-XP", "MS950_HKSCS_XP", new String[]{"MS950_HKSCS_XP"});
        this.charset("x-MS950-HKSCS", "MS950_HKSCS", new String[]{"MS950_HKSCS"});
        this.charset("x-windows-950", "MS950", new String[]{"ms950", "windows-950"});
        this.charset("windows-874", "MS874", new String[]{"ms874", "ms-874", "x-windows-874", "windows-874"});
        this.charset("x-EUC-TW", "EUC_TW", new String[]{"euc_tw", "euctw", "cns11643", "euc-tw", "x-euc-tw", "x-EUC_TW"});
        this.charset("Big5-HKSCS", "Big5_HKSCS", new String[]{"big5_hkscs", "big5hk", "big5-hkscs", "big5hkscs"});
        this.charset("x-Big5-HKSCS-2001", "Big5_HKSCS_2001", new String[]{"Big5_HKSCS_2001", "big5hk-2001", "big5-hkscs-2001", "big5-hkscs:unicode3.0", "big5hkscs-2001"});
        this.charset("x-Big5-Solaris", "Big5_Solaris", new String[]{"Big5_Solaris"});
        this.charset("GBK", "GBK", new String[]{"ibm-936", "ibm936", "cp936", "936"});
        this.charset("GB18030", "GB18030", new String[]{"gb18030-2000", "ibm-1392", "ibm1392", "cp1392", "1392", "windows-54936"});
        this.charset("GB2312", "EUC_CN", new String[]{"euc-cn", "euccn", "x-euc-cn", "euc_cn", "x-euc_cn", "gb2312", "gb2312-80", "gb2312-1980"});
        this.charset("x-mswin-936", "MS936", new String[]{"ms936", "ms_936", "windows-936", "x-mswin-936"});
        this.charset("x-mswin-936A", "MS936A", new String[]{"ms936A", "ms_936A", "x-mswin-936A", "936A", "bestfit936"});
        this.charset("Shift_JIS", "SJIS", new String[]{"sjis", "shift_jis", "shift-jis", "ms_kanji", "x-sjis", "csShiftJIS"});
        this.charset("windows-31j", "MS932", new String[]{"MS932", "windows-932", "csWindows31J"});
        this.charset("JIS_X0201", "JIS_X_0201", new String[]{"JIS0201", "JIS_X0201", "X0201", "csHalfWidthKatakana"});
        this.charset("x-JIS0208", "JIS_X_0208", new String[]{"JIS0208", "JIS_C6226-1983", "iso-ir-87", "x0208", "JIS_X0208-1983", "csISO87JISX0208"});
        this.charset("JIS_X0212-1990", "JIS_X_0212", new String[]{"JIS0212", "jis_x0212-1990", "x0212", "iso-ir-159", "csISO159JISX02121990"});
        this.charset("x-SJIS_0213", "SJIS_0213", new String[]{"sjis-0213", "sjis_0213", "sjis:2004", "sjis_0213:2004", "shift_jis_0213:2004", "shift_jis:2004"});
        this.charset("x-MS932_0213", "MS932_0213", new String[]{"MS932-0213", "MS932_0213", "MS932:2004", "windows-932-0213", "windows-932:2004"});
        this.charset("EUC-JP", "EUC_JP", new String[]{"euc_jp", "eucjis", "eucjp", "extended_unix_code_packed_format_for_japanese", "cseucpkdfmtjapanese", "x-euc-jp", "x-eucjp"});
        this.charset("x-euc-jp-linux", "EUC_JP_LINUX", new String[]{"euc_jp_linux", "euc-jp-linux", "x-euc_jp_linux"});
        this.charset("x-eucjp-open", "EUC_JP_Open", new String[]{"euc_jp_solaris", "eucjp-open"});
        this.charset("x-PCK", "PCK", new String[]{"pck"});
        this.charset("ISO-2022-JP", "ISO2022_JP", new String[]{"iso2022jp", "jis", "csISO2022JP", "jis_encoding", "csjisencoding", "iso2022-jp", "jis-encoding"});
        this.charset("ISO-2022-JP-2", "ISO2022_JP_2", new String[]{"csISO2022JP2", "iso2022jp2", "iso-2022-jp2"});
        this.charset("x-windows-50221", "MS50221", new String[]{"ms50221", "cp50221"});
        this.charset("x-windows-50220", "MS50220", new String[]{"ms50220", "cp50220"});
        this.charset("x-windows-iso2022jp", "MSISO2022JP", new String[]{"windows-iso2022jp"});
        this.charset("x-JISAutoDetect", "JISAutoDetect", new String[]{"JISAutoDetect"});
        this.charset("x-IBM-udcJP", "IBMUDCJP", new String[]{"IBM-udcJP", "ibmudcJP", "cpudcJP", "udcJP"});
        this.charset("x-KSC5601", "KSC5601", new String[]{"ksc5601"});
        this.charset("EUC-KR", "EUC_KR", new String[]{"euc_kr", "euckr", "ks_c_5601-1987", "ksc5601-1987", "ksc5601_1987", "ksc_5601", "cseuckr", "ks-c-5601-1987", "euc-kr", "ksc-5601", "5601"});
        this.charset("x-windows-949", "MS949", new String[]{"ms949", "windows949", "windows-949", "ms_949", "cp1361", "ibm-1361", "ibm1361", "1361"});
        this.charset("x-Johab", "Johab", new String[]{"ksc5601-1992", "ksc5601_1992", "ms1361", "johab"});
        this.charset("ISO-2022-KR", "ISO2022_KR", new String[]{"ISO2022KR", "csISO2022KR", "iso-2022-kr", "iso2022-kr"});
        this.charset("ISO-2022-CN", "ISO2022_CN", new String[]{"ISO2022CN", "csISO2022CN", "iso2022-cn", "iso-2022-cn-ext", "iso-2022-cn"});
        this.charset("x-ISO-2022-CN-CNS", "ISO2022_CN_CNS", new String[]{"ISO2022CN_CNS", "ISO-2022-CN-CNS", "iso2022-cn-cns", "iso2022cn-cns", "iso2022_cn_cns"});
        this.charset("x-ISO-2022-CN-GB", "ISO2022_CN_GB", new String[]{"ISO2022CN_GB", "ISO-2022-CN-GB", "iso2022-cn-gb", "iso2022cn-gb"});
        this.charset("x-ISCII91", "ISCII91", new String[]{"iscii", "ST_SEV_358-88", "iso-ir-153", "csISO153GOST1976874", "ISCII91"});
        this.charset("ISO-8859-3", "ISO_8859_3", new String[]{"iso8859_3", "8859_3", "iso-8859-3:1988", "iso_8859-3:1988", "iso-ir-109", "iso_8859-3", "iso8859-3", "latin3", "l3", "ibm913", "ibm-913", "cp913", "913", "csISOLatin3", "8859-3"});
        this.charset("ISO-8859-6", "ISO_8859_6", new String[]{"iso8859_6", "8859_6", "iso-ir-127", "iso_8859-6", "iso-8859-6:1987", "iso_8859-6:1987", "iso8859-6", "ecma-114", "asmo-708", "arabic", "ibm1089", "ibm-1089", "cp1089", "1089", "csISOLatinArabic", "8859-6"});
        this.charset("x-ISO-8859-6S", "ISO_8859_6S", new String[]{"iso8859-6s", "8859_6s", "iso-8859-6s", "iso8859-6s", "iso8859_6s"});
        this.charset("ISO-8859-8", "ISO_8859_8", new String[]{"iso8859_8", "8859_8", "iso-ir-138", "iso_8859-8", "iso-8859-8:1988", "iso_8859-8:1988", "iso8859-8", "cp916", "916", "ibm916", "ibm-916", "hebrew", "csISOLatinHebrew", "8859-8"});
        this.charset("x-ISO-8859-11", "ISO_8859_11", new String[]{"iso-8859-11", "iso8859_11"});
        this.charset("TIS-620", "TIS_620", new String[]{"tis620", "tis620.2533"});
        this.charset("windows-1255", "MS1255", new String[]{"cp1255", "ibm-1255", "ibm1255", "1255"});
        this.charset("windows-1256", "MS1256", new String[]{"cp1256", "ibm-1256", "ibm1256", "1256"});
        this.charset("x-windows-1256S", "IBM1256S", new String[]{"cp1256s", "ibm-1256s", "windows-1256s", "ibm1256s", "1256s"});
        this.charset("windows-1258", "MS1258", new String[]{"cp1258", "ibm-1258", "ibm1258", "1258"});
        this.charset("x-IBM941", "IBM941", new String[]{"cp941", "ibm941", "ibm-941", "941"});
        this.charset("x-IBM942", "IBM942", new String[]{"cp942", "ibm942", "ibm-942", "942"});
        this.charset("x-IBM1041", "IBM1041", new String[]{"cp1041", "ibm1041", "ibm-1041", "1041"});
        this.charset("x-IBM1043", "IBM1043", new String[]{"cp1043", "ibm1043", "ibm-1043", "1043"});
        this.charset("x-IBM1114", "IBM1114", new String[]{"cp1114", "ibm1114", "ibm-1114", "1114"});
        this.charset("x-IBM1115", "IBM1115", new String[]{"cp1115", "ibm1115", "ibm-1115", "1115"});
        this.charset("x-IBM1351", "IBM1351", new String[]{"cp1351", "ibm1351", "ibm-1351", "1351"});
        this.charset("x-IBM1370", "IBM1370", new String[]{"cp1370", "ibm1370", "ibm-1370", "1370"});
        this.charset("x-IBM1380", "IBM1380", new String[]{"cp1380", "ibm1380", "ibm-1380", "1380"});
        this.charset("x-IBM301", "IBM301", new String[]{"cp301", "ibm301", "ibm-301", "301"});
        this.charset("x-IBM897", "IBM897", new String[]{"cp897", "ibm897", "ibm-897", "897"});
        this.charset("x-IBM927", "IBM927", new String[]{"cp927", "ibm927", "ibm-927", "927"});
        this.charset("x-IBM942C", "IBM942C", new String[]{"cp932", "ibm932", "ibm-932", "932", "cp942c", "ibm942c", "ibm-942c", "942c", "x-ibm932", "x-ibm942c"});
        this.charset("x-IBM947", "IBM947", new String[]{"cp947", "ibm947", "ibm-947", "947"});
        this.charset("x-IBM951", "IBM951", new String[]{"cp951", "ibm951", "ibm-951", "951"});
        this.charset("x-IBM1385", "IBM1385", new String[]{"cp1385", "ibm1385", "ibm-1385", "1385"});
        this.charset("x-IBM1386", "IBM1386", new String[]{"cp1386", "x-ibm1386", "ibm1386", "ibm-1386", "1386"});
        this.charset("x-IBM943", "IBM943", new String[]{"cp943", "ibm943", "ibm-943", "943"});
        this.charset("x-IBM943C", "IBM943C", new String[]{"cp943c", "ibm943c", "ibm-943c", "943c"});
        this.charset("x-IBM948", "IBM948", new String[]{"cp948", "ibm948", "ibm-948", "948"});
        this.charset("x-IBM950", "IBM950", new String[]{"cp950", "ibm950", "ibm-950", "950"});
        this.charset("x-IBM954", "IBM954", new String[]{"cp954", "ibm954", "ibm-954", "954"});
        this.charset("x-IBM954C", "IBM954C", new String[]{"cp954c", "ibm954c", "ibm-954c", "954c"});
        this.charset("x-IBM930", "IBM930", new String[]{"cp930", "ibm930", "ibm-930", "930", "Cp5026", "ibm5026", "ibm-5026", "5026"});
        this.charset("x-IBM930A", "IBM930A", new String[]{"cp930A", "ibm930A", "ibm-930A", "930A"});
        this.charset("x-IBM935", "IBM935", new String[]{"cp935", "ibm935", "ibm-935", "935"});
        this.charset("x-IBM937", "IBM937", new String[]{"cp937", "ibm937", "ibm-937", "937"});
        this.charset("x-IBM856", "IBM856", new String[]{"cp856", "ibm-856", "ibm856", "856"});
        this.charset("IBM860", "IBM860", new String[]{"cp860", "ibm860", "ibm-860", "860", "csIBM860"});
        this.charset("IBM861", "IBM861", new String[]{"cp861", "ibm861", "ibm-861", "861", "csIBM861", "cp-is"});
        this.charset("IBM863", "IBM863", new String[]{"cp863", "ibm863", "ibm-863", "863", "csIBM863"});
        this.charset("IBM864", "IBM864", new String[]{"cp864", "ibm864", "ibm-864", "864", "csIBM864"});
        this.charset("x-IBM864S", "IBM864S", new String[]{"cp864s", "ibm864s", "ibm-864s", "864s", "csibm864s"});
        this.charset("IBM865", "IBM865", new String[]{"cp865", "ibm865", "ibm-865", "865", "csIBM865"});
        this.charset("IBM868", "IBM868", new String[]{"cp868", "ibm868", "ibm-868", "868", "cp-ar", "csIBM868"});
        this.charset("IBM869", "IBM869", new String[]{"cp869", "ibm869", "ibm-869", "869", "cp-gr", "csIBM869"});
        this.charset("x-IBM921", "IBM921", new String[]{"cp921", "ibm921", "ibm-921", "921"});
        this.charset("x-IBM1006", "IBM1006", new String[]{"cp1006", "ibm1006", "ibm-1006", "1006"});
        this.charset("x-IBM1046", "IBM1046", new String[]{"cp1046", "ibm1046", "ibm-1046", "1046"});
        this.charset("x-IBM1046S", "IBM1046S", new String[]{"cp1046s", "ibm1046s", "ibm-1046s", "1046s"});
        this.charset("IBM1047", "IBM1047", new String[]{"cp1047", "ibm1047", "ibm-1047", "1047"});
        this.charset("x-IBM1047_LF", "IBM1047_LF", new String[]{"cp1047_lf", "ibm1047_lf", "ibm-1047_lf", "1047_lf"});
        this.charset("x-IBM1098", "IBM1098", new String[]{"cp1098", "ibm1098", "ibm-1098", "1098"});
        this.charset("IBM037", "IBM037", new String[]{"cp037", "ibm037", "ebcdic-cp-us", "ebcdic-cp-ca", "ebcdic-cp-wt", "ebcdic-cp-nl", "csIBM037", "cs-ebcdic-cp-us", "cs-ebcdic-cp-ca", "cs-ebcdic-cp-wt", "cs-ebcdic-cp-nl", "ibm-037", "ibm-37", "cpibm37", "037"});
        this.charset("x-IBM1025", "IBM1025", new String[]{"cp1025", "ibm1025", "ibm-1025", "1025"});
        this.charset("IBM1026", "IBM1026", new String[]{"cp1026", "ibm1026", "ibm-1026", "1026"});
        this.charset("x-IBM1027", "IBM1027", new String[]{"cp1027", "ibm1027", "ibm-1027", "1027"});
        this.charset("x-IBM1112", "IBM1112", new String[]{"cp1112", "ibm1112", "ibm-1112", "1112"});
        this.charset("x-IBM1122", "IBM1122", new String[]{"cp1122", "ibm1122", "ibm-1122", "1122"});
        this.charset("x-IBM1123", "IBM1123", new String[]{"cp1123", "ibm1123", "ibm-1123", "1123"});
        this.charset("x-IBM1124", "IBM1124", new String[]{"cp1124", "ibm1124", "ibm-1124", "1124"});
        this.charset("x-IBM1129", "IBM1129", new String[]{"cp1129", "ibm1129", "ibm-1129", "1129"});
        this.charset("x-IBM1130", "IBM1130", new String[]{"cp1130", "ibm1130", "ibm-1130", "1130"});
        this.charset("x-IBM1164", "IBM1164", new String[]{"cp1164", "ibm1164", "ibm-1164", "1164"});
        this.charset("x-IBM1166", "IBM1166", new String[]{"cp1166", "ibm1166", "ibm-1166", "1166"});
        this.charset("x-IBM1364", "IBM1364", new String[]{"cp1364", "ibm1364", "ibm-1364", "1364"});
        this.charset("IBM273", "IBM273", new String[]{"cp273", "ibm273", "ibm-273", "273", "csibm273"});
        this.charset("IBM277", "IBM277", new String[]{"cp277", "ibm277", "ibm-277", "277", "ebcdic-cp-dk", "ebcdic-cp-no", "csibm277"});
        this.charset("IBM278", "IBM278", new String[]{"cp278", "ibm278", "ibm-278", "278", "ebcdic-sv", "ebcdic-cp-se", "csibm278", "ebcdic-cp-fi"});
        this.charset("IBM280", "IBM280", new String[]{"cp280", "ibm280", "ibm-280", "280", "ebcdic-cp-it", "csibm280"});
        this.charset("IBM284", "IBM284", new String[]{"cp284", "ibm284", "ibm-284", "284", "csIBM284", "cpibm284", "ebcdic-cp-es"});
        this.charset("IBM285", "IBM285", new String[]{"cp285", "ibm285", "ibm-285", "285", "ebcdic-cp-gb", "ebcdic-gb", "csIBM285", "cpibm285"});
        this.charset("IBM290", "IBM290", new String[]{"cp290", "ibm290", "ibm-290", "290", "csIBM290", "cpibm290", "EBCDIC-JP-kana"});
        this.charset("IBM297", "IBM297", new String[]{"cp297", "ibm297", "ibm-297", "297", "ebcdic-cp-fr", "cpibm297", "csIBM297"});
        this.charset("x-IBM300", "IBM300", new String[]{"cp300", "ibm300", "ibm-300", "300", "cpibm300", "csIBM300"});
        this.charset("x-IBM300A", "IBM300A", new String[]{"cp300a", "ibm300a", "ibm-300a", "300a", "cpibm300a", "csIBM300a"});
        this.charset("IBM420", "IBM420", new String[]{"cp420", "ibm420", "ibm-420", "ebcdic-cp-ar1", "420", "csIBM420"});
        this.charset("x-IBM420S", "IBM420S", new String[]{"cp420s", "ibm420s", "ibm-420s", "420s", "csibm420s"});
        this.charset("IBM424", "IBM424", new String[]{"cp424", "ibm424", "ibm-424", "424", "ebcdic-cp-he", "csIBM424"});
        this.charset("IBM500", "IBM500", new String[]{"cp500", "ibm500", "ibm-500", "500", "ebcdic-cp-ch", "ebcdic-cp-be", "ebcdic-cp-bh", "csIBM500"});
        this.charset("x-IBM833", "IBM833", new String[]{"cp833", "ibm833", "ibm-833", "833"});
        this.charset("x-IBM834", "IBM834", new String[]{"cp834", "ibm834", "ibm-834", "834"});
        this.charset("x-IBM835", "IBM835", new String[]{"cp835", "ibm835", "ibm-835", "835"});
        this.charset("x-IBM836", "IBM836", new String[]{"cp836", "ibm836", "ibm-836", "836"});
        this.charset("x-IBM837", "IBM837", new String[]{"cp837", "ibm837", "ibm-837", "837"});
        this.charset("x-IBM4933", "IBM4933", new String[]{"cp4933", "ibm4933", "ibm-4933", "4933"});
        this.charset("IBM-Thai", "IBM838", new String[]{"cp838", "ibm838", "ibm-838", "838"});
        this.charset("IBM870", "IBM870", new String[]{"cp870", "ibm870", "ibm-870", "870", "ebcdic-cp-roece", "ebcdic-cp-yu", "csIBM870"});
        this.charset("IBM871", "IBM871", new String[]{"cp871", "ibm871", "ibm-871", "871", "ebcdic-cp-is", "csIBM871"});
        this.charset("x-IBM875", "IBM875", new String[]{"cp875", "ibm875", "ibm-875", "875"});
        this.charset("IBM918", "IBM918", new String[]{"cp918", "ibm-918", "ibm918", "918", "ebcdic-cp-ar2", "csibm918"});
        this.charset("x-IBM922", "IBM922", new String[]{"cp922", "ibm922", "ibm-922", "922"});
        this.charset("x-IBM1097", "IBM1097", new String[]{"cp1097", "ibm1097", "ibm-1097", "1097"});
        this.charset("x-IBM949", "IBM949", new String[]{"cp949", "ibm949", "ibm-949", "949"});
        this.charset("x-IBM949C", "IBM949C", new String[]{"cp949c", "ibm949c", "ibm-949c", "949c"});
        this.charset("x-IBM939", "IBM939", new String[]{"cp939", "ibm939", "ibm-939", "939", "5035", "cp5035", "ibm5035", "ibm-5035"});
        this.charset("x-IBM939A", "IBM939A", new String[]{"cp939A", "ibm939A", "ibm-939A", "939A"});
        this.charset("x-IBM933", "IBM933", new String[]{"cp933", "ibm933", "ibm-933", "933"});
        this.charset("x-IBM1371", "IBM1371", new String[]{"cp1371", "ibm1371", "ibm-1371", "1371"});
        this.charset("x-IBM1377", "IBM1377", new String[]{"cp1377", "ibm1377", "ibm-1377", "1377"});
        this.charset("x-IBM1379", "IBM1379", new String[]{"cp1379", "ibm1379", "ibm-1379", "1379"});
        this.charset("x-IBM1381", "IBM1381", new String[]{"cp1381", "ibm1381", "ibm-1381", "1381"});
        this.charset("x-IBM1382", "IBM1382", new String[]{"cp1382", "ibm1382", "ibm-1382", "1382"});
        this.charset("x-IBM1383", "IBM1383", new String[]{"cp1383", "ibm1383", "ibm-1383", "1383", "ibm-euccn", "ibmeuccn", "cpeuccn"});
        this.charset("x-IBM1388", "IBM1388", new String[]{"cp1388", "ibm1388", "ibm-1388", "1388"});
        this.charset("x-IBM1390", "IBM1390", new String[]{"cp1390", "ibm1390", "ibm-1390", "1390"});
        this.charset("x-IBM1390A", "IBM1390A", new String[]{"cp1390a", "ibm1390a", "ibm-1390a", "1390a"});
        this.charset("x-IBM1399", "IBM1399", new String[]{"cp1399", "ibm1399", "ibm-1399", "1399"});
        this.charset("x-IBM1399A", "IBM1399A", new String[]{"cp1399a", "ibm1399a", "ibm-1399a", "1399a"});
        this.charset("x-IBM16684", "IBM16684", new String[]{"cp16684", "ibm16684", "ibm-16684", "16684"});
        this.charset("x-IBM16684A", "IBM16684A", new String[]{"cp16684a", "ibm16684a", "ibm-16684a", "16684a"});
        this.charset("x-IBM970", "IBM970", new String[]{"cp970", "ibm970", "ibm-970", "ibm-euckr", "cpeuckr", "ibmeuckr", "970"});
        this.charset("x-IBM971", "IBM971", new String[]{"cp971", "ibm971", "ibm-971", "971"});
        this.charset("x-IBM964", "IBM964", new String[]{"cp964", "ibm964", "ibm-964", "964", "ibm-euctw"});
        this.charset("x-IBM33722", "IBM33722", new String[]{"cp33722", "ibm33722", "ibm-33722", "33722", "ibm-33722_vascii_vpua", "cp5050", "ibm5050", "ibm-5050", "5050"});
        this.charset("x-IBM33722C", "IBM33722C", new String[]{"cp33722c", "ibm33722c", "ibm-33722c", "33722c", "cp5050c", "ibm5050c", "ibm-5050c", "5050c"});
        this.charset("x-IBM33722A", "IBM33722A", new String[]{"cp33722A", "ibm33722A", "ibm-33722A", "33722A", "cp5050A", "ibm5050A", "ibm-5050A", "5050A"});
        this.charset("x-IBM29626", "IBM29626", new String[]{"cp29626", "ibm29626", "ibm-29626", "ibm-29626_vascii_vpua", "29626"});
        this.charset("x-IBM29626C", "IBM29626C", new String[]{"cp29626c", "ibm29626c", "ibm-29626c", "29626c", "ibm-eucjp"});
        this.charset("IBM01140", "IBM1140", new String[]{"cp1140", "ccsid01140", "cp01140", "1140", "ibm-1140", "ibm1140", "IBM-1140"});
        this.charset("IBM01141", "IBM1141", new String[]{"cp1141", "ccsid01141", "cp01141", "1141", "ibm-1141", "ibm1141"});
        this.charset("x-IBM1141_LF", "IBM1141_LF", new String[]{"cp1141_lf", "1141_lf", "ibm-1141_lf", "ibm1141_lf"});
        this.charset("IBM01142", "IBM1142", new String[]{"cp1142", "ccsid01142", "cp01142", "1142", "ibm1142", "ibm-1142"});
        this.charset("IBM01143", "IBM1143", new String[]{"cp1143", "ccsid01143", "cp01143", "1143", "ibm1143", "ibm-1143"});
        this.charset("IBM01144", "IBM1144", new String[]{"cp1144", "ccsid01144", "cp01144", "1144", "ibm1144", "ibm-1144"});
        this.charset("IBM01145", "IBM1145", new String[]{"cp1145", "ccsid01145", "cp01145", "1145", "ibm1145", "ibm-1145"});
        this.charset("IBM01146", "IBM1146", new String[]{"cp1146", "ccsid01146", "cp01146", "1146", "ibm1146", "ibm-1146"});
        this.charset("IBM01147", "IBM1147", new String[]{"cp1147", "ccsid01147", "cp01147", "1147", "ibm1147", "ibm-1147"});
        this.charset("IBM01148", "IBM1148", new String[]{"cp1148", "ccsid01148", "cp01148", "1148", "ibm1148", "ibm-1148"});
        this.charset("IBM01149", "IBM1149", new String[]{"cp1149", "ccsid01149", "cp01149", "1149", "ibm1149", "ibm-1149"});
        this.charset("x-IBM1153", "IBM1153", new String[]{"cp1153", "ccsid01153", "cp01153", "ibm01153", "1153", "ibm1153", "ibm-1153"});
        this.charset("x-IBM1165", "IBM1165", new String[]{"cp1165", "ibm1165", "ibm-1165", "1165"});
        this.charset("x-MacRoman", "MacRoman", new String[]{"macroman", "cp1275", "ibm1275", "ibm-1275", "1275"});
        this.charset("x-MacCentralEurope", "MacCentralEurope", new String[]{"maccentraleurope", "cp1282", "ibm1282", "ibm-1282", "1282"});
        this.charset("x-MacCroatian", "MacCroatian", new String[]{"maccroatian", "cp1284", "ibm1284", "ibm-1284", "1284"});
        this.charset("x-MacGreek", "MacGreek", new String[]{"macgreek", "cp1280", "ibm1280", "ibm-1280", "1280"});
        this.charset("x-MacCyrillic", "MacCyrillic", new String[]{"maccyrillic", "cp1283", "ibm1283", "ibm-1283", "1283"});
        this.charset("x-MacUkraine", "MacUkraine", new String[]{"macukraine"});
        this.charset("x-MacTurkish", "MacTurkish", new String[]{"macturkish", "cp1281", "ibm1281", "ibm-1281", "1281"});
        this.charset("x-MacArabic", "MacArabic", new String[]{"MacArabic"});
        this.charset("x-MacHebrew", "MacHebrew", new String[]{"machebrew"});
        this.charset("x-MacIceland", "MacIceland", new String[]{"maciceland", "cp1286", "ibm1286", "ibm-1286", "1286"});
        this.charset("x-MacRomania", "MacRomania", new String[]{"macromania", "cp1285", "ibm1285", "ibm-1285", "1285"});
        this.charset("x-MacThai", "MacThai", new String[]{"macthai"});
        this.charset("x-MacSymbol", "MacSymbol", new String[]{"macsymbol", "cp1038", "ibm1038", "ibm-1038", "1038", "adobe-symbol-encoding"});
        this.charset("x-MacDingbat", "MacDingbat", new String[]{"macdingbat"});
        this.charset("x-IBM1362", "IBM1362", new String[]{"ibm1362", "ibm-1362", "cp1362", "1362"});
        this.charset("x-IBM1363", "IBM1363", new String[]{"ibm1363", "ibm-1363", "cp1363", "1363"});
        this.charset("x-IBM1363C", "IBM1363C", new String[]{"ibm1363c", "ibm-1363c", "cp1363c", "1363c"});
        this.charset("x-IBM867", "IBM867", new String[]{"ibm-867", "ibm867", "cp867", "867"});
        this.charset("KZ-1048", "RK1048", new String[]{"rk1048", "kz-1048", "strk1048-2002"});
        instance = this;
    }

    protected void init() {
        Object object;
        if (this.initialized) {
            return;
        }
        if (!VM.isBooted()) {
            return;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.nio.cs.map"));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string != null) {
            object = string.split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].equalsIgnoreCase("Windows-31J/Shift_JIS")) {
                    bl = true;
                    continue;
                }
                if (object[i].equalsIgnoreCase("x-windows-50221/ISO-2022-JP")) {
                    bl2 = true;
                    continue;
                }
                if (object[i].equalsIgnoreCase("x-windows-50220/ISO-2022-JP")) {
                    bl3 = true;
                    continue;
                }
                if (!object[i].equalsIgnoreCase("x-windows-iso2022jp/ISO-2022-JP")) continue;
                bl4 = true;
            }
        }
        if (bl) {
            this.deleteCharset("Shift_JIS", new String[]{"sjis", "shift_jis", "shift-jis", "ms_kanji", "x-sjis", "csShiftJIS"});
            this.deleteCharset("windows-31j", new String[]{"MS932", "windows-932", "csWindows31J"});
            this.charset("Shift_JIS", "SJIS", new String[]{"sjis"});
            this.charset("windows-31j", "MS932", new String[]{"MS932", "windows-932", "csWindows31J", "shift-jis", "ms_kanji", "x-sjis", "csShiftJIS", "shift_jis"});
        }
        if (bl2 || bl3 || bl4) {
            this.deleteCharset("ISO-2022-JP", new String[]{"iso2022jp", "jis", "csISO2022JP", "jis_encoding", "csjisencoding"});
            if (bl2) {
                this.deleteCharset("x-windows-50221", new String[]{"cp50221", "ms50221"});
                this.charset("x-windows-50221", "MS50221", new String[]{"cp50221", "ms50221", "iso-2022-jp", "iso2022jp", "jis", "csISO2022JP", "jis_encoding", "csjisencoding"});
            } else if (bl3) {
                this.deleteCharset("x-windows-50220", new String[]{"cp50220", "ms50220"});
                this.charset("x-windows-50220", "MS50220", new String[]{"cp50220", "ms50220", "iso-2022-jp", "iso2022jp", "jis", "csISO2022JP", "jis_encoding", "csjisencoding"});
            } else {
                this.deleteCharset("x-windows-iso2022jp", new String[]{"windows-iso2022jp"});
                this.charset("x-windows-iso2022jp", "MSISO2022JP", new String[]{"windows-iso2022jp", "iso-2022-jp", "iso2022jp", "jis", "csISO2022JP", "jis_encoding", "csjisencoding"});
            }
        }
        object = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        this.charset("x-COMPOUND_TEXT", "COMPOUND_TEXT", new String[]{"COMPOUND_TEXT", "x11-compound_text", "x11-compound-text", "x-compound_text", "x-compound-text"});
        this.initialized = true;
    }

    public static final boolean isSwapLF() {
        if (swapLF) {
            return swapLF;
        }
        if (VM.isBooted()) {
            boolean bl = false;
            bl = System.getSecurityManager() == null ? new GetBooleanAction("ibm.swapLF").run().booleanValue() : AccessController.doPrivileged(new GetBooleanAction("ibm.swapLF")).booleanValue();
            if (bl) {
                swapLF = bl;
            }
        }
        return swapLF;
    }

    public static String[] aliasesFor(String string) {
        if (instance == null) {
            return null;
        }
        return instance.aliases(string);
    }

    protected void charset(String string, String string2, String[] stringArray) {
        if (!empty && excludedCharsetsList.contains(string2)) {
            return;
        }
        super.charset(string, string2, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        excludedCharsetsList = new HashSet<String>();
        try (Scanner scanner = null;){
            InputStream inputStream = ExtendedCharsets.class.getResourceAsStream(EXCLUDE_LIST_NAME);
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                scanner = new Scanner(bufferedReader);
                while (scanner.hasNext()) {
                    String string = scanner.next();
                    excludedCharsetsList.add(string);
                }
            }
        }
        empty = excludedCharsetsList.size() <= 0;
    }
}

