/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.https;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.BrowserKeystore;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.X509DeployKeyManager;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.security.X509Extended7DeployTrustManager;
import com.sun.deploy.security.X509ExtendedDeployTrustManager;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Handler
extends com.ibm.net.ssl.www2.protocol.https.Handler {
    protected URLConnection openConnection(URL uRL) throws IOException {
        Initializer.init();
        return super.openConnection(uRL);
    }

    static class Initializer {
        Initializer() {
        }

        static void init() {
        }

        static {
            String string = null;
            try {
                string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return System.getProperty("https.protocols");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            if (string == null || string.trim().length() == 0) {
                boolean bl = false;
                for (String string2 : Config.ALL_TLS_PROTOCOLS) {
                    if (!Config.getBooleanProperty(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    SecurityException securityException = new SecurityException("No TLS/SSL protocol is enabled.");
                    Trace.println("No TLS/SSL protocol is enabled", TraceLevel.NETWORK);
                    Trace.ignored(securityException);
                    throw securityException;
                }
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        TrustManager[] trustManagerArray;
                        X509TrustManager x509TrustManager;
                        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                            BrowserKeystore.registerSecurityProviders();
                        }
                        SecureRandom secureRandom = ServiceManager.getService().getSecureRandom();
                        secureRandom.nextInt();
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        if (Config.isJavaVersionAtLeast17()) {
                            x509TrustManager = new X509Extended7DeployTrustManager();
                        } else if (Config.isJavaVersionAtLeast16()) {
                            x509TrustManager = new X509ExtendedDeployTrustManager();
                        } else {
                            trustManagerArray = new CertificateHostnameVerifier();
                            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)trustManagerArray);
                            x509TrustManager = new X509DeployTrustManager();
                        }
                        trustManagerArray = new TrustManager[]{x509TrustManager};
                        X509DeployKeyManager x509DeployKeyManager = new X509DeployKeyManager();
                        KeyManager[] keyManagerArray = new KeyManager[]{x509DeployKeyManager};
                        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
                        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
    }
}

