/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.DecisionTime;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.TrustRecorder;
import com.sun.deploy.security.UserDeclinedException;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLException;

public class SandboxSecurity {
    protected static final String FILENAME = "sandbox.properties";
    private static final String SESSION_VALUE_TRUE = "true";
    private static final String SESSION_VALUE_FALSE = "false";
    private static final String SESSION_VALUE_INPROGRESS = "in-progress";
    private static final String LOOSE_RESOURCE_KEY_SUFIX = ".loose.resource";
    private static SessionProperties sessionProps = new SessionProperties("sandbox.properties");
    private static final Set verifiedHttpsConnection;
    private static Object lock;
    private static Object blockLock;
    private static String blockKey;
    private static String masthead;
    private static String runKey;
    private static String cancel;
    private static String securityInfoDescription;
    private static String securityInfoCanel;
    private static String securityInfoTrusted;
    private static String securityRisk;

    public static void addConnectPermission(PermissionCollection permissionCollection, URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = URLUtil.getPort(uRL);
        if ("https".equalsIgnoreCase(string) && !SandboxSecurity.verifyHttpsConnection(uRL)) {
            return;
        }
        if (Config.isJavaVersionAtLeast18()) {
            permissionCollection.add(new URLPermission(string + "://" + string2 + ":" + n + "/-"));
            permissionCollection.add(new URLPermission(string + "://" + string2 + ":" + n));
        } else {
            permissionCollection.add(new SocketPermission(string2, "connect,accept"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyHttpsConnection(URL uRL) {
        String string = uRL.getHost();
        int n = URLUtil.getPort(uRL);
        String string2 = "https://" + string + ":" + n;
        Object object = lock;
        synchronized (object) {
            if (verifiedHttpsConnection.contains(string2)) {
                return true;
            }
        }
        try {
            object = (HttpURLConnection)uRL.openConnection();
            ((HttpURLConnection)object).getResponseCode();
        }
        catch (SSLException sSLException) {
            Trace.ignored(sSLException);
            return false;
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            return false;
        }
        object = lock;
        synchronized (object) {
            verifiedHttpsConnection.add(string2);
        }
        return true;
    }

    public static void resetAcceptedVersion(LocalApplicationProperties localApplicationProperties, AppInfo appInfo) {
        if (localApplicationProperties != null) {
            DecisionTime.reset(localApplicationProperties);
            String string = TrustDecider.getLocString(localApplicationProperties.getLocation(), appInfo);
            if (string != null) {
                sessionProps.remove(string);
                sessionProps.remove(string + LOOSE_RESOURCE_KEY_SUFIX);
            }
        }
    }

    public static void isPermissionGranted(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) {
        SandboxSecurity.isPermissionGranted(codeSource, appInfo, deploymentRuleSet, preloader, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void isPermissionGranted(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader, boolean bl) {
        Config.getHooks().trackUsage(appInfo, deploymentRuleSet);
        boolean bl2 = true;
        try {
            try {
                if (TrustRecorder.isGranted(codeSource.getLocation(), false)) {
                    return;
                }
                if (deploymentRuleSet.isRuleBlock()) {
                    String string = "deployment.blocked.by.rule";
                    if (deploymentRuleSet instanceof BlockRule && ((BlockRule)deploymentRuleSet).isFromExceptionList()) {
                        string = "deployment.blocked.by.exception.list";
                    }
                    BlockedDialog.show(appInfo, deploymentRuleSet.getMessage(), string, deploymentRuleSet.getException(), codeSource, deploymentRuleSet);
                }
                if (codeSource != null && codeSource.getCertificates() != null) {
                    try {
                        DeployManifestChecker.verify(deploymentRuleSet, codeSource.getLocation(), false, appInfo);
                    }
                    catch (SecurityException securityException) {
                        Trace.ignored(securityException);
                        BlockedDialog.show(appInfo, null, null, securityException, codeSource, deploymentRuleSet);
                    }
                    if (Config.isJavaVersionAtLeast16()) {
                        SandboxSecurity.checkSignedSandboxSecurity(codeSource, appInfo, deploymentRuleSet, preloader);
                    } else {
                        Trace.println("Jar has Certs, treating sandbox app as unsigned due to running old JRE", TraceLevel.SECURITY);
                        SandboxSecurity.checkUnsignedSandboxSecurity(appInfo, codeSource, deploymentRuleSet, bl);
                    }
                } else {
                    SandboxSecurity.checkUnsignedSandboxSecurity(appInfo, codeSource, deploymentRuleSet, bl);
                }
                TrustRecorder.grant(codeSource.getLocation(), false);
                return;
            }
            catch (UserDeclinedException userDeclinedException) {
                Config.getHooks().confirmAppDenied(deploymentRuleSet);
                bl2 = false;
                throw userDeclinedException;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!bl2) throw throwable;
            Config.getHooks().confirmAppBlocked(deploymentRuleSet);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkSignedSandboxSecurity(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) {
        block29: {
            block30: {
                String string = null;
                try {
                    try {
                        List list;
                        TrustDecider.grabDeployLock();
                        ValidationState validationState = new ValidationState(ValidationState.TYPE.SANDBOX_PERMISSIONS);
                        Certificate[] certificateArray = null;
                        X509Certificate x509Certificate = null;
                        Certificate[] certificateArray2 = codeSource.getCertificates();
                        boolean bl = false;
                        try {
                            TrustDecider.ensureBasicStoresLoaded();
                            list = TrustDecider.breakDownMultiSignerChains(certificateArray2);
                        }
                        catch (Exception exception) {
                            BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                            throw new SecurityException(exception.getMessage(), exception);
                        }
                        Iterator iterator = list.iterator();
                        if (iterator.hasNext()) {
                            List list2 = (List)iterator.next();
                            certificateArray = list2.toArray(new X509Certificate[0]);
                            while (deploymentRuleSet.skipThisCertArray((X509Certificate[])certificateArray) && iterator.hasNext()) {
                                list2 = (List)iterator.next();
                                certificateArray = list2.toArray(new X509Certificate[0]);
                            }
                            try {
                                x509Certificate = certificateArray[0];
                                boolean bl2 = deploymentRuleSet.isRevocationCheckBestEffort();
                                boolean bl3 = deploymentRuleSet.isRuleRun();
                                validationState = TrustDecider.getValidationState((X509Certificate[])certificateArray, codeSource, 0, ValidationState.TYPE.SANDBOX_PERMISSIONS, bl2, bl3, appInfo, deploymentRuleSet, false);
                                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(appInfo.getLapURL());
                                if (localApplicationProperties != null) {
                                    localApplicationProperties.storeMainPublisherAndTitle(validationState.getPublisher(), appInfo.getDisplayTitle());
                                }
                                bl = validationState.rootCAValid;
                                if (validationState.trustDecision == 0L) {
                                    String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
                                    TrustDecider.notifyOnUserDeclined(preloader, string2);
                                } else if (bl) {
                                    if (deploymentRuleSet.isCaSignedNever()) {
                                        string = "deployment.run.sandbox.signed.never.text";
                                    }
                                } else if (deploymentRuleSet.isSelfSignedNever()) {
                                    string = "deployment.run.sandbox.selfsigned.never.text";
                                } else if (SecurityBaseline.isExpired() && deploymentRuleSet.isSSVModeNever()) {
                                    string = "deployment.ssv2.mode.never.text";
                                }
                                if (string == null && !validationState.timeValid && deploymentRuleSet.isExpiredBlocked()) {
                                    string = "deployment.block.expired.text";
                                }
                                if (string == null && !bl && SandboxSecurity.isLocalApp(appInfo) && deploymentRuleSet.isRunLocalAppletsNever()) {
                                    string = "deployment.local.applet.never.text";
                                }
                            }
                            catch (Exception exception) {
                                BadCertificateDialog.showDialog(codeSource, appInfo, exception);
                                throw new SecurityException(exception.getMessage(), exception);
                            }
                        }
                        if (string != null) {
                            BlockedDialog.show(appInfo, null, string, null, codeSource, deploymentRuleSet);
                        }
                        if (validationState.trustDecision == 0L) {
                            throw new UserDeclinedException("user declined to run signed sandbox app");
                        }
                        try {
                            TrustDecider.checkMainJarManifest(deploymentRuleSet, codeSource.getLocation(), appInfo, false);
                            if (deploymentRuleSet.isRuleRun()) {
                                validationState.trustDecision = 1L;
                                SandboxSecurity.checkRunRuleMessage(deploymentRuleSet, codeSource.getLocation(), appInfo, x509Certificate);
                            }
                        }
                        catch (SecurityException securityException) {
                            String string3 = "deployment.blocked.permissions";
                            BlockedDialog.show(appInfo, null, string3, securityException, codeSource, deploymentRuleSet);
                        }
                        if (validationState.trustDecision != 2L) break block29;
                        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, x509Certificate, "ssv.decision.sandbox.time")) {
                            validationState.trustDecision = 1L;
                            Object var18_23 = null;
                            break block30;
                        }
                        int n = SandboxSecurity.showSandboxDialog(codeSource.getLocation(), appInfo, deploymentRuleSet, (X509Certificate[])certificateArray, !validationState.timeValid, !validationState.rootCAValid, validationState.revStatusUnknown);
                        TrustDecider.recordSandboxAnswer(certificateArray, codeSource, validationState, preloader, n, appInfo);
                        if (n == 0) {
                            DecisionTime.setTime(codeSource.getLocation(), appInfo, x509Certificate, "ssv.decision.sandbox.time");
                        }
                        break block29;
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignored(interruptedException);
                        BlockedDialog.show(appInfo, null, "deployment.run.sandbox.signed.error", interruptedException, codeSource, deploymentRuleSet);
                        Object var18_25 = null;
                        TrustDecider.releaseDeployLock();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_26 = null;
                    TrustDecider.releaseDeployLock();
                    throw throwable;
                }
            }
            TrustDecider.releaseDeployLock();
            return;
        }
        Object var18_24 = null;
        TrustDecider.releaseDeployLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void checkUnsignedSandboxSecurity(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet, boolean bl) {
        if (deploymentRuleSet.isRuleRun()) {
            SandboxSecurity.checkRunRuleMessage(deploymentRuleSet, codeSource.getLocation(), appInfo, null);
            return;
        }
        SessionProperties sessionProperties = sessionProps;
        synchronized (sessionProperties) {
            String string;
            String string2;
            block14: {
                string2 = TrustDecider.getLocString(appInfo.getLapURL(), appInfo);
                string = string2 + LOOSE_RESOURCE_KEY_SUFIX;
                String string3 = sessionProps.getProperty(string2);
                String string4 = sessionProps.getProperty(string);
                if (SESSION_VALUE_TRUE.equals(string3)) return;
                if (bl && SESSION_VALUE_TRUE.equals(string4)) {
                    return;
                }
                if (SESSION_VALUE_FALSE.equals(string3)) throw new UserDeclinedException("User declined to run unsigned sandbox content");
                if (bl && SESSION_VALUE_FALSE.equals(string4)) {
                    throw new UserDeclinedException("User declined to run unsigned sandbox content");
                }
                if (SESSION_VALUE_INPROGRESS.equals(string3)) {
                    throw new ClassCircularityError("re-entrant call to checkUnsignedSandboxSecurity()");
                }
                sessionProps.setProperty(string2, SESSION_VALUE_INPROGRESS);
                try {
                    if (SecurityBaseline.isExpired()) {
                        SandboxSecurity.checkRunExpired(appInfo, deploymentRuleSet, bl);
                    } else if (SandboxSecurity.isLocalApp(appInfo)) {
                        SandboxSecurity.checkRunLocal(appInfo, codeSource, deploymentRuleSet, bl);
                    } else {
                        SandboxSecurity.checkRunUntrusted(appInfo, codeSource, deploymentRuleSet, bl);
                    }
                    Object var10_9 = null;
                    if (!SESSION_VALUE_INPROGRESS.equals(sessionProps.getProperty(string2))) break block14;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (!SESSION_VALUE_INPROGRESS.equals(sessionProps.getProperty(string2))) throw throwable;
                    sessionProps.remove(string2);
                    throw throwable;
                }
                sessionProps.remove(string2);
            }
            if (bl) {
                sessionProps.setProperty(string, SESSION_VALUE_TRUE);
            } else {
                sessionProps.setProperty(string2, SESSION_VALUE_TRUE);
            }
            return;
        }
    }

    private static void checkRunUntrusted(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet, boolean bl) {
        if (deploymentRuleSet.isRunUntrustedNever() && !bl) {
            BlockedDialog.show(appInfo, null, "deployment.run.untrusted.never.text", deploymentRuleSet.getException(), null, deploymentRuleSet);
        }
        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(appInfo, deploymentRuleSet, bl, false);
        DecisionTime.setTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time");
    }

    private static void checkRunExpired(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, boolean bl) {
        if (deploymentRuleSet.isSSVModeNever() && !bl) {
            BlockedDialog.show(appInfo, null, "deployment.ssv2.mode.never.text", deploymentRuleSet.getException(), null, deploymentRuleSet);
        }
        SandboxSecurity.showUntrustedDialog(appInfo, deploymentRuleSet, bl, true);
    }

    private static void checkRunLocal(AppInfo appInfo, CodeSource codeSource, DeploymentRuleSet deploymentRuleSet, boolean bl) {
        if (deploymentRuleSet.isRunLocalAppletsNever()) {
            BlockedDialog.show(appInfo, null, "deployment.local.applet.never.text", deploymentRuleSet.getException(), null, deploymentRuleSet);
        }
        if (deploymentRuleSet.isRunUntrustedNever() && !bl) {
            BlockedDialog.show(appInfo, null, "deployment.run.untrusted.never.text", deploymentRuleSet.getException(), null, deploymentRuleSet);
        }
        if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time")) {
            return;
        }
        SandboxSecurity.showUntrustedDialog(appInfo, deploymentRuleSet, bl, false);
        DecisionTime.setTime(codeSource.getLocation(), appInfo, null, "ssv.decision.unsigned.time");
    }

    private static boolean isLocalApp(AppInfo appInfo) {
        URL uRL = appInfo.getFrom();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    private static LocalApplicationProperties getLap(AppInfo appInfo) {
        return Cache.getLocalApplicationProperties(appInfo.getLapURL());
    }

    public static boolean showUntrustedDialog(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, boolean bl, boolean bl2) {
        LocalApplicationProperties localApplicationProperties;
        String string = "deployment.ssv.title";
        String string2 = "deployment.ssv.masthead";
        String string3 = appInfo.isMultiHost() ? "deployment.ssv.location.multihost" : "deployment.ssv.location";
        Object var7_7 = null;
        String string4 = "deployment.ssv.prompt";
        String string5 = null;
        String string6 = null;
        if (deploymentRuleSet.isRunUntrustedMultiClick()) {
            string5 = "deployment.ssv.multi.prompt";
            string6 = "deployment.ssv.multi.text";
        }
        String string7 = "deployment.ssv.run";
        String string8 = null;
        String string9 = "deployment.ssv.cancel";
        URL uRL = null;
        String string10 = "deployment.ssv." + (bl2 ? "expired." : "") + (SandboxSecurity.isLocalApp(appInfo) ? "localapp." : "");
        String string11 = string10 + (bl ? "res" : "main");
        if (bl2) {
            string4 = "deployment.ssv.update.prompt";
            string8 = null;
        }
        if (bl) {
            string4 = string4 + ".res";
        }
        if ((localApplicationProperties = ResourceProvider.get().getLocalApplicationProperties(appInfo.getLapURL(), null, true)) != null) {
            localApplicationProperties.storeMainPublisherAndTitle(null, null);
        }
        String string12 = null;
        String string13 = (String)ToolkitStore.get().getAppContext().get("jarverifier.weak.ctx_key");
        if (string13 != null) {
            string4 = string4 == null ? "" : ResourceManager.getString(string4) + "<br><br><b>";
            string4 = string4 + ResourceManager.getString("deployment.ssv.warning") + "</b> " + string13;
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string, string2, string11, string3, string4, string5, string6, string7, string8, string9, string12, uRL);
        if (n == 2) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        String string14 = TrustDecider.getLocString(appInfo.getLapURL(), appInfo) + (bl ? LOOSE_RESOURCE_KEY_SUFIX : "");
        sessionProps.setProperty(string14, SESSION_VALUE_FALSE);
        throw new UserDeclinedException("User declined to run unsigned sandbox content");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showBlockedDialog(AppInfo appInfo, String string, String string2, Exception exception, CodeSource codeSource) {
        String string3 = null;
        String string4 = ResourceManager.getString("deployment.blocked.masthead");
        if (string != null) {
            string3 = string;
            string4 = ResourceManager.getString("deployment.blocked.ruleset.masthead");
        } else if (string2 != null) {
            string3 = ResourceManager.getString(string2);
        }
        Trace.println(string3, TraceLevel.BASIC);
        Object object = blockLock;
        synchronized (object) {
            String string5;
            String string6 = null;
            String string7 = ResourceManager.getString("deployment.blocked.title");
            if (string3 == null) {
                string3 = ResourceManager.getString("deployment.blocked.text");
            }
            String string8 = ResourceManager.getString("common.ok_btn");
            String string9 = ResourceManager.getString("common.detail.button");
            URL uRL = appInfo.getLapURL();
            String string10 = string5 = uRL == null ? null : uRL.toString();
            if (string5 == null || !string5.equals(blockKey)) {
                appInfo.setVendor(null);
                ToolkitStore.getUI().showPublisherInfo(null, appInfo, string7, string4, string3, string8, string9, string6);
            }
            blockKey = string5;
        }
        throw new BlockedException(string3, (Throwable)exception, codeSource, appInfo);
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int showSandboxDialog(URL uRL, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, X509Certificate[] x509CertificateArray, boolean bl, boolean bl2, boolean bl3) {
        String string;
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(securityInfoDescription);
        arrayList2.add(securityInfoCanel);
        String string2 = CertUtils.extractSubjectAliasName(x509CertificateArray[0]);
        if (bl2) {
            arrayList = new ArrayList<String>();
            arrayList.add(securityRisk);
            string = SandboxSecurity.getMessage("security.dialog.notverified.subject");
            arrayList2.add(SandboxSecurity.getMessage("security.info.publisher.unknown").replaceAll(string, string.toUpperCase()));
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.selfsigned.state"));
            string2 = string.toUpperCase();
        } else if (bl) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.dialog.expired.signed.label")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.expired.state"));
        } else if (bl3) {
            arrayList = new ArrayList();
            arrayList.add(SandboxSecurity.combineMessage(securityRisk, SandboxSecurity.getMessage("sandbox.security.info.selfsigned.revocation.unknown")));
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.revocation.unsure.state"));
        } else {
            arrayList2.add(securityInfoTrusted);
            arrayList2.add(SandboxSecurity.getMessage("sandbox.security.info.trusted.state"));
        }
        if (arrayList != null) {
            arrayList.addAll(arrayList2);
        }
        string = arrayList == null ? SandboxSecurity.getMessage("security.dialog.valid.caption") : SandboxSecurity.getMessage("security.dialog.caption");
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl2 && !bl3) {
            if (appInfo.isMultiHost()) {
                if (DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
                    bl4 = true;
                    bl5 = true;
                } else if (appInfo.shouldDisplayMainJNLP()) {
                    bl4 = true;
                }
            } else {
                bl4 = true;
            }
        }
        DeployManifestChecker.printWarningsIfRequired(uRL, appInfo);
        return ToolkitStore.getUI().showSandboxSecurityDialog(bl5 ? AppInfo.createSingleHostAppInfo(appInfo) : new AppInfo(appInfo), string, masthead, string2, uRL, bl4, false, runKey, cancel, arrayList != null ? arrayList.toArray(new String[arrayList.size()]) : null, arrayList == null ? arrayList2.toArray(new String[arrayList2.size()]) : null, true, x509CertificateArray, 0, x509CertificateArray.length, bl2 || bl || bl3, bl2);
    }

    protected static void checkRunRuleMessage(DeploymentRuleSet deploymentRuleSet, URL uRL, AppInfo appInfo, X509Certificate x509Certificate) {
        String string = deploymentRuleSet.getMessage();
        if (string != null && string.length() > 0) {
            if (DecisionTime.withinTime(uRL, appInfo, x509Certificate, "ssv.decision.runrule.time")) {
                return;
            }
            UIFactory uIFactory = ToolkitStore.getUI();
            ToolkitStore.getUI();
            uIFactory.showMessageDialog(null, appInfo, 1, SandboxSecurity.getMessage("runrule.message.title"), SandboxSecurity.getMessage("runrule.message.masthead"), string, null, SandboxSecurity.getMessage("common.ok_btn"), null, null, null);
            DecisionTime.setTime(uRL, appInfo, x509Certificate, "ssv.decision.runrule.time");
        }
    }

    private static String combineMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("\n\n");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    static {
        SessionState.register(sessionProps);
        verifiedHttpsConnection = new HashSet();
        lock = new Object();
        blockLock = new Object();
        blockKey = null;
        masthead = SandboxSecurity.getMessage("deployment.ssv.masthead");
        runKey = "deployment.ssv.run";
        cancel = SandboxSecurity.getMessage("deployment.ssv.cancel");
        securityInfoDescription = SandboxSecurity.getMessage("sandbox.security.info.description");
        securityInfoCanel = SandboxSecurity.getMessage("sandbox.security.info.cancel");
        securityInfoTrusted = SandboxSecurity.getMessage("sandbox.security.info.trusted");
        securityRisk = SandboxSecurity.getMessage("sandbox.security.info.risk");
    }
}

