/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.EncryptedValue;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;

public final class EncryptedKey
extends CMPDerObject {
    private EncryptedValue encryptedValue;
    private EnvelopedData envelopedData;
    private static final byte TAG_ENVELOPED_DATA = 0;
    boolean bEncryptedValue;

    public EncryptedKey(EncryptedValue encryptedValue) {
        if (encryptedValue == null) {
            throw new IllegalArgumentException("EncryptedKey error, encrypted value not specified");
        }
        this.encryptedValue = encryptedValue;
        this.envelopedData = null;
        this.bEncryptedValue = true;
    }

    public EncryptedKey(EnvelopedData envelopedData) {
        if (envelopedData == null) {
            throw new IllegalArgumentException("EncryptedKey error, enveloped data not specified");
        }
        this.envelopedData = envelopedData;
        this.encryptedValue = null;
        this.bEncryptedValue = false;
    }

    public EncryptedKey(byte[] byArray) throws IOException {
        super(byArray);
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new EncryptedKey(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.encryptedValue = null;
        this.envelopedData = null;
        this.bEncryptedValue = true;
        if (derValue.getData().available() == 0) {
            throw new IOException("EncryptedKey parsing error, missing data");
        }
        if (derValue.isContextSpecific((byte)0) && derValue.isConstructed()) {
            derValue.resetTag((byte)48);
            this.envelopedData = new EnvelopedData(derValue.toByteArray());
            this.bEncryptedValue = false;
        } else {
            this.encryptedValue = new EncryptedValue(derValue.toByteArray());
            this.bEncryptedValue = true;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.bEncryptedValue) {
            if (this.encryptedValue == null) {
                throw new IOException("EncryptedKey encoding error, encrypted value not specified");
            }
            this.encryptedValue.encode((OutputStream)derOutputStream);
        } else {
            if (this.envelopedData == null) {
                throw new IOException("EncryptedKey encoding error, enveloped data not specified");
            }
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.envelopedData.encode((OutputStream)derOutputStream2);
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public boolean equals(EncryptedKey encryptedKey) {
        DerValue derValue;
        DerValue derValue2;
        if (encryptedKey == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            encryptedKey.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof EncryptedKey) {
            return this.equals((EncryptedKey)object);
        }
        return false;
    }

    public Object getEncryptedKey() {
        if (this.bEncryptedValue) {
            return this.encryptedValue.clone();
        }
        return this.envelopedData.clone();
    }

    public boolean isEncryptedValue() {
        return this.bEncryptedValue;
    }

    public String toString() {
        String string = "EncryptedKey:";
        string = this.bEncryptedValue ? String.valueOf(string) + "\r\n\tencrypted value: " + this.encryptedValue.toString() : String.valueOf(string) + "\r\n\tenveloped data: " + this.envelopedData.toString();
        return string;
    }
}

