/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.crmf;

import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.crmf.SinglePubInfo;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public final class PKIPublicationInfo
extends CMPDerObject {
    private int action;
    private SinglePubInfo[] pubInfos;
    private static final String DONT_PUBLISH_STRING = "dontPublish";
    private static final String PLEASE_PUBLISH_STRING = "pleasePublish";
    private static final String[] Actions = new String[]{"dontPublish", "pleasePublish"};
    public static final int DONT_PUBLISH = 0;
    public static final int PLEASE_PUBLISH = 1;

    public PKIPublicationInfo(int n, SinglePubInfo[] singlePubInfoArray) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("PKIPublicationInfo error, invalid action");
        }
        this.action = n;
        this.pubInfos = n == 0 ? null : singlePubInfoArray;
    }

    public PKIPublicationInfo(byte[] byArray) throws IOException {
        super(byArray);
    }

    public PKIPublicationInfo addPubInfo(SinglePubInfo[] singlePubInfoArray) {
        PKIPublicationInfo pKIPublicationInfo = (PKIPublicationInfo)this.clone();
        if (this.action == 0) {
            return pKIPublicationInfo;
        }
        if (singlePubInfoArray == null || singlePubInfoArray.length == 0) {
            return pKIPublicationInfo;
        }
        if (pKIPublicationInfo.pubInfos == null) {
            pKIPublicationInfo.pubInfos = singlePubInfoArray;
        } else {
            int n = pKIPublicationInfo.pubInfos.length + singlePubInfoArray.length;
            SinglePubInfo[] singlePubInfoArray2 = new SinglePubInfo[n];
            int n2 = 0;
            while (n2 < pKIPublicationInfo.pubInfos.length) {
                singlePubInfoArray2[n2] = pKIPublicationInfo.pubInfos[n2];
                ++n2;
            }
            int n3 = n2;
            int n4 = 0;
            while (n3 < n) {
                singlePubInfoArray2[n3] = singlePubInfoArray[n4];
                ++n3;
                ++n4;
            }
            pKIPublicationInfo.pubInfos = singlePubInfoArray2;
        }
        return pKIPublicationInfo;
    }

    public Object clone() {
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            return new PKIPublicationInfo(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("PKIPublicationInfo parsing error, not a SEQUENCE");
        }
        if (derValue.getData().available() == 0) {
            throw new IOException("PKIPublicationInfo parsing error, missing data");
        }
        this.pubInfos = null;
        BigInteger bigInteger = derValue.getData().getInteger();
        if (bigInteger.compareTo(BigInteger.valueOf(0L)) == 0) {
            if (derValue.getData().available() != 0) {
                throw new IOException("PKIPublicationInfo parsing error, data overrun");
            }
            this.action = 0;
            this.pubInfos = null;
            return;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(1L)) != 0) {
            throw new IOException("PKIPublicationInfo parsing error, invalid action");
        }
        this.action = 1;
        this.pubInfos = null;
        if (derValue.getData().available() != 0) {
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException("PKIPublicationInfo parsing error, not a SEQUENCE OF");
            }
            Vector<SinglePubInfo> vector = new Vector<SinglePubInfo>();
            while (derValue2.getData().available() != 0) {
                DerValue derValue3 = derValue2.getData().getDerValue();
                SinglePubInfo singlePubInfo = new SinglePubInfo(derValue3.toByteArray());
                vector.add(singlePubInfo);
            }
            if (vector.size() > 0) {
                this.pubInfos = new SinglePubInfo[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    this.pubInfos[n] = (SinglePubInfo)vector.elementAt(n);
                    ++n;
                }
            }
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("PKIPublicationInfo parsing error, data overrun");
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.action));
        if (this.pubInfos != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            int n = 0;
            while (n < this.pubInfos.length) {
                this.pubInfos[n].encode((OutputStream)derOutputStream3);
                ++n;
            }
            derOutputStream.write((byte)48, derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public boolean equals(PKIPublicationInfo pKIPublicationInfo) {
        DerValue derValue;
        DerValue derValue2;
        if (pKIPublicationInfo == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            pKIPublicationInfo.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof PKIPublicationInfo) {
            return this.equals((PKIPublicationInfo)object);
        }
        return false;
    }

    public int getAction() {
        return this.action;
    }

    public SinglePubInfo[] getPubInfos() {
        if (this.pubInfos == null) {
            return null;
        }
        return (SinglePubInfo[])this.pubInfos.clone();
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "PKIPublicationInfo:";
        string = String.valueOf(string) + "\r\n\taction: " + Actions[this.action];
        if (this.pubInfos == null || this.pubInfos.length == 0) {
            string = String.valueOf(string) + "\r\n\tNo pubInfos";
        } else {
            int n = 0;
            while (n < this.pubInfos.length) {
                string = String.valueOf(string) + "SinglePubInfo[" + n + "]\r\n";
                string = String.valueOf(string) + this.pubInfos[n].toString();
                string = String.valueOf(string) + "\r\n";
                ++n;
            }
        }
        return string;
    }
}

