/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.MemoryAccessException;

public class MemoryRange
implements Comparable {
    private static final String[] printableEBCDIC = new String[]{"40", " ", "F0", "0", "F1", "1", "F2", "2", "F3", "3", "F4", "4", "F5", "5", "F6", "6", "F7", "7", "F8", "8", "F9", "9", "C1", "A", "C2", "B", "C3", "C", "C4", "D", "C5", "E", "C6", "F", "C7", "G", "C8", "H", "C9", "I", "D1", "J", "D2", "K", "D3", "L", "D4", "M", "D5", "N", "D6", "O", "D7", "P", "D8", "Q", "D9", "R", "E2", "S", "E3", "T", "E4", "U", "E5", "V", "E6", "W", "E7", "X", "E8", "Y", "E9", "Z", "81", "a", "82", "b", "83", "c", "84", "d", "85", "e", "86", "f", "87", "g", "88", "h", "89", "i", "91", "j", "92", "k", "93", "l", "94", "m", "95", "n", "96", "o", "97", "p", "98", "q", "99", "r", "A2", "s", "A3", "t", "A4", "u", "A5", "v", "A6", "w", "A7", "x", "A8", "y", "A9", "z"};
    private DumpReader _libraryReader = null;
    private long _virtualAddress;
    private long _fileOffset;
    private long _size;
    private boolean _inCoreFile = true;
    private int _asid = 0;
    private boolean _shared = false;
    private boolean _readOnly = false;
    private boolean _executable = true;
    private boolean _permissionsSupported = false;

    public MemoryRange(long virtualAddress, long fileOffset, long size) {
        this._virtualAddress = virtualAddress;
        this._fileOffset = fileOffset;
        this._size = size;
    }

    public MemoryRange(long virtualAddress, long fileOffset, long size, int asid) {
        this(virtualAddress, fileOffset, size);
        this._asid = asid;
    }

    public MemoryRange(long virtualAddress, long fileOffset, long size, int asid, boolean isShared, boolean isReadOnly, boolean isExecutable) {
        this(virtualAddress, fileOffset, size, asid);
        this._shared = isShared;
        this._readOnly = isReadOnly;
        this._executable = isExecutable;
        this._permissionsSupported = true;
    }

    public MemoryRange(long virtualAddress, long fileOffset, long size, int asid, boolean isShared, boolean isReadOnly, boolean isExecutable, boolean inCoreFile) {
        this(virtualAddress, fileOffset, size, asid, isShared, isReadOnly, isExecutable);
        this._inCoreFile = inCoreFile;
    }

    public MemoryRange(MemoryRange range, int asid) {
        this(range.getVirtualAddress(), range.getFileOffset(), range.getSize(), asid);
        this._permissionsSupported = true;
        try {
            this._shared = range.isShared();
            this._readOnly = range.isReadOnly();
            this._executable = range.isExecutable();
            this._inCoreFile = range.isInCoreFile();
            this._libraryReader = range.getLibraryReader();
        }
        catch (MemoryAccessException exc) {
            this._permissionsSupported = false;
        }
    }

    public boolean contains(long address) {
        return this.getVirtualAddress() <= address && address < this.getVirtualAddress() + this.getSize();
    }

    public boolean contains(int asid, long address) {
        return asid == this._asid && this.contains(address);
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public long getSize() {
        return this._size;
    }

    public long getVirtualAddress() {
        return this._virtualAddress;
    }

    public boolean isInCoreFile() {
        return this._inCoreFile;
    }

    public DumpReader getLibraryReader() {
        return this._libraryReader;
    }

    public void setLibraryReader(DumpReader libraryReader) {
        this._libraryReader = libraryReader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Addr: 0x" + Long.toHexString(this.getVirtualAddress()));
        sb.append("   Size: 0x" + Long.toHexString(this.getSize()) + " (" + this.getSize() + ")");
        sb.append("   File Offset: 0x" + Long.toHexString(this.getFileOffset()));
        sb.append(" (" + this.getFileOffset() + ")");
        if (this._asid != 0) {
            String tempASID = Integer.toHexString(this._asid);
            boolean bIsReadable = false;
            StringBuffer sBuff = new StringBuffer("");
            if (8 == tempASID.length()) {
                bIsReadable = true;
                for (int i = 0; i < 8 && bIsReadable; i += 2) {
                    String x = tempASID.substring(i, i + 2);
                    String y = this.isPrintableEbcdic(x);
                    if (null == y) {
                        bIsReadable = false;
                        continue;
                    }
                    sBuff.append(y);
                }
            }
            if (bIsReadable) {
                sb.append("   asid: " + sBuff);
            } else {
                sb.append("   asid: 0x" + Integer.toHexString(this._asid));
            }
        }
        return sb.toString();
    }

    private String isPrintableEbcdic(String in) {
        in = in.toUpperCase();
        for (int i = 0; i < printableEBCDIC.length; i += 2) {
            if (!in.equals(printableEBCDIC[i])) continue;
            return printableEBCDIC[i + 1];
        }
        return null;
    }

    public int getAsid() {
        return this._asid;
    }

    public boolean isExecutable() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._executable;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public boolean isReadOnly() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._readOnly;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public boolean isShared() throws MemoryAccessException {
        if (this._permissionsSupported) {
            return this._shared;
        }
        throw new MemoryAccessException(this.getAsid(), this.getVirtualAddress());
    }

    public int compareTo(Object o) {
        MemoryRange rhs = (MemoryRange)o;
        if (this._asid < rhs._asid) {
            return -1;
        }
        if (this._asid > rhs._asid) {
            return 1;
        }
        if (this._virtualAddress == rhs._virtualAddress) {
            return 0;
        }
        if (this._virtualAddress >= 0L && rhs._virtualAddress >= 0L || this._virtualAddress < 0L && rhs._virtualAddress < 0L) {
            return this._virtualAddress < rhs._virtualAddress ? -1 : 1;
        }
        return this._virtualAddress < rhs._virtualAddress ? 1 : -1;
    }
}

