/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.javacore.JCImage;
import com.ibm.dtfj.image.javacore.JCImagePointer;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageAddressSpace
implements ImageAddressSpace {
    private Vector fProcesses;
    private Vector fImageSections;
    private JCImage fImage;

    public JCImageAddressSpace(JCImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Must pass a valid image");
        }
        this.fImage = image;
        this.fProcesses = new Vector();
        this.fImageSections = new Vector();
        image.addAddressSpace(this);
    }

    public ImageProcess getCurrentProcess() {
        ImageProcess currentProcess = null;
        int size = this.fProcesses.size();
        if (size > 0) {
            currentProcess = (ImageProcess)this.fProcesses.get(size - 1);
        }
        return currentProcess;
    }

    public Iterator getImageSections() {
        return this.fImageSections.iterator();
    }

    public ImagePointer getPointer(long address) {
        try {
            return new JCImagePointer(this, address);
        }
        catch (JCInvalidArgumentsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Iterator getProcesses() {
        return this.fProcesses.iterator();
    }

    public void addImageProcess(ImageProcess imageProcess) {
        if (imageProcess != null) {
            this.fProcesses.add(imageProcess);
        }
    }

    public JCImage getImage() {
        return this.fImage;
    }

    public boolean isValidAddressID(long id) {
        return id != -1L;
    }

    public void addImageSection(ImageSection imageSection) {
        this.fImageSections.add(imageSection);
    }

    public String getID() throws DataUnavailable, CorruptDataException {
        return "0";
    }

    public Properties getProperties() {
        return new Properties();
    }
}

