/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.environment;

import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.environment.IEnvironmentTypes;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EnvironmentSectionParser
extends SectionParser
implements IEnvironmentTypes {
    private IImageProcessBuilder fImageProcessBuilder;
    private IJavaRuntimeBuilder fRuntimeBuilder;

    public EnvironmentSectionParser() {
        super("ENVINFO");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.parseVersion();
        this.parseUserArgs();
        this.parseEnvironmentVars();
        this.parseJVMMI();
    }

    private void parseVersion() throws ParserException {
        String pidStr;
        String nanoTimeString;
        SimpleDateFormat sdf;
        Date startDate;
        String dateTimeString;
        IParserToken token;
        IAttributeValueMap results = null;
        results = this.processTagLineOptional("1CIJAVAVERSION");
        if (results != null) {
            int pointerSize = results.getIntValue("pointer_size");
            if (pointerSize != -1) {
                this.fImageProcessBuilder.setPointerSize(pointerSize);
            }
            String javaversion = results.getTokenValue("environment_arg_string");
            String checkString = "j2re 1.";
            if (javaversion.toLowerCase().startsWith(checkString) && javaversion.length() > checkString.length() + 1) {
                String number = javaversion.substring(checkString.length(), javaversion.indexOf(46, checkString.length() + 1));
                try {
                    int version = Integer.parseInt(number);
                    if (version <= 4) {
                        throw new ParserException("Javacore files earlier than 1.5.0 are not supported");
                    }
                }
                catch (NumberFormatException e) {
                    this.handleError("Error determining Java version", e);
                }
            }
            if ((results = this.processTagLineOptional("1CIVMVERSION")) != null) {
                javaversion = this.buildVersionString(javaversion, results);
            }
            if ((results = this.processTagLineOptional("1CIJITVERSION")) != null) {
                javaversion = this.buildVersionString(javaversion, results);
            }
            if ((results = this.processTagLineOptional("1CIGCVERSION")) != null) {
                javaversion = this.buildVersionString(javaversion, results);
            }
            if (javaversion != null) {
                this.fRuntimeBuilder.setJavaVersion(javaversion);
            }
        } else {
            this.processTagLineOptional("1CIVMVERSION");
            this.processTagLineOptional("1CIJITVERSION");
            this.processTagLineOptional("1CIGCVERSION");
        }
        results = this.processTagLineOptional("1CIJITMODES");
        if (results != null && (token = results.getToken("environment_jit_mode")) != null) {
            String value = token.getValue().trim();
            if (value.toLowerCase().startsWith("unavailable")) {
                this.fRuntimeBuilder.setJITEnabled(false);
            } else {
                this.fRuntimeBuilder.setJITEnabled(true);
                String[] props = value.split(",");
                for (int i = 0; i < props.length; ++i) {
                    String item = props[i].trim();
                    int index = item.indexOf(32);
                    if (index == -1) {
                        this.fRuntimeBuilder.addJITProperty(props[i], "<default value>");
                        continue;
                    }
                    String name = item.substring(0, index);
                    String pvalue = item.substring(index + 1);
                    this.fRuntimeBuilder.addJITProperty(name, pvalue);
                }
            }
        }
        this.processTagLineOptional("1CIRUNNINGAS");
        results = this.processTagLineOptional("1CISTARTTIME");
        if (results != null && (dateTimeString = results.getTokenValue("environment_start_time")) != null && (startDate = (sdf = new SimpleDateFormat("yyyy/MM/dd 'at' HH:mm:ss:SSS")).parse(dateTimeString, new ParsePosition(0))) != null) {
            this.fRuntimeBuilder.setStartTime(startDate.getTime());
        }
        if ((results = this.processTagLineOptional("1CISTARTNANO")) != null && (nanoTimeString = results.getTokenValue("environment_start_nano")) != null) {
            this.fRuntimeBuilder.setStartTimeNanos(Long.parseLong(nanoTimeString));
        }
        if ((results = this.processTagLineOptional("1CIPROCESSID")) != null && (pidStr = results.getTokenValue("environment_pid_string")) != null) {
            this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder().setID(pidStr);
        }
        String cmdLine = null;
        results = this.processTagLineOptional("1CICMDLINE");
        if (results != null) {
            cmdLine = results.getTokenValue("environment_cmd_line");
            if ("[not available]".equals(cmdLine)) {
                cmdLine = null;
            } else {
                this.fImageProcessBuilder.setCommandLine(cmdLine);
            }
        }
        String home = null;
        results = this.processTagLineOptional("1CIJAVAHOMEDIR");
        if (results != null) {
            home = results.getTokenValue("environment_arg_string");
        }
        String dlldir = null;
        results = this.processTagLineOptional("1CIJAVADLLDIR");
        if (results != null) {
            dlldir = results.getTokenValue("environment_arg_string");
        }
        if (cmdLine != null) {
            int sp;
            if (dlldir != null) {
                int min2;
                int min1 = cmdLine.indexOf(47) + 1;
                if (min1 == 0) {
                    min1 = cmdLine.length();
                }
                if ((min2 = cmdLine.indexOf(92) + 1) == 0) {
                    min2 = cmdLine.length();
                }
                int min = Math.min(min1, min2);
                for (int i = cmdLine.length(); i > min; --i) {
                    String prefix = cmdLine.substring(0, i);
                    int j = dlldir.indexOf(prefix);
                    if (j < 0) continue;
                    cmdLine = dlldir.substring(0, j) + cmdLine;
                    break;
                }
            }
            int i = 0;
            if (dlldir != null) {
                for (i = dlldir.length(); i >= 0 && !cmdLine.startsWith(dlldir.substring(0, i)); --i) {
                }
            }
            String exec = (sp = cmdLine.indexOf(32, i)) >= 0 ? cmdLine.substring(0, sp) : cmdLine;
            ImageModule execMod = this.fImageProcessBuilder.addLibrary(exec);
            this.fImageProcessBuilder.setExecutable(execMod);
        }
        this.processTagLineOptional("1CISYSCP");
    }

    private String buildVersionString(String javaversion, IAttributeValueMap results) {
        String extra = results.getTokenValue("environment_arg_string");
        if (extra != null) {
            javaversion = javaversion != null ? javaversion + "\n" + extra : extra;
        }
        return javaversion;
    }

    private void parseUserArgs() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineRequired("1CIUSERARGS");
        if (results != null) {
            boolean added = false;
            while ((results = this.processTagLineOptional("2CIUSERARG")) != null) {
                if (!added) {
                    added = true;
                    try {
                        this.fRuntimeBuilder.addVMInitArgs();
                    }
                    catch (BuilderFailureException e) {
                        this.handleError("Failed to add JavaVMInitArgs to builder: ", e);
                    }
                }
                String argString = results.getTokenValue("environment_arg_string");
                long extraInfo = results.getLongValue("environment_arg_extra");
                try {
                    if (extraInfo == -1L) {
                        if (argString == null) continue;
                        this.fRuntimeBuilder.addVMOption(argString);
                        continue;
                    }
                    this.fRuntimeBuilder.addVMOption(argString, extraInfo);
                }
                catch (BuilderFailureException e) {
                    this.handleError("Failed to add VM option to builder: " + argString + " ", e);
                }
            }
        }
    }

    private void parseJVMMI() throws ParserException {
        this.processTagLineOptional("1CIJVMMI");
        this.processTagLineOptional("2CIJVMMIOFF");
    }

    private void parseEnvironmentVars() throws ParserException {
        IAttributeValueMap results = null;
        results = this.processTagLineOptional("1CIENVVARS");
        if (results != null) {
            while ((results = this.processTagLineOptional("2CIENVVAR")) != null) {
                String env_name = results.getTokenValue("environment_variable_name");
                String env_value = results.getTokenValue("environment_variable_value");
                if (env_name == null || env_value == null) continue;
                this.fImageProcessBuilder.addEnvironmentVariable(env_name, env_value);
            }
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

