/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.stack;

import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.stack.IStackTypes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTagParser
extends TagParser
implements IStackTypes {
    private static final Matcher LINUXADDRESS = CommonPatternMatchers.generateMatcher("\\[0[xX]\\p{XDigit}+\\]");

    public StackTagParser() {
        super("Stack");
    }

    protected void initTagAttributeRules() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("stack_thread");
            }
        };
        this.addTag("BTTHREADID", lineRule);
        lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                if (this.indexOfLast(LINUXADDRESS) >= 0) {
                    IParserToken token = this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_module", CommonPatternMatchers.open_paren);
                    if (token != null) {
                        this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_routine", Pattern.compile("[+-]").matcher(""));
                        this.addPrefixedHexToken("stack_offset");
                    } else {
                        this.addAllCharactersAsTokenAndConsumeFirstMatch("stack_module", CommonPatternMatchers.whitespace);
                    }
                    this.addPrefixedHexToken("stack_proc_address");
                } else {
                    int lastColon = this.indexOfLast(CommonPatternMatchers.colon);
                    if (lastColon >= 0) {
                        String name = this.consumeCharacters(0, lastColon);
                        if (name.indexOf("/") != -1) {
                            this.addToken("stack_module", name);
                        } else {
                            this.addToken("stack_routine", name);
                        }
                    }
                    this.addPrefixedHexToken("stack_proc_address");
                    this.addPrefixedHexToken("stack_routine_address");
                    this.addPrefixedHexToken("stack_offset");
                }
            }
        };
        this.addTag("1BTSTACKENT", lineRule);
    }
}

