/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptImageModule;
import com.ibm.dtfj.phd.PHDCorruptImageThread;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageFactory;
import com.ibm.dtfj.phd.PHDImageModule;
import com.ibm.dtfj.phd.PHDImageThread;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PHDImageProcess
implements ImageProcess {
    private final boolean is64bit;
    private final List<JavaRuntime> runtimes;
    private final String pid;
    private final ImageProcess metaImageProcess;
    private final ArrayList<ImageModule> modules = new ArrayList();
    private final LinkedHashMap<Object, ImageThread> threads = new LinkedHashMap();
    private CorruptData modules_cd;
    private ImageThread currentThread;

    PHDImageProcess(ImageInputStream stream, PHDImage parentImage, ImageAddressSpace space, ImageProcess metaImageProcess) throws IOException {
        this.metaImageProcess = metaImageProcess;
        JavaRuntime metaRuntime = this.getJavaRuntime(metaImageProcess);
        HeapdumpReader reader = new HeapdumpReader(stream, parentImage);
        this.is64bit = reader.is64Bit();
        this.processData(space);
        this.pid = "<unknown pid>";
        this.runtimes = new ArrayList<JavaRuntime>();
        this.runtimes.add(new PHDJavaRuntime(stream, parentImage, space, this, metaRuntime));
    }

    PHDImageProcess(File file, PHDImage parentImage, ImageAddressSpace space, ImageProcess metaImageProcess) throws IOException {
        this.metaImageProcess = metaImageProcess;
        JavaRuntime metaRuntime = this.getJavaRuntime(metaImageProcess);
        HeapdumpReader reader = new HeapdumpReader(file, parentImage);
        this.is64bit = reader.is64Bit();
        this.processData(space);
        this.pid = this.getPID(file);
        this.runtimes = new ArrayList<JavaRuntime>();
        this.runtimes.add(new PHDJavaRuntime(file, parentImage, space, this, metaRuntime));
    }

    private JavaRuntime getJavaRuntime(ImageProcess process) {
        Object o2;
        Iterator i2;
        JavaRuntime metaRuntime = null;
        if (process != null && (i2 = process.getRuntimes()).hasNext() && !((o2 = i2.next()) instanceof CorruptData) && o2 instanceof JavaRuntime) {
            metaRuntime = (JavaRuntime)o2;
        }
        return metaRuntime;
    }

    private void processData(ImageAddressSpace space) {
        if (this.metaImageProcess != null) {
            ImageThread current;
            try {
                Iterator it = this.metaImageProcess.getLibraries();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next instanceof CorruptData) {
                        this.modules.add(new PHDCorruptImageModule(space, (CorruptData)next));
                        continue;
                    }
                    try {
                        ImageModule mod = (ImageModule)next;
                        this.modules.add(new PHDImageModule(mod.getName()));
                    }
                    catch (CorruptDataException e) {
                        this.modules.add(new PHDCorruptImageModule(space, e));
                    }
                }
            }
            catch (CorruptDataException e) {
                this.modules_cd = new PHDCorruptData(space, e);
            }
            catch (DataUnavailable e) {
                // empty catch block
            }
            try {
                current = this.metaImageProcess.getCurrentThread();
            }
            catch (CorruptDataException e) {
                this.currentThread = new PHDCorruptImageThread(space, e.getCorruptData());
                current = null;
            }
            Iterator it = this.metaImageProcess.getThreads();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof CorruptData) {
                    this.threads.put(next, new PHDCorruptImageThread(space, (CorruptData)next));
                    continue;
                }
                ImageThread thrd = (ImageThread)next;
                ImageThread imageThread = this.getThread(space, thrd);
                if (!thrd.equals(current)) continue;
                this.currentThread = imageThread;
            }
        }
    }

    private String getPID(File file) {
        String pid = null;
        String fn = file.getName();
        pid = this.getPID(fn, PHDImageFactory.earliestDump, PHDImageFactory.latestDump);
        if (pid == null) {
            pid = this.getPIDAIX(fn, PHDImageFactory.earliestDump, PHDImageFactory.latestDump);
        }
        return pid;
    }

    private String getPID(String fn, Date d1, Date d2) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd.HHmmss");
        ParsePosition pp = new ParsePosition(0);
        block2: for (int i = 0; i < fn.length(); ++i) {
            pp.setIndex(i);
            Date dF = sdf.parse(fn, pp);
            if (dF == null || d1.before(dF) || !d2.after(dF)) continue;
            String[] rest = fn.substring(pp.getIndex()).split("\\.");
            for (int j = 0; j < rest.length; ++j) {
                if (rest[j].equals("")) continue;
                try {
                    Integer.parseInt(rest[j]);
                    return rest[j];
                }
                catch (NumberFormatException e) {
                    continue block2;
                }
            }
        }
        return null;
    }

    private String getPIDAIX(String name, Date d1, Date d2) {
        String prefix = "heapdump";
        int p = Math.max(0, name.indexOf(prefix));
        String[] s = (name = name.substring(p)).split("\\.");
        if ((s.length == 3 || s.length == 4 && s[3].equals("gz")) && s[0].startsWith(prefix)) {
            try {
                int i1 = Integer.parseInt(s[0].substring(prefix.length()));
                long l2 = Long.parseLong(s[1]);
                Date dF = new Date(l2 * 1000L);
                if (!dF.before(d1) && dF.before(d2)) {
                    return Integer.toString(i1);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    public String getCommandLine() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getCommandLine();
        }
        throw new DataUnavailable();
    }

    public ImageThread getCurrentThread() throws CorruptDataException {
        return this.currentThread;
    }

    public Properties getEnvironment() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getEnvironment();
        }
        throw new DataUnavailable();
    }

    public ImageModule getExecutable() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }

    public String getID() throws DataUnavailable, CorruptDataException {
        if (this.pid != null) {
            return this.pid;
        }
        throw new DataUnavailable();
    }

    public Iterator<ImageModule> getLibraries() throws DataUnavailable, CorruptDataException {
        if (this.modules_cd != null) {
            throw new CorruptDataException(this.modules_cd);
        }
        if (this.modules.size() == 0) {
            throw new DataUnavailable();
        }
        return this.modules.iterator();
    }

    public int getPointerSize() {
        return this.is64bit ? 64 : 32;
    }

    public Iterator<JavaRuntime> getRuntimes() {
        return this.runtimes.iterator();
    }

    public String getSignalName() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getSignalName();
        }
        throw new DataUnavailable();
    }

    public int getSignalNumber() throws DataUnavailable, CorruptDataException {
        if (this.metaImageProcess != null) {
            return this.metaImageProcess.getSignalNumber();
        }
        throw new DataUnavailable();
    }

    public Iterator<ImageThread> getThreads() {
        return this.threads.values().iterator();
    }

    ImageThread getThread(ImageAddressSpace space, ImageThread metaThread) {
        if (!this.threads.containsKey(metaThread)) {
            PHDImageThread imageThread = new PHDImageThread(space, metaThread);
            this.threads.put(metaThread, imageThread);
        }
        return this.threads.get(metaThread);
    }

    public Properties getProperties() {
        return new Properties();
    }
}

